% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{quantile_ab_p_value}
\alias{quantile_ab_p_value}
\title{Two-sample, sequential test of equal quantiles.}
\usage{
quantile_ab_p_value(a_values, b_values, quantile_p, t_opt,
  alpha_opt = 0.05)
}
\arguments{
\item{a_values}{values observed so far from the first sample}

\item{b_values}{values observed so far from the second samples}

\item{quantile_p}{designates which quantile we wish to test}

\item{t_opt}{sample size for which test is optimized}

\item{alpha_opt}{level for which test is optimized}
}
\description{
This function tests the null that two i.i.d. samples are drawn from
populations with the same `quantile_p` quantile. It returns a two-tailed,
always-valid p-value.
}
\examples{
quantile_ab_p_value(1:1000, 86:1085, .5, 100)
}
