% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{double_stitching_bound}
\alias{double_stitching_bound}
\title{"Double stitching" bound (Theorem 3 of the quantile paper).}
\usage{
double_stitching_bound(quantile_p, t, alpha, t_opt, delta = 0.5,
  s = 1.4, eta = 2)
}
\arguments{
\item{quantile_p}{designates which quantile we wish to bound}

\item{t}{number of samples observed}

\item{alpha}{error / crossing probability of the boundary}

\item{t_opt}{sample size for which the bound is optimized}

\item{delta}{controls the fineness of the quantile grid used in construction
of the bound}

\item{s}{controls how crossing probability is distribted over epochs}

\item{eta}{controls the spacing of epochs}
}
\description{
Yields a confidence sequence uniform over quantiles and time.
}
\examples{
double_stitching_bound(c(.1, .5, .9), 1000, .05, 100)
}
