"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlSync = exports.readJsonSync = void 0;
const fs = require("fs");
const yaml = require("yaml");
function readJsonSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return JSON.parse(fileContents.toString());
}
exports.readJsonSync = readJsonSync;
function readYamlSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return parseYamlStrWithCfnTags(fileContents.toString());
}
exports.readYamlSync = readYamlSync;
function makeTagForCfnIntrinsic(intrinsicName, addFnPrefix = true, resolveFun) {
    return {
        identify(value) { return typeof value === 'string'; },
        tag: `!${intrinsicName}`,
        resolve: resolveFun || ((_doc, cstNode) => {
            const ret = {};
            ret[addFnPrefix ? `Fn::${intrinsicName}` : intrinsicName] =
                // the +1 is to account for the ! the short form begins with
                parseYamlStrWithCfnTags(cstNode.toString().substring(intrinsicName.length + 1));
            return ret;
        }),
    };
}
const shortForms = [
    'Base64', 'Cidr', 'FindInMap', 'GetAZs', 'ImportValue', 'Join', 'Sub',
    'Select', 'Split', 'Transform', 'And', 'Equals', 'If', 'Not', 'Or',
].map(name => makeTagForCfnIntrinsic(name)).concat(makeTagForCfnIntrinsic('Ref', false), makeTagForCfnIntrinsic('Condition', false), makeTagForCfnIntrinsic('GetAtt', true, (_doc, cstNode) => {
    // The position of the leftmost period and opening bracket tell us what syntax is being used
    // If no brackets are found, then the dot notation is being used; the leftmost dot separates the
    // logical ID from the attribute.
    //
    // If a bracket is found, then the list notation is being used; if present, the leftmost dot separates the
    // logical ID from the attribute.
    const firstDot = cstNode.toString().indexOf('.');
    const firstBracket = cstNode.toString().indexOf('[');
    return {
        'Fn::GetAtt': firstDot !== -1 && firstBracket === -1
            ? [
                cstNode.toString().substring('!GetAtt '.length, firstDot),
                parseYamlStrWithCfnTags((cstNode.toString().substring(firstDot + 1))),
            ]
            : parseYamlStrWithCfnTags(cstNode.toString().substring('!GetAtt'.length)),
    };
}));
function parseYamlStrWithCfnTags(text) {
    return yaml.parse(text, {
        customTags: shortForms,
        schema: 'yaml-1.1',
    });
}
//# sourceMappingURL=data:application/json;base64,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