"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic
 */
class Topic extends topic_base_1.TopicBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.topicName,
        });
        this.autoCreatePolicy = true;
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: this.physicalName,
            kmsMasterKeyId: props.masterKey && props.masterKey.keyArn,
        });
        this.topicArn = this.getResourceArnAttribute(resource.ref, {
            service: 'sns',
            resource: this.physicalName,
        });
        this.topicName = this.getResourceNameAttribute(resource.attrTopicName);
    }
    /**
     * Import an existing SNS topic provided an ARN
     *
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic)
     */
    static fromTopicArn(scope, id, topicArn) {
        class Import extends topic_base_1.TopicBase {
            constructor() {
                super(...arguments);
                this.topicArn = topicArn;
                this.topicName = core_1.Stack.of(scope).parseArn(topicArn).resource;
                this.autoCreatePolicy = false;
            }
        }
        return new Import(scope, id);
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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