"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cloudwatch = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const instance_1 = require("./instance");
instance_1.DatabaseInstanceBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/RDS',
        metricName,
        dimensions: { DBInstanceIdentifier: this.instanceIdentifier },
        ...props
    }).attachTo(this);
};
instance_1.DatabaseInstanceBase.prototype.metricCPUUtilization = function (props) {
    return this.metric('CPUUtilization', { statistic: 'Average', ...props });
};
instance_1.DatabaseInstanceBase.prototype.metricDatabaseConnections = function (props) {
    return this.metric('DatabaseConnections', { statistic: 'Average', ...props });
};
instance_1.DatabaseInstanceBase.prototype.metricFreeStorageSpace = function (props) {
    return this.metric('FreeStorageSpace', { statistic: 'Average', ...props });
};
instance_1.DatabaseInstanceBase.prototype.metricFreeableMemory = function (props) {
    return this.metric('FreeableMemory', { statistic: 'Average', ...props });
};
instance_1.DatabaseInstanceBase.prototype.metricWriteIOPS = function (props) {
    return this.metric('WriteIOPS', { statistic: 'Average', ...props });
};
instance_1.DatabaseInstanceBase.prototype.metricReadIOPS = function (props) {
    return this.metric('ReadIOPS', { statistic: 'Average', ...props });
};
//# sourceMappingURL=data:application/json;base64,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