"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as an EventBridge rule target.
 */
class CodePipeline {
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZXBpcGVsaW5lLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29kZXBpcGVsaW5lLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLHFDQUFxQyxDQUFDLG1EQUFtRDtBQUN6RixpQ0FBNEM7QUFhNUM7O0dBRUc7QUFDSCxNQUFhLFlBQVk7SUFDckIsWUFBNkIsUUFBZ0MsRUFBbUIsVUFBcUMsRUFBRTtRQUExRixhQUFRLEdBQVIsUUFBUSxDQUF3QjtRQUFtQixZQUFPLEdBQVAsT0FBTyxDQUFnQztJQUN2SCxDQUFDO0lBQ00sSUFBSSxDQUFDLEtBQW1CLEVBQUUsR0FBWTtRQUN6QyxPQUFPO1lBQ0gsRUFBRSxFQUFFLEVBQUU7WUFDTixHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXO1lBQzlCLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSx5QkFBa0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO29CQUNuRixTQUFTLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQztvQkFDdEMsT0FBTyxFQUFFLENBQUMscUNBQXFDLENBQUM7aUJBQ25ELENBQUMsQ0FBQyxDQUFDO1lBQ1IsY0FBYyxFQUFFLElBQUksQ0FBQyxRQUFRO1NBQ2hDLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFkRCxvQ0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tIFwiLi4vLi4vYXdzLWNvZGVwaXBlbGluZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSdcbmltcG9ydCAqIGFzIGV2ZW50cyBmcm9tIFwiLi4vLi4vYXdzLWV2ZW50c1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cydcbmltcG9ydCAqIGFzIGlhbSBmcm9tIFwiLi4vLi4vYXdzLWlhbVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSdcbmltcG9ydCB7IHNpbmdsZXRvbkV2ZW50Um9sZSB9IGZyb20gJy4vdXRpbCc7XG4vKipcbiAqIEN1c3RvbWl6YXRpb24gb3B0aW9ucyB3aGVuIGNyZWF0aW5nIGEge0BsaW5rIENvZGVQaXBlbGluZX0gZXZlbnQgdGFyZ2V0LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENvZGVQaXBlbGluZVRhcmdldE9wdGlvbnMge1xuICAgIC8qKlxuICAgICAqIFRoZSByb2xlIHRvIGFzc3VtZSBiZWZvcmUgaW52b2tpbmcgdGhlIHRhcmdldFxuICAgICAqIChpLmUuLCB0aGUgcGlwZWxpbmUpIHdoZW4gdGhlIGdpdmVuIHJ1bGUgaXMgdHJpZ2dlcmVkLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBhIG5ldyByb2xlIHdpbGwgYmUgY3JlYXRlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGV2ZW50Um9sZT86IGlhbS5JUm9sZTtcbn1cbi8qKlxuICogQWxsb3dzIHRoZSBwaXBlbGluZSB0byBiZSB1c2VkIGFzIGFuIEV2ZW50QnJpZGdlIHJ1bGUgdGFyZ2V0LlxuICovXG5leHBvcnQgY2xhc3MgQ29kZVBpcGVsaW5lIGltcGxlbWVudHMgZXZlbnRzLklSdWxlVGFyZ2V0IHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHBpcGVsaW5lOiBjb2RlcGlwZWxpbmUuSVBpcGVsaW5lLCBwcml2YXRlIHJlYWRvbmx5IG9wdGlvbnM6IENvZGVQaXBlbGluZVRhcmdldE9wdGlvbnMgPSB7fSkge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcnVsZTogZXZlbnRzLklSdWxlLCBfaWQ/OiBzdHJpbmcpOiBldmVudHMuUnVsZVRhcmdldENvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBpZDogJycsXG4gICAgICAgICAgICBhcm46IHRoaXMucGlwZWxpbmUucGlwZWxpbmVBcm4sXG4gICAgICAgICAgICByb2xlOiB0aGlzLm9wdGlvbnMuZXZlbnRSb2xlIHx8IHNpbmdsZXRvbkV2ZW50Um9sZSh0aGlzLnBpcGVsaW5lLCBbbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgICAgICAgICAgICByZXNvdXJjZXM6IFt0aGlzLnBpcGVsaW5lLnBpcGVsaW5lQXJuXSxcbiAgICAgICAgICAgICAgICAgICAgYWN0aW9uczogWydjb2RlcGlwZWxpbmU6U3RhcnRQaXBlbGluZUV4ZWN1dGlvbiddLFxuICAgICAgICAgICAgICAgIH0pXSksXG4gICAgICAgICAgICB0YXJnZXRSZXNvdXJjZTogdGhpcy5waXBlbGluZSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=