"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleTransition = exports.DefaultResult = exports.LifecycleHook = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a life cycle hook
 */
class LifecycleHook extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.lifecycleHookName,
        });
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('autoscaling.amazonaws.com'),
        });
        const targetProps = props.notificationTarget.bind(this, this);
        const resource = new autoscaling_generated_1.CfnLifecycleHook(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            defaultResult: props.defaultResult,
            heartbeatTimeout: props.heartbeatTimeout && props.heartbeatTimeout.toSeconds(),
            lifecycleHookName: this.physicalName,
            lifecycleTransition: props.lifecycleTransition,
            notificationMetadata: props.notificationMetadata,
            notificationTargetArn: targetProps.notificationTargetArn,
            roleArn: this.role.roleArn,
        });
        // A LifecycleHook resource is going to do a permissions test upon creation,
        // so we have to make sure the role has full permissions before creating the
        // lifecycle hook.
        resource.node.addDependency(this.role);
        this.lifecycleHookName = resource.ref;
    }
}
exports.LifecycleHook = LifecycleHook;
var DefaultResult;
(function (DefaultResult) {
    DefaultResult["CONTINUE"] = "CONTINUE";
    DefaultResult["ABANDON"] = "ABANDON";
})(DefaultResult = exports.DefaultResult || (exports.DefaultResult = {}));
/**
 * What instance transition to attach the hook to
 */
var LifecycleTransition;
(function (LifecycleTransition) {
    /**
     * Execute the hook when an instance is about to be added
     */
    LifecycleTransition["INSTANCE_LAUNCHING"] = "autoscaling:EC2_INSTANCE_LAUNCHING";
    /**
     * Execute the hook when an instance is about to be terminated
     */
    LifecycleTransition["INSTANCE_TERMINATING"] = "autoscaling:EC2_INSTANCE_TERMINATING";
})(LifecycleTransition = exports.LifecycleTransition || (exports.LifecycleTransition = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlmZWN5Y2xlLWhvb2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaWZlY3ljbGUtaG9vay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBcUMsQ0FBQyxtREFBbUQ7QUFDekYscUNBQXNFLENBQUMsZ0RBQWdEO0FBRXZILG1FQUEyRDtBQWlFM0Q7O0dBRUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxlQUFRO0lBVXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDYixZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtTQUN4QyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDakQsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLDJCQUEyQixDQUFDO1NBQ25FLENBQUMsQ0FBQztRQUNILE1BQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlELE1BQU0sUUFBUSxHQUFHLElBQUksd0NBQWdCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwRCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CO1lBQ2pFLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLFNBQVMsRUFBRTtZQUM5RSxpQkFBaUIsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUNwQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0I7WUFDaEQscUJBQXFCLEVBQUUsV0FBVyxDQUFDLHFCQUFxQjtZQUN4RCxPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPO1NBQzdCLENBQUMsQ0FBQztRQUNILDRFQUE0RTtRQUM1RSw0RUFBNEU7UUFDNUUsa0JBQWtCO1FBQ2xCLFFBQVEsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztJQUMxQyxDQUFDO0NBQ0o7QUFsQ0Qsc0NBa0NDO0FBQ0QsSUFBWSxhQUdYO0FBSEQsV0FBWSxhQUFhO0lBQ3JCLHNDQUFxQixDQUFBO0lBQ3JCLG9DQUFtQixDQUFBO0FBQ3ZCLENBQUMsRUFIVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQUd4QjtBQUNEOztHQUVHO0FBQ0gsSUFBWSxtQkFTWDtBQVRELFdBQVksbUJBQW1CO0lBQzNCOztPQUVHO0lBQ0gsZ0ZBQXlELENBQUE7SUFDekQ7O09BRUc7SUFDSCxvRkFBNkQsQ0FBQTtBQUNqRSxDQUFDLEVBVFcsbUJBQW1CLEdBQW5CLDJCQUFtQixLQUFuQiwyQkFBbUIsUUFTOUIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSBcIi4uLy4uL2F3cy1pYW1cIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nXG5pbXBvcnQgeyBDb25zdHJ1Y3QsIER1cmF0aW9uLCBJUmVzb3VyY2UsIFJlc291cmNlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBJQXV0b1NjYWxpbmdHcm91cCB9IGZyb20gJy4vYXV0by1zY2FsaW5nLWdyb3VwJztcbmltcG9ydCB7IENmbkxpZmVjeWNsZUhvb2sgfSBmcm9tICcuL2F1dG9zY2FsaW5nLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJTGlmZWN5Y2xlSG9va1RhcmdldCB9IGZyb20gJy4vbGlmZWN5Y2xlLWhvb2stdGFyZ2V0Jztcbi8qKlxuICogQmFzaWMgcHJvcGVydGllcyBmb3IgYSBsaWZlY3ljbGUgaG9va1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEJhc2ljTGlmZWN5Y2xlSG9va1Byb3BzIHtcbiAgICAvKipcbiAgICAgKiBOYW1lIG9mIHRoZSBsaWZlY3ljbGUgaG9va1xuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBBdXRvbWF0aWNhbGx5IGdlbmVyYXRlZCBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxpZmVjeWNsZUhvb2tOYW1lPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBhY3Rpb24gdGhlIEF1dG8gU2NhbGluZyBncm91cCB0YWtlcyB3aGVuIHRoZSBsaWZlY3ljbGUgaG9vayB0aW1lb3V0IGVsYXBzZXMgb3IgaWYgYW4gdW5leHBlY3RlZCBmYWlsdXJlIG9jY3Vycy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IENvbnRpbnVlXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVmYXVsdFJlc3VsdD86IERlZmF1bHRSZXN1bHQ7XG4gICAgLyoqXG4gICAgICogTWF4aW11bSB0aW1lIGJldHdlZW4gY2FsbHMgdG8gUmVjb3JkTGlmZWN5Y2xlQWN0aW9uSGVhcnRiZWF0IGZvciB0aGUgaG9va1xuICAgICAqXG4gICAgICogSWYgdGhlIGxpZmVjeWNsZSBob29rIHRpbWVzIG91dCwgcGVyZm9ybSB0aGUgYWN0aW9uIGluIERlZmF1bHRSZXN1bHQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vIGhlYXJ0YmVhdCB0aW1lb3V0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGhlYXJ0YmVhdFRpbWVvdXQ/OiBEdXJhdGlvbjtcbiAgICAvKipcbiAgICAgKiBUaGUgc3RhdGUgb2YgdGhlIEFtYXpvbiBFQzIgaW5zdGFuY2UgdG8gd2hpY2ggeW91IHdhbnQgdG8gYXR0YWNoIHRoZSBsaWZlY3ljbGUgaG9vay5cbiAgICAgKi9cbiAgICByZWFkb25seSBsaWZlY3ljbGVUcmFuc2l0aW9uOiBMaWZlY3ljbGVUcmFuc2l0aW9uO1xuICAgIC8qKlxuICAgICAqIEFkZGl0aW9uYWwgZGF0YSB0byBwYXNzIHRvIHRoZSBsaWZlY3ljbGUgaG9vayB0YXJnZXRcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gTm8gbWV0YWRhdGEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbm90aWZpY2F0aW9uTWV0YWRhdGE/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIHRhcmdldCBvZiB0aGUgbGlmZWN5Y2xlIGhvb2tcbiAgICAgKi9cbiAgICByZWFkb25seSBub3RpZmljYXRpb25UYXJnZXQ6IElMaWZlY3ljbGVIb29rVGFyZ2V0O1xuICAgIC8qKlxuICAgICAqIFRoZSByb2xlIHRoYXQgYWxsb3dzIHB1Ymxpc2hpbmcgdG8gdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXRcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gQSByb2xlIGlzIGF1dG9tYXRpY2FsbHkgY3JlYXRlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xufVxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIExpZmVjeWNsZSBob29rXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTGlmZWN5Y2xlSG9va1Byb3BzIGV4dGVuZHMgQmFzaWNMaWZlY3ljbGVIb29rUHJvcHMge1xuICAgIC8qKlxuICAgICAqIFRoZSBBdXRvU2NhbGluZ0dyb3VwIHRvIGFkZCB0aGUgbGlmZWN5Y2xlIGhvb2sgdG9cbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRvU2NhbGluZ0dyb3VwOiBJQXV0b1NjYWxpbmdHcm91cDtcbn1cbi8qKlxuICogQSBiYXNpYyBsaWZlY3ljbGUgaG9vayBvYmplY3RcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTGlmZWN5Y2xlSG9vayBleHRlbmRzIElSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJvbGUgZm9yIHRoZSBsaWZlY3ljbGUgaG9vayB0byBleGVjdXRlXG4gICAgICovXG4gICAgcmVhZG9ubHkgcm9sZTogaWFtLklSb2xlO1xufVxuLyoqXG4gKiBEZWZpbmUgYSBsaWZlIGN5Y2xlIGhvb2tcbiAqL1xuZXhwb3J0IGNsYXNzIExpZmVjeWNsZUhvb2sgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElMaWZlY3ljbGVIb29rIHtcbiAgICAvKipcbiAgICAgKiBUaGUgcm9sZSB0aGF0IGFsbG93cyB0aGUgQVNHIHRvIHB1Ymxpc2ggdG8gdGhlIG5vdGlmaWNhdGlvbiB0YXJnZXRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgcm9sZTogaWFtLklSb2xlO1xuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoaXMgbGlmZWN5Y2xlIGhvb2tcbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGxpZmVjeWNsZUhvb2tOYW1lOiBzdHJpbmc7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExpZmVjeWNsZUhvb2tQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgICAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMubGlmZWN5Y2xlSG9va05hbWUsXG4gICAgICAgIH0pO1xuICAgICAgICB0aGlzLnJvbGUgPSBwcm9wcy5yb2xlIHx8IG5ldyBpYW0uUm9sZSh0aGlzLCAnUm9sZScsIHtcbiAgICAgICAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdhdXRvc2NhbGluZy5hbWF6b25hd3MuY29tJyksXG4gICAgICAgIH0pO1xuICAgICAgICBjb25zdCB0YXJnZXRQcm9wcyA9IHByb3BzLm5vdGlmaWNhdGlvblRhcmdldC5iaW5kKHRoaXMsIHRoaXMpO1xuICAgICAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5MaWZlY3ljbGVIb29rKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIGF1dG9TY2FsaW5nR3JvdXBOYW1lOiBwcm9wcy5hdXRvU2NhbGluZ0dyb3VwLmF1dG9TY2FsaW5nR3JvdXBOYW1lLFxuICAgICAgICAgICAgZGVmYXVsdFJlc3VsdDogcHJvcHMuZGVmYXVsdFJlc3VsdCxcbiAgICAgICAgICAgIGhlYXJ0YmVhdFRpbWVvdXQ6IHByb3BzLmhlYXJ0YmVhdFRpbWVvdXQgJiYgcHJvcHMuaGVhcnRiZWF0VGltZW91dC50b1NlY29uZHMoKSxcbiAgICAgICAgICAgIGxpZmVjeWNsZUhvb2tOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgICAgICAgIGxpZmVjeWNsZVRyYW5zaXRpb246IHByb3BzLmxpZmVjeWNsZVRyYW5zaXRpb24sXG4gICAgICAgICAgICBub3RpZmljYXRpb25NZXRhZGF0YTogcHJvcHMubm90aWZpY2F0aW9uTWV0YWRhdGEsXG4gICAgICAgICAgICBub3RpZmljYXRpb25UYXJnZXRBcm46IHRhcmdldFByb3BzLm5vdGlmaWNhdGlvblRhcmdldEFybixcbiAgICAgICAgICAgIHJvbGVBcm46IHRoaXMucm9sZS5yb2xlQXJuLFxuICAgICAgICB9KTtcbiAgICAgICAgLy8gQSBMaWZlY3ljbGVIb29rIHJlc291cmNlIGlzIGdvaW5nIHRvIGRvIGEgcGVybWlzc2lvbnMgdGVzdCB1cG9uIGNyZWF0aW9uLFxuICAgICAgICAvLyBzbyB3ZSBoYXZlIHRvIG1ha2Ugc3VyZSB0aGUgcm9sZSBoYXMgZnVsbCBwZXJtaXNzaW9ucyBiZWZvcmUgY3JlYXRpbmcgdGhlXG4gICAgICAgIC8vIGxpZmVjeWNsZSBob29rLlxuICAgICAgICByZXNvdXJjZS5ub2RlLmFkZERlcGVuZGVuY3kodGhpcy5yb2xlKTtcbiAgICAgICAgdGhpcy5saWZlY3ljbGVIb29rTmFtZSA9IHJlc291cmNlLnJlZjtcbiAgICB9XG59XG5leHBvcnQgZW51bSBEZWZhdWx0UmVzdWx0IHtcbiAgICBDT05USU5VRSA9ICdDT05USU5VRScsXG4gICAgQUJBTkRPTiA9ICdBQkFORE9OJ1xufVxuLyoqXG4gKiBXaGF0IGluc3RhbmNlIHRyYW5zaXRpb24gdG8gYXR0YWNoIHRoZSBob29rIHRvXG4gKi9cbmV4cG9ydCBlbnVtIExpZmVjeWNsZVRyYW5zaXRpb24ge1xuICAgIC8qKlxuICAgICAqIEV4ZWN1dGUgdGhlIGhvb2sgd2hlbiBhbiBpbnN0YW5jZSBpcyBhYm91dCB0byBiZSBhZGRlZFxuICAgICAqL1xuICAgIElOU1RBTkNFX0xBVU5DSElORyA9ICdhdXRvc2NhbGluZzpFQzJfSU5TVEFOQ0VfTEFVTkNISU5HJyxcbiAgICAvKipcbiAgICAgKiBFeGVjdXRlIHRoZSBob29rIHdoZW4gYW4gaW5zdGFuY2UgaXMgYWJvdXQgdG8gYmUgdGVybWluYXRlZFxuICAgICAqL1xuICAgIElOU1RBTkNFX1RFUk1JTkFUSU5HID0gJ2F1dG9zY2FsaW5nOkVDMl9JTlNUQU5DRV9URVJNSU5BVElORydcbn1cbiJdfQ==