# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .services.recommender import RecommenderClient
from .types.insight import Insight
from .types.insight import InsightStateInfo
from .types.recommendation import CostProjection
from .types.recommendation import Impact
from .types.recommendation import Operation
from .types.recommendation import OperationGroup
from .types.recommendation import Recommendation
from .types.recommendation import RecommendationContent
from .types.recommendation import RecommendationStateInfo
from .types.recommendation import ValueMatcher
from .types.recommender_service import GetInsightRequest
from .types.recommender_service import GetRecommendationRequest
from .types.recommender_service import ListInsightsRequest
from .types.recommender_service import ListInsightsResponse
from .types.recommender_service import ListRecommendationsRequest
from .types.recommender_service import ListRecommendationsResponse
from .types.recommender_service import MarkInsightAcceptedRequest
from .types.recommender_service import MarkRecommendationClaimedRequest
from .types.recommender_service import MarkRecommendationFailedRequest
from .types.recommender_service import MarkRecommendationSucceededRequest


__all__ = (
    "CostProjection",
    "GetInsightRequest",
    "GetRecommendationRequest",
    "Impact",
    "Insight",
    "InsightStateInfo",
    "ListInsightsRequest",
    "ListInsightsResponse",
    "ListRecommendationsRequest",
    "ListRecommendationsResponse",
    "MarkInsightAcceptedRequest",
    "MarkRecommendationClaimedRequest",
    "MarkRecommendationFailedRequest",
    "MarkRecommendationSucceededRequest",
    "Operation",
    "OperationGroup",
    "Recommendation",
    "RecommendationContent",
    "RecommendationStateInfo",
    "ValueMatcher",
    "RecommenderClient",
)
