from typing import Iterable

from pandas.core.indexes.base import Index

from pandas._typing import np_ndarray_int64

class NumericIndex(Index):
    def __init__(self, data: Iterable = ..., dtype=..., copy: bool = ..., name=...): ...
    @property
    def is_all_dates(self) -> bool: ...
    def insert(self, loc, item): ...
    def __add__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __radd__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __sub__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __rsub__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __mul__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __rmul__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __truediv__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __rtruediv__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __floordiv__(self, other: NumericIndex | complex) -> NumericIndex: ...
    def __rfloordiv__(self, other: NumericIndex | complex) -> NumericIndex: ...

class IntegerIndex(NumericIndex):
    def __contains__(self, key) -> bool: ...

class Int64Index(IntegerIndex):
    @property
    def asi8(self) -> np_ndarray_int64: ...

class UInt64Index(IntegerIndex):
    @property
    def asi8(self) -> np_ndarray_int64: ...

class Float64Index(NumericIndex):
    def astype(self, dtype, copy: bool = ...): ...
    def get_value(self, series, key): ...
    def equals(self, other) -> bool: ...
    def __contains__(self, other) -> bool: ...
    def get_loc(self, key, tolerance=...): ...
    @property
    def is_unique(self) -> bool: ...
    def isin(self, values, level=...): ...
