import { Construct } from 'constructs';
export interface GeneralRoleProps {
    /**
     * The name of the IAM policy for the IAM role.
     *
     * @default 'general-role-s3olap-policy'
     */
    readonly policyName?: string;
    /**
       * The name of the object Lambda access point, which will be the same as the S3 acceess point for the S3 bucket in the demostration.
       *
       * @default 'accessctl-s3olap-survey-results-unknown-pii'
       */
    readonly objectLambdaAccessPointName?: string;
    /**
       * The name of the IAM role.
       *
       * @default 'GeneralRole'
       */
    readonly iamRoleName?: string;
}
/**
 * The role that you are going to assume (switch role)
 *
 * Explores how the S3 Object Lambda works.
 */
export declare class GeneralRole extends Construct {
    /**
       * The ARN of the IAM role.
       *
       */
    readonly roleArn: string;
    /**
       * The name of the IAM role.
       *
       */
    readonly roleName: string;
    /**
       * The unique string identifying the role.
       *
       */
    readonly roleId: string;
    constructor(scope: Construct, id: string, props: GeneralRoleProps);
}
export interface AdminRoleProps {
    /**
     * The name of the IAM policy for the IAM role.
     *
     * @default 'admin-role-s3olap-policy'
     */
    readonly policyName?: string;
    /**
     * The name of the object Lambda access point, which will be the same as the S3 acceess point for the S3 bucket in the demostration.
     *
     * @default 'admin-s3olap-call-transcripts-known-pii'
     */
    readonly objectLambdaAccessPointName?: string;
    /**
     * The name of the IAM role.
     *
     * @default 'RedactionAdminRole'
     */
    readonly iamRoleName?: string;
}
export declare class AdminRole extends Construct {
    /**
     * The ARN of the IAM role.
     */
    readonly roleArn: string;
    /**
     * The name of the IAM role.
     */
    readonly roleName: string;
    /**
     * The unique string identifying the role.
     */
    readonly roleId: string;
    constructor(scope: Construct, id: string, props?: AdminRoleProps);
}
export interface BillingRoleProps {
    /**
     * The name of the IAM policy for the IAM role.
     *
     * @default 'billing-role-s3olap-policy'
     */
    readonly policyName?: string;
    /**
     * The name of the object Lambda access point, which will be the same as the S3 acceess point for the S3 bucket in the demostration.
     *
     * @default 'billing-s3olap-call-transcripts-known-pii'
     */
    readonly objectLambdaAccessPointName?: string;
    /**
     * The name of the IAM role.
     *
     * @default 'RedactionBillingRole'
     */
    readonly iamRoleName?: string;
}
export declare class BillingRole extends Construct {
    /**
     * The ARN of the IAM role.
     */
    readonly roleArn: string;
    /**
     * The name of the IAM role.
     */
    readonly roleName: string;
    /**
     * The unique string identifying the role.
     */
    readonly roleId: string;
    constructor(scope: Construct, id: string, props?: AdminRoleProps);
}
export interface CustSupportRoleProps {
    /**
     * The name of the IAM policy for the IAM role.
     *
     * @default 'customersupport-role-s3olap-policy'
     */
    readonly policyName?: string;
    /**
     * The name of the object Lambda access point, which will be the same as the S3 acceess point for the S3 bucket in the demostration.
     *
     * @default 'custsupport-s3olap-call-transcripts-known-pii'
     */
    readonly objectLambdaAccessPointName?: string;
    /**
     * The name of the IAM role.
     *
     * @default 'RedactionCustSupportRole'
     */
    readonly iamRoleName?: string;
}
export declare class CustSupportRole extends Construct {
    /**
     * The ARN of the IAM role.
     */
    readonly roleArn: string;
    /**
     * The name of the IAM role.
     */
    readonly roleName: string;
    /**
     * The unique string identifying the role.
     */
    readonly roleId: string;
    constructor(scope: Construct, id: string, props?: AdminRoleProps);
}
