# Contributing

Please take a moment to review this document to make the contribution process easy and effective
for everyone involved.

## License

You agree to license your contribution under the
[MIT License](LICENSE-MIT).

## Submission guidelines

1. Format your contribution with [rustfmt](https://github.com/rust-lang/rustfmt#quick-start).
1. Resolve all warnings from [clippy](https://github.com/rust-lang/rust-clippy#usage).
1. Document your contribution per the
   [Rust documentation guidelines](https://doc.rust-lang.org/1.30.0/book/first-edition/documentation.html).

Provide tests that prove the functionality you're contributing is correct.

Ensure your contribution is free of all warnings and errors during compilation
and testing.
maintain quality.

## Pull requests

This project appreciates pull requests that fix bugs, make improvements or add new features.
These are one of the main points of collaboration for the project.

Pull requests should remain focused in scope and not contain unrelated commits.

The project may use automated tools to verify submitted pull requests.
Ensure you address any errors these tools may report.

The project may choose to **not** accept your contribution.  When this happens we'll explain why
and where possible make suggestions for how you might be able to achieve what you set out to
with your pull request.
