# coding: utf-8

"""
    Vector Similarity Demo

    The test functionality and Query testing  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@hyper-space.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hyperspace.api_client import ApiClient


class HyperspaceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_batch(self, body, collection_name, **kwargs):  # noqa: E501
        """Add a new batch to the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_batch(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Document] body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_batch_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.add_batch_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def add_batch_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Add a new batch to the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_batch_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Document] body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_batch`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `add_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_document(self, body, collection_name, **kwargs):  # noqa: E501
        """Add a new document to the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_document(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_document_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.add_document_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def add_document_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Add a new document to the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_document_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_document`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `add_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/document/add', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clear_collection(self, collection_name, **kwargs):  # noqa: E501
        """Clear all collection vectors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_collection(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clear_collection_with_http_info(collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.clear_collection_with_http_info(collection_name, **kwargs)  # noqa: E501
            return data

    def clear_collection_with_http_info(self, collection_name, **kwargs):  # noqa: E501
        """Clear all collection vectors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_collection_with_http_info(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `clear_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/delete', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def collections_info(self, **kwargs):  # noqa: E501
        """Get the information of all the collections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collections_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FunctionFunctionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.collections_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.collections_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def collections_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get the information of all the collections  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collections_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FunctionFunctionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collections_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/collectionsInfo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FunctionFunctionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def commit(self, collection_name, **kwargs):  # noqa: E501
        """Commit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.commit(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.commit_with_http_info(collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.commit_with_http_info(collection_name, **kwargs)  # noqa: E501
            return data

    def commit_with_http_info(self, collection_name, **kwargs):  # noqa: E501
        """Commit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.commit_with_http_info(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method commit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `commit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/commit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_collection(self, body, collection_name, **kwargs):  # noqa: E501
        """Create a new collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectionCollectionNameBody body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_collection_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_collection_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def create_collection_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Create a new collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectionCollectionNameBody body: (required)
        :param str collection_name: (required)
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_collection`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `create_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/collection/{collectionName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_by_query(self, body, collection_name, **kwargs):  # noqa: E501
        """Deletes documents that match the specified query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_by_query(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteByQueryRequest body: (required)
        :param str collection_name: (required)
        :return: DeleteByQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_by_query_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_by_query_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def delete_by_query_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Deletes documents that match the specified query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_by_query_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeleteByQueryRequest body: (required)
        :param str collection_name: (required)
        :return: DeleteByQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_by_query`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `delete_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/delete_by_query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteByQueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collection(self, collection_name, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collection(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_collection_with_http_info(collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_collection_with_http_info(collection_name, **kwargs)  # noqa: E501
            return data

    def delete_collection_with_http_info(self, collection_name, **kwargs):  # noqa: E501
        """Delete a collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collection_with_http_info(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `delete_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/collection/{collectionName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_document(self, collection_name, document_id, **kwargs):  # noqa: E501
        """Delete document by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_document(collection_name, document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str document_id: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_document_with_http_info(collection_name, document_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_document_with_http_info(collection_name, document_id, **kwargs)  # noqa: E501
            return data

    def delete_document_with_http_info(self, collection_name, document_id, **kwargs):  # noqa: E501
        """Delete document by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_document_with_http_info(collection_name, document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str document_id: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name', 'document_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `delete_document`")  # noqa: E501
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params or
                params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []
        if 'document_id' in params:
            query_params.append(('documentId', params['document_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/document/delete', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_function(self, collection_name, function_name, **kwargs):  # noqa: E501
        """Delete function by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_function(collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_function_with_http_info(collection_name, function_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_function_with_http_info(collection_name, function_name, **kwargs)  # noqa: E501
            return data

    def delete_function_with_http_info(self, collection_name, function_name, **kwargs):  # noqa: E501
        """Delete function by name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_function_with_http_info(collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name', 'function_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `delete_function`")  # noqa: E501
        # verify the required parameter 'function_name' is set
        if ('function_name' not in params or
                params['function_name'] is None):
            raise ValueError("Missing the required parameter `function_name` when calling `delete_function`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501
        if 'function_name' in params:
            path_params['functionName'] = params['function_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/function/delete/{functionName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def dsl_search(self, body, size, collection_name, **kwargs):  # noqa: E501
        """Find top X similar documents in the dataset using Elasticsearch DSL query  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dsl_search(body, size, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectionNameDslSearchBody body: (required)
        :param int size: (required)
        :param str collection_name: (required)
        :param str options:
        :param bool source: Indicates whether source fields are returned for matching documents.These fields are returned in the hits._source property of the search response.Defaults to false.
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.dsl_search_with_http_info(body, size, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.dsl_search_with_http_info(body, size, collection_name, **kwargs)  # noqa: E501
            return data

    def dsl_search_with_http_info(self, body, size, collection_name, **kwargs):  # noqa: E501
        """Find top X similar documents in the dataset using Elasticsearch DSL query  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dsl_search_with_http_info(body, size, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectionNameDslSearchBody body: (required)
        :param int size: (required)
        :param str collection_name: (required)
        :param str options:
        :param bool source: Indicates whether source fields are returned for matching documents.These fields are returned in the hits._source property of the search response.Defaults to false.
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'size', 'collection_name', 'options', 'source']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dsl_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `dsl_search`")  # noqa: E501
        # verify the required parameter 'size' is set
        if ('size' not in params or
                params['size'] is None):
            raise ValueError("Missing the required parameter `size` when calling `dsl_search`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `dsl_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'options' in params:
            query_params.append(('options', params['options']))  # noqa: E501
        if 'source' in params:
            query_params.append(('_source', params['source']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/dsl_search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionNameDslSearchBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document(self, collection_name, document_id, **kwargs):  # noqa: E501
        """Find document by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document(collection_name, document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str document_id: (required)
        :param bool metadata_only:
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_document_with_http_info(collection_name, document_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document_with_http_info(collection_name, document_id, **kwargs)  # noqa: E501
            return data

    def get_document_with_http_info(self, collection_name, document_id, **kwargs):  # noqa: E501
        """Find document by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_with_http_info(collection_name, document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str document_id: (required)
        :param bool metadata_only:
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name', 'document_id', 'metadata_only']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `get_document`")  # noqa: E501
        # verify the required parameter 'document_id' is set
        if ('document_id' not in params or
                params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []
        if 'document_id' in params:
            query_params.append(('documentId', params['document_id']))  # noqa: E501
        if 'metadata_only' in params:
            query_params.append(('metadata_only', params['metadata_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/document/get', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_function(self, collection_name, function_name, **kwargs):  # noqa: E501
        """Get Function  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_function(collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_function_with_http_info(collection_name, function_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_function_with_http_info(collection_name, function_name, **kwargs)  # noqa: E501
            return data

    def get_function_with_http_info(self, collection_name, function_name, **kwargs):  # noqa: E501
        """Get Function  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_function_with_http_info(collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name', 'function_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `get_function`")  # noqa: E501
        # verify the required parameter 'function_name' is set
        if ('function_name' not in params or
                params['function_name'] is None):
            raise ValueError("Missing the required parameter `function_name` when calling `get_function`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501
        if 'function_name' in params:
            path_params['functionName'] = params['function_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/function/{functionName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionNameDslSearchBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_schema(self, collection_name, **kwargs):  # noqa: E501
        """Get schema of collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schema(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_schema_with_http_info(collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_schema_with_http_info(collection_name, **kwargs)  # noqa: E501
            return data

    def get_schema_with_http_info(self, collection_name, **kwargs):  # noqa: E501
        """Get schema of collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_schema_with_http_info(collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_name: (required)
        :return: CollectionNameDslSearchBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_schema" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `get_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionNameDslSearchBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def login(self, body, **kwargs):  # noqa: E501
        """Login  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginDto body: (required)
        :return: AuthDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.login_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.login_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def login_with_http_info(self, body, **kwargs):  # noqa: E501
        """Login  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginDto body: (required)
        :return: AuthDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_password(self, **kwargs):  # noqa: E501
        """Reset password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_password_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_password_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_password_with_http_info(self, **kwargs):  # noqa: E501
        """Reset password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_password_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_password" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/reset_password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search(self, body, size, collection_name, **kwargs):  # noqa: E501
        """Find top X similar documents in the dataset according to the selected search option.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(body, size, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param int size: (required)
        :param str collection_name: (required)
        :param str function_name:
        :param str options:
        :param bool source: Indicates whether source fields are returned for matching documents.These fields are returned in the hits._source property of the search response.Defaults to false.
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_with_http_info(body, size, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(body, size, collection_name, **kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, body, size, collection_name, **kwargs):  # noqa: E501
        """Find top X similar documents in the dataset according to the selected search option.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(body, size, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param int size: (required)
        :param str collection_name: (required)
        :param str function_name:
        :param str options:
        :param bool source: Indicates whether source fields are returned for matching documents.These fields are returned in the hits._source property of the search response.Defaults to false.
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'size', 'collection_name', 'function_name', 'options', 'source']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `search`")  # noqa: E501
        # verify the required parameter 'size' is set
        if ('size' not in params or
                params['size'] is None):
            raise ValueError("Missing the required parameter `size` when calling `search`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'function_name' in params:
            query_params.append(('functionName', params['function_name']))  # noqa: E501
        if 'options' in params:
            query_params.append(('options', params['options']))  # noqa: E501
        if 'source' in params:
            query_params.append(('_source', params['source']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_function(self, body, collection_name, function_name, **kwargs):  # noqa: E501
        """Set Function  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_function(body, collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FunctionFunctionNameBody body: (required)
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_function_with_http_info(body, collection_name, function_name, **kwargs)  # noqa: E501
        else:
            (data) = self.set_function_with_http_info(body, collection_name, function_name, **kwargs)  # noqa: E501
            return data

    def set_function_with_http_info(self, body, collection_name, function_name, **kwargs):  # noqa: E501
        """Set Function  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_function_with_http_info(body, collection_name, function_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FunctionFunctionNameBody body: (required)
        :param str collection_name: (required)
        :param str function_name: (required)
        :return: StatusDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name', 'function_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_function`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `set_function`")  # noqa: E501
        # verify the required parameter 'function_name' is set
        if ('function_name' not in params or
                params['function_name'] is None):
            raise ValueError("Missing the required parameter `function_name` when calling `set_function`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501
        if 'function_name' in params:
            path_params['functionName'] = params['function_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/function/{functionName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatusDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_by_query(self, body, collection_name, **kwargs):  # noqa: E501
        """Update documents that match a query using a script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_by_query(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateByQuery body: (required)
        :param str collection_name: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_by_query_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_by_query_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def update_by_query_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Update documents that match a query using a script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_by_query_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateByQuery body: (required)
        :param str collection_name: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_by_query`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `update_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/update_by_query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_document(self, body, collection_name, **kwargs):  # noqa: E501
        """Update document by Id in the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_document(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param str collection_name: (required)
        :param bool partial_update:
        :param bool doc_as_upsert:
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_document_with_http_info(body, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_document_with_http_info(body, collection_name, **kwargs)  # noqa: E501
            return data

    def update_document_with_http_info(self, body, collection_name, **kwargs):  # noqa: E501
        """Update document by Id in the collection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_document_with_http_info(body, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Document body: (required)
        :param str collection_name: (required)
        :param bool partial_update:
        :param bool doc_as_upsert:
        :return: CollectionCollectionNameBody
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_name', 'partial_update', 'doc_as_upsert']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_document`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if ('collection_name' not in params or
                params['collection_name'] is None):
            raise ValueError("Missing the required parameter `collection_name` when calling `update_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []
        if 'partial_update' in params:
            query_params.append(('partialUpdate', params['partial_update']))  # noqa: E501
        if 'doc_as_upsert' in params:
            query_params.append(('docAsUpsert', params['doc_as_upsert']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/msgpack'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/{collectionName}/document/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CollectionCollectionNameBody',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
