# coding: utf-8

"""
    IGVF Project API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 52.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CrisprModification(BaseModel):
    """
    A CRISPR modification altering sample genomic material. For example, CRISPRi dCas9-KRAB modification.
    """ # noqa: E501
    release_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was released.")
    sources: Optional[List[StrictStr]] = Field(default=None, description="The originating lab(s) or vendor(s).")
    lot_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The lot identifier provided by the originating lab or vendor.")
    product_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The product or catalog identifier provided following deposition to addgene.org.")
    documents: Optional[List[StrictStr]] = Field(default=None, description="Documents that provide additional information (not data file).")
    status: Optional[StrictStr] = Field(default=None, description="The status of the metadata object.")
    lab: Optional[StrictStr] = Field(default=None, description="Lab associated with the submission.")
    award: Optional[StrictStr] = Field(default=None, description="Grant associated with the submission.")
    schema_version: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The version of the JSON schema that the server uses to validate the object.")
    uuid: Optional[StrictStr] = Field(default=None, description="The unique identifier associated with every object.")
    notes: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DACC internal notes.")
    aliases: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Lab specific identifiers to reference an object.")
    creation_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was created.")
    submitted_by: Optional[StrictStr] = Field(default=None, description="The user who submitted the object.")
    submitter_comment: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Additional information specified by the submitter to be displayed as a comment on the portal.")
    description: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A plain text description of the object.")
    activated: Optional[StrictBool] = Field(default=None, description="A boolean indicating whether the modification has been activated by a chemical agent.")
    activating_agent_term_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The CHEBI identifier for the activating agent of the modification.")
    activating_agent_term_name: Optional[StrictStr] = Field(default=None, description="The CHEBI name for the activating agent of the modification.")
    modality: Optional[StrictStr] = Field(default=None, description="The purpose or intended effect of a modification.")
    cas: Optional[StrictStr] = Field(default=None, description="The name of the CRISPR associated protein used in the modification.")
    fused_domain: Optional[StrictStr] = Field(default=None, description="The name of the molecule fused to a Cas protein.")
    tagged_protein: Optional[StrictStr] = Field(default=None, description="The tagged protein in modifications in which the Cas nuclease is fused to an antibody.")
    cas_species: Optional[StrictStr] = Field(default=None, description="The originating species of the Cas nuclease.")
    id: Optional[StrictStr] = Field(default=None, alias="@id")
    type: Optional[List[StrictStr]] = Field(default=None, alias="@type")
    summary: Optional[StrictStr] = None
    biosamples_modified: Optional[List[StrictStr]] = Field(default=None, description="The biosamples which have been modified with this modification.")
    __properties: ClassVar[List[str]] = ["release_timestamp", "sources", "lot_id", "product_id", "documents", "status", "lab", "award", "schema_version", "uuid", "notes", "aliases", "creation_timestamp", "submitted_by", "submitter_comment", "description", "activated", "activating_agent_term_id", "activating_agent_term_name", "modality", "cas", "fused_domain", "tagged_protein", "cas_species", "@id", "@type", "summary", "biosamples_modified"]

    @field_validator('lot_id')
    def lot_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('product_id')
    def product_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^addgene:\d{5,6}$", value):
            raise ValueError(r"must validate the regular expression /^addgene:\d{5,6}$/")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['archived', 'deleted', 'in progress', 'released']):
            raise ValueError("must be one of enum values ('archived', 'deleted', 'in progress', 'released')")
        return value

    @field_validator('schema_version')
    def schema_version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d+(\.\d+)*$", value):
            raise ValueError(r"must validate the regular expression /^\d+(\.\d+)*$/")
        return value

    @field_validator('notes')
    def notes_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('submitter_comment')
    def submitter_comment_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('activating_agent_term_id')
    def activating_agent_term_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^CHEBI:[0-9]{1,7}$", value):
            raise ValueError(r"must validate the regular expression /^CHEBI:[0-9]{1,7}$/")
        return value

    @field_validator('modality')
    def modality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['activation', 'base editing', 'cutting', 'interference', 'knockout', 'localizing', 'prime editing']):
            raise ValueError("must be one of enum values ('activation', 'base editing', 'cutting', 'interference', 'knockout', 'localizing', 'prime editing')")
        return value

    @field_validator('cas')
    def cas_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Cas9', 'Cas12a', 'Cas13', 'dCas9', 'nCas9', 'SpG', 'SpRY']):
            raise ValueError("must be one of enum values ('Cas9', 'Cas12a', 'Cas13', 'dCas9', 'nCas9', 'SpG', 'SpRY')")
        return value

    @field_validator('fused_domain')
    def fused_domain_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['2xVP64', '3xVP64', 'ABE8e', 'ABE8.20', 'ANTI-FLAG', 'BE4', 'BE4max', 'eA3A', 'eA3A-T31A', 'eA3A-T44D-S45A', 'KOX1-KRAB', 'M-MLV RT (PE2)', 'p300', 'TdCBE', 'TdCGBE', 'TdDE', 'VPH', 'VP64', 'VP64-p65-Rta (VPR)', 'ZIM3-KRAB']):
            raise ValueError("must be one of enum values ('2xVP64', '3xVP64', 'ABE8e', 'ABE8.20', 'ANTI-FLAG', 'BE4', 'BE4max', 'eA3A', 'eA3A-T31A', 'eA3A-T44D-S45A', 'KOX1-KRAB', 'M-MLV RT (PE2)', 'p300', 'TdCBE', 'TdCGBE', 'TdDE', 'VPH', 'VP64', 'VP64-p65-Rta (VPR)', 'ZIM3-KRAB')")
        return value

    @field_validator('cas_species')
    def cas_species_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Streptococcus pyogenes (Sp)', 'Staphylococcus aureus (Sa)', 'Campylobacter jejuni (Cj)', 'Neisseria meningitidis (Nm)']):
            raise ValueError("must be one of enum values ('Streptococcus pyogenes (Sp)', 'Staphylococcus aureus (Sa)', 'Campylobacter jejuni (Cj)', 'Neisseria meningitidis (Nm)')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CrisprModification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CrisprModification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "release_timestamp": obj.get("release_timestamp"),
            "sources": obj.get("sources"),
            "lot_id": obj.get("lot_id"),
            "product_id": obj.get("product_id"),
            "documents": obj.get("documents"),
            "status": obj.get("status"),
            "lab": obj.get("lab"),
            "award": obj.get("award"),
            "schema_version": obj.get("schema_version"),
            "uuid": obj.get("uuid"),
            "notes": obj.get("notes"),
            "aliases": obj.get("aliases"),
            "creation_timestamp": obj.get("creation_timestamp"),
            "submitted_by": obj.get("submitted_by"),
            "submitter_comment": obj.get("submitter_comment"),
            "description": obj.get("description"),
            "activated": obj.get("activated"),
            "activating_agent_term_id": obj.get("activating_agent_term_id"),
            "activating_agent_term_name": obj.get("activating_agent_term_name"),
            "modality": obj.get("modality"),
            "cas": obj.get("cas"),
            "fused_domain": obj.get("fused_domain"),
            "tagged_protein": obj.get("tagged_protein"),
            "cas_species": obj.get("cas_species"),
            "@id": obj.get("@id"),
            "@type": obj.get("@type"),
            "summary": obj.get("summary"),
            "biosamples_modified": obj.get("biosamples_modified")
        })
        return _obj


