# coding: utf-8

"""
    IGVF Project API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 52.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated
from igvf_client.models.access_key_results import AccessKeyResults
from igvf_client.models.alignment_file_results import AlignmentFileResults
from igvf_client.models.analysis_set_results import AnalysisSetResults
from igvf_client.models.analysis_step_results import AnalysisStepResults
from igvf_client.models.analysis_step_version_results import AnalysisStepVersionResults
from igvf_client.models.assay_term_results import AssayTermResults
from igvf_client.models.auxiliary_set_results import AuxiliarySetResults
from igvf_client.models.award_results import AwardResults
from igvf_client.models.biomarker_results import BiomarkerResults
from igvf_client.models.configuration_file_results import ConfigurationFileResults
from igvf_client.models.construct_library_set_results import ConstructLibrarySetResults
from igvf_client.models.crispr_modification_results import CrisprModificationResults
from igvf_client.models.curated_set_results import CuratedSetResults
from igvf_client.models.degron_modification_results import DegronModificationResults
from igvf_client.models.document_results import DocumentResults
from igvf_client.models.gene_location import GeneLocation
from igvf_client.models.gene_results import GeneResults
from igvf_client.models.genome_browser_annotation_file_results import GenomeBrowserAnnotationFileResults
from igvf_client.models.human_donor_results import HumanDonorResults
from igvf_client.models.image_file_results import ImageFileResults
from igvf_client.models.image_results import ImageResults
from igvf_client.models.in_vitro_system_results import InVitroSystemResults
from igvf_client.models.institutional_certificate_results import InstitutionalCertificateResults
from igvf_client.models.item import Item
from igvf_client.models.item_type import ItemType
from igvf_client.models.lab_results import LabResults
from igvf_client.models.locus import Locus
from igvf_client.models.matrix_file_results import MatrixFileResults
from igvf_client.models.measurement_set_results import MeasurementSetResults
from igvf_client.models.model_file_results import ModelFileResults
from igvf_client.models.model_set_results import ModelSetResults
from igvf_client.models.multiplexed_sample_results import MultiplexedSampleResults
from igvf_client.models.open_reading_frame_results import OpenReadingFrameResults
from igvf_client.models.page_results import PageResults
from igvf_client.models.phenotype_term_results import PhenotypeTermResults
from igvf_client.models.phenotypic_feature_results import PhenotypicFeatureResults
from igvf_client.models.platform_term_results import PlatformTermResults
from igvf_client.models.prediction_set_results import PredictionSetResults
from igvf_client.models.primary_cell_results import PrimaryCellResults
from igvf_client.models.publication_results import PublicationResults
from igvf_client.models.reference_file_results import ReferenceFileResults
from igvf_client.models.rodent_donor_results import RodentDonorResults
from igvf_client.models.sample_term_results import SampleTermResults
from igvf_client.models.search_results import SearchResults
from igvf_client.models.sequence_file_results import SequenceFileResults
from igvf_client.models.signal_file_results import SignalFileResults
from igvf_client.models.software_results import SoftwareResults
from igvf_client.models.software_version_results import SoftwareVersionResults
from igvf_client.models.source_results import SourceResults
from igvf_client.models.tabular_file_results import TabularFileResults
from igvf_client.models.technical_sample_results import TechnicalSampleResults
from igvf_client.models.tissue_results import TissueResults
from igvf_client.models.treatment_results import TreatmentResults
from igvf_client.models.user_results import UserResults
from igvf_client.models.whole_organism_results import WholeOrganismResults
from igvf_client.models.workflow_results import WorkflowResults

from igvf_client.api_client import ApiClient, RequestSerialized
from igvf_client.api_response import ApiResponse
from igvf_client.rest import RESTResponseType


class IgvfApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def access_keys(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        access_key_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by access_key_id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        secret_access_key_hash: Annotated[Optional[List[StrictStr]], Field(description="Filter by secret_access_key_hash")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        user: Annotated[Optional[List[StrictStr]], Field(description="Filter by user")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AccessKeyResults:
        """List items in the AccessKey collection.

        Collection endpoint that accepts various query parameters to filter and sort AccessKey items. Supports filtering on fields within AccessKey items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param access_key_id: Filter by access_key_id
        :type access_key_id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param secret_access_key_hash: Filter by secret_access_key_hash
        :type secret_access_key_hash: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param user: Filter by user
        :type user: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._access_keys_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            access_key_id=access_key_id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            description=description,
            notes=notes,
            secret_access_key_hash=secret_access_key_hash,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            user=user,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessKeyResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def access_keys_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        access_key_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by access_key_id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        secret_access_key_hash: Annotated[Optional[List[StrictStr]], Field(description="Filter by secret_access_key_hash")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        user: Annotated[Optional[List[StrictStr]], Field(description="Filter by user")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AccessKeyResults]:
        """List items in the AccessKey collection.

        Collection endpoint that accepts various query parameters to filter and sort AccessKey items. Supports filtering on fields within AccessKey items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param access_key_id: Filter by access_key_id
        :type access_key_id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param secret_access_key_hash: Filter by secret_access_key_hash
        :type secret_access_key_hash: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param user: Filter by user
        :type user: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._access_keys_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            access_key_id=access_key_id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            description=description,
            notes=notes,
            secret_access_key_hash=secret_access_key_hash,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            user=user,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessKeyResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def access_keys_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        access_key_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by access_key_id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        secret_access_key_hash: Annotated[Optional[List[StrictStr]], Field(description="Filter by secret_access_key_hash")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        user: Annotated[Optional[List[StrictStr]], Field(description="Filter by user")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AccessKey collection.

        Collection endpoint that accepts various query parameters to filter and sort AccessKey items. Supports filtering on fields within AccessKey items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param access_key_id: Filter by access_key_id
        :type access_key_id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param secret_access_key_hash: Filter by secret_access_key_hash
        :type secret_access_key_hash: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param user: Filter by user
        :type user: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._access_keys_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            access_key_id=access_key_id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            description=description,
            notes=notes,
            secret_access_key_hash=secret_access_key_hash,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            user=user,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessKeyResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _access_keys_serialize(
        self,
        query,
        limit,
        sort,
        id,
        access_key_id,
        aliases,
        creation_timestamp,
        description,
        notes,
        secret_access_key_hash,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        user,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'access_key_id': 'multi',
            'aliases': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'notes': 'multi',
            'secret_access_key_hash': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'user': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if access_key_id is not None:
            
            _query_params.append(('access_key_id', access_key_id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if secret_access_key_hash is not None:
            
            _query_params.append(('secret_access_key_hash', secret_access_key_hash))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if user is not None:
            
            _query_params.append(('user', user))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/access-keys/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def alignment_files(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        anvil_url: Annotated[Optional[List[StrictStr]], Field(description="Filter by anvil_url")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_summary")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        controlled_access: Annotated[Optional[List[StrictBool]], Field(description="Filter by controlled_access")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        filtered: Annotated[Optional[List[StrictBool]], Field(description="Filter by filtered")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        redacted: Annotated[Optional[List[StrictBool]], Field(description="Filter by redacted")] = None,
        reference_files: Annotated[Optional[List[StrictStr]], Field(description="Filter by reference_files")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AlignmentFileResults:
        """List items in the AlignmentFile collection.

        Collection endpoint that accepts various query parameters to filter and sort AlignmentFile items. Supports filtering on fields within AlignmentFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param anvil_url: Filter by anvil_url
        :type anvil_url: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param assembly: Filter by assembly
        :type assembly: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_summary: Filter by content_summary
        :type content_summary: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param controlled_access: Filter by controlled_access
        :type controlled_access: List[bool]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param filtered: Filter by filtered
        :type filtered: List[bool]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param redacted: Filter by redacted
        :type redacted: List[bool]
        :param reference_files: Filter by reference_files
        :type reference_files: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._alignment_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            anvil_url=anvil_url,
            assay_titles=assay_titles,
            assembly=assembly,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_summary=content_summary,
            content_type=content_type,
            controlled_access=controlled_access,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            filtered=filtered,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            redacted=redacted,
            reference_files=reference_files,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            transcriptome_annotation=transcriptome_annotation,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlignmentFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def alignment_files_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        anvil_url: Annotated[Optional[List[StrictStr]], Field(description="Filter by anvil_url")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_summary")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        controlled_access: Annotated[Optional[List[StrictBool]], Field(description="Filter by controlled_access")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        filtered: Annotated[Optional[List[StrictBool]], Field(description="Filter by filtered")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        redacted: Annotated[Optional[List[StrictBool]], Field(description="Filter by redacted")] = None,
        reference_files: Annotated[Optional[List[StrictStr]], Field(description="Filter by reference_files")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AlignmentFileResults]:
        """List items in the AlignmentFile collection.

        Collection endpoint that accepts various query parameters to filter and sort AlignmentFile items. Supports filtering on fields within AlignmentFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param anvil_url: Filter by anvil_url
        :type anvil_url: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param assembly: Filter by assembly
        :type assembly: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_summary: Filter by content_summary
        :type content_summary: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param controlled_access: Filter by controlled_access
        :type controlled_access: List[bool]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param filtered: Filter by filtered
        :type filtered: List[bool]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param redacted: Filter by redacted
        :type redacted: List[bool]
        :param reference_files: Filter by reference_files
        :type reference_files: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._alignment_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            anvil_url=anvil_url,
            assay_titles=assay_titles,
            assembly=assembly,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_summary=content_summary,
            content_type=content_type,
            controlled_access=controlled_access,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            filtered=filtered,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            redacted=redacted,
            reference_files=reference_files,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            transcriptome_annotation=transcriptome_annotation,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlignmentFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def alignment_files_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        anvil_url: Annotated[Optional[List[StrictStr]], Field(description="Filter by anvil_url")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_summary")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        controlled_access: Annotated[Optional[List[StrictBool]], Field(description="Filter by controlled_access")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        filtered: Annotated[Optional[List[StrictBool]], Field(description="Filter by filtered")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        redacted: Annotated[Optional[List[StrictBool]], Field(description="Filter by redacted")] = None,
        reference_files: Annotated[Optional[List[StrictStr]], Field(description="Filter by reference_files")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AlignmentFile collection.

        Collection endpoint that accepts various query parameters to filter and sort AlignmentFile items. Supports filtering on fields within AlignmentFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param anvil_url: Filter by anvil_url
        :type anvil_url: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param assembly: Filter by assembly
        :type assembly: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_summary: Filter by content_summary
        :type content_summary: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param controlled_access: Filter by controlled_access
        :type controlled_access: List[bool]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param filtered: Filter by filtered
        :type filtered: List[bool]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param redacted: Filter by redacted
        :type redacted: List[bool]
        :param reference_files: Filter by reference_files
        :type reference_files: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._alignment_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            anvil_url=anvil_url,
            assay_titles=assay_titles,
            assembly=assembly,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_summary=content_summary,
            content_type=content_type,
            controlled_access=controlled_access,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            filtered=filtered,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            redacted=redacted,
            reference_files=reference_files,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            transcriptome_annotation=transcriptome_annotation,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AlignmentFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _alignment_files_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        analysis_step_version,
        anvil_url,
        assay_titles,
        assembly,
        award_id,
        award_component,
        collections,
        content_md5sum,
        content_summary,
        content_type,
        controlled_access,
        creation_timestamp,
        dbxrefs,
        derived_from,
        description,
        documents,
        file_format,
        file_format_specifications,
        file_set_id,
        file_set_accession,
        file_set_file_set_type,
        file_set_samples_id,
        file_set_samples_accession,
        file_set_samples_classifications,
        file_set_samples_disease_terms_id,
        file_set_samples_disease_terms_summary,
        file_set_samples_disease_terms_term_name,
        file_set_samples_sample_terms_id,
        file_set_samples_sample_terms_term_name,
        file_set_samples_summary,
        file_set_samples_taxa,
        file_set_summary,
        file_set_taxa,
        file_size,
        filtered,
        gene_list_for,
        href,
        input_file_for,
        integrated_in_id,
        integrated_in_associated_phenotypes_id,
        integrated_in_associated_phenotypes_summary,
        integrated_in_associated_phenotypes_term_name,
        integrated_in_file_set_type,
        integrated_in_small_scale_gene_list_id,
        integrated_in_small_scale_gene_list_symbol,
        integrated_in_summary,
        lab_id,
        lab_title,
        loci_list_for,
        md5sum,
        notes,
        redacted,
        reference_files,
        release_timestamp,
        revoke_detail,
        s3_uri,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_file_name,
        submitter_comment,
        summary,
        transcriptome_annotation,
        upload_status,
        uuid,
        validation_error_detail,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'analysis_step_version': 'multi',
            'anvil_url': 'multi',
            'assay_titles': 'multi',
            'assembly': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'collections': 'multi',
            'content_md5sum': 'multi',
            'content_summary': 'multi',
            'content_type': 'multi',
            'controlled_access': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'derived_from': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'file_format': 'multi',
            'file_format_specifications': 'multi',
            'file_set.@id': 'multi',
            'file_set.accession': 'multi',
            'file_set.file_set_type': 'multi',
            'file_set.samples.@id': 'multi',
            'file_set.samples.accession': 'multi',
            'file_set.samples.classifications': 'multi',
            'file_set.samples.disease_terms.@id': 'multi',
            'file_set.samples.disease_terms.summary': 'multi',
            'file_set.samples.disease_terms.term_name': 'multi',
            'file_set.samples.sample_terms.@id': 'multi',
            'file_set.samples.sample_terms.term_name': 'multi',
            'file_set.samples.summary': 'multi',
            'file_set.samples.taxa': 'multi',
            'file_set.summary': 'multi',
            'file_set.taxa': 'multi',
            'file_size': 'multi',
            'filtered': 'multi',
            'gene_list_for': 'multi',
            'href': 'multi',
            'input_file_for': 'multi',
            'integrated_in.@id': 'multi',
            'integrated_in.associated_phenotypes.@id': 'multi',
            'integrated_in.associated_phenotypes.summary': 'multi',
            'integrated_in.associated_phenotypes.term_name': 'multi',
            'integrated_in.file_set_type': 'multi',
            'integrated_in.small_scale_gene_list.@id': 'multi',
            'integrated_in.small_scale_gene_list.symbol': 'multi',
            'integrated_in.summary': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'loci_list_for': 'multi',
            'md5sum': 'multi',
            'notes': 'multi',
            'redacted': 'multi',
            'reference_files': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            's3_uri': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_file_name': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'transcriptome_annotation': 'multi',
            'upload_status': 'multi',
            'uuid': 'multi',
            'validation_error_detail': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if analysis_step_version is not None:
            
            _query_params.append(('analysis_step_version', analysis_step_version))
            
        if anvil_url is not None:
            
            _query_params.append(('anvil_url', anvil_url))
            
        if assay_titles is not None:
            
            _query_params.append(('assay_titles', assay_titles))
            
        if assembly is not None:
            
            _query_params.append(('assembly', assembly))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if content_md5sum is not None:
            
            _query_params.append(('content_md5sum', content_md5sum))
            
        if content_summary is not None:
            
            _query_params.append(('content_summary', content_summary))
            
        if content_type is not None:
            
            _query_params.append(('content_type', content_type))
            
        if controlled_access is not None:
            
            _query_params.append(('controlled_access', controlled_access))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if derived_from is not None:
            
            _query_params.append(('derived_from', derived_from))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if file_format is not None:
            
            _query_params.append(('file_format', file_format))
            
        if file_format_specifications is not None:
            
            _query_params.append(('file_format_specifications', file_format_specifications))
            
        if file_set_id is not None:
            
            _query_params.append(('file_set.@id', file_set_id))
            
        if file_set_accession is not None:
            
            _query_params.append(('file_set.accession', file_set_accession))
            
        if file_set_file_set_type is not None:
            
            _query_params.append(('file_set.file_set_type', file_set_file_set_type))
            
        if file_set_samples_id is not None:
            
            _query_params.append(('file_set.samples.@id', file_set_samples_id))
            
        if file_set_samples_accession is not None:
            
            _query_params.append(('file_set.samples.accession', file_set_samples_accession))
            
        if file_set_samples_classifications is not None:
            
            _query_params.append(('file_set.samples.classifications', file_set_samples_classifications))
            
        if file_set_samples_disease_terms_id is not None:
            
            _query_params.append(('file_set.samples.disease_terms.@id', file_set_samples_disease_terms_id))
            
        if file_set_samples_disease_terms_summary is not None:
            
            _query_params.append(('file_set.samples.disease_terms.summary', file_set_samples_disease_terms_summary))
            
        if file_set_samples_disease_terms_term_name is not None:
            
            _query_params.append(('file_set.samples.disease_terms.term_name', file_set_samples_disease_terms_term_name))
            
        if file_set_samples_sample_terms_id is not None:
            
            _query_params.append(('file_set.samples.sample_terms.@id', file_set_samples_sample_terms_id))
            
        if file_set_samples_sample_terms_term_name is not None:
            
            _query_params.append(('file_set.samples.sample_terms.term_name', file_set_samples_sample_terms_term_name))
            
        if file_set_samples_summary is not None:
            
            _query_params.append(('file_set.samples.summary', file_set_samples_summary))
            
        if file_set_samples_taxa is not None:
            
            _query_params.append(('file_set.samples.taxa', file_set_samples_taxa))
            
        if file_set_summary is not None:
            
            _query_params.append(('file_set.summary', file_set_summary))
            
        if file_set_taxa is not None:
            
            _query_params.append(('file_set.taxa', file_set_taxa))
            
        if file_size is not None:
            
            _query_params.append(('file_size', file_size))
            
        if filtered is not None:
            
            _query_params.append(('filtered', filtered))
            
        if gene_list_for is not None:
            
            _query_params.append(('gene_list_for', gene_list_for))
            
        if href is not None:
            
            _query_params.append(('href', href))
            
        if input_file_for is not None:
            
            _query_params.append(('input_file_for', input_file_for))
            
        if integrated_in_id is not None:
            
            _query_params.append(('integrated_in.@id', integrated_in_id))
            
        if integrated_in_associated_phenotypes_id is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.@id', integrated_in_associated_phenotypes_id))
            
        if integrated_in_associated_phenotypes_summary is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.summary', integrated_in_associated_phenotypes_summary))
            
        if integrated_in_associated_phenotypes_term_name is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.term_name', integrated_in_associated_phenotypes_term_name))
            
        if integrated_in_file_set_type is not None:
            
            _query_params.append(('integrated_in.file_set_type', integrated_in_file_set_type))
            
        if integrated_in_small_scale_gene_list_id is not None:
            
            _query_params.append(('integrated_in.small_scale_gene_list.@id', integrated_in_small_scale_gene_list_id))
            
        if integrated_in_small_scale_gene_list_symbol is not None:
            
            _query_params.append(('integrated_in.small_scale_gene_list.symbol', integrated_in_small_scale_gene_list_symbol))
            
        if integrated_in_summary is not None:
            
            _query_params.append(('integrated_in.summary', integrated_in_summary))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if loci_list_for is not None:
            
            _query_params.append(('loci_list_for', loci_list_for))
            
        if md5sum is not None:
            
            _query_params.append(('md5sum', md5sum))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if redacted is not None:
            
            _query_params.append(('redacted', redacted))
            
        if reference_files is not None:
            
            _query_params.append(('reference_files', reference_files))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if s3_uri is not None:
            
            _query_params.append(('s3_uri', s3_uri))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_file_name is not None:
            
            _query_params.append(('submitted_file_name', submitted_file_name))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if transcriptome_annotation is not None:
            
            _query_params.append(('transcriptome_annotation', transcriptome_annotation))
            
        if upload_status is not None:
            
            _query_params.append(('upload_status', upload_status))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        if validation_error_detail is not None:
            
            _query_params.append(('validation_error_detail', validation_error_detail))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/alignment-files/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analysis_sets(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        external_image_data_url: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by external_image_data_url")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        functional_assay_mechanisms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by functional_assay_mechanisms.@id")] = None,
        functional_assay_mechanisms_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_id")] = None,
        functional_assay_mechanisms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_name")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        input_file_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.@id")] = None,
        input_file_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.accession")] = None,
        input_file_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by input_file_sets.aliases")] = None,
        input_file_sets_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.file_set_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        protocols: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by protocols")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        sample_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by sample_summary")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AnalysisSetResults:
        """List items in the AnalysisSet collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisSet items. Supports filtering on fields within AnalysisSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param external_image_data_url: Filter by external_image_data_url
        :type external_image_data_url: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param functional_assay_mechanisms_id: Filter by functional_assay_mechanisms.@id
        :type functional_assay_mechanisms_id: List[str]
        :param functional_assay_mechanisms_term_id: Filter by functional_assay_mechanisms.term_id
        :type functional_assay_mechanisms_term_id: List[str]
        :param functional_assay_mechanisms_term_name: Filter by functional_assay_mechanisms.term_name
        :type functional_assay_mechanisms_term_name: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param input_file_sets_id: Filter by input_file_sets.@id
        :type input_file_sets_id: List[str]
        :param input_file_sets_accession: Filter by input_file_sets.accession
        :type input_file_sets_accession: List[str]
        :param input_file_sets_aliases: Filter by input_file_sets.aliases
        :type input_file_sets_aliases: List[str]
        :param input_file_sets_file_set_type: Filter by input_file_sets.file_set_type
        :type input_file_sets_file_set_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param protocols: Filter by protocols
        :type protocols: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param sample_summary: Filter by sample_summary
        :type sample_summary: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            external_image_data_url=external_image_data_url,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            functional_assay_mechanisms_id=functional_assay_mechanisms_id,
            functional_assay_mechanisms_term_id=functional_assay_mechanisms_term_id,
            functional_assay_mechanisms_term_name=functional_assay_mechanisms_term_name,
            input_file_set_for=input_file_set_for,
            input_file_sets_id=input_file_sets_id,
            input_file_sets_accession=input_file_sets_accession,
            input_file_sets_aliases=input_file_sets_aliases,
            input_file_sets_file_set_type=input_file_sets_file_set_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            protocols=protocols,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            sample_summary=sample_summary,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def analysis_sets_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        external_image_data_url: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by external_image_data_url")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        functional_assay_mechanisms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by functional_assay_mechanisms.@id")] = None,
        functional_assay_mechanisms_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_id")] = None,
        functional_assay_mechanisms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_name")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        input_file_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.@id")] = None,
        input_file_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.accession")] = None,
        input_file_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by input_file_sets.aliases")] = None,
        input_file_sets_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.file_set_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        protocols: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by protocols")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        sample_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by sample_summary")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AnalysisSetResults]:
        """List items in the AnalysisSet collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisSet items. Supports filtering on fields within AnalysisSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param external_image_data_url: Filter by external_image_data_url
        :type external_image_data_url: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param functional_assay_mechanisms_id: Filter by functional_assay_mechanisms.@id
        :type functional_assay_mechanisms_id: List[str]
        :param functional_assay_mechanisms_term_id: Filter by functional_assay_mechanisms.term_id
        :type functional_assay_mechanisms_term_id: List[str]
        :param functional_assay_mechanisms_term_name: Filter by functional_assay_mechanisms.term_name
        :type functional_assay_mechanisms_term_name: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param input_file_sets_id: Filter by input_file_sets.@id
        :type input_file_sets_id: List[str]
        :param input_file_sets_accession: Filter by input_file_sets.accession
        :type input_file_sets_accession: List[str]
        :param input_file_sets_aliases: Filter by input_file_sets.aliases
        :type input_file_sets_aliases: List[str]
        :param input_file_sets_file_set_type: Filter by input_file_sets.file_set_type
        :type input_file_sets_file_set_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param protocols: Filter by protocols
        :type protocols: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param sample_summary: Filter by sample_summary
        :type sample_summary: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            external_image_data_url=external_image_data_url,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            functional_assay_mechanisms_id=functional_assay_mechanisms_id,
            functional_assay_mechanisms_term_id=functional_assay_mechanisms_term_id,
            functional_assay_mechanisms_term_name=functional_assay_mechanisms_term_name,
            input_file_set_for=input_file_set_for,
            input_file_sets_id=input_file_sets_id,
            input_file_sets_accession=input_file_sets_accession,
            input_file_sets_aliases=input_file_sets_aliases,
            input_file_sets_file_set_type=input_file_sets_file_set_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            protocols=protocols,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            sample_summary=sample_summary,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def analysis_sets_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        external_image_data_url: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by external_image_data_url")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        functional_assay_mechanisms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by functional_assay_mechanisms.@id")] = None,
        functional_assay_mechanisms_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_id")] = None,
        functional_assay_mechanisms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by functional_assay_mechanisms.term_name")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        input_file_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.@id")] = None,
        input_file_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.accession")] = None,
        input_file_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by input_file_sets.aliases")] = None,
        input_file_sets_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_sets.file_set_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        protocols: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by protocols")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        sample_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by sample_summary")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AnalysisSet collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisSet items. Supports filtering on fields within AnalysisSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param external_image_data_url: Filter by external_image_data_url
        :type external_image_data_url: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param functional_assay_mechanisms_id: Filter by functional_assay_mechanisms.@id
        :type functional_assay_mechanisms_id: List[str]
        :param functional_assay_mechanisms_term_id: Filter by functional_assay_mechanisms.term_id
        :type functional_assay_mechanisms_term_id: List[str]
        :param functional_assay_mechanisms_term_name: Filter by functional_assay_mechanisms.term_name
        :type functional_assay_mechanisms_term_name: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param input_file_sets_id: Filter by input_file_sets.@id
        :type input_file_sets_id: List[str]
        :param input_file_sets_accession: Filter by input_file_sets.accession
        :type input_file_sets_accession: List[str]
        :param input_file_sets_aliases: Filter by input_file_sets.aliases
        :type input_file_sets_aliases: List[str]
        :param input_file_sets_file_set_type: Filter by input_file_sets.file_set_type
        :type input_file_sets_file_set_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param protocols: Filter by protocols
        :type protocols: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param sample_summary: Filter by sample_summary
        :type sample_summary: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            external_image_data_url=external_image_data_url,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            functional_assay_mechanisms_id=functional_assay_mechanisms_id,
            functional_assay_mechanisms_term_id=functional_assay_mechanisms_term_id,
            functional_assay_mechanisms_term_name=functional_assay_mechanisms_term_name,
            input_file_set_for=input_file_set_for,
            input_file_sets_id=input_file_sets_id,
            input_file_sets_accession=input_file_sets_accession,
            input_file_sets_aliases=input_file_sets_aliases,
            input_file_sets_file_set_type=input_file_sets_file_set_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            protocols=protocols,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            sample_summary=sample_summary,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analysis_sets_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        assay_titles,
        award_id,
        award_component,
        award_contact_pi_id,
        award_contact_pi_title,
        award_title,
        collections,
        control_for_id,
        control_for_accession,
        control_for_aliases,
        control_type,
        creation_timestamp,
        dbxrefs,
        description,
        documents,
        donors_id,
        donors_accession,
        donors_aliases,
        donors_sex,
        donors_status,
        donors_taxa,
        external_image_data_url,
        file_set_type,
        files_id,
        files_accession,
        files_aliases,
        files_content_type,
        files_creation_timestamp,
        files_file_format,
        files_file_size,
        files_href,
        files_s3_uri,
        files_sequencing_platform,
        files_submitted_file_name,
        files_upload_status,
        functional_assay_mechanisms_id,
        functional_assay_mechanisms_term_id,
        functional_assay_mechanisms_term_name,
        input_file_set_for,
        input_file_sets_id,
        input_file_sets_accession,
        input_file_sets_aliases,
        input_file_sets_file_set_type,
        lab_id,
        lab_title,
        notes,
        protocols,
        publications_id,
        publications_publication_identifiers,
        release_timestamp,
        revoke_detail,
        sample_summary,
        samples_id,
        samples_accession,
        samples_aliases,
        samples_cell_fate_change_treatments,
        samples_classifications,
        samples_construct_library_sets,
        samples_disease_terms_id,
        samples_disease_terms_term_name,
        samples_modifications,
        samples_sample_terms_id,
        samples_sample_terms_aliases,
        samples_sample_terms_status,
        samples_sample_terms_summary,
        samples_sample_terms_term_name,
        samples_status,
        samples_summary,
        samples_targeted_sample_term_id,
        samples_targeted_sample_term_term_name,
        samples_taxa,
        samples_treatments,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_files_timestamp,
        submitter_comment,
        summary,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'assay_titles': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'award.contact_pi.@id': 'multi',
            'award.contact_pi.title': 'multi',
            'award.title': 'multi',
            'collections': 'multi',
            'control_for.@id': 'multi',
            'control_for.accession': 'multi',
            'control_for.aliases': 'multi',
            'control_type': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'donors.@id': 'multi',
            'donors.accession': 'multi',
            'donors.aliases': 'multi',
            'donors.sex': 'multi',
            'donors.status': 'multi',
            'donors.taxa': 'multi',
            'external_image_data_url': 'multi',
            'file_set_type': 'multi',
            'files.@id': 'multi',
            'files.accession': 'multi',
            'files.aliases': 'multi',
            'files.content_type': 'multi',
            'files.creation_timestamp': 'multi',
            'files.file_format': 'multi',
            'files.file_size': 'multi',
            'files.href': 'multi',
            'files.s3_uri': 'multi',
            'files.sequencing_platform': 'multi',
            'files.submitted_file_name': 'multi',
            'files.upload_status': 'multi',
            'functional_assay_mechanisms.@id': 'multi',
            'functional_assay_mechanisms.term_id': 'multi',
            'functional_assay_mechanisms.term_name': 'multi',
            'input_file_set_for': 'multi',
            'input_file_sets.@id': 'multi',
            'input_file_sets.accession': 'multi',
            'input_file_sets.aliases': 'multi',
            'input_file_sets.file_set_type': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'notes': 'multi',
            'protocols': 'multi',
            'publications.@id': 'multi',
            'publications.publication_identifiers': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            'sample_summary': 'multi',
            'samples.@id': 'multi',
            'samples.accession': 'multi',
            'samples.aliases': 'multi',
            'samples.cell_fate_change_treatments': 'multi',
            'samples.classifications': 'multi',
            'samples.construct_library_sets': 'multi',
            'samples.disease_terms.@id': 'multi',
            'samples.disease_terms.term_name': 'multi',
            'samples.modifications': 'multi',
            'samples.sample_terms.@id': 'multi',
            'samples.sample_terms.aliases': 'multi',
            'samples.sample_terms.status': 'multi',
            'samples.sample_terms.summary': 'multi',
            'samples.sample_terms.term_name': 'multi',
            'samples.status': 'multi',
            'samples.summary': 'multi',
            'samples.targeted_sample_term.@id': 'multi',
            'samples.targeted_sample_term.term_name': 'multi',
            'samples.taxa': 'multi',
            'samples.treatments': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_files_timestamp': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if assay_titles is not None:
            
            _query_params.append(('assay_titles', assay_titles))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if award_contact_pi_id is not None:
            
            _query_params.append(('award.contact_pi.@id', award_contact_pi_id))
            
        if award_contact_pi_title is not None:
            
            _query_params.append(('award.contact_pi.title', award_contact_pi_title))
            
        if award_title is not None:
            
            _query_params.append(('award.title', award_title))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if control_for_id is not None:
            
            _query_params.append(('control_for.@id', control_for_id))
            
        if control_for_accession is not None:
            
            _query_params.append(('control_for.accession', control_for_accession))
            
        if control_for_aliases is not None:
            
            _query_params.append(('control_for.aliases', control_for_aliases))
            
        if control_type is not None:
            
            _query_params.append(('control_type', control_type))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if donors_id is not None:
            
            _query_params.append(('donors.@id', donors_id))
            
        if donors_accession is not None:
            
            _query_params.append(('donors.accession', donors_accession))
            
        if donors_aliases is not None:
            
            _query_params.append(('donors.aliases', donors_aliases))
            
        if donors_sex is not None:
            
            _query_params.append(('donors.sex', donors_sex))
            
        if donors_status is not None:
            
            _query_params.append(('donors.status', donors_status))
            
        if donors_taxa is not None:
            
            _query_params.append(('donors.taxa', donors_taxa))
            
        if external_image_data_url is not None:
            
            _query_params.append(('external_image_data_url', external_image_data_url))
            
        if file_set_type is not None:
            
            _query_params.append(('file_set_type', file_set_type))
            
        if files_id is not None:
            
            _query_params.append(('files.@id', files_id))
            
        if files_accession is not None:
            
            _query_params.append(('files.accession', files_accession))
            
        if files_aliases is not None:
            
            _query_params.append(('files.aliases', files_aliases))
            
        if files_content_type is not None:
            
            _query_params.append(('files.content_type', files_content_type))
            
        if files_creation_timestamp is not None:
            
            _query_params.append(('files.creation_timestamp', files_creation_timestamp))
            
        if files_file_format is not None:
            
            _query_params.append(('files.file_format', files_file_format))
            
        if files_file_size is not None:
            
            _query_params.append(('files.file_size', files_file_size))
            
        if files_href is not None:
            
            _query_params.append(('files.href', files_href))
            
        if files_s3_uri is not None:
            
            _query_params.append(('files.s3_uri', files_s3_uri))
            
        if files_sequencing_platform is not None:
            
            _query_params.append(('files.sequencing_platform', files_sequencing_platform))
            
        if files_submitted_file_name is not None:
            
            _query_params.append(('files.submitted_file_name', files_submitted_file_name))
            
        if files_upload_status is not None:
            
            _query_params.append(('files.upload_status', files_upload_status))
            
        if functional_assay_mechanisms_id is not None:
            
            _query_params.append(('functional_assay_mechanisms.@id', functional_assay_mechanisms_id))
            
        if functional_assay_mechanisms_term_id is not None:
            
            _query_params.append(('functional_assay_mechanisms.term_id', functional_assay_mechanisms_term_id))
            
        if functional_assay_mechanisms_term_name is not None:
            
            _query_params.append(('functional_assay_mechanisms.term_name', functional_assay_mechanisms_term_name))
            
        if input_file_set_for is not None:
            
            _query_params.append(('input_file_set_for', input_file_set_for))
            
        if input_file_sets_id is not None:
            
            _query_params.append(('input_file_sets.@id', input_file_sets_id))
            
        if input_file_sets_accession is not None:
            
            _query_params.append(('input_file_sets.accession', input_file_sets_accession))
            
        if input_file_sets_aliases is not None:
            
            _query_params.append(('input_file_sets.aliases', input_file_sets_aliases))
            
        if input_file_sets_file_set_type is not None:
            
            _query_params.append(('input_file_sets.file_set_type', input_file_sets_file_set_type))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if protocols is not None:
            
            _query_params.append(('protocols', protocols))
            
        if publications_id is not None:
            
            _query_params.append(('publications.@id', publications_id))
            
        if publications_publication_identifiers is not None:
            
            _query_params.append(('publications.publication_identifiers', publications_publication_identifiers))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if sample_summary is not None:
            
            _query_params.append(('sample_summary', sample_summary))
            
        if samples_id is not None:
            
            _query_params.append(('samples.@id', samples_id))
            
        if samples_accession is not None:
            
            _query_params.append(('samples.accession', samples_accession))
            
        if samples_aliases is not None:
            
            _query_params.append(('samples.aliases', samples_aliases))
            
        if samples_cell_fate_change_treatments is not None:
            
            _query_params.append(('samples.cell_fate_change_treatments', samples_cell_fate_change_treatments))
            
        if samples_classifications is not None:
            
            _query_params.append(('samples.classifications', samples_classifications))
            
        if samples_construct_library_sets is not None:
            
            _query_params.append(('samples.construct_library_sets', samples_construct_library_sets))
            
        if samples_disease_terms_id is not None:
            
            _query_params.append(('samples.disease_terms.@id', samples_disease_terms_id))
            
        if samples_disease_terms_term_name is not None:
            
            _query_params.append(('samples.disease_terms.term_name', samples_disease_terms_term_name))
            
        if samples_modifications is not None:
            
            _query_params.append(('samples.modifications', samples_modifications))
            
        if samples_sample_terms_id is not None:
            
            _query_params.append(('samples.sample_terms.@id', samples_sample_terms_id))
            
        if samples_sample_terms_aliases is not None:
            
            _query_params.append(('samples.sample_terms.aliases', samples_sample_terms_aliases))
            
        if samples_sample_terms_status is not None:
            
            _query_params.append(('samples.sample_terms.status', samples_sample_terms_status))
            
        if samples_sample_terms_summary is not None:
            
            _query_params.append(('samples.sample_terms.summary', samples_sample_terms_summary))
            
        if samples_sample_terms_term_name is not None:
            
            _query_params.append(('samples.sample_terms.term_name', samples_sample_terms_term_name))
            
        if samples_status is not None:
            
            _query_params.append(('samples.status', samples_status))
            
        if samples_summary is not None:
            
            _query_params.append(('samples.summary', samples_summary))
            
        if samples_targeted_sample_term_id is not None:
            
            _query_params.append(('samples.targeted_sample_term.@id', samples_targeted_sample_term_id))
            
        if samples_targeted_sample_term_term_name is not None:
            
            _query_params.append(('samples.targeted_sample_term.term_name', samples_targeted_sample_term_term_name))
            
        if samples_taxa is not None:
            
            _query_params.append(('samples.taxa', samples_taxa))
            
        if samples_treatments is not None:
            
            _query_params.append(('samples.treatments', samples_treatments))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_files_timestamp is not None:
            
            _query_params.append(('submitted_files_timestamp', submitted_files_timestamp))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/analysis-sets/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analysis_step_versions(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.@id")] = None,
        analysis_step_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.name")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        software_versions_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.@id")] = None,
        software_versions_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.name")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AnalysisStepVersionResults:
        """List items in the AnalysisStepVersion collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStepVersion items. Supports filtering on fields within AnalysisStepVersion items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_id: Filter by analysis_step.@id
        :type analysis_step_id: List[str]
        :param analysis_step_name: Filter by analysis_step.name
        :type analysis_step_name: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param software_versions_id: Filter by software_versions.@id
        :type software_versions_id: List[str]
        :param software_versions_name: Filter by software_versions.name
        :type software_versions_name: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_step_versions_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_id=analysis_step_id,
            analysis_step_name=analysis_step_name,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            software_versions_id=software_versions_id,
            software_versions_name=software_versions_name,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepVersionResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def analysis_step_versions_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.@id")] = None,
        analysis_step_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.name")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        software_versions_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.@id")] = None,
        software_versions_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.name")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AnalysisStepVersionResults]:
        """List items in the AnalysisStepVersion collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStepVersion items. Supports filtering on fields within AnalysisStepVersion items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_id: Filter by analysis_step.@id
        :type analysis_step_id: List[str]
        :param analysis_step_name: Filter by analysis_step.name
        :type analysis_step_name: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param software_versions_id: Filter by software_versions.@id
        :type software_versions_id: List[str]
        :param software_versions_name: Filter by software_versions.name
        :type software_versions_name: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_step_versions_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_id=analysis_step_id,
            analysis_step_name=analysis_step_name,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            software_versions_id=software_versions_id,
            software_versions_name=software_versions_name,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepVersionResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def analysis_step_versions_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.@id")] = None,
        analysis_step_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step.name")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        software_versions_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.@id")] = None,
        software_versions_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by software_versions.name")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AnalysisStepVersion collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStepVersion items. Supports filtering on fields within AnalysisStepVersion items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_id: Filter by analysis_step.@id
        :type analysis_step_id: List[str]
        :param analysis_step_name: Filter by analysis_step.name
        :type analysis_step_name: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param software_versions_id: Filter by software_versions.@id
        :type software_versions_id: List[str]
        :param software_versions_name: Filter by software_versions.name
        :type software_versions_name: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_step_versions_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_id=analysis_step_id,
            analysis_step_name=analysis_step_name,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            software_versions_id=software_versions_id,
            software_versions_name=software_versions_name,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepVersionResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analysis_step_versions_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        analysis_step_id,
        analysis_step_name,
        award_id,
        award_component,
        creation_timestamp,
        description,
        lab_id,
        lab_title,
        notes,
        release_timestamp,
        software_versions_id,
        software_versions_name,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'analysis_step.@id': 'multi',
            'analysis_step.name': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'notes': 'multi',
            'release_timestamp': 'multi',
            'software_versions.@id': 'multi',
            'software_versions.name': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if analysis_step_id is not None:
            
            _query_params.append(('analysis_step.@id', analysis_step_id))
            
        if analysis_step_name is not None:
            
            _query_params.append(('analysis_step.name', analysis_step_name))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if software_versions_id is not None:
            
            _query_params.append(('software_versions.@id', software_versions_id))
            
        if software_versions_name is not None:
            
            _query_params.append(('software_versions.name', software_versions_name))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/analysis-step-versions/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def analysis_steps(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_types")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        input_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_content_types")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        output_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by output_content_types")] = None,
        parents_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by parents.@id")] = None,
        parents_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by parents.title")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        step_label: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by step_label")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        workflow_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.@id")] = None,
        workflow_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.accession")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AnalysisStepResults:
        """List items in the AnalysisStep collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStep items. Supports filtering on fields within AnalysisStep items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_types: Filter by analysis_step_types
        :type analysis_step_types: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param input_content_types: Filter by input_content_types
        :type input_content_types: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param output_content_types: Filter by output_content_types
        :type output_content_types: List[str]
        :param parents_id: Filter by parents.@id
        :type parents_id: List[str]
        :param parents_title: Filter by parents.title
        :type parents_title: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param step_label: Filter by step_label
        :type step_label: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param workflow_id: Filter by workflow.@id
        :type workflow_id: List[str]
        :param workflow_accession: Filter by workflow.accession
        :type workflow_accession: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_steps_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_types=analysis_step_types,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            input_content_types=input_content_types,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            notes=notes,
            output_content_types=output_content_types,
            parents_id=parents_id,
            parents_title=parents_title,
            release_timestamp=release_timestamp,
            status=status,
            step_label=step_label,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            uuid=uuid,
            workflow_id=workflow_id,
            workflow_accession=workflow_accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def analysis_steps_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_types")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        input_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_content_types")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        output_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by output_content_types")] = None,
        parents_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by parents.@id")] = None,
        parents_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by parents.title")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        step_label: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by step_label")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        workflow_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.@id")] = None,
        workflow_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.accession")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AnalysisStepResults]:
        """List items in the AnalysisStep collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStep items. Supports filtering on fields within AnalysisStep items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_types: Filter by analysis_step_types
        :type analysis_step_types: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param input_content_types: Filter by input_content_types
        :type input_content_types: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param output_content_types: Filter by output_content_types
        :type output_content_types: List[str]
        :param parents_id: Filter by parents.@id
        :type parents_id: List[str]
        :param parents_title: Filter by parents.title
        :type parents_title: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param step_label: Filter by step_label
        :type step_label: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param workflow_id: Filter by workflow.@id
        :type workflow_id: List[str]
        :param workflow_accession: Filter by workflow.accession
        :type workflow_accession: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_steps_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_types=analysis_step_types,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            input_content_types=input_content_types,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            notes=notes,
            output_content_types=output_content_types,
            parents_id=parents_id,
            parents_title=parents_title,
            release_timestamp=release_timestamp,
            status=status,
            step_label=step_label,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            uuid=uuid,
            workflow_id=workflow_id,
            workflow_accession=workflow_accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def analysis_steps_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        analysis_step_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_types")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        input_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_content_types")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        output_content_types: Annotated[Optional[List[StrictStr]], Field(description="Filter by output_content_types")] = None,
        parents_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by parents.@id")] = None,
        parents_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by parents.title")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        step_label: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by step_label")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        workflow_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.@id")] = None,
        workflow_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by workflow.accession")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AnalysisStep collection.

        Collection endpoint that accepts various query parameters to filter and sort AnalysisStep items. Supports filtering on fields within AnalysisStep items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param analysis_step_types: Filter by analysis_step_types
        :type analysis_step_types: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param input_content_types: Filter by input_content_types
        :type input_content_types: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param output_content_types: Filter by output_content_types
        :type output_content_types: List[str]
        :param parents_id: Filter by parents.@id
        :type parents_id: List[str]
        :param parents_title: Filter by parents.title
        :type parents_title: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param step_label: Filter by step_label
        :type step_label: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param workflow_id: Filter by workflow.@id
        :type workflow_id: List[str]
        :param workflow_accession: Filter by workflow.accession
        :type workflow_accession: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._analysis_steps_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            analysis_step_types=analysis_step_types,
            award_id=award_id,
            award_component=award_component,
            creation_timestamp=creation_timestamp,
            description=description,
            input_content_types=input_content_types,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            notes=notes,
            output_content_types=output_content_types,
            parents_id=parents_id,
            parents_title=parents_title,
            release_timestamp=release_timestamp,
            status=status,
            step_label=step_label,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            uuid=uuid,
            workflow_id=workflow_id,
            workflow_accession=workflow_accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AnalysisStepResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _analysis_steps_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        analysis_step_types,
        award_id,
        award_component,
        creation_timestamp,
        description,
        input_content_types,
        lab_id,
        lab_title,
        name,
        notes,
        output_content_types,
        parents_id,
        parents_title,
        release_timestamp,
        status,
        step_label,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        title,
        uuid,
        workflow_id,
        workflow_accession,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'analysis_step_types': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'input_content_types': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'name': 'multi',
            'notes': 'multi',
            'output_content_types': 'multi',
            'parents.@id': 'multi',
            'parents.title': 'multi',
            'release_timestamp': 'multi',
            'status': 'multi',
            'step_label': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'title': 'multi',
            'uuid': 'multi',
            'workflow.@id': 'multi',
            'workflow.accession': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if analysis_step_types is not None:
            
            _query_params.append(('analysis_step_types', analysis_step_types))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if input_content_types is not None:
            
            _query_params.append(('input_content_types', input_content_types))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if output_content_types is not None:
            
            _query_params.append(('output_content_types', output_content_types))
            
        if parents_id is not None:
            
            _query_params.append(('parents.@id', parents_id))
            
        if parents_title is not None:
            
            _query_params.append(('parents.title', parents_title))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if step_label is not None:
            
            _query_params.append(('step_label', step_label))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        if workflow_id is not None:
            
            _query_params.append(('workflow.@id', workflow_id))
            
        if workflow_accession is not None:
            
            _query_params.append(('workflow.accession', workflow_accession))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/analysis-steps/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def assay_terms(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        ancestors: Annotated[Optional[List[StrictStr]], Field(description="Filter by ancestors")] = None,
        assay_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_slims")] = None,
        category_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by category_slims")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        deprecated_ntr_terms: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by deprecated_ntr_terms")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        is_a: Annotated[Optional[List[StrictStr]], Field(description="Filter by is_a")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        objective_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by objective_slims")] = None,
        ontology: Annotated[Optional[List[StrictStr]], Field(description="Filter by ontology")] = None,
        preferred_assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by preferred_assay_titles")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_id")] = None,
        term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_name")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AssayTermResults:
        """List items in the AssayTerm collection.

        Collection endpoint that accepts various query parameters to filter and sort AssayTerm items. Supports filtering on fields within AssayTerm items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param ancestors: Filter by ancestors
        :type ancestors: List[str]
        :param assay_slims: Filter by assay_slims
        :type assay_slims: List[str]
        :param category_slims: Filter by category_slims
        :type category_slims: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param deprecated_ntr_terms: Filter by deprecated_ntr_terms
        :type deprecated_ntr_terms: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param is_a: Filter by is_a
        :type is_a: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param objective_slims: Filter by objective_slims
        :type objective_slims: List[str]
        :param ontology: Filter by ontology
        :type ontology: List[str]
        :param preferred_assay_titles: Filter by preferred_assay_titles
        :type preferred_assay_titles: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param term_id: Filter by term_id
        :type term_id: List[str]
        :param term_name: Filter by term_name
        :type term_name: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assay_terms_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            ancestors=ancestors,
            assay_slims=assay_slims,
            category_slims=category_slims,
            creation_timestamp=creation_timestamp,
            deprecated_ntr_terms=deprecated_ntr_terms,
            description=description,
            is_a=is_a,
            name=name,
            notes=notes,
            objective_slims=objective_slims,
            ontology=ontology,
            preferred_assay_titles=preferred_assay_titles,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            term_id=term_id,
            term_name=term_name,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AssayTermResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def assay_terms_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        ancestors: Annotated[Optional[List[StrictStr]], Field(description="Filter by ancestors")] = None,
        assay_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_slims")] = None,
        category_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by category_slims")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        deprecated_ntr_terms: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by deprecated_ntr_terms")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        is_a: Annotated[Optional[List[StrictStr]], Field(description="Filter by is_a")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        objective_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by objective_slims")] = None,
        ontology: Annotated[Optional[List[StrictStr]], Field(description="Filter by ontology")] = None,
        preferred_assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by preferred_assay_titles")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_id")] = None,
        term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_name")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AssayTermResults]:
        """List items in the AssayTerm collection.

        Collection endpoint that accepts various query parameters to filter and sort AssayTerm items. Supports filtering on fields within AssayTerm items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param ancestors: Filter by ancestors
        :type ancestors: List[str]
        :param assay_slims: Filter by assay_slims
        :type assay_slims: List[str]
        :param category_slims: Filter by category_slims
        :type category_slims: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param deprecated_ntr_terms: Filter by deprecated_ntr_terms
        :type deprecated_ntr_terms: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param is_a: Filter by is_a
        :type is_a: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param objective_slims: Filter by objective_slims
        :type objective_slims: List[str]
        :param ontology: Filter by ontology
        :type ontology: List[str]
        :param preferred_assay_titles: Filter by preferred_assay_titles
        :type preferred_assay_titles: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param term_id: Filter by term_id
        :type term_id: List[str]
        :param term_name: Filter by term_name
        :type term_name: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assay_terms_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            ancestors=ancestors,
            assay_slims=assay_slims,
            category_slims=category_slims,
            creation_timestamp=creation_timestamp,
            deprecated_ntr_terms=deprecated_ntr_terms,
            description=description,
            is_a=is_a,
            name=name,
            notes=notes,
            objective_slims=objective_slims,
            ontology=ontology,
            preferred_assay_titles=preferred_assay_titles,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            term_id=term_id,
            term_name=term_name,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AssayTermResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def assay_terms_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        ancestors: Annotated[Optional[List[StrictStr]], Field(description="Filter by ancestors")] = None,
        assay_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_slims")] = None,
        category_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by category_slims")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        deprecated_ntr_terms: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by deprecated_ntr_terms")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        is_a: Annotated[Optional[List[StrictStr]], Field(description="Filter by is_a")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        objective_slims: Annotated[Optional[List[StrictStr]], Field(description="Filter by objective_slims")] = None,
        ontology: Annotated[Optional[List[StrictStr]], Field(description="Filter by ontology")] = None,
        preferred_assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by preferred_assay_titles")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_id")] = None,
        term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by term_name")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AssayTerm collection.

        Collection endpoint that accepts various query parameters to filter and sort AssayTerm items. Supports filtering on fields within AssayTerm items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param ancestors: Filter by ancestors
        :type ancestors: List[str]
        :param assay_slims: Filter by assay_slims
        :type assay_slims: List[str]
        :param category_slims: Filter by category_slims
        :type category_slims: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param deprecated_ntr_terms: Filter by deprecated_ntr_terms
        :type deprecated_ntr_terms: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param is_a: Filter by is_a
        :type is_a: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param objective_slims: Filter by objective_slims
        :type objective_slims: List[str]
        :param ontology: Filter by ontology
        :type ontology: List[str]
        :param preferred_assay_titles: Filter by preferred_assay_titles
        :type preferred_assay_titles: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param term_id: Filter by term_id
        :type term_id: List[str]
        :param term_name: Filter by term_name
        :type term_name: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assay_terms_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            ancestors=ancestors,
            assay_slims=assay_slims,
            category_slims=category_slims,
            creation_timestamp=creation_timestamp,
            deprecated_ntr_terms=deprecated_ntr_terms,
            description=description,
            is_a=is_a,
            name=name,
            notes=notes,
            objective_slims=objective_slims,
            ontology=ontology,
            preferred_assay_titles=preferred_assay_titles,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            term_id=term_id,
            term_name=term_name,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AssayTermResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _assay_terms_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        ancestors,
        assay_slims,
        category_slims,
        creation_timestamp,
        deprecated_ntr_terms,
        description,
        is_a,
        name,
        notes,
        objective_slims,
        ontology,
        preferred_assay_titles,
        release_timestamp,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        synonyms,
        term_id,
        term_name,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'ancestors': 'multi',
            'assay_slims': 'multi',
            'category_slims': 'multi',
            'creation_timestamp': 'multi',
            'deprecated_ntr_terms': 'multi',
            'description': 'multi',
            'is_a': 'multi',
            'name': 'multi',
            'notes': 'multi',
            'objective_slims': 'multi',
            'ontology': 'multi',
            'preferred_assay_titles': 'multi',
            'release_timestamp': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'synonyms': 'multi',
            'term_id': 'multi',
            'term_name': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if ancestors is not None:
            
            _query_params.append(('ancestors', ancestors))
            
        if assay_slims is not None:
            
            _query_params.append(('assay_slims', assay_slims))
            
        if category_slims is not None:
            
            _query_params.append(('category_slims', category_slims))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if deprecated_ntr_terms is not None:
            
            _query_params.append(('deprecated_ntr_terms', deprecated_ntr_terms))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if is_a is not None:
            
            _query_params.append(('is_a', is_a))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if objective_slims is not None:
            
            _query_params.append(('objective_slims', objective_slims))
            
        if ontology is not None:
            
            _query_params.append(('ontology', ontology))
            
        if preferred_assay_titles is not None:
            
            _query_params.append(('preferred_assay_titles', preferred_assay_titles))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if synonyms is not None:
            
            _query_params.append(('synonyms', synonyms))
            
        if term_id is not None:
            
            _query_params.append(('term_id', term_id))
            
        if term_name is not None:
            
            _query_params.append(('term_name', term_name))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/assay-terms/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def auxiliary_sets(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        barcode_map: Annotated[Optional[List[StrictStr]], Field(description="Filter by barcode_map")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        measurement_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.@id")] = None,
        measurement_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.accession")] = None,
        measurement_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by measurement_sets.aliases")] = None,
        measurement_sets_preferred_assay_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.preferred_assay_title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AuxiliarySetResults:
        """List items in the AuxiliarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort AuxiliarySet items. Supports filtering on fields within AuxiliarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param barcode_map: Filter by barcode_map
        :type barcode_map: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param measurement_sets_id: Filter by measurement_sets.@id
        :type measurement_sets_id: List[str]
        :param measurement_sets_accession: Filter by measurement_sets.accession
        :type measurement_sets_accession: List[str]
        :param measurement_sets_aliases: Filter by measurement_sets.aliases
        :type measurement_sets_aliases: List[str]
        :param measurement_sets_preferred_assay_title: Filter by measurement_sets.preferred_assay_title
        :type measurement_sets_preferred_assay_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._auxiliary_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            barcode_map=barcode_map,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            measurement_sets_id=measurement_sets_id,
            measurement_sets_accession=measurement_sets_accession,
            measurement_sets_aliases=measurement_sets_aliases,
            measurement_sets_preferred_assay_title=measurement_sets_preferred_assay_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AuxiliarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def auxiliary_sets_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        barcode_map: Annotated[Optional[List[StrictStr]], Field(description="Filter by barcode_map")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        measurement_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.@id")] = None,
        measurement_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.accession")] = None,
        measurement_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by measurement_sets.aliases")] = None,
        measurement_sets_preferred_assay_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.preferred_assay_title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AuxiliarySetResults]:
        """List items in the AuxiliarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort AuxiliarySet items. Supports filtering on fields within AuxiliarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param barcode_map: Filter by barcode_map
        :type barcode_map: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param measurement_sets_id: Filter by measurement_sets.@id
        :type measurement_sets_id: List[str]
        :param measurement_sets_accession: Filter by measurement_sets.accession
        :type measurement_sets_accession: List[str]
        :param measurement_sets_aliases: Filter by measurement_sets.aliases
        :type measurement_sets_aliases: List[str]
        :param measurement_sets_preferred_assay_title: Filter by measurement_sets.preferred_assay_title
        :type measurement_sets_preferred_assay_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._auxiliary_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            barcode_map=barcode_map,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            measurement_sets_id=measurement_sets_id,
            measurement_sets_accession=measurement_sets_accession,
            measurement_sets_aliases=measurement_sets_aliases,
            measurement_sets_preferred_assay_title=measurement_sets_preferred_assay_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AuxiliarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def auxiliary_sets_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        barcode_map: Annotated[Optional[List[StrictStr]], Field(description="Filter by barcode_map")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        measurement_sets_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.@id")] = None,
        measurement_sets_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.accession")] = None,
        measurement_sets_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by measurement_sets.aliases")] = None,
        measurement_sets_preferred_assay_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by measurement_sets.preferred_assay_title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the AuxiliarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort AuxiliarySet items. Supports filtering on fields within AuxiliarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param barcode_map: Filter by barcode_map
        :type barcode_map: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param measurement_sets_id: Filter by measurement_sets.@id
        :type measurement_sets_id: List[str]
        :param measurement_sets_accession: Filter by measurement_sets.accession
        :type measurement_sets_accession: List[str]
        :param measurement_sets_aliases: Filter by measurement_sets.aliases
        :type measurement_sets_aliases: List[str]
        :param measurement_sets_preferred_assay_title: Filter by measurement_sets.preferred_assay_title
        :type measurement_sets_preferred_assay_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._auxiliary_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            barcode_map=barcode_map,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            measurement_sets_id=measurement_sets_id,
            measurement_sets_accession=measurement_sets_accession,
            measurement_sets_aliases=measurement_sets_aliases,
            measurement_sets_preferred_assay_title=measurement_sets_preferred_assay_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AuxiliarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _auxiliary_sets_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        award_id,
        award_component,
        award_contact_pi_id,
        award_contact_pi_title,
        award_title,
        barcode_map,
        collections,
        control_for_id,
        control_for_accession,
        control_for_aliases,
        control_type,
        creation_timestamp,
        dbxrefs,
        description,
        documents,
        donors_id,
        donors_accession,
        donors_aliases,
        donors_sex,
        donors_status,
        donors_taxa,
        file_set_type,
        files_id,
        files_accession,
        files_aliases,
        files_content_type,
        files_creation_timestamp,
        files_file_format,
        files_file_size,
        files_href,
        files_s3_uri,
        files_sequencing_platform,
        files_submitted_file_name,
        files_upload_status,
        input_file_set_for,
        lab_id,
        lab_title,
        measurement_sets_id,
        measurement_sets_accession,
        measurement_sets_aliases,
        measurement_sets_preferred_assay_title,
        notes,
        publications_id,
        publications_publication_identifiers,
        release_timestamp,
        revoke_detail,
        samples_id,
        samples_accession,
        samples_aliases,
        samples_cell_fate_change_treatments,
        samples_classifications,
        samples_construct_library_sets,
        samples_disease_terms_id,
        samples_disease_terms_term_name,
        samples_modifications,
        samples_sample_terms_id,
        samples_sample_terms_aliases,
        samples_sample_terms_status,
        samples_sample_terms_summary,
        samples_sample_terms_term_name,
        samples_status,
        samples_summary,
        samples_targeted_sample_term_id,
        samples_targeted_sample_term_term_name,
        samples_taxa,
        samples_treatments,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_files_timestamp,
        submitter_comment,
        summary,
        url,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'award.contact_pi.@id': 'multi',
            'award.contact_pi.title': 'multi',
            'award.title': 'multi',
            'barcode_map': 'multi',
            'collections': 'multi',
            'control_for.@id': 'multi',
            'control_for.accession': 'multi',
            'control_for.aliases': 'multi',
            'control_type': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'donors.@id': 'multi',
            'donors.accession': 'multi',
            'donors.aliases': 'multi',
            'donors.sex': 'multi',
            'donors.status': 'multi',
            'donors.taxa': 'multi',
            'file_set_type': 'multi',
            'files.@id': 'multi',
            'files.accession': 'multi',
            'files.aliases': 'multi',
            'files.content_type': 'multi',
            'files.creation_timestamp': 'multi',
            'files.file_format': 'multi',
            'files.file_size': 'multi',
            'files.href': 'multi',
            'files.s3_uri': 'multi',
            'files.sequencing_platform': 'multi',
            'files.submitted_file_name': 'multi',
            'files.upload_status': 'multi',
            'input_file_set_for': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'measurement_sets.@id': 'multi',
            'measurement_sets.accession': 'multi',
            'measurement_sets.aliases': 'multi',
            'measurement_sets.preferred_assay_title': 'multi',
            'notes': 'multi',
            'publications.@id': 'multi',
            'publications.publication_identifiers': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            'samples.@id': 'multi',
            'samples.accession': 'multi',
            'samples.aliases': 'multi',
            'samples.cell_fate_change_treatments': 'multi',
            'samples.classifications': 'multi',
            'samples.construct_library_sets': 'multi',
            'samples.disease_terms.@id': 'multi',
            'samples.disease_terms.term_name': 'multi',
            'samples.modifications': 'multi',
            'samples.sample_terms.@id': 'multi',
            'samples.sample_terms.aliases': 'multi',
            'samples.sample_terms.status': 'multi',
            'samples.sample_terms.summary': 'multi',
            'samples.sample_terms.term_name': 'multi',
            'samples.status': 'multi',
            'samples.summary': 'multi',
            'samples.targeted_sample_term.@id': 'multi',
            'samples.targeted_sample_term.term_name': 'multi',
            'samples.taxa': 'multi',
            'samples.treatments': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_files_timestamp': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'url': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if award_contact_pi_id is not None:
            
            _query_params.append(('award.contact_pi.@id', award_contact_pi_id))
            
        if award_contact_pi_title is not None:
            
            _query_params.append(('award.contact_pi.title', award_contact_pi_title))
            
        if award_title is not None:
            
            _query_params.append(('award.title', award_title))
            
        if barcode_map is not None:
            
            _query_params.append(('barcode_map', barcode_map))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if control_for_id is not None:
            
            _query_params.append(('control_for.@id', control_for_id))
            
        if control_for_accession is not None:
            
            _query_params.append(('control_for.accession', control_for_accession))
            
        if control_for_aliases is not None:
            
            _query_params.append(('control_for.aliases', control_for_aliases))
            
        if control_type is not None:
            
            _query_params.append(('control_type', control_type))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if donors_id is not None:
            
            _query_params.append(('donors.@id', donors_id))
            
        if donors_accession is not None:
            
            _query_params.append(('donors.accession', donors_accession))
            
        if donors_aliases is not None:
            
            _query_params.append(('donors.aliases', donors_aliases))
            
        if donors_sex is not None:
            
            _query_params.append(('donors.sex', donors_sex))
            
        if donors_status is not None:
            
            _query_params.append(('donors.status', donors_status))
            
        if donors_taxa is not None:
            
            _query_params.append(('donors.taxa', donors_taxa))
            
        if file_set_type is not None:
            
            _query_params.append(('file_set_type', file_set_type))
            
        if files_id is not None:
            
            _query_params.append(('files.@id', files_id))
            
        if files_accession is not None:
            
            _query_params.append(('files.accession', files_accession))
            
        if files_aliases is not None:
            
            _query_params.append(('files.aliases', files_aliases))
            
        if files_content_type is not None:
            
            _query_params.append(('files.content_type', files_content_type))
            
        if files_creation_timestamp is not None:
            
            _query_params.append(('files.creation_timestamp', files_creation_timestamp))
            
        if files_file_format is not None:
            
            _query_params.append(('files.file_format', files_file_format))
            
        if files_file_size is not None:
            
            _query_params.append(('files.file_size', files_file_size))
            
        if files_href is not None:
            
            _query_params.append(('files.href', files_href))
            
        if files_s3_uri is not None:
            
            _query_params.append(('files.s3_uri', files_s3_uri))
            
        if files_sequencing_platform is not None:
            
            _query_params.append(('files.sequencing_platform', files_sequencing_platform))
            
        if files_submitted_file_name is not None:
            
            _query_params.append(('files.submitted_file_name', files_submitted_file_name))
            
        if files_upload_status is not None:
            
            _query_params.append(('files.upload_status', files_upload_status))
            
        if input_file_set_for is not None:
            
            _query_params.append(('input_file_set_for', input_file_set_for))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if measurement_sets_id is not None:
            
            _query_params.append(('measurement_sets.@id', measurement_sets_id))
            
        if measurement_sets_accession is not None:
            
            _query_params.append(('measurement_sets.accession', measurement_sets_accession))
            
        if measurement_sets_aliases is not None:
            
            _query_params.append(('measurement_sets.aliases', measurement_sets_aliases))
            
        if measurement_sets_preferred_assay_title is not None:
            
            _query_params.append(('measurement_sets.preferred_assay_title', measurement_sets_preferred_assay_title))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if publications_id is not None:
            
            _query_params.append(('publications.@id', publications_id))
            
        if publications_publication_identifiers is not None:
            
            _query_params.append(('publications.publication_identifiers', publications_publication_identifiers))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if samples_id is not None:
            
            _query_params.append(('samples.@id', samples_id))
            
        if samples_accession is not None:
            
            _query_params.append(('samples.accession', samples_accession))
            
        if samples_aliases is not None:
            
            _query_params.append(('samples.aliases', samples_aliases))
            
        if samples_cell_fate_change_treatments is not None:
            
            _query_params.append(('samples.cell_fate_change_treatments', samples_cell_fate_change_treatments))
            
        if samples_classifications is not None:
            
            _query_params.append(('samples.classifications', samples_classifications))
            
        if samples_construct_library_sets is not None:
            
            _query_params.append(('samples.construct_library_sets', samples_construct_library_sets))
            
        if samples_disease_terms_id is not None:
            
            _query_params.append(('samples.disease_terms.@id', samples_disease_terms_id))
            
        if samples_disease_terms_term_name is not None:
            
            _query_params.append(('samples.disease_terms.term_name', samples_disease_terms_term_name))
            
        if samples_modifications is not None:
            
            _query_params.append(('samples.modifications', samples_modifications))
            
        if samples_sample_terms_id is not None:
            
            _query_params.append(('samples.sample_terms.@id', samples_sample_terms_id))
            
        if samples_sample_terms_aliases is not None:
            
            _query_params.append(('samples.sample_terms.aliases', samples_sample_terms_aliases))
            
        if samples_sample_terms_status is not None:
            
            _query_params.append(('samples.sample_terms.status', samples_sample_terms_status))
            
        if samples_sample_terms_summary is not None:
            
            _query_params.append(('samples.sample_terms.summary', samples_sample_terms_summary))
            
        if samples_sample_terms_term_name is not None:
            
            _query_params.append(('samples.sample_terms.term_name', samples_sample_terms_term_name))
            
        if samples_status is not None:
            
            _query_params.append(('samples.status', samples_status))
            
        if samples_summary is not None:
            
            _query_params.append(('samples.summary', samples_summary))
            
        if samples_targeted_sample_term_id is not None:
            
            _query_params.append(('samples.targeted_sample_term.@id', samples_targeted_sample_term_id))
            
        if samples_targeted_sample_term_term_name is not None:
            
            _query_params.append(('samples.targeted_sample_term.term_name', samples_targeted_sample_term_term_name))
            
        if samples_taxa is not None:
            
            _query_params.append(('samples.taxa', samples_taxa))
            
        if samples_treatments is not None:
            
            _query_params.append(('samples.treatments', samples_treatments))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_files_timestamp is not None:
            
            _query_params.append(('submitted_files_timestamp', submitted_files_timestamp))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if url is not None:
            
            _query_params.append(('url', url))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/auxiliary-sets/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def awards(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        component: Annotated[Optional[List[StrictStr]], Field(description="Filter by component")] = None,
        contact_pi: Annotated[Optional[List[StrictStr]], Field(description="Filter by contact_pi")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        end_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by end_date")] = None,
        name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        pis: Annotated[Optional[List[StrictStr]], Field(description="Filter by pis")] = None,
        project: Annotated[Optional[List[StrictStr]], Field(description="Filter by project")] = None,
        start_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by start_date")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        viewing_group: Annotated[Optional[List[StrictStr]], Field(description="Filter by viewing_group")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AwardResults:
        """List items in the Award collection.

        Collection endpoint that accepts various query parameters to filter and sort Award items. Supports filtering on fields within Award items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param component: Filter by component
        :type component: List[str]
        :param contact_pi: Filter by contact_pi
        :type contact_pi: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param end_date: Filter by end_date
        :type end_date: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param pis: Filter by pis
        :type pis: List[str]
        :param project: Filter by project
        :type project: List[str]
        :param start_date: Filter by start_date
        :type start_date: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param viewing_group: Filter by viewing_group
        :type viewing_group: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._awards_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            component=component,
            contact_pi=contact_pi,
            creation_timestamp=creation_timestamp,
            description=description,
            end_date=end_date,
            name=name,
            notes=notes,
            pis=pis,
            project=project,
            start_date=start_date,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            url=url,
            uuid=uuid,
            viewing_group=viewing_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AwardResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def awards_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        component: Annotated[Optional[List[StrictStr]], Field(description="Filter by component")] = None,
        contact_pi: Annotated[Optional[List[StrictStr]], Field(description="Filter by contact_pi")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        end_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by end_date")] = None,
        name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        pis: Annotated[Optional[List[StrictStr]], Field(description="Filter by pis")] = None,
        project: Annotated[Optional[List[StrictStr]], Field(description="Filter by project")] = None,
        start_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by start_date")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        viewing_group: Annotated[Optional[List[StrictStr]], Field(description="Filter by viewing_group")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AwardResults]:
        """List items in the Award collection.

        Collection endpoint that accepts various query parameters to filter and sort Award items. Supports filtering on fields within Award items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param component: Filter by component
        :type component: List[str]
        :param contact_pi: Filter by contact_pi
        :type contact_pi: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param end_date: Filter by end_date
        :type end_date: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param pis: Filter by pis
        :type pis: List[str]
        :param project: Filter by project
        :type project: List[str]
        :param start_date: Filter by start_date
        :type start_date: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param viewing_group: Filter by viewing_group
        :type viewing_group: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._awards_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            component=component,
            contact_pi=contact_pi,
            creation_timestamp=creation_timestamp,
            description=description,
            end_date=end_date,
            name=name,
            notes=notes,
            pis=pis,
            project=project,
            start_date=start_date,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            url=url,
            uuid=uuid,
            viewing_group=viewing_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AwardResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def awards_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        component: Annotated[Optional[List[StrictStr]], Field(description="Filter by component")] = None,
        contact_pi: Annotated[Optional[List[StrictStr]], Field(description="Filter by contact_pi")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        end_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by end_date")] = None,
        name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        pis: Annotated[Optional[List[StrictStr]], Field(description="Filter by pis")] = None,
        project: Annotated[Optional[List[StrictStr]], Field(description="Filter by project")] = None,
        start_date: Annotated[Optional[List[StrictStr]], Field(description="Filter by start_date")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by title")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        viewing_group: Annotated[Optional[List[StrictStr]], Field(description="Filter by viewing_group")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the Award collection.

        Collection endpoint that accepts various query parameters to filter and sort Award items. Supports filtering on fields within Award items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param component: Filter by component
        :type component: List[str]
        :param contact_pi: Filter by contact_pi
        :type contact_pi: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param end_date: Filter by end_date
        :type end_date: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param pis: Filter by pis
        :type pis: List[str]
        :param project: Filter by project
        :type project: List[str]
        :param start_date: Filter by start_date
        :type start_date: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param viewing_group: Filter by viewing_group
        :type viewing_group: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._awards_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            component=component,
            contact_pi=contact_pi,
            creation_timestamp=creation_timestamp,
            description=description,
            end_date=end_date,
            name=name,
            notes=notes,
            pis=pis,
            project=project,
            start_date=start_date,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            title=title,
            url=url,
            uuid=uuid,
            viewing_group=viewing_group,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AwardResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _awards_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        component,
        contact_pi,
        creation_timestamp,
        description,
        end_date,
        name,
        notes,
        pis,
        project,
        start_date,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        title,
        url,
        uuid,
        viewing_group,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'component': 'multi',
            'contact_pi': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'end_date': 'multi',
            'name': 'multi',
            'notes': 'multi',
            'pis': 'multi',
            'project': 'multi',
            'start_date': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'title': 'multi',
            'url': 'multi',
            'uuid': 'multi',
            'viewing_group': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if component is not None:
            
            _query_params.append(('component', component))
            
        if contact_pi is not None:
            
            _query_params.append(('contact_pi', contact_pi))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if pis is not None:
            
            _query_params.append(('pis', pis))
            
        if project is not None:
            
            _query_params.append(('project', project))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if url is not None:
            
            _query_params.append(('url', url))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        if viewing_group is not None:
            
            _query_params.append(('viewing_group', viewing_group))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/awards/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def batch_download(
        self,
        type: Annotated[List[StrictStr], Field(description="Type of objects to return. Can be repeated for multiple types.")],
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        field_filters: Annotated[Optional[Dict[str, Any]], Field(description="Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """List files to download based on search query. All results are returned.

        Generates TSV of files contained in FileSets in search results.

        :param type: Type of objects to return. Can be repeated for multiple types. (required)
        :type type: List[str]
        :param query: Query string for searching.
        :type query: str
        :param field_filters: Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.
        :type field_filters: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_download_serialize(
            type=type,
            query=query,
            field_filters=field_filters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "object",
            '404': "object",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def batch_download_with_http_info(
        self,
        type: Annotated[List[StrictStr], Field(description="Type of objects to return. Can be repeated for multiple types.")],
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        field_filters: Annotated[Optional[Dict[str, Any]], Field(description="Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """List files to download based on search query. All results are returned.

        Generates TSV of files contained in FileSets in search results.

        :param type: Type of objects to return. Can be repeated for multiple types. (required)
        :type type: List[str]
        :param query: Query string for searching.
        :type query: str
        :param field_filters: Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.
        :type field_filters: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_download_serialize(
            type=type,
            query=query,
            field_filters=field_filters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "object",
            '404': "object",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def batch_download_without_preload_content(
        self,
        type: Annotated[List[StrictStr], Field(description="Type of objects to return. Can be repeated for multiple types.")],
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        field_filters: Annotated[Optional[Dict[str, Any]], Field(description="Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List files to download based on search query. All results are returned.

        Generates TSV of files contained in FileSets in search results.

        :param type: Type of objects to return. Can be repeated for multiple types. (required)
        :type type: List[str]
        :param query: Query string for searching.
        :type query: str
        :param field_filters: Any field from any object type can be used as a filter. Use '!' for negation, '*' as a wildcard, and 'lt:', 'lte:', 'gt:', 'gte:' for range queries on numeric fields.
        :type field_filters: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_download_serialize(
            type=type,
            query=query,
            field_filters=field_filters,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': "object",
            '404': "object",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _batch_download_serialize(
        self,
        type,
        query,
        field_filters,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if type is not None:
            
            _query_params.append(('type', type))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if field_filters is not None:
             for k, v in field_filters.items():
                if isinstance(v, list):
                    for item in v:
                        _query_params.append((k, item))
                else:
                    _query_params.append((k, v))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'text/tab-separated-values', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/batch-download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def biomarkers(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.name")] = None,
        biomarker_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by biomarker_for")] = None,
        classification: Annotated[Optional[List[StrictStr]], Field(description="Filter by classification")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        gene: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        name_quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by name_quantification")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by quantification")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BiomarkerResults:
        """List items in the Biomarker collection.

        Collection endpoint that accepts various query parameters to filter and sort Biomarker items. Supports filtering on fields within Biomarker items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_name: Filter by award.name
        :type award_name: List[str]
        :param biomarker_for: Filter by biomarker_for
        :type biomarker_for: List[str]
        :param classification: Filter by classification
        :type classification: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param gene: Filter by gene
        :type gene: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param name_quantification: Filter by name_quantification
        :type name_quantification: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param quantification: Filter by quantification
        :type quantification: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._biomarkers_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            award_name=award_name,
            biomarker_for=biomarker_for,
            classification=classification,
            creation_timestamp=creation_timestamp,
            description=description,
            gene=gene,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            name_quantification=name_quantification,
            notes=notes,
            quantification=quantification,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BiomarkerResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def biomarkers_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.name")] = None,
        biomarker_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by biomarker_for")] = None,
        classification: Annotated[Optional[List[StrictStr]], Field(description="Filter by classification")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        gene: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        name_quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by name_quantification")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by quantification")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BiomarkerResults]:
        """List items in the Biomarker collection.

        Collection endpoint that accepts various query parameters to filter and sort Biomarker items. Supports filtering on fields within Biomarker items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_name: Filter by award.name
        :type award_name: List[str]
        :param biomarker_for: Filter by biomarker_for
        :type biomarker_for: List[str]
        :param classification: Filter by classification
        :type classification: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param gene: Filter by gene
        :type gene: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param name_quantification: Filter by name_quantification
        :type name_quantification: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param quantification: Filter by quantification
        :type quantification: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._biomarkers_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            award_name=award_name,
            biomarker_for=biomarker_for,
            classification=classification,
            creation_timestamp=creation_timestamp,
            description=description,
            gene=gene,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            name_quantification=name_quantification,
            notes=notes,
            quantification=quantification,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BiomarkerResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def biomarkers_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.name")] = None,
        biomarker_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by biomarker_for")] = None,
        classification: Annotated[Optional[List[StrictStr]], Field(description="Filter by classification")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        gene: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        name_quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by name_quantification")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        quantification: Annotated[Optional[List[StrictStr]], Field(description="Filter by quantification")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the Biomarker collection.

        Collection endpoint that accepts various query parameters to filter and sort Biomarker items. Supports filtering on fields within Biomarker items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_name: Filter by award.name
        :type award_name: List[str]
        :param biomarker_for: Filter by biomarker_for
        :type biomarker_for: List[str]
        :param classification: Filter by classification
        :type classification: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param gene: Filter by gene
        :type gene: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param name: Filter by name
        :type name: List[str]
        :param name_quantification: Filter by name_quantification
        :type name_quantification: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param quantification: Filter by quantification
        :type quantification: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._biomarkers_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            award_name=award_name,
            biomarker_for=biomarker_for,
            classification=classification,
            creation_timestamp=creation_timestamp,
            description=description,
            gene=gene,
            lab_id=lab_id,
            lab_title=lab_title,
            name=name,
            name_quantification=name_quantification,
            notes=notes,
            quantification=quantification,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            synonyms=synonyms,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BiomarkerResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _biomarkers_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        award_id,
        award_component,
        award_name,
        biomarker_for,
        classification,
        creation_timestamp,
        description,
        gene,
        lab_id,
        lab_title,
        name,
        name_quantification,
        notes,
        quantification,
        release_timestamp,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        synonyms,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'award.name': 'multi',
            'biomarker_for': 'multi',
            'classification': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'gene': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'name': 'multi',
            'name_quantification': 'multi',
            'notes': 'multi',
            'quantification': 'multi',
            'release_timestamp': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'synonyms': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if award_name is not None:
            
            _query_params.append(('award.name', award_name))
            
        if biomarker_for is not None:
            
            _query_params.append(('biomarker_for', biomarker_for))
            
        if classification is not None:
            
            _query_params.append(('classification', classification))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if gene is not None:
            
            _query_params.append(('gene', gene))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name_quantification is not None:
            
            _query_params.append(('name_quantification', name_quantification))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if quantification is not None:
            
            _query_params.append(('quantification', quantification))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if synonyms is not None:
            
            _query_params.append(('synonyms', synonyms))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/biomarkers/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def configuration_files(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        seqspec_of: Annotated[Optional[List[StrictStr]], Field(description="Filter by seqspec_of")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ConfigurationFileResults:
        """List items in the ConfigurationFile collection.

        Collection endpoint that accepts various query parameters to filter and sort ConfigurationFile items. Supports filtering on fields within ConfigurationFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param seqspec_of: Filter by seqspec_of
        :type seqspec_of: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._configuration_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_type=content_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            seqspec_of=seqspec_of,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConfigurationFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def configuration_files_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        seqspec_of: Annotated[Optional[List[StrictStr]], Field(description="Filter by seqspec_of")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ConfigurationFileResults]:
        """List items in the ConfigurationFile collection.

        Collection endpoint that accepts various query parameters to filter and sort ConfigurationFile items. Supports filtering on fields within ConfigurationFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param seqspec_of: Filter by seqspec_of
        :type seqspec_of: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._configuration_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_type=content_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            seqspec_of=seqspec_of,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConfigurationFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def configuration_files_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        seqspec_of: Annotated[Optional[List[StrictStr]], Field(description="Filter by seqspec_of")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the ConfigurationFile collection.

        Collection endpoint that accepts various query parameters to filter and sort ConfigurationFile items. Supports filtering on fields within ConfigurationFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param seqspec_of: Filter by seqspec_of
        :type seqspec_of: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._configuration_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            assay_titles=assay_titles,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            content_md5sum=content_md5sum,
            content_type=content_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            seqspec_of=seqspec_of,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConfigurationFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _configuration_files_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        analysis_step_version,
        assay_titles,
        award_id,
        award_component,
        collections,
        content_md5sum,
        content_type,
        creation_timestamp,
        dbxrefs,
        derived_from,
        description,
        documents,
        file_format,
        file_format_specifications,
        file_set_id,
        file_set_accession,
        file_set_file_set_type,
        file_set_samples_id,
        file_set_samples_accession,
        file_set_samples_classifications,
        file_set_samples_disease_terms_id,
        file_set_samples_disease_terms_summary,
        file_set_samples_disease_terms_term_name,
        file_set_samples_sample_terms_id,
        file_set_samples_sample_terms_term_name,
        file_set_samples_summary,
        file_set_samples_taxa,
        file_set_summary,
        file_set_taxa,
        file_size,
        gene_list_for,
        href,
        input_file_for,
        integrated_in_id,
        integrated_in_associated_phenotypes_id,
        integrated_in_associated_phenotypes_summary,
        integrated_in_associated_phenotypes_term_name,
        integrated_in_file_set_type,
        integrated_in_small_scale_gene_list_id,
        integrated_in_small_scale_gene_list_symbol,
        integrated_in_summary,
        lab_id,
        lab_title,
        loci_list_for,
        md5sum,
        notes,
        release_timestamp,
        revoke_detail,
        s3_uri,
        seqspec_of,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_file_name,
        submitter_comment,
        summary,
        upload_status,
        uuid,
        validation_error_detail,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'analysis_step_version': 'multi',
            'assay_titles': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'collections': 'multi',
            'content_md5sum': 'multi',
            'content_type': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'derived_from': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'file_format': 'multi',
            'file_format_specifications': 'multi',
            'file_set.@id': 'multi',
            'file_set.accession': 'multi',
            'file_set.file_set_type': 'multi',
            'file_set.samples.@id': 'multi',
            'file_set.samples.accession': 'multi',
            'file_set.samples.classifications': 'multi',
            'file_set.samples.disease_terms.@id': 'multi',
            'file_set.samples.disease_terms.summary': 'multi',
            'file_set.samples.disease_terms.term_name': 'multi',
            'file_set.samples.sample_terms.@id': 'multi',
            'file_set.samples.sample_terms.term_name': 'multi',
            'file_set.samples.summary': 'multi',
            'file_set.samples.taxa': 'multi',
            'file_set.summary': 'multi',
            'file_set.taxa': 'multi',
            'file_size': 'multi',
            'gene_list_for': 'multi',
            'href': 'multi',
            'input_file_for': 'multi',
            'integrated_in.@id': 'multi',
            'integrated_in.associated_phenotypes.@id': 'multi',
            'integrated_in.associated_phenotypes.summary': 'multi',
            'integrated_in.associated_phenotypes.term_name': 'multi',
            'integrated_in.file_set_type': 'multi',
            'integrated_in.small_scale_gene_list.@id': 'multi',
            'integrated_in.small_scale_gene_list.symbol': 'multi',
            'integrated_in.summary': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'loci_list_for': 'multi',
            'md5sum': 'multi',
            'notes': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            's3_uri': 'multi',
            'seqspec_of': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_file_name': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'upload_status': 'multi',
            'uuid': 'multi',
            'validation_error_detail': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if analysis_step_version is not None:
            
            _query_params.append(('analysis_step_version', analysis_step_version))
            
        if assay_titles is not None:
            
            _query_params.append(('assay_titles', assay_titles))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if content_md5sum is not None:
            
            _query_params.append(('content_md5sum', content_md5sum))
            
        if content_type is not None:
            
            _query_params.append(('content_type', content_type))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if derived_from is not None:
            
            _query_params.append(('derived_from', derived_from))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if file_format is not None:
            
            _query_params.append(('file_format', file_format))
            
        if file_format_specifications is not None:
            
            _query_params.append(('file_format_specifications', file_format_specifications))
            
        if file_set_id is not None:
            
            _query_params.append(('file_set.@id', file_set_id))
            
        if file_set_accession is not None:
            
            _query_params.append(('file_set.accession', file_set_accession))
            
        if file_set_file_set_type is not None:
            
            _query_params.append(('file_set.file_set_type', file_set_file_set_type))
            
        if file_set_samples_id is not None:
            
            _query_params.append(('file_set.samples.@id', file_set_samples_id))
            
        if file_set_samples_accession is not None:
            
            _query_params.append(('file_set.samples.accession', file_set_samples_accession))
            
        if file_set_samples_classifications is not None:
            
            _query_params.append(('file_set.samples.classifications', file_set_samples_classifications))
            
        if file_set_samples_disease_terms_id is not None:
            
            _query_params.append(('file_set.samples.disease_terms.@id', file_set_samples_disease_terms_id))
            
        if file_set_samples_disease_terms_summary is not None:
            
            _query_params.append(('file_set.samples.disease_terms.summary', file_set_samples_disease_terms_summary))
            
        if file_set_samples_disease_terms_term_name is not None:
            
            _query_params.append(('file_set.samples.disease_terms.term_name', file_set_samples_disease_terms_term_name))
            
        if file_set_samples_sample_terms_id is not None:
            
            _query_params.append(('file_set.samples.sample_terms.@id', file_set_samples_sample_terms_id))
            
        if file_set_samples_sample_terms_term_name is not None:
            
            _query_params.append(('file_set.samples.sample_terms.term_name', file_set_samples_sample_terms_term_name))
            
        if file_set_samples_summary is not None:
            
            _query_params.append(('file_set.samples.summary', file_set_samples_summary))
            
        if file_set_samples_taxa is not None:
            
            _query_params.append(('file_set.samples.taxa', file_set_samples_taxa))
            
        if file_set_summary is not None:
            
            _query_params.append(('file_set.summary', file_set_summary))
            
        if file_set_taxa is not None:
            
            _query_params.append(('file_set.taxa', file_set_taxa))
            
        if file_size is not None:
            
            _query_params.append(('file_size', file_size))
            
        if gene_list_for is not None:
            
            _query_params.append(('gene_list_for', gene_list_for))
            
        if href is not None:
            
            _query_params.append(('href', href))
            
        if input_file_for is not None:
            
            _query_params.append(('input_file_for', input_file_for))
            
        if integrated_in_id is not None:
            
            _query_params.append(('integrated_in.@id', integrated_in_id))
            
        if integrated_in_associated_phenotypes_id is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.@id', integrated_in_associated_phenotypes_id))
            
        if integrated_in_associated_phenotypes_summary is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.summary', integrated_in_associated_phenotypes_summary))
            
        if integrated_in_associated_phenotypes_term_name is not None:
            
            _query_params.append(('integrated_in.associated_phenotypes.term_name', integrated_in_associated_phenotypes_term_name))
            
        if integrated_in_file_set_type is not None:
            
            _query_params.append(('integrated_in.file_set_type', integrated_in_file_set_type))
            
        if integrated_in_small_scale_gene_list_id is not None:
            
            _query_params.append(('integrated_in.small_scale_gene_list.@id', integrated_in_small_scale_gene_list_id))
            
        if integrated_in_small_scale_gene_list_symbol is not None:
            
            _query_params.append(('integrated_in.small_scale_gene_list.symbol', integrated_in_small_scale_gene_list_symbol))
            
        if integrated_in_summary is not None:
            
            _query_params.append(('integrated_in.summary', integrated_in_summary))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if loci_list_for is not None:
            
            _query_params.append(('loci_list_for', loci_list_for))
            
        if md5sum is not None:
            
            _query_params.append(('md5sum', md5sum))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if s3_uri is not None:
            
            _query_params.append(('s3_uri', s3_uri))
            
        if seqspec_of is not None:
            
            _query_params.append(('seqspec_of', seqspec_of))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_file_name is not None:
            
            _query_params.append(('submitted_file_name', submitted_file_name))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if upload_status is not None:
            
            _query_params.append(('upload_status', upload_status))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        if validation_error_detail is not None:
            
            _query_params.append(('validation_error_detail', validation_error_detail))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/configuration-files/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def construct_library_sets(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        applied_to_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.@id")] = None,
        applied_to_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.accession")] = None,
        applied_to_samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.aliases")] = None,
        applied_to_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.classifications")] = None,
        applied_to_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.disease_terms.@id")] = None,
        applied_to_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.disease_terms.term_name")] = None,
        applied_to_samples_donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.@id")] = None,
        applied_to_samples_donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.taxa")] = None,
        applied_to_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.sample_terms.@id")] = None,
        applied_to_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.sample_terms.term_name")] = None,
        applied_to_samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.status")] = None,
        applied_to_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.summary")] = None,
        applied_to_samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.targeted_sample_term.@id")] = None,
        applied_to_samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.targeted_sample_term.term_name")] = None,
        applied_to_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.taxa")] = None,
        associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by associated_phenotypes.@id")] = None,
        associated_phenotypes_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_id")] = None,
        associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_name")] = None,
        average_guide_coverage: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_guide_coverage")] = None,
        average_insert_size: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_insert_size")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        exon: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by exon")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        guide_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by guide_type")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        integrated_content_files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.@id")] = None,
        integrated_content_files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.accession")] = None,
        integrated_content_files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_content_files.aliases")] = None,
        integrated_content_files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.content_type")] = None,
        integrated_content_files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.file_format")] = None,
        integrated_content_files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.upload_status")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        large_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.@id")] = None,
        large_scale_gene_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.accession")] = None,
        large_scale_gene_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_gene_list.aliases")] = None,
        large_scale_loci_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.@id")] = None,
        large_scale_loci_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.accession")] = None,
        large_scale_loci_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_loci_list.aliases")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        lower_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_guide_coverage")] = None,
        lower_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_insert_size")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        orf_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.@id")] = None,
        orf_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.aliases")] = None,
        orf_list_genes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.@id")] = None,
        orf_list_genes_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.symbol")] = None,
        orf_list_orf_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.orf_id")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        scope: Annotated[Optional[List[StrictStr]], Field(description="Filter by scope")] = None,
        selection_criteria: Annotated[Optional[List[StrictStr]], Field(description="Filter by selection_criteria")] = None,
        small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.@id")] = None,
        small_scale_gene_list_geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by small_scale_gene_list.geneid")] = None,
        small_scale_gene_list_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.name")] = None,
        small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.symbol")] = None,
        small_scale_gene_list_synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.synonyms")] = None,
        small_scale_loci_list: Annotated[Optional[List[Locus]], Field(description="Filter by small_scale_loci_list")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        targeton: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by targeton")] = None,
        tiling_modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by tiling_modality")] = None,
        upper_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_guide_coverage")] = None,
        upper_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_insert_size")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ConstructLibrarySetResults:
        """List items in the ConstructLibrarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort ConstructLibrarySet items. Supports filtering on fields within ConstructLibrarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param applied_to_samples_id: Filter by applied_to_samples.@id
        :type applied_to_samples_id: List[str]
        :param applied_to_samples_accession: Filter by applied_to_samples.accession
        :type applied_to_samples_accession: List[str]
        :param applied_to_samples_aliases: Filter by applied_to_samples.aliases
        :type applied_to_samples_aliases: List[str]
        :param applied_to_samples_classifications: Filter by applied_to_samples.classifications
        :type applied_to_samples_classifications: List[str]
        :param applied_to_samples_disease_terms_id: Filter by applied_to_samples.disease_terms.@id
        :type applied_to_samples_disease_terms_id: List[str]
        :param applied_to_samples_disease_terms_term_name: Filter by applied_to_samples.disease_terms.term_name
        :type applied_to_samples_disease_terms_term_name: List[str]
        :param applied_to_samples_donors_id: Filter by applied_to_samples.donors.@id
        :type applied_to_samples_donors_id: List[str]
        :param applied_to_samples_donors_taxa: Filter by applied_to_samples.donors.taxa
        :type applied_to_samples_donors_taxa: List[str]
        :param applied_to_samples_sample_terms_id: Filter by applied_to_samples.sample_terms.@id
        :type applied_to_samples_sample_terms_id: List[str]
        :param applied_to_samples_sample_terms_term_name: Filter by applied_to_samples.sample_terms.term_name
        :type applied_to_samples_sample_terms_term_name: List[str]
        :param applied_to_samples_status: Filter by applied_to_samples.status
        :type applied_to_samples_status: List[str]
        :param applied_to_samples_summary: Filter by applied_to_samples.summary
        :type applied_to_samples_summary: List[str]
        :param applied_to_samples_targeted_sample_term_id: Filter by applied_to_samples.targeted_sample_term.@id
        :type applied_to_samples_targeted_sample_term_id: List[str]
        :param applied_to_samples_targeted_sample_term_term_name: Filter by applied_to_samples.targeted_sample_term.term_name
        :type applied_to_samples_targeted_sample_term_term_name: List[str]
        :param applied_to_samples_taxa: Filter by applied_to_samples.taxa
        :type applied_to_samples_taxa: List[str]
        :param associated_phenotypes_id: Filter by associated_phenotypes.@id
        :type associated_phenotypes_id: List[str]
        :param associated_phenotypes_term_id: Filter by associated_phenotypes.term_id
        :type associated_phenotypes_term_id: List[str]
        :param associated_phenotypes_term_name: Filter by associated_phenotypes.term_name
        :type associated_phenotypes_term_name: List[str]
        :param average_guide_coverage: Filter by average_guide_coverage
        :type average_guide_coverage: List[float]
        :param average_insert_size: Filter by average_insert_size
        :type average_insert_size: List[float]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param exon: Filter by exon
        :type exon: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param guide_type: Filter by guide_type
        :type guide_type: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param integrated_content_files_id: Filter by integrated_content_files.@id
        :type integrated_content_files_id: List[str]
        :param integrated_content_files_accession: Filter by integrated_content_files.accession
        :type integrated_content_files_accession: List[str]
        :param integrated_content_files_aliases: Filter by integrated_content_files.aliases
        :type integrated_content_files_aliases: List[str]
        :param integrated_content_files_content_type: Filter by integrated_content_files.content_type
        :type integrated_content_files_content_type: List[str]
        :param integrated_content_files_file_format: Filter by integrated_content_files.file_format
        :type integrated_content_files_file_format: List[str]
        :param integrated_content_files_upload_status: Filter by integrated_content_files.upload_status
        :type integrated_content_files_upload_status: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param large_scale_gene_list_id: Filter by large_scale_gene_list.@id
        :type large_scale_gene_list_id: List[str]
        :param large_scale_gene_list_accession: Filter by large_scale_gene_list.accession
        :type large_scale_gene_list_accession: List[str]
        :param large_scale_gene_list_aliases: Filter by large_scale_gene_list.aliases
        :type large_scale_gene_list_aliases: List[str]
        :param large_scale_loci_list_id: Filter by large_scale_loci_list.@id
        :type large_scale_loci_list_id: List[str]
        :param large_scale_loci_list_accession: Filter by large_scale_loci_list.accession
        :type large_scale_loci_list_accession: List[str]
        :param large_scale_loci_list_aliases: Filter by large_scale_loci_list.aliases
        :type large_scale_loci_list_aliases: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param lower_bound_guide_coverage: Filter by lower_bound_guide_coverage
        :type lower_bound_guide_coverage: List[int]
        :param lower_bound_insert_size: Filter by lower_bound_insert_size
        :type lower_bound_insert_size: List[int]
        :param notes: Filter by notes
        :type notes: List[str]
        :param orf_list_id: Filter by orf_list.@id
        :type orf_list_id: List[str]
        :param orf_list_aliases: Filter by orf_list.aliases
        :type orf_list_aliases: List[str]
        :param orf_list_genes_id: Filter by orf_list.genes.@id
        :type orf_list_genes_id: List[str]
        :param orf_list_genes_symbol: Filter by orf_list.genes.symbol
        :type orf_list_genes_symbol: List[str]
        :param orf_list_orf_id: Filter by orf_list.orf_id
        :type orf_list_orf_id: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param scope: Filter by scope
        :type scope: List[str]
        :param selection_criteria: Filter by selection_criteria
        :type selection_criteria: List[str]
        :param small_scale_gene_list_id: Filter by small_scale_gene_list.@id
        :type small_scale_gene_list_id: List[str]
        :param small_scale_gene_list_geneid: Filter by small_scale_gene_list.geneid
        :type small_scale_gene_list_geneid: List[str]
        :param small_scale_gene_list_name: Filter by small_scale_gene_list.name
        :type small_scale_gene_list_name: List[str]
        :param small_scale_gene_list_symbol: Filter by small_scale_gene_list.symbol
        :type small_scale_gene_list_symbol: List[str]
        :param small_scale_gene_list_synonyms: Filter by small_scale_gene_list.synonyms
        :type small_scale_gene_list_synonyms: List[str]
        :param small_scale_loci_list: Filter by small_scale_loci_list
        :type small_scale_loci_list: List[Locus]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param targeton: Filter by targeton
        :type targeton: List[str]
        :param tiling_modality: Filter by tiling_modality
        :type tiling_modality: List[str]
        :param upper_bound_guide_coverage: Filter by upper_bound_guide_coverage
        :type upper_bound_guide_coverage: List[int]
        :param upper_bound_insert_size: Filter by upper_bound_insert_size
        :type upper_bound_insert_size: List[int]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._construct_library_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            applied_to_samples_id=applied_to_samples_id,
            applied_to_samples_accession=applied_to_samples_accession,
            applied_to_samples_aliases=applied_to_samples_aliases,
            applied_to_samples_classifications=applied_to_samples_classifications,
            applied_to_samples_disease_terms_id=applied_to_samples_disease_terms_id,
            applied_to_samples_disease_terms_term_name=applied_to_samples_disease_terms_term_name,
            applied_to_samples_donors_id=applied_to_samples_donors_id,
            applied_to_samples_donors_taxa=applied_to_samples_donors_taxa,
            applied_to_samples_sample_terms_id=applied_to_samples_sample_terms_id,
            applied_to_samples_sample_terms_term_name=applied_to_samples_sample_terms_term_name,
            applied_to_samples_status=applied_to_samples_status,
            applied_to_samples_summary=applied_to_samples_summary,
            applied_to_samples_targeted_sample_term_id=applied_to_samples_targeted_sample_term_id,
            applied_to_samples_targeted_sample_term_term_name=applied_to_samples_targeted_sample_term_term_name,
            applied_to_samples_taxa=applied_to_samples_taxa,
            associated_phenotypes_id=associated_phenotypes_id,
            associated_phenotypes_term_id=associated_phenotypes_term_id,
            associated_phenotypes_term_name=associated_phenotypes_term_name,
            average_guide_coverage=average_guide_coverage,
            average_insert_size=average_insert_size,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            exon=exon,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_file_format=files_file_format,
            files_upload_status=files_upload_status,
            guide_type=guide_type,
            input_file_set_for=input_file_set_for,
            integrated_content_files_id=integrated_content_files_id,
            integrated_content_files_accession=integrated_content_files_accession,
            integrated_content_files_aliases=integrated_content_files_aliases,
            integrated_content_files_content_type=integrated_content_files_content_type,
            integrated_content_files_file_format=integrated_content_files_file_format,
            integrated_content_files_upload_status=integrated_content_files_upload_status,
            lab_id=lab_id,
            lab_title=lab_title,
            large_scale_gene_list_id=large_scale_gene_list_id,
            large_scale_gene_list_accession=large_scale_gene_list_accession,
            large_scale_gene_list_aliases=large_scale_gene_list_aliases,
            large_scale_loci_list_id=large_scale_loci_list_id,
            large_scale_loci_list_accession=large_scale_loci_list_accession,
            large_scale_loci_list_aliases=large_scale_loci_list_aliases,
            lot_id=lot_id,
            lower_bound_guide_coverage=lower_bound_guide_coverage,
            lower_bound_insert_size=lower_bound_insert_size,
            notes=notes,
            orf_list_id=orf_list_id,
            orf_list_aliases=orf_list_aliases,
            orf_list_genes_id=orf_list_genes_id,
            orf_list_genes_symbol=orf_list_genes_symbol,
            orf_list_orf_id=orf_list_orf_id,
            product_id=product_id,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            scope=scope,
            selection_criteria=selection_criteria,
            small_scale_gene_list_id=small_scale_gene_list_id,
            small_scale_gene_list_geneid=small_scale_gene_list_geneid,
            small_scale_gene_list_name=small_scale_gene_list_name,
            small_scale_gene_list_symbol=small_scale_gene_list_symbol,
            small_scale_gene_list_synonyms=small_scale_gene_list_synonyms,
            small_scale_loci_list=small_scale_loci_list,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            targeton=targeton,
            tiling_modality=tiling_modality,
            upper_bound_guide_coverage=upper_bound_guide_coverage,
            upper_bound_insert_size=upper_bound_insert_size,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConstructLibrarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def construct_library_sets_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        applied_to_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.@id")] = None,
        applied_to_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.accession")] = None,
        applied_to_samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.aliases")] = None,
        applied_to_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.classifications")] = None,
        applied_to_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.disease_terms.@id")] = None,
        applied_to_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.disease_terms.term_name")] = None,
        applied_to_samples_donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.@id")] = None,
        applied_to_samples_donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.taxa")] = None,
        applied_to_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.sample_terms.@id")] = None,
        applied_to_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.sample_terms.term_name")] = None,
        applied_to_samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.status")] = None,
        applied_to_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.summary")] = None,
        applied_to_samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.targeted_sample_term.@id")] = None,
        applied_to_samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.targeted_sample_term.term_name")] = None,
        applied_to_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.taxa")] = None,
        associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by associated_phenotypes.@id")] = None,
        associated_phenotypes_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_id")] = None,
        associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_name")] = None,
        average_guide_coverage: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_guide_coverage")] = None,
        average_insert_size: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_insert_size")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        exon: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by exon")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        guide_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by guide_type")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        integrated_content_files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.@id")] = None,
        integrated_content_files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.accession")] = None,
        integrated_content_files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_content_files.aliases")] = None,
        integrated_content_files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.content_type")] = None,
        integrated_content_files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.file_format")] = None,
        integrated_content_files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.upload_status")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        large_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.@id")] = None,
        large_scale_gene_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.accession")] = None,
        large_scale_gene_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_gene_list.aliases")] = None,
        large_scale_loci_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.@id")] = None,
        large_scale_loci_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.accession")] = None,
        large_scale_loci_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_loci_list.aliases")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        lower_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_guide_coverage")] = None,
        lower_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_insert_size")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        orf_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.@id")] = None,
        orf_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.aliases")] = None,
        orf_list_genes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.@id")] = None,
        orf_list_genes_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.symbol")] = None,
        orf_list_orf_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.orf_id")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        scope: Annotated[Optional[List[StrictStr]], Field(description="Filter by scope")] = None,
        selection_criteria: Annotated[Optional[List[StrictStr]], Field(description="Filter by selection_criteria")] = None,
        small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.@id")] = None,
        small_scale_gene_list_geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by small_scale_gene_list.geneid")] = None,
        small_scale_gene_list_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.name")] = None,
        small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.symbol")] = None,
        small_scale_gene_list_synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.synonyms")] = None,
        small_scale_loci_list: Annotated[Optional[List[Locus]], Field(description="Filter by small_scale_loci_list")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        targeton: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by targeton")] = None,
        tiling_modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by tiling_modality")] = None,
        upper_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_guide_coverage")] = None,
        upper_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_insert_size")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ConstructLibrarySetResults]:
        """List items in the ConstructLibrarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort ConstructLibrarySet items. Supports filtering on fields within ConstructLibrarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param applied_to_samples_id: Filter by applied_to_samples.@id
        :type applied_to_samples_id: List[str]
        :param applied_to_samples_accession: Filter by applied_to_samples.accession
        :type applied_to_samples_accession: List[str]
        :param applied_to_samples_aliases: Filter by applied_to_samples.aliases
        :type applied_to_samples_aliases: List[str]
        :param applied_to_samples_classifications: Filter by applied_to_samples.classifications
        :type applied_to_samples_classifications: List[str]
        :param applied_to_samples_disease_terms_id: Filter by applied_to_samples.disease_terms.@id
        :type applied_to_samples_disease_terms_id: List[str]
        :param applied_to_samples_disease_terms_term_name: Filter by applied_to_samples.disease_terms.term_name
        :type applied_to_samples_disease_terms_term_name: List[str]
        :param applied_to_samples_donors_id: Filter by applied_to_samples.donors.@id
        :type applied_to_samples_donors_id: List[str]
        :param applied_to_samples_donors_taxa: Filter by applied_to_samples.donors.taxa
        :type applied_to_samples_donors_taxa: List[str]
        :param applied_to_samples_sample_terms_id: Filter by applied_to_samples.sample_terms.@id
        :type applied_to_samples_sample_terms_id: List[str]
        :param applied_to_samples_sample_terms_term_name: Filter by applied_to_samples.sample_terms.term_name
        :type applied_to_samples_sample_terms_term_name: List[str]
        :param applied_to_samples_status: Filter by applied_to_samples.status
        :type applied_to_samples_status: List[str]
        :param applied_to_samples_summary: Filter by applied_to_samples.summary
        :type applied_to_samples_summary: List[str]
        :param applied_to_samples_targeted_sample_term_id: Filter by applied_to_samples.targeted_sample_term.@id
        :type applied_to_samples_targeted_sample_term_id: List[str]
        :param applied_to_samples_targeted_sample_term_term_name: Filter by applied_to_samples.targeted_sample_term.term_name
        :type applied_to_samples_targeted_sample_term_term_name: List[str]
        :param applied_to_samples_taxa: Filter by applied_to_samples.taxa
        :type applied_to_samples_taxa: List[str]
        :param associated_phenotypes_id: Filter by associated_phenotypes.@id
        :type associated_phenotypes_id: List[str]
        :param associated_phenotypes_term_id: Filter by associated_phenotypes.term_id
        :type associated_phenotypes_term_id: List[str]
        :param associated_phenotypes_term_name: Filter by associated_phenotypes.term_name
        :type associated_phenotypes_term_name: List[str]
        :param average_guide_coverage: Filter by average_guide_coverage
        :type average_guide_coverage: List[float]
        :param average_insert_size: Filter by average_insert_size
        :type average_insert_size: List[float]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param exon: Filter by exon
        :type exon: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param guide_type: Filter by guide_type
        :type guide_type: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param integrated_content_files_id: Filter by integrated_content_files.@id
        :type integrated_content_files_id: List[str]
        :param integrated_content_files_accession: Filter by integrated_content_files.accession
        :type integrated_content_files_accession: List[str]
        :param integrated_content_files_aliases: Filter by integrated_content_files.aliases
        :type integrated_content_files_aliases: List[str]
        :param integrated_content_files_content_type: Filter by integrated_content_files.content_type
        :type integrated_content_files_content_type: List[str]
        :param integrated_content_files_file_format: Filter by integrated_content_files.file_format
        :type integrated_content_files_file_format: List[str]
        :param integrated_content_files_upload_status: Filter by integrated_content_files.upload_status
        :type integrated_content_files_upload_status: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param large_scale_gene_list_id: Filter by large_scale_gene_list.@id
        :type large_scale_gene_list_id: List[str]
        :param large_scale_gene_list_accession: Filter by large_scale_gene_list.accession
        :type large_scale_gene_list_accession: List[str]
        :param large_scale_gene_list_aliases: Filter by large_scale_gene_list.aliases
        :type large_scale_gene_list_aliases: List[str]
        :param large_scale_loci_list_id: Filter by large_scale_loci_list.@id
        :type large_scale_loci_list_id: List[str]
        :param large_scale_loci_list_accession: Filter by large_scale_loci_list.accession
        :type large_scale_loci_list_accession: List[str]
        :param large_scale_loci_list_aliases: Filter by large_scale_loci_list.aliases
        :type large_scale_loci_list_aliases: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param lower_bound_guide_coverage: Filter by lower_bound_guide_coverage
        :type lower_bound_guide_coverage: List[int]
        :param lower_bound_insert_size: Filter by lower_bound_insert_size
        :type lower_bound_insert_size: List[int]
        :param notes: Filter by notes
        :type notes: List[str]
        :param orf_list_id: Filter by orf_list.@id
        :type orf_list_id: List[str]
        :param orf_list_aliases: Filter by orf_list.aliases
        :type orf_list_aliases: List[str]
        :param orf_list_genes_id: Filter by orf_list.genes.@id
        :type orf_list_genes_id: List[str]
        :param orf_list_genes_symbol: Filter by orf_list.genes.symbol
        :type orf_list_genes_symbol: List[str]
        :param orf_list_orf_id: Filter by orf_list.orf_id
        :type orf_list_orf_id: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param scope: Filter by scope
        :type scope: List[str]
        :param selection_criteria: Filter by selection_criteria
        :type selection_criteria: List[str]
        :param small_scale_gene_list_id: Filter by small_scale_gene_list.@id
        :type small_scale_gene_list_id: List[str]
        :param small_scale_gene_list_geneid: Filter by small_scale_gene_list.geneid
        :type small_scale_gene_list_geneid: List[str]
        :param small_scale_gene_list_name: Filter by small_scale_gene_list.name
        :type small_scale_gene_list_name: List[str]
        :param small_scale_gene_list_symbol: Filter by small_scale_gene_list.symbol
        :type small_scale_gene_list_symbol: List[str]
        :param small_scale_gene_list_synonyms: Filter by small_scale_gene_list.synonyms
        :type small_scale_gene_list_synonyms: List[str]
        :param small_scale_loci_list: Filter by small_scale_loci_list
        :type small_scale_loci_list: List[Locus]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param targeton: Filter by targeton
        :type targeton: List[str]
        :param tiling_modality: Filter by tiling_modality
        :type tiling_modality: List[str]
        :param upper_bound_guide_coverage: Filter by upper_bound_guide_coverage
        :type upper_bound_guide_coverage: List[int]
        :param upper_bound_insert_size: Filter by upper_bound_insert_size
        :type upper_bound_insert_size: List[int]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._construct_library_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            applied_to_samples_id=applied_to_samples_id,
            applied_to_samples_accession=applied_to_samples_accession,
            applied_to_samples_aliases=applied_to_samples_aliases,
            applied_to_samples_classifications=applied_to_samples_classifications,
            applied_to_samples_disease_terms_id=applied_to_samples_disease_terms_id,
            applied_to_samples_disease_terms_term_name=applied_to_samples_disease_terms_term_name,
            applied_to_samples_donors_id=applied_to_samples_donors_id,
            applied_to_samples_donors_taxa=applied_to_samples_donors_taxa,
            applied_to_samples_sample_terms_id=applied_to_samples_sample_terms_id,
            applied_to_samples_sample_terms_term_name=applied_to_samples_sample_terms_term_name,
            applied_to_samples_status=applied_to_samples_status,
            applied_to_samples_summary=applied_to_samples_summary,
            applied_to_samples_targeted_sample_term_id=applied_to_samples_targeted_sample_term_id,
            applied_to_samples_targeted_sample_term_term_name=applied_to_samples_targeted_sample_term_term_name,
            applied_to_samples_taxa=applied_to_samples_taxa,
            associated_phenotypes_id=associated_phenotypes_id,
            associated_phenotypes_term_id=associated_phenotypes_term_id,
            associated_phenotypes_term_name=associated_phenotypes_term_name,
            average_guide_coverage=average_guide_coverage,
            average_insert_size=average_insert_size,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            exon=exon,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_file_format=files_file_format,
            files_upload_status=files_upload_status,
            guide_type=guide_type,
            input_file_set_for=input_file_set_for,
            integrated_content_files_id=integrated_content_files_id,
            integrated_content_files_accession=integrated_content_files_accession,
            integrated_content_files_aliases=integrated_content_files_aliases,
            integrated_content_files_content_type=integrated_content_files_content_type,
            integrated_content_files_file_format=integrated_content_files_file_format,
            integrated_content_files_upload_status=integrated_content_files_upload_status,
            lab_id=lab_id,
            lab_title=lab_title,
            large_scale_gene_list_id=large_scale_gene_list_id,
            large_scale_gene_list_accession=large_scale_gene_list_accession,
            large_scale_gene_list_aliases=large_scale_gene_list_aliases,
            large_scale_loci_list_id=large_scale_loci_list_id,
            large_scale_loci_list_accession=large_scale_loci_list_accession,
            large_scale_loci_list_aliases=large_scale_loci_list_aliases,
            lot_id=lot_id,
            lower_bound_guide_coverage=lower_bound_guide_coverage,
            lower_bound_insert_size=lower_bound_insert_size,
            notes=notes,
            orf_list_id=orf_list_id,
            orf_list_aliases=orf_list_aliases,
            orf_list_genes_id=orf_list_genes_id,
            orf_list_genes_symbol=orf_list_genes_symbol,
            orf_list_orf_id=orf_list_orf_id,
            product_id=product_id,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            scope=scope,
            selection_criteria=selection_criteria,
            small_scale_gene_list_id=small_scale_gene_list_id,
            small_scale_gene_list_geneid=small_scale_gene_list_geneid,
            small_scale_gene_list_name=small_scale_gene_list_name,
            small_scale_gene_list_symbol=small_scale_gene_list_symbol,
            small_scale_gene_list_synonyms=small_scale_gene_list_synonyms,
            small_scale_loci_list=small_scale_loci_list,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            targeton=targeton,
            tiling_modality=tiling_modality,
            upper_bound_guide_coverage=upper_bound_guide_coverage,
            upper_bound_insert_size=upper_bound_insert_size,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConstructLibrarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def construct_library_sets_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        applied_to_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.@id")] = None,
        applied_to_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.accession")] = None,
        applied_to_samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.aliases")] = None,
        applied_to_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.classifications")] = None,
        applied_to_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.disease_terms.@id")] = None,
        applied_to_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.disease_terms.term_name")] = None,
        applied_to_samples_donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.@id")] = None,
        applied_to_samples_donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.donors.taxa")] = None,
        applied_to_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.sample_terms.@id")] = None,
        applied_to_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.sample_terms.term_name")] = None,
        applied_to_samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.status")] = None,
        applied_to_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.summary")] = None,
        applied_to_samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.targeted_sample_term.@id")] = None,
        applied_to_samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by applied_to_samples.targeted_sample_term.term_name")] = None,
        applied_to_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by applied_to_samples.taxa")] = None,
        associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by associated_phenotypes.@id")] = None,
        associated_phenotypes_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_id")] = None,
        associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by associated_phenotypes.term_name")] = None,
        average_guide_coverage: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_guide_coverage")] = None,
        average_insert_size: Annotated[Optional[List[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]]], Field(description="Filter by average_insert_size")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        exon: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by exon")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        guide_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by guide_type")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        integrated_content_files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.@id")] = None,
        integrated_content_files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.accession")] = None,
        integrated_content_files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_content_files.aliases")] = None,
        integrated_content_files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.content_type")] = None,
        integrated_content_files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.file_format")] = None,
        integrated_content_files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_content_files.upload_status")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        large_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.@id")] = None,
        large_scale_gene_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_gene_list.accession")] = None,
        large_scale_gene_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_gene_list.aliases")] = None,
        large_scale_loci_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.@id")] = None,
        large_scale_loci_list_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by large_scale_loci_list.accession")] = None,
        large_scale_loci_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by large_scale_loci_list.aliases")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        lower_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_guide_coverage")] = None,
        lower_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by lower_bound_insert_size")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        orf_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.@id")] = None,
        orf_list_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.aliases")] = None,
        orf_list_genes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.@id")] = None,
        orf_list_genes_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by orf_list.genes.symbol")] = None,
        orf_list_orf_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by orf_list.orf_id")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        scope: Annotated[Optional[List[StrictStr]], Field(description="Filter by scope")] = None,
        selection_criteria: Annotated[Optional[List[StrictStr]], Field(description="Filter by selection_criteria")] = None,
        small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.@id")] = None,
        small_scale_gene_list_geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by small_scale_gene_list.geneid")] = None,
        small_scale_gene_list_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.name")] = None,
        small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.symbol")] = None,
        small_scale_gene_list_synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by small_scale_gene_list.synonyms")] = None,
        small_scale_loci_list: Annotated[Optional[List[Locus]], Field(description="Filter by small_scale_loci_list")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        targeton: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by targeton")] = None,
        tiling_modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by tiling_modality")] = None,
        upper_bound_guide_coverage: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_guide_coverage")] = None,
        upper_bound_insert_size: Annotated[Optional[List[StrictInt]], Field(description="Filter by upper_bound_insert_size")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the ConstructLibrarySet collection.

        Collection endpoint that accepts various query parameters to filter and sort ConstructLibrarySet items. Supports filtering on fields within ConstructLibrarySet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param applied_to_samples_id: Filter by applied_to_samples.@id
        :type applied_to_samples_id: List[str]
        :param applied_to_samples_accession: Filter by applied_to_samples.accession
        :type applied_to_samples_accession: List[str]
        :param applied_to_samples_aliases: Filter by applied_to_samples.aliases
        :type applied_to_samples_aliases: List[str]
        :param applied_to_samples_classifications: Filter by applied_to_samples.classifications
        :type applied_to_samples_classifications: List[str]
        :param applied_to_samples_disease_terms_id: Filter by applied_to_samples.disease_terms.@id
        :type applied_to_samples_disease_terms_id: List[str]
        :param applied_to_samples_disease_terms_term_name: Filter by applied_to_samples.disease_terms.term_name
        :type applied_to_samples_disease_terms_term_name: List[str]
        :param applied_to_samples_donors_id: Filter by applied_to_samples.donors.@id
        :type applied_to_samples_donors_id: List[str]
        :param applied_to_samples_donors_taxa: Filter by applied_to_samples.donors.taxa
        :type applied_to_samples_donors_taxa: List[str]
        :param applied_to_samples_sample_terms_id: Filter by applied_to_samples.sample_terms.@id
        :type applied_to_samples_sample_terms_id: List[str]
        :param applied_to_samples_sample_terms_term_name: Filter by applied_to_samples.sample_terms.term_name
        :type applied_to_samples_sample_terms_term_name: List[str]
        :param applied_to_samples_status: Filter by applied_to_samples.status
        :type applied_to_samples_status: List[str]
        :param applied_to_samples_summary: Filter by applied_to_samples.summary
        :type applied_to_samples_summary: List[str]
        :param applied_to_samples_targeted_sample_term_id: Filter by applied_to_samples.targeted_sample_term.@id
        :type applied_to_samples_targeted_sample_term_id: List[str]
        :param applied_to_samples_targeted_sample_term_term_name: Filter by applied_to_samples.targeted_sample_term.term_name
        :type applied_to_samples_targeted_sample_term_term_name: List[str]
        :param applied_to_samples_taxa: Filter by applied_to_samples.taxa
        :type applied_to_samples_taxa: List[str]
        :param associated_phenotypes_id: Filter by associated_phenotypes.@id
        :type associated_phenotypes_id: List[str]
        :param associated_phenotypes_term_id: Filter by associated_phenotypes.term_id
        :type associated_phenotypes_term_id: List[str]
        :param associated_phenotypes_term_name: Filter by associated_phenotypes.term_name
        :type associated_phenotypes_term_name: List[str]
        :param average_guide_coverage: Filter by average_guide_coverage
        :type average_guide_coverage: List[float]
        :param average_insert_size: Filter by average_insert_size
        :type average_insert_size: List[float]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param exon: Filter by exon
        :type exon: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param guide_type: Filter by guide_type
        :type guide_type: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param integrated_content_files_id: Filter by integrated_content_files.@id
        :type integrated_content_files_id: List[str]
        :param integrated_content_files_accession: Filter by integrated_content_files.accession
        :type integrated_content_files_accession: List[str]
        :param integrated_content_files_aliases: Filter by integrated_content_files.aliases
        :type integrated_content_files_aliases: List[str]
        :param integrated_content_files_content_type: Filter by integrated_content_files.content_type
        :type integrated_content_files_content_type: List[str]
        :param integrated_content_files_file_format: Filter by integrated_content_files.file_format
        :type integrated_content_files_file_format: List[str]
        :param integrated_content_files_upload_status: Filter by integrated_content_files.upload_status
        :type integrated_content_files_upload_status: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param large_scale_gene_list_id: Filter by large_scale_gene_list.@id
        :type large_scale_gene_list_id: List[str]
        :param large_scale_gene_list_accession: Filter by large_scale_gene_list.accession
        :type large_scale_gene_list_accession: List[str]
        :param large_scale_gene_list_aliases: Filter by large_scale_gene_list.aliases
        :type large_scale_gene_list_aliases: List[str]
        :param large_scale_loci_list_id: Filter by large_scale_loci_list.@id
        :type large_scale_loci_list_id: List[str]
        :param large_scale_loci_list_accession: Filter by large_scale_loci_list.accession
        :type large_scale_loci_list_accession: List[str]
        :param large_scale_loci_list_aliases: Filter by large_scale_loci_list.aliases
        :type large_scale_loci_list_aliases: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param lower_bound_guide_coverage: Filter by lower_bound_guide_coverage
        :type lower_bound_guide_coverage: List[int]
        :param lower_bound_insert_size: Filter by lower_bound_insert_size
        :type lower_bound_insert_size: List[int]
        :param notes: Filter by notes
        :type notes: List[str]
        :param orf_list_id: Filter by orf_list.@id
        :type orf_list_id: List[str]
        :param orf_list_aliases: Filter by orf_list.aliases
        :type orf_list_aliases: List[str]
        :param orf_list_genes_id: Filter by orf_list.genes.@id
        :type orf_list_genes_id: List[str]
        :param orf_list_genes_symbol: Filter by orf_list.genes.symbol
        :type orf_list_genes_symbol: List[str]
        :param orf_list_orf_id: Filter by orf_list.orf_id
        :type orf_list_orf_id: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param scope: Filter by scope
        :type scope: List[str]
        :param selection_criteria: Filter by selection_criteria
        :type selection_criteria: List[str]
        :param small_scale_gene_list_id: Filter by small_scale_gene_list.@id
        :type small_scale_gene_list_id: List[str]
        :param small_scale_gene_list_geneid: Filter by small_scale_gene_list.geneid
        :type small_scale_gene_list_geneid: List[str]
        :param small_scale_gene_list_name: Filter by small_scale_gene_list.name
        :type small_scale_gene_list_name: List[str]
        :param small_scale_gene_list_symbol: Filter by small_scale_gene_list.symbol
        :type small_scale_gene_list_symbol: List[str]
        :param small_scale_gene_list_synonyms: Filter by small_scale_gene_list.synonyms
        :type small_scale_gene_list_synonyms: List[str]
        :param small_scale_loci_list: Filter by small_scale_loci_list
        :type small_scale_loci_list: List[Locus]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param targeton: Filter by targeton
        :type targeton: List[str]
        :param tiling_modality: Filter by tiling_modality
        :type tiling_modality: List[str]
        :param upper_bound_guide_coverage: Filter by upper_bound_guide_coverage
        :type upper_bound_guide_coverage: List[int]
        :param upper_bound_insert_size: Filter by upper_bound_insert_size
        :type upper_bound_insert_size: List[int]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._construct_library_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            applied_to_samples_id=applied_to_samples_id,
            applied_to_samples_accession=applied_to_samples_accession,
            applied_to_samples_aliases=applied_to_samples_aliases,
            applied_to_samples_classifications=applied_to_samples_classifications,
            applied_to_samples_disease_terms_id=applied_to_samples_disease_terms_id,
            applied_to_samples_disease_terms_term_name=applied_to_samples_disease_terms_term_name,
            applied_to_samples_donors_id=applied_to_samples_donors_id,
            applied_to_samples_donors_taxa=applied_to_samples_donors_taxa,
            applied_to_samples_sample_terms_id=applied_to_samples_sample_terms_id,
            applied_to_samples_sample_terms_term_name=applied_to_samples_sample_terms_term_name,
            applied_to_samples_status=applied_to_samples_status,
            applied_to_samples_summary=applied_to_samples_summary,
            applied_to_samples_targeted_sample_term_id=applied_to_samples_targeted_sample_term_id,
            applied_to_samples_targeted_sample_term_term_name=applied_to_samples_targeted_sample_term_term_name,
            applied_to_samples_taxa=applied_to_samples_taxa,
            associated_phenotypes_id=associated_phenotypes_id,
            associated_phenotypes_term_id=associated_phenotypes_term_id,
            associated_phenotypes_term_name=associated_phenotypes_term_name,
            average_guide_coverage=average_guide_coverage,
            average_insert_size=average_insert_size,
            award_id=award_id,
            award_component=award_component,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            exon=exon,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_file_format=files_file_format,
            files_upload_status=files_upload_status,
            guide_type=guide_type,
            input_file_set_for=input_file_set_for,
            integrated_content_files_id=integrated_content_files_id,
            integrated_content_files_accession=integrated_content_files_accession,
            integrated_content_files_aliases=integrated_content_files_aliases,
            integrated_content_files_content_type=integrated_content_files_content_type,
            integrated_content_files_file_format=integrated_content_files_file_format,
            integrated_content_files_upload_status=integrated_content_files_upload_status,
            lab_id=lab_id,
            lab_title=lab_title,
            large_scale_gene_list_id=large_scale_gene_list_id,
            large_scale_gene_list_accession=large_scale_gene_list_accession,
            large_scale_gene_list_aliases=large_scale_gene_list_aliases,
            large_scale_loci_list_id=large_scale_loci_list_id,
            large_scale_loci_list_accession=large_scale_loci_list_accession,
            large_scale_loci_list_aliases=large_scale_loci_list_aliases,
            lot_id=lot_id,
            lower_bound_guide_coverage=lower_bound_guide_coverage,
            lower_bound_insert_size=lower_bound_insert_size,
            notes=notes,
            orf_list_id=orf_list_id,
            orf_list_aliases=orf_list_aliases,
            orf_list_genes_id=orf_list_genes_id,
            orf_list_genes_symbol=orf_list_genes_symbol,
            orf_list_orf_id=orf_list_orf_id,
            product_id=product_id,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            scope=scope,
            selection_criteria=selection_criteria,
            small_scale_gene_list_id=small_scale_gene_list_id,
            small_scale_gene_list_geneid=small_scale_gene_list_geneid,
            small_scale_gene_list_name=small_scale_gene_list_name,
            small_scale_gene_list_symbol=small_scale_gene_list_symbol,
            small_scale_gene_list_synonyms=small_scale_gene_list_synonyms,
            small_scale_loci_list=small_scale_loci_list,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            targeton=targeton,
            tiling_modality=tiling_modality,
            upper_bound_guide_coverage=upper_bound_guide_coverage,
            upper_bound_insert_size=upper_bound_insert_size,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ConstructLibrarySetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _construct_library_sets_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        applied_to_samples_id,
        applied_to_samples_accession,
        applied_to_samples_aliases,
        applied_to_samples_classifications,
        applied_to_samples_disease_terms_id,
        applied_to_samples_disease_terms_term_name,
        applied_to_samples_donors_id,
        applied_to_samples_donors_taxa,
        applied_to_samples_sample_terms_id,
        applied_to_samples_sample_terms_term_name,
        applied_to_samples_status,
        applied_to_samples_summary,
        applied_to_samples_targeted_sample_term_id,
        applied_to_samples_targeted_sample_term_term_name,
        applied_to_samples_taxa,
        associated_phenotypes_id,
        associated_phenotypes_term_id,
        associated_phenotypes_term_name,
        average_guide_coverage,
        average_insert_size,
        award_id,
        award_component,
        collections,
        control_for_id,
        control_for_accession,
        control_for_aliases,
        control_type,
        creation_timestamp,
        description,
        documents,
        exon,
        file_set_type,
        files_id,
        files_accession,
        files_aliases,
        files_content_type,
        files_file_format,
        files_upload_status,
        guide_type,
        input_file_set_for,
        integrated_content_files_id,
        integrated_content_files_accession,
        integrated_content_files_aliases,
        integrated_content_files_content_type,
        integrated_content_files_file_format,
        integrated_content_files_upload_status,
        lab_id,
        lab_title,
        large_scale_gene_list_id,
        large_scale_gene_list_accession,
        large_scale_gene_list_aliases,
        large_scale_loci_list_id,
        large_scale_loci_list_accession,
        large_scale_loci_list_aliases,
        lot_id,
        lower_bound_guide_coverage,
        lower_bound_insert_size,
        notes,
        orf_list_id,
        orf_list_aliases,
        orf_list_genes_id,
        orf_list_genes_symbol,
        orf_list_orf_id,
        product_id,
        publications_id,
        publications_publication_identifiers,
        release_timestamp,
        revoke_detail,
        scope,
        selection_criteria,
        small_scale_gene_list_id,
        small_scale_gene_list_geneid,
        small_scale_gene_list_name,
        small_scale_gene_list_symbol,
        small_scale_gene_list_synonyms,
        small_scale_loci_list,
        sources,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_files_timestamp,
        submitter_comment,
        summary,
        targeton,
        tiling_modality,
        upper_bound_guide_coverage,
        upper_bound_insert_size,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'applied_to_samples.@id': 'multi',
            'applied_to_samples.accession': 'multi',
            'applied_to_samples.aliases': 'multi',
            'applied_to_samples.classifications': 'multi',
            'applied_to_samples.disease_terms.@id': 'multi',
            'applied_to_samples.disease_terms.term_name': 'multi',
            'applied_to_samples.donors.@id': 'multi',
            'applied_to_samples.donors.taxa': 'multi',
            'applied_to_samples.sample_terms.@id': 'multi',
            'applied_to_samples.sample_terms.term_name': 'multi',
            'applied_to_samples.status': 'multi',
            'applied_to_samples.summary': 'multi',
            'applied_to_samples.targeted_sample_term.@id': 'multi',
            'applied_to_samples.targeted_sample_term.term_name': 'multi',
            'applied_to_samples.taxa': 'multi',
            'associated_phenotypes.@id': 'multi',
            'associated_phenotypes.term_id': 'multi',
            'associated_phenotypes.term_name': 'multi',
            'average_guide_coverage': 'multi',
            'average_insert_size': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'collections': 'multi',
            'control_for.@id': 'multi',
            'control_for.accession': 'multi',
            'control_for.aliases': 'multi',
            'control_type': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'exon': 'multi',
            'file_set_type': 'multi',
            'files.@id': 'multi',
            'files.accession': 'multi',
            'files.aliases': 'multi',
            'files.content_type': 'multi',
            'files.file_format': 'multi',
            'files.upload_status': 'multi',
            'guide_type': 'multi',
            'input_file_set_for': 'multi',
            'integrated_content_files.@id': 'multi',
            'integrated_content_files.accession': 'multi',
            'integrated_content_files.aliases': 'multi',
            'integrated_content_files.content_type': 'multi',
            'integrated_content_files.file_format': 'multi',
            'integrated_content_files.upload_status': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'large_scale_gene_list.@id': 'multi',
            'large_scale_gene_list.accession': 'multi',
            'large_scale_gene_list.aliases': 'multi',
            'large_scale_loci_list.@id': 'multi',
            'large_scale_loci_list.accession': 'multi',
            'large_scale_loci_list.aliases': 'multi',
            'lot_id': 'multi',
            'lower_bound_guide_coverage': 'multi',
            'lower_bound_insert_size': 'multi',
            'notes': 'multi',
            'orf_list.@id': 'multi',
            'orf_list.aliases': 'multi',
            'orf_list.genes.@id': 'multi',
            'orf_list.genes.symbol': 'multi',
            'orf_list.orf_id': 'multi',
            'product_id': 'multi',
            'publications.@id': 'multi',
            'publications.publication_identifiers': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            'scope': 'multi',
            'selection_criteria': 'multi',
            'small_scale_gene_list.@id': 'multi',
            'small_scale_gene_list.geneid': 'multi',
            'small_scale_gene_list.name': 'multi',
            'small_scale_gene_list.symbol': 'multi',
            'small_scale_gene_list.synonyms': 'multi',
            'small_scale_loci_list': 'multi',
            'sources': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_files_timestamp': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'targeton': 'multi',
            'tiling_modality': 'multi',
            'upper_bound_guide_coverage': 'multi',
            'upper_bound_insert_size': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if applied_to_samples_id is not None:
            
            _query_params.append(('applied_to_samples.@id', applied_to_samples_id))
            
        if applied_to_samples_accession is not None:
            
            _query_params.append(('applied_to_samples.accession', applied_to_samples_accession))
            
        if applied_to_samples_aliases is not None:
            
            _query_params.append(('applied_to_samples.aliases', applied_to_samples_aliases))
            
        if applied_to_samples_classifications is not None:
            
            _query_params.append(('applied_to_samples.classifications', applied_to_samples_classifications))
            
        if applied_to_samples_disease_terms_id is not None:
            
            _query_params.append(('applied_to_samples.disease_terms.@id', applied_to_samples_disease_terms_id))
            
        if applied_to_samples_disease_terms_term_name is not None:
            
            _query_params.append(('applied_to_samples.disease_terms.term_name', applied_to_samples_disease_terms_term_name))
            
        if applied_to_samples_donors_id is not None:
            
            _query_params.append(('applied_to_samples.donors.@id', applied_to_samples_donors_id))
            
        if applied_to_samples_donors_taxa is not None:
            
            _query_params.append(('applied_to_samples.donors.taxa', applied_to_samples_donors_taxa))
            
        if applied_to_samples_sample_terms_id is not None:
            
            _query_params.append(('applied_to_samples.sample_terms.@id', applied_to_samples_sample_terms_id))
            
        if applied_to_samples_sample_terms_term_name is not None:
            
            _query_params.append(('applied_to_samples.sample_terms.term_name', applied_to_samples_sample_terms_term_name))
            
        if applied_to_samples_status is not None:
            
            _query_params.append(('applied_to_samples.status', applied_to_samples_status))
            
        if applied_to_samples_summary is not None:
            
            _query_params.append(('applied_to_samples.summary', applied_to_samples_summary))
            
        if applied_to_samples_targeted_sample_term_id is not None:
            
            _query_params.append(('applied_to_samples.targeted_sample_term.@id', applied_to_samples_targeted_sample_term_id))
            
        if applied_to_samples_targeted_sample_term_term_name is not None:
            
            _query_params.append(('applied_to_samples.targeted_sample_term.term_name', applied_to_samples_targeted_sample_term_term_name))
            
        if applied_to_samples_taxa is not None:
            
            _query_params.append(('applied_to_samples.taxa', applied_to_samples_taxa))
            
        if associated_phenotypes_id is not None:
            
            _query_params.append(('associated_phenotypes.@id', associated_phenotypes_id))
            
        if associated_phenotypes_term_id is not None:
            
            _query_params.append(('associated_phenotypes.term_id', associated_phenotypes_term_id))
            
        if associated_phenotypes_term_name is not None:
            
            _query_params.append(('associated_phenotypes.term_name', associated_phenotypes_term_name))
            
        if average_guide_coverage is not None:
            
            _query_params.append(('average_guide_coverage', average_guide_coverage))
            
        if average_insert_size is not None:
            
            _query_params.append(('average_insert_size', average_insert_size))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if control_for_id is not None:
            
            _query_params.append(('control_for.@id', control_for_id))
            
        if control_for_accession is not None:
            
            _query_params.append(('control_for.accession', control_for_accession))
            
        if control_for_aliases is not None:
            
            _query_params.append(('control_for.aliases', control_for_aliases))
            
        if control_type is not None:
            
            _query_params.append(('control_type', control_type))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if exon is not None:
            
            _query_params.append(('exon', exon))
            
        if file_set_type is not None:
            
            _query_params.append(('file_set_type', file_set_type))
            
        if files_id is not None:
            
            _query_params.append(('files.@id', files_id))
            
        if files_accession is not None:
            
            _query_params.append(('files.accession', files_accession))
            
        if files_aliases is not None:
            
            _query_params.append(('files.aliases', files_aliases))
            
        if files_content_type is not None:
            
            _query_params.append(('files.content_type', files_content_type))
            
        if files_file_format is not None:
            
            _query_params.append(('files.file_format', files_file_format))
            
        if files_upload_status is not None:
            
            _query_params.append(('files.upload_status', files_upload_status))
            
        if guide_type is not None:
            
            _query_params.append(('guide_type', guide_type))
            
        if input_file_set_for is not None:
            
            _query_params.append(('input_file_set_for', input_file_set_for))
            
        if integrated_content_files_id is not None:
            
            _query_params.append(('integrated_content_files.@id', integrated_content_files_id))
            
        if integrated_content_files_accession is not None:
            
            _query_params.append(('integrated_content_files.accession', integrated_content_files_accession))
            
        if integrated_content_files_aliases is not None:
            
            _query_params.append(('integrated_content_files.aliases', integrated_content_files_aliases))
            
        if integrated_content_files_content_type is not None:
            
            _query_params.append(('integrated_content_files.content_type', integrated_content_files_content_type))
            
        if integrated_content_files_file_format is not None:
            
            _query_params.append(('integrated_content_files.file_format', integrated_content_files_file_format))
            
        if integrated_content_files_upload_status is not None:
            
            _query_params.append(('integrated_content_files.upload_status', integrated_content_files_upload_status))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if large_scale_gene_list_id is not None:
            
            _query_params.append(('large_scale_gene_list.@id', large_scale_gene_list_id))
            
        if large_scale_gene_list_accession is not None:
            
            _query_params.append(('large_scale_gene_list.accession', large_scale_gene_list_accession))
            
        if large_scale_gene_list_aliases is not None:
            
            _query_params.append(('large_scale_gene_list.aliases', large_scale_gene_list_aliases))
            
        if large_scale_loci_list_id is not None:
            
            _query_params.append(('large_scale_loci_list.@id', large_scale_loci_list_id))
            
        if large_scale_loci_list_accession is not None:
            
            _query_params.append(('large_scale_loci_list.accession', large_scale_loci_list_accession))
            
        if large_scale_loci_list_aliases is not None:
            
            _query_params.append(('large_scale_loci_list.aliases', large_scale_loci_list_aliases))
            
        if lot_id is not None:
            
            _query_params.append(('lot_id', lot_id))
            
        if lower_bound_guide_coverage is not None:
            
            _query_params.append(('lower_bound_guide_coverage', lower_bound_guide_coverage))
            
        if lower_bound_insert_size is not None:
            
            _query_params.append(('lower_bound_insert_size', lower_bound_insert_size))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if orf_list_id is not None:
            
            _query_params.append(('orf_list.@id', orf_list_id))
            
        if orf_list_aliases is not None:
            
            _query_params.append(('orf_list.aliases', orf_list_aliases))
            
        if orf_list_genes_id is not None:
            
            _query_params.append(('orf_list.genes.@id', orf_list_genes_id))
            
        if orf_list_genes_symbol is not None:
            
            _query_params.append(('orf_list.genes.symbol', orf_list_genes_symbol))
            
        if orf_list_orf_id is not None:
            
            _query_params.append(('orf_list.orf_id', orf_list_orf_id))
            
        if product_id is not None:
            
            _query_params.append(('product_id', product_id))
            
        if publications_id is not None:
            
            _query_params.append(('publications.@id', publications_id))
            
        if publications_publication_identifiers is not None:
            
            _query_params.append(('publications.publication_identifiers', publications_publication_identifiers))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        if selection_criteria is not None:
            
            _query_params.append(('selection_criteria', selection_criteria))
            
        if small_scale_gene_list_id is not None:
            
            _query_params.append(('small_scale_gene_list.@id', small_scale_gene_list_id))
            
        if small_scale_gene_list_geneid is not None:
            
            _query_params.append(('small_scale_gene_list.geneid', small_scale_gene_list_geneid))
            
        if small_scale_gene_list_name is not None:
            
            _query_params.append(('small_scale_gene_list.name', small_scale_gene_list_name))
            
        if small_scale_gene_list_symbol is not None:
            
            _query_params.append(('small_scale_gene_list.symbol', small_scale_gene_list_symbol))
            
        if small_scale_gene_list_synonyms is not None:
            
            _query_params.append(('small_scale_gene_list.synonyms', small_scale_gene_list_synonyms))
            
        if small_scale_loci_list is not None:
            
            _query_params.append(('small_scale_loci_list', small_scale_loci_list))
            
        if sources is not None:
            
            _query_params.append(('sources', sources))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_files_timestamp is not None:
            
            _query_params.append(('submitted_files_timestamp', submitted_files_timestamp))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if targeton is not None:
            
            _query_params.append(('targeton', targeton))
            
        if tiling_modality is not None:
            
            _query_params.append(('tiling_modality', tiling_modality))
            
        if upper_bound_guide_coverage is not None:
            
            _query_params.append(('upper_bound_guide_coverage', upper_bound_guide_coverage))
            
        if upper_bound_insert_size is not None:
            
            _query_params.append(('upper_bound_insert_size', upper_bound_insert_size))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/construct-library-sets/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def crispr_modifications(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        cas: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas")] = None,
        cas_species: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas_species")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        fused_domain: Annotated[Optional[List[StrictStr]], Field(description="Filter by fused_domain")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_protein: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_protein")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CrisprModificationResults:
        """List items in the CrisprModification collection.

        Collection endpoint that accepts various query parameters to filter and sort CrisprModification items. Supports filtering on fields within CrisprModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param cas: Filter by cas
        :type cas: List[str]
        :param cas_species: Filter by cas_species
        :type cas_species: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param fused_domain: Filter by fused_domain
        :type fused_domain: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_protein: Filter by tagged_protein
        :type tagged_protein: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._crispr_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            cas=cas,
            cas_species=cas_species,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            fused_domain=fused_domain,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_protein=tagged_protein,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CrisprModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def crispr_modifications_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        cas: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas")] = None,
        cas_species: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas_species")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        fused_domain: Annotated[Optional[List[StrictStr]], Field(description="Filter by fused_domain")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_protein: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_protein")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CrisprModificationResults]:
        """List items in the CrisprModification collection.

        Collection endpoint that accepts various query parameters to filter and sort CrisprModification items. Supports filtering on fields within CrisprModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param cas: Filter by cas
        :type cas: List[str]
        :param cas_species: Filter by cas_species
        :type cas_species: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param fused_domain: Filter by fused_domain
        :type fused_domain: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_protein: Filter by tagged_protein
        :type tagged_protein: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._crispr_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            cas=cas,
            cas_species=cas_species,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            fused_domain=fused_domain,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_protein=tagged_protein,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CrisprModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def crispr_modifications_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        cas: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas")] = None,
        cas_species: Annotated[Optional[List[StrictStr]], Field(description="Filter by cas_species")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        fused_domain: Annotated[Optional[List[StrictStr]], Field(description="Filter by fused_domain")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_protein: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_protein")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the CrisprModification collection.

        Collection endpoint that accepts various query parameters to filter and sort CrisprModification items. Supports filtering on fields within CrisprModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param cas: Filter by cas
        :type cas: List[str]
        :param cas_species: Filter by cas_species
        :type cas_species: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param fused_domain: Filter by fused_domain
        :type fused_domain: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_protein: Filter by tagged_protein
        :type tagged_protein: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._crispr_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            cas=cas,
            cas_species=cas_species,
            creation_timestamp=creation_timestamp,
            description=description,
            documents=documents,
            fused_domain=fused_domain,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_protein=tagged_protein,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CrisprModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _crispr_modifications_serialize(
        self,
        query,
        limit,
        sort,
        id,
        activated,
        activating_agent_term_id,
        activating_agent_term_name,
        aliases,
        award_id,
        award_component,
        biosamples_modified,
        cas,
        cas_species,
        creation_timestamp,
        description,
        documents,
        fused_domain,
        lab_id,
        lab_title,
        lot_id,
        modality,
        notes,
        product_id,
        release_timestamp,
        sources,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        tagged_protein,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'activated': 'multi',
            'activating_agent_term_id': 'multi',
            'activating_agent_term_name': 'multi',
            'aliases': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'biosamples_modified': 'multi',
            'cas': 'multi',
            'cas_species': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'fused_domain': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'lot_id': 'multi',
            'modality': 'multi',
            'notes': 'multi',
            'product_id': 'multi',
            'release_timestamp': 'multi',
            'sources': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'tagged_protein': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if activated is not None:
            
            _query_params.append(('activated', activated))
            
        if activating_agent_term_id is not None:
            
            _query_params.append(('activating_agent_term_id', activating_agent_term_id))
            
        if activating_agent_term_name is not None:
            
            _query_params.append(('activating_agent_term_name', activating_agent_term_name))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if biosamples_modified is not None:
            
            _query_params.append(('biosamples_modified', biosamples_modified))
            
        if cas is not None:
            
            _query_params.append(('cas', cas))
            
        if cas_species is not None:
            
            _query_params.append(('cas_species', cas_species))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if fused_domain is not None:
            
            _query_params.append(('fused_domain', fused_domain))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if lot_id is not None:
            
            _query_params.append(('lot_id', lot_id))
            
        if modality is not None:
            
            _query_params.append(('modality', modality))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if product_id is not None:
            
            _query_params.append(('product_id', product_id))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if sources is not None:
            
            _query_params.append(('sources', sources))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if tagged_protein is not None:
            
            _query_params.append(('tagged_protein', tagged_protein))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/crispr-modifications/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def curated_sets(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assemblies: Annotated[Optional[List[StrictStr]], Field(description="Filter by assemblies")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        transcriptome_annotations: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotations")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CuratedSetResults:
        """List items in the CuratedSet collection.

        Collection endpoint that accepts various query parameters to filter and sort CuratedSet items. Supports filtering on fields within CuratedSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assemblies: Filter by assemblies
        :type assemblies: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param transcriptome_annotations: Filter by transcriptome_annotations
        :type transcriptome_annotations: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._curated_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assemblies=assemblies,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            taxa=taxa,
            transcriptome_annotations=transcriptome_annotations,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CuratedSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def curated_sets_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assemblies: Annotated[Optional[List[StrictStr]], Field(description="Filter by assemblies")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        transcriptome_annotations: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotations")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CuratedSetResults]:
        """List items in the CuratedSet collection.

        Collection endpoint that accepts various query parameters to filter and sort CuratedSet items. Supports filtering on fields within CuratedSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assemblies: Filter by assemblies
        :type assemblies: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param transcriptome_annotations: Filter by transcriptome_annotations
        :type transcriptome_annotations: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._curated_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assemblies=assemblies,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            taxa=taxa,
            transcriptome_annotations=transcriptome_annotations,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CuratedSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def curated_sets_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        assemblies: Annotated[Optional[List[StrictStr]], Field(description="Filter by assemblies")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        award_contact_pi_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.@id")] = None,
        award_contact_pi_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.contact_pi.title")] = None,
        award_title: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by award.title")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        control_for_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.@id")] = None,
        control_for_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_for.accession")] = None,
        control_for_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by control_for.aliases")] = None,
        control_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by control_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        donors_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.@id")] = None,
        donors_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.accession")] = None,
        donors_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by donors.aliases")] = None,
        donors_sex: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.sex")] = None,
        donors_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.status")] = None,
        donors_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by donors.taxa")] = None,
        file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set_type")] = None,
        files_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.@id")] = None,
        files_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.accession")] = None,
        files_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by files.aliases")] = None,
        files_content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.content_type")] = None,
        files_creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.creation_timestamp")] = None,
        files_file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.file_format")] = None,
        files_file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by files.file_size")] = None,
        files_href: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.href")] = None,
        files_s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.s3_uri")] = None,
        files_sequencing_platform: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.sequencing_platform")] = None,
        files_submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.submitted_file_name")] = None,
        files_upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by files.upload_status")] = None,
        input_file_set_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_set_for")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        publications_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by publications.@id")] = None,
        publications_publication_identifiers: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by publications.publication_identifiers")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.@id")] = None,
        samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.accession")] = None,
        samples_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.aliases")] = None,
        samples_cell_fate_change_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.cell_fate_change_treatments")] = None,
        samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.classifications")] = None,
        samples_construct_library_sets: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.construct_library_sets")] = None,
        samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.disease_terms.@id")] = None,
        samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.disease_terms.term_name")] = None,
        samples_modifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.modifications")] = None,
        samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.@id")] = None,
        samples_sample_terms_aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.aliases")] = None,
        samples_sample_terms_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.status")] = None,
        samples_sample_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.sample_terms.summary")] = None,
        samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.sample_terms.term_name")] = None,
        samples_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.status")] = None,
        samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.summary")] = None,
        samples_targeted_sample_term_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.targeted_sample_term.@id")] = None,
        samples_targeted_sample_term_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by samples.targeted_sample_term.term_name")] = None,
        samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.taxa")] = None,
        samples_treatments: Annotated[Optional[List[StrictStr]], Field(description="Filter by samples.treatments")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_files_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_files_timestamp")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        transcriptome_annotations: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotations")] = None,
        url: Annotated[Optional[List[StrictStr]], Field(description="Filter by url")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the CuratedSet collection.

        Collection endpoint that accepts various query parameters to filter and sort CuratedSet items. Supports filtering on fields within CuratedSet items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param assemblies: Filter by assemblies
        :type assemblies: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param award_contact_pi_id: Filter by award.contact_pi.@id
        :type award_contact_pi_id: List[str]
        :param award_contact_pi_title: Filter by award.contact_pi.title
        :type award_contact_pi_title: List[str]
        :param award_title: Filter by award.title
        :type award_title: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param control_for_id: Filter by control_for.@id
        :type control_for_id: List[str]
        :param control_for_accession: Filter by control_for.accession
        :type control_for_accession: List[str]
        :param control_for_aliases: Filter by control_for.aliases
        :type control_for_aliases: List[str]
        :param control_type: Filter by control_type
        :type control_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param donors_id: Filter by donors.@id
        :type donors_id: List[str]
        :param donors_accession: Filter by donors.accession
        :type donors_accession: List[str]
        :param donors_aliases: Filter by donors.aliases
        :type donors_aliases: List[str]
        :param donors_sex: Filter by donors.sex
        :type donors_sex: List[str]
        :param donors_status: Filter by donors.status
        :type donors_status: List[str]
        :param donors_taxa: Filter by donors.taxa
        :type donors_taxa: List[str]
        :param file_set_type: Filter by file_set_type
        :type file_set_type: List[str]
        :param files_id: Filter by files.@id
        :type files_id: List[str]
        :param files_accession: Filter by files.accession
        :type files_accession: List[str]
        :param files_aliases: Filter by files.aliases
        :type files_aliases: List[str]
        :param files_content_type: Filter by files.content_type
        :type files_content_type: List[str]
        :param files_creation_timestamp: Filter by files.creation_timestamp
        :type files_creation_timestamp: List[str]
        :param files_file_format: Filter by files.file_format
        :type files_file_format: List[str]
        :param files_file_size: Filter by files.file_size
        :type files_file_size: List[int]
        :param files_href: Filter by files.href
        :type files_href: List[str]
        :param files_s3_uri: Filter by files.s3_uri
        :type files_s3_uri: List[str]
        :param files_sequencing_platform: Filter by files.sequencing_platform
        :type files_sequencing_platform: List[str]
        :param files_submitted_file_name: Filter by files.submitted_file_name
        :type files_submitted_file_name: List[str]
        :param files_upload_status: Filter by files.upload_status
        :type files_upload_status: List[str]
        :param input_file_set_for: Filter by input_file_set_for
        :type input_file_set_for: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param publications_id: Filter by publications.@id
        :type publications_id: List[str]
        :param publications_publication_identifiers: Filter by publications.publication_identifiers
        :type publications_publication_identifiers: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param samples_id: Filter by samples.@id
        :type samples_id: List[str]
        :param samples_accession: Filter by samples.accession
        :type samples_accession: List[str]
        :param samples_aliases: Filter by samples.aliases
        :type samples_aliases: List[str]
        :param samples_cell_fate_change_treatments: Filter by samples.cell_fate_change_treatments
        :type samples_cell_fate_change_treatments: List[str]
        :param samples_classifications: Filter by samples.classifications
        :type samples_classifications: List[str]
        :param samples_construct_library_sets: Filter by samples.construct_library_sets
        :type samples_construct_library_sets: List[str]
        :param samples_disease_terms_id: Filter by samples.disease_terms.@id
        :type samples_disease_terms_id: List[str]
        :param samples_disease_terms_term_name: Filter by samples.disease_terms.term_name
        :type samples_disease_terms_term_name: List[str]
        :param samples_modifications: Filter by samples.modifications
        :type samples_modifications: List[str]
        :param samples_sample_terms_id: Filter by samples.sample_terms.@id
        :type samples_sample_terms_id: List[str]
        :param samples_sample_terms_aliases: Filter by samples.sample_terms.aliases
        :type samples_sample_terms_aliases: List[str]
        :param samples_sample_terms_status: Filter by samples.sample_terms.status
        :type samples_sample_terms_status: List[str]
        :param samples_sample_terms_summary: Filter by samples.sample_terms.summary
        :type samples_sample_terms_summary: List[str]
        :param samples_sample_terms_term_name: Filter by samples.sample_terms.term_name
        :type samples_sample_terms_term_name: List[str]
        :param samples_status: Filter by samples.status
        :type samples_status: List[str]
        :param samples_summary: Filter by samples.summary
        :type samples_summary: List[str]
        :param samples_targeted_sample_term_id: Filter by samples.targeted_sample_term.@id
        :type samples_targeted_sample_term_id: List[str]
        :param samples_targeted_sample_term_term_name: Filter by samples.targeted_sample_term.term_name
        :type samples_targeted_sample_term_term_name: List[str]
        :param samples_taxa: Filter by samples.taxa
        :type samples_taxa: List[str]
        :param samples_treatments: Filter by samples.treatments
        :type samples_treatments: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_files_timestamp: Filter by submitted_files_timestamp
        :type submitted_files_timestamp: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param transcriptome_annotations: Filter by transcriptome_annotations
        :type transcriptome_annotations: List[str]
        :param url: Filter by url
        :type url: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._curated_sets_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            assemblies=assemblies,
            award_id=award_id,
            award_component=award_component,
            award_contact_pi_id=award_contact_pi_id,
            award_contact_pi_title=award_contact_pi_title,
            award_title=award_title,
            collections=collections,
            control_for_id=control_for_id,
            control_for_accession=control_for_accession,
            control_for_aliases=control_for_aliases,
            control_type=control_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            documents=documents,
            donors_id=donors_id,
            donors_accession=donors_accession,
            donors_aliases=donors_aliases,
            donors_sex=donors_sex,
            donors_status=donors_status,
            donors_taxa=donors_taxa,
            file_set_type=file_set_type,
            files_id=files_id,
            files_accession=files_accession,
            files_aliases=files_aliases,
            files_content_type=files_content_type,
            files_creation_timestamp=files_creation_timestamp,
            files_file_format=files_file_format,
            files_file_size=files_file_size,
            files_href=files_href,
            files_s3_uri=files_s3_uri,
            files_sequencing_platform=files_sequencing_platform,
            files_submitted_file_name=files_submitted_file_name,
            files_upload_status=files_upload_status,
            input_file_set_for=input_file_set_for,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            publications_id=publications_id,
            publications_publication_identifiers=publications_publication_identifiers,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            samples_id=samples_id,
            samples_accession=samples_accession,
            samples_aliases=samples_aliases,
            samples_cell_fate_change_treatments=samples_cell_fate_change_treatments,
            samples_classifications=samples_classifications,
            samples_construct_library_sets=samples_construct_library_sets,
            samples_disease_terms_id=samples_disease_terms_id,
            samples_disease_terms_term_name=samples_disease_terms_term_name,
            samples_modifications=samples_modifications,
            samples_sample_terms_id=samples_sample_terms_id,
            samples_sample_terms_aliases=samples_sample_terms_aliases,
            samples_sample_terms_status=samples_sample_terms_status,
            samples_sample_terms_summary=samples_sample_terms_summary,
            samples_sample_terms_term_name=samples_sample_terms_term_name,
            samples_status=samples_status,
            samples_summary=samples_summary,
            samples_targeted_sample_term_id=samples_targeted_sample_term_id,
            samples_targeted_sample_term_term_name=samples_targeted_sample_term_term_name,
            samples_taxa=samples_taxa,
            samples_treatments=samples_treatments,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_files_timestamp=submitted_files_timestamp,
            submitter_comment=submitter_comment,
            summary=summary,
            taxa=taxa,
            transcriptome_annotations=transcriptome_annotations,
            url=url,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CuratedSetResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _curated_sets_serialize(
        self,
        query,
        limit,
        sort,
        id,
        accession,
        aliases,
        alternate_accessions,
        assemblies,
        award_id,
        award_component,
        award_contact_pi_id,
        award_contact_pi_title,
        award_title,
        collections,
        control_for_id,
        control_for_accession,
        control_for_aliases,
        control_type,
        creation_timestamp,
        dbxrefs,
        description,
        documents,
        donors_id,
        donors_accession,
        donors_aliases,
        donors_sex,
        donors_status,
        donors_taxa,
        file_set_type,
        files_id,
        files_accession,
        files_aliases,
        files_content_type,
        files_creation_timestamp,
        files_file_format,
        files_file_size,
        files_href,
        files_s3_uri,
        files_sequencing_platform,
        files_submitted_file_name,
        files_upload_status,
        input_file_set_for,
        lab_id,
        lab_title,
        notes,
        publications_id,
        publications_publication_identifiers,
        release_timestamp,
        revoke_detail,
        samples_id,
        samples_accession,
        samples_aliases,
        samples_cell_fate_change_treatments,
        samples_classifications,
        samples_construct_library_sets,
        samples_disease_terms_id,
        samples_disease_terms_term_name,
        samples_modifications,
        samples_sample_terms_id,
        samples_sample_terms_aliases,
        samples_sample_terms_status,
        samples_sample_terms_summary,
        samples_sample_terms_term_name,
        samples_status,
        samples_summary,
        samples_targeted_sample_term_id,
        samples_targeted_sample_term_term_name,
        samples_taxa,
        samples_treatments,
        status,
        submitted_by_id,
        submitted_by_title,
        submitted_files_timestamp,
        submitter_comment,
        summary,
        taxa,
        transcriptome_annotations,
        url,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'accession': 'multi',
            'aliases': 'multi',
            'alternate_accessions': 'multi',
            'assemblies': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'award.contact_pi.@id': 'multi',
            'award.contact_pi.title': 'multi',
            'award.title': 'multi',
            'collections': 'multi',
            'control_for.@id': 'multi',
            'control_for.accession': 'multi',
            'control_for.aliases': 'multi',
            'control_type': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'donors.@id': 'multi',
            'donors.accession': 'multi',
            'donors.aliases': 'multi',
            'donors.sex': 'multi',
            'donors.status': 'multi',
            'donors.taxa': 'multi',
            'file_set_type': 'multi',
            'files.@id': 'multi',
            'files.accession': 'multi',
            'files.aliases': 'multi',
            'files.content_type': 'multi',
            'files.creation_timestamp': 'multi',
            'files.file_format': 'multi',
            'files.file_size': 'multi',
            'files.href': 'multi',
            'files.s3_uri': 'multi',
            'files.sequencing_platform': 'multi',
            'files.submitted_file_name': 'multi',
            'files.upload_status': 'multi',
            'input_file_set_for': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'notes': 'multi',
            'publications.@id': 'multi',
            'publications.publication_identifiers': 'multi',
            'release_timestamp': 'multi',
            'revoke_detail': 'multi',
            'samples.@id': 'multi',
            'samples.accession': 'multi',
            'samples.aliases': 'multi',
            'samples.cell_fate_change_treatments': 'multi',
            'samples.classifications': 'multi',
            'samples.construct_library_sets': 'multi',
            'samples.disease_terms.@id': 'multi',
            'samples.disease_terms.term_name': 'multi',
            'samples.modifications': 'multi',
            'samples.sample_terms.@id': 'multi',
            'samples.sample_terms.aliases': 'multi',
            'samples.sample_terms.status': 'multi',
            'samples.sample_terms.summary': 'multi',
            'samples.sample_terms.term_name': 'multi',
            'samples.status': 'multi',
            'samples.summary': 'multi',
            'samples.targeted_sample_term.@id': 'multi',
            'samples.targeted_sample_term.term_name': 'multi',
            'samples.taxa': 'multi',
            'samples.treatments': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitted_files_timestamp': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'taxa': 'multi',
            'transcriptome_annotations': 'multi',
            'url': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if accession is not None:
            
            _query_params.append(('accession', accession))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if alternate_accessions is not None:
            
            _query_params.append(('alternate_accessions', alternate_accessions))
            
        if assemblies is not None:
            
            _query_params.append(('assemblies', assemblies))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if award_contact_pi_id is not None:
            
            _query_params.append(('award.contact_pi.@id', award_contact_pi_id))
            
        if award_contact_pi_title is not None:
            
            _query_params.append(('award.contact_pi.title', award_contact_pi_title))
            
        if award_title is not None:
            
            _query_params.append(('award.title', award_title))
            
        if collections is not None:
            
            _query_params.append(('collections', collections))
            
        if control_for_id is not None:
            
            _query_params.append(('control_for.@id', control_for_id))
            
        if control_for_accession is not None:
            
            _query_params.append(('control_for.accession', control_for_accession))
            
        if control_for_aliases is not None:
            
            _query_params.append(('control_for.aliases', control_for_aliases))
            
        if control_type is not None:
            
            _query_params.append(('control_type', control_type))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if donors_id is not None:
            
            _query_params.append(('donors.@id', donors_id))
            
        if donors_accession is not None:
            
            _query_params.append(('donors.accession', donors_accession))
            
        if donors_aliases is not None:
            
            _query_params.append(('donors.aliases', donors_aliases))
            
        if donors_sex is not None:
            
            _query_params.append(('donors.sex', donors_sex))
            
        if donors_status is not None:
            
            _query_params.append(('donors.status', donors_status))
            
        if donors_taxa is not None:
            
            _query_params.append(('donors.taxa', donors_taxa))
            
        if file_set_type is not None:
            
            _query_params.append(('file_set_type', file_set_type))
            
        if files_id is not None:
            
            _query_params.append(('files.@id', files_id))
            
        if files_accession is not None:
            
            _query_params.append(('files.accession', files_accession))
            
        if files_aliases is not None:
            
            _query_params.append(('files.aliases', files_aliases))
            
        if files_content_type is not None:
            
            _query_params.append(('files.content_type', files_content_type))
            
        if files_creation_timestamp is not None:
            
            _query_params.append(('files.creation_timestamp', files_creation_timestamp))
            
        if files_file_format is not None:
            
            _query_params.append(('files.file_format', files_file_format))
            
        if files_file_size is not None:
            
            _query_params.append(('files.file_size', files_file_size))
            
        if files_href is not None:
            
            _query_params.append(('files.href', files_href))
            
        if files_s3_uri is not None:
            
            _query_params.append(('files.s3_uri', files_s3_uri))
            
        if files_sequencing_platform is not None:
            
            _query_params.append(('files.sequencing_platform', files_sequencing_platform))
            
        if files_submitted_file_name is not None:
            
            _query_params.append(('files.submitted_file_name', files_submitted_file_name))
            
        if files_upload_status is not None:
            
            _query_params.append(('files.upload_status', files_upload_status))
            
        if input_file_set_for is not None:
            
            _query_params.append(('input_file_set_for', input_file_set_for))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if publications_id is not None:
            
            _query_params.append(('publications.@id', publications_id))
            
        if publications_publication_identifiers is not None:
            
            _query_params.append(('publications.publication_identifiers', publications_publication_identifiers))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if revoke_detail is not None:
            
            _query_params.append(('revoke_detail', revoke_detail))
            
        if samples_id is not None:
            
            _query_params.append(('samples.@id', samples_id))
            
        if samples_accession is not None:
            
            _query_params.append(('samples.accession', samples_accession))
            
        if samples_aliases is not None:
            
            _query_params.append(('samples.aliases', samples_aliases))
            
        if samples_cell_fate_change_treatments is not None:
            
            _query_params.append(('samples.cell_fate_change_treatments', samples_cell_fate_change_treatments))
            
        if samples_classifications is not None:
            
            _query_params.append(('samples.classifications', samples_classifications))
            
        if samples_construct_library_sets is not None:
            
            _query_params.append(('samples.construct_library_sets', samples_construct_library_sets))
            
        if samples_disease_terms_id is not None:
            
            _query_params.append(('samples.disease_terms.@id', samples_disease_terms_id))
            
        if samples_disease_terms_term_name is not None:
            
            _query_params.append(('samples.disease_terms.term_name', samples_disease_terms_term_name))
            
        if samples_modifications is not None:
            
            _query_params.append(('samples.modifications', samples_modifications))
            
        if samples_sample_terms_id is not None:
            
            _query_params.append(('samples.sample_terms.@id', samples_sample_terms_id))
            
        if samples_sample_terms_aliases is not None:
            
            _query_params.append(('samples.sample_terms.aliases', samples_sample_terms_aliases))
            
        if samples_sample_terms_status is not None:
            
            _query_params.append(('samples.sample_terms.status', samples_sample_terms_status))
            
        if samples_sample_terms_summary is not None:
            
            _query_params.append(('samples.sample_terms.summary', samples_sample_terms_summary))
            
        if samples_sample_terms_term_name is not None:
            
            _query_params.append(('samples.sample_terms.term_name', samples_sample_terms_term_name))
            
        if samples_status is not None:
            
            _query_params.append(('samples.status', samples_status))
            
        if samples_summary is not None:
            
            _query_params.append(('samples.summary', samples_summary))
            
        if samples_targeted_sample_term_id is not None:
            
            _query_params.append(('samples.targeted_sample_term.@id', samples_targeted_sample_term_id))
            
        if samples_targeted_sample_term_term_name is not None:
            
            _query_params.append(('samples.targeted_sample_term.term_name', samples_targeted_sample_term_term_name))
            
        if samples_taxa is not None:
            
            _query_params.append(('samples.taxa', samples_taxa))
            
        if samples_treatments is not None:
            
            _query_params.append(('samples.treatments', samples_treatments))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitted_files_timestamp is not None:
            
            _query_params.append(('submitted_files_timestamp', submitted_files_timestamp))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if taxa is not None:
            
            _query_params.append(('taxa', taxa))
            
        if transcriptome_annotations is not None:
            
            _query_params.append(('transcriptome_annotations', transcriptome_annotations))
            
        if url is not None:
            
            _query_params.append(('url', url))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/curated-sets/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def degron_modifications(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        degron_system: Annotated[Optional[List[StrictStr]], Field(description="Filter by degron_system")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_proteins: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_proteins")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DegronModificationResults:
        """List items in the DegronModification collection.

        Collection endpoint that accepts various query parameters to filter and sort DegronModification items. Supports filtering on fields within DegronModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param degron_system: Filter by degron_system
        :type degron_system: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_proteins: Filter by tagged_proteins
        :type tagged_proteins: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._degron_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            creation_timestamp=creation_timestamp,
            degron_system=degron_system,
            description=description,
            documents=documents,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_proteins=tagged_proteins,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DegronModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def degron_modifications_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        degron_system: Annotated[Optional[List[StrictStr]], Field(description="Filter by degron_system")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_proteins: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_proteins")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DegronModificationResults]:
        """List items in the DegronModification collection.

        Collection endpoint that accepts various query parameters to filter and sort DegronModification items. Supports filtering on fields within DegronModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param degron_system: Filter by degron_system
        :type degron_system: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_proteins: Filter by tagged_proteins
        :type tagged_proteins: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._degron_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            creation_timestamp=creation_timestamp,
            degron_system=degron_system,
            description=description,
            documents=documents,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_proteins=tagged_proteins,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DegronModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def degron_modifications_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        activated: Annotated[Optional[List[StrictBool]], Field(description="Filter by activated")] = None,
        activating_agent_term_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by activating_agent_term_id")] = None,
        activating_agent_term_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by activating_agent_term_name")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        biosamples_modified: Annotated[Optional[List[StrictStr]], Field(description="Filter by biosamples_modified")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        degron_system: Annotated[Optional[List[StrictStr]], Field(description="Filter by degron_system")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        lot_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by lot_id")] = None,
        modality: Annotated[Optional[List[StrictStr]], Field(description="Filter by modality")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        product_id: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by product_id")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        sources: Annotated[Optional[List[StrictStr]], Field(description="Filter by sources")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        tagged_proteins: Annotated[Optional[List[StrictStr]], Field(description="Filter by tagged_proteins")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the DegronModification collection.

        Collection endpoint that accepts various query parameters to filter and sort DegronModification items. Supports filtering on fields within DegronModification items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param activated: Filter by activated
        :type activated: List[bool]
        :param activating_agent_term_id: Filter by activating_agent_term_id
        :type activating_agent_term_id: List[str]
        :param activating_agent_term_name: Filter by activating_agent_term_name
        :type activating_agent_term_name: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param biosamples_modified: Filter by biosamples_modified
        :type biosamples_modified: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param degron_system: Filter by degron_system
        :type degron_system: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param lot_id: Filter by lot_id
        :type lot_id: List[str]
        :param modality: Filter by modality
        :type modality: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param product_id: Filter by product_id
        :type product_id: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param sources: Filter by sources
        :type sources: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param tagged_proteins: Filter by tagged_proteins
        :type tagged_proteins: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._degron_modifications_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            activated=activated,
            activating_agent_term_id=activating_agent_term_id,
            activating_agent_term_name=activating_agent_term_name,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            biosamples_modified=biosamples_modified,
            creation_timestamp=creation_timestamp,
            degron_system=degron_system,
            description=description,
            documents=documents,
            lab_id=lab_id,
            lab_title=lab_title,
            lot_id=lot_id,
            modality=modality,
            notes=notes,
            product_id=product_id,
            release_timestamp=release_timestamp,
            sources=sources,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            tagged_proteins=tagged_proteins,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DegronModificationResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _degron_modifications_serialize(
        self,
        query,
        limit,
        sort,
        id,
        activated,
        activating_agent_term_id,
        activating_agent_term_name,
        aliases,
        award_id,
        award_component,
        biosamples_modified,
        creation_timestamp,
        degron_system,
        description,
        documents,
        lab_id,
        lab_title,
        lot_id,
        modality,
        notes,
        product_id,
        release_timestamp,
        sources,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        tagged_proteins,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'activated': 'multi',
            'activating_agent_term_id': 'multi',
            'activating_agent_term_name': 'multi',
            'aliases': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'biosamples_modified': 'multi',
            'creation_timestamp': 'multi',
            'degron_system': 'multi',
            'description': 'multi',
            'documents': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'lot_id': 'multi',
            'modality': 'multi',
            'notes': 'multi',
            'product_id': 'multi',
            'release_timestamp': 'multi',
            'sources': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'tagged_proteins': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if activated is not None:
            
            _query_params.append(('activated', activated))
            
        if activating_agent_term_id is not None:
            
            _query_params.append(('activating_agent_term_id', activating_agent_term_id))
            
        if activating_agent_term_name is not None:
            
            _query_params.append(('activating_agent_term_name', activating_agent_term_name))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if biosamples_modified is not None:
            
            _query_params.append(('biosamples_modified', biosamples_modified))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if degron_system is not None:
            
            _query_params.append(('degron_system', degron_system))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if documents is not None:
            
            _query_params.append(('documents', documents))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if lot_id is not None:
            
            _query_params.append(('lot_id', lot_id))
            
        if modality is not None:
            
            _query_params.append(('modality', modality))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if product_id is not None:
            
            _query_params.append(('product_id', product_id))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if sources is not None:
            
            _query_params.append(('sources', sources))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if tagged_proteins is not None:
            
            _query_params.append(('tagged_proteins', tagged_proteins))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/degron-modifications/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def documents(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        characterization_method: Annotated[Optional[List[StrictStr]], Field(description="Filter by characterization_method")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        document_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by document_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        urls: Annotated[Optional[List[StrictStr]], Field(description="Filter by urls")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DocumentResults:
        """List items in the Document collection.

        Collection endpoint that accepts various query parameters to filter and sort Document items. Supports filtering on fields within Document items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param characterization_method: Filter by characterization_method
        :type characterization_method: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param document_type: Filter by document_type
        :type document_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param urls: Filter by urls
        :type urls: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._documents_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            characterization_method=characterization_method,
            creation_timestamp=creation_timestamp,
            description=description,
            document_type=document_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            urls=urls,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def documents_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        characterization_method: Annotated[Optional[List[StrictStr]], Field(description="Filter by characterization_method")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        document_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by document_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        urls: Annotated[Optional[List[StrictStr]], Field(description="Filter by urls")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DocumentResults]:
        """List items in the Document collection.

        Collection endpoint that accepts various query parameters to filter and sort Document items. Supports filtering on fields within Document items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param characterization_method: Filter by characterization_method
        :type characterization_method: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param document_type: Filter by document_type
        :type document_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param urls: Filter by urls
        :type urls: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._documents_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            characterization_method=characterization_method,
            creation_timestamp=creation_timestamp,
            description=description,
            document_type=document_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            urls=urls,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def documents_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        characterization_method: Annotated[Optional[List[StrictStr]], Field(description="Filter by characterization_method")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        document_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by document_type")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        urls: Annotated[Optional[List[StrictStr]], Field(description="Filter by urls")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the Document collection.

        Collection endpoint that accepts various query parameters to filter and sort Document items. Supports filtering on fields within Document items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param characterization_method: Filter by characterization_method
        :type characterization_method: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param document_type: Filter by document_type
        :type document_type: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param urls: Filter by urls
        :type urls: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._documents_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            award_id=award_id,
            award_component=award_component,
            characterization_method=characterization_method,
            creation_timestamp=creation_timestamp,
            description=description,
            document_type=document_type,
            lab_id=lab_id,
            lab_title=lab_title,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            urls=urls,
            uuid=uuid,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _documents_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        award_id,
        award_component,
        characterization_method,
        creation_timestamp,
        description,
        document_type,
        lab_id,
        lab_title,
        notes,
        release_timestamp,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        urls,
        uuid,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'award.@id': 'multi',
            'award.component': 'multi',
            'characterization_method': 'multi',
            'creation_timestamp': 'multi',
            'description': 'multi',
            'document_type': 'multi',
            'lab.@id': 'multi',
            'lab.title': 'multi',
            'notes': 'multi',
            'release_timestamp': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'urls': 'multi',
            'uuid': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if award_id is not None:
            
            _query_params.append(('award.@id', award_id))
            
        if award_component is not None:
            
            _query_params.append(('award.component', award_component))
            
        if characterization_method is not None:
            
            _query_params.append(('characterization_method', characterization_method))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if document_type is not None:
            
            _query_params.append(('document_type', document_type))
            
        if lab_id is not None:
            
            _query_params.append(('lab.@id', lab_id))
            
        if lab_title is not None:
            
            _query_params.append(('lab.title', lab_title))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if urls is not None:
            
            _query_params.append(('urls', urls))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/documents/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download(
        self,
        file_id: Annotated[StrictStr, Field(description="The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03).")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Download file.

        Returns underlying file associated with file metadata

        :param file_id: The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03). (required)
        :type file_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03).")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Download file.

        Returns underlying file associated with file metadata

        :param file_id: The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03). (required)
        :type file_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03).")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download file.

        Returns underlying file associated with file metadata

        :param file_id: The unique identifier for the file to download, e.g. @id (/tabular-files/IGVFFI8092FZKL/), accession (IGVFFI8092FZKL), or UUID (fdbdc159-e5b9-40a8-b788-3f72c9886b03). (required)
        :type file_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_serialize(
        self,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/octet-stream'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/{file_id}/@@download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genes(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by geneid")] = None,
        geneid_with_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by geneid_with_version")] = None,
        locations: Annotated[Optional[List[GeneLocation]], Field(description="Filter by locations")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by symbol")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        title: Annotated[Optional[List[StrictStr]], Field(description="Filter by title")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        version_number: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by version_number")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GeneResults:
        """List items in the Gene collection.

        Collection endpoint that accepts various query parameters to filter and sort Gene items. Supports filtering on fields within Gene items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param geneid: Filter by geneid
        :type geneid: List[str]
        :param geneid_with_version: Filter by geneid_with_version
        :type geneid_with_version: List[str]
        :param locations: Filter by locations
        :type locations: List[GeneLocation]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param symbol: Filter by symbol
        :type symbol: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param version_number: Filter by version_number
        :type version_number: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genes_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            geneid=geneid,
            geneid_with_version=geneid_with_version,
            locations=locations,
            name=name,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            symbol=symbol,
            synonyms=synonyms,
            taxa=taxa,
            title=title,
            transcriptome_annotation=transcriptome_annotation,
            uuid=uuid,
            version_number=version_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeneResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genes_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by geneid")] = None,
        geneid_with_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by geneid_with_version")] = None,
        locations: Annotated[Optional[List[GeneLocation]], Field(description="Filter by locations")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by symbol")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        title: Annotated[Optional[List[StrictStr]], Field(description="Filter by title")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        version_number: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by version_number")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GeneResults]:
        """List items in the Gene collection.

        Collection endpoint that accepts various query parameters to filter and sort Gene items. Supports filtering on fields within Gene items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param geneid: Filter by geneid
        :type geneid: List[str]
        :param geneid_with_version: Filter by geneid_with_version
        :type geneid_with_version: List[str]
        :param locations: Filter by locations
        :type locations: List[GeneLocation]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param symbol: Filter by symbol
        :type symbol: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param version_number: Filter by version_number
        :type version_number: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genes_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            geneid=geneid,
            geneid_with_version=geneid_with_version,
            locations=locations,
            name=name,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            symbol=symbol,
            synonyms=synonyms,
            taxa=taxa,
            title=title,
            transcriptome_annotation=transcriptome_annotation,
            uuid=uuid,
            version_number=version_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeneResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genes_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        geneid: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by geneid")] = None,
        geneid_with_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by geneid_with_version")] = None,
        locations: Annotated[Optional[List[GeneLocation]], Field(description="Filter by locations")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="Filter by name")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by symbol")] = None,
        synonyms: Annotated[Optional[List[StrictStr]], Field(description="Filter by synonyms")] = None,
        taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by taxa")] = None,
        title: Annotated[Optional[List[StrictStr]], Field(description="Filter by title")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        version_number: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by version_number")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List items in the Gene collection.

        Collection endpoint that accepts various query parameters to filter and sort Gene items. Supports filtering on fields within Gene items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param geneid: Filter by geneid
        :type geneid: List[str]
        :param geneid_with_version: Filter by geneid_with_version
        :type geneid_with_version: List[str]
        :param locations: Filter by locations
        :type locations: List[GeneLocation]
        :param name: Filter by name
        :type name: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param symbol: Filter by symbol
        :type symbol: List[str]
        :param synonyms: Filter by synonyms
        :type synonyms: List[str]
        :param taxa: Filter by taxa
        :type taxa: List[str]
        :param title: Filter by title
        :type title: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param version_number: Filter by version_number
        :type version_number: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genes_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            aliases=aliases,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            description=description,
            geneid=geneid,
            geneid_with_version=geneid_with_version,
            locations=locations,
            name=name,
            notes=notes,
            release_timestamp=release_timestamp,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitter_comment=submitter_comment,
            summary=summary,
            symbol=symbol,
            synonyms=synonyms,
            taxa=taxa,
            title=title,
            transcriptome_annotation=transcriptome_annotation,
            uuid=uuid,
            version_number=version_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeneResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genes_serialize(
        self,
        query,
        limit,
        sort,
        id,
        aliases,
        creation_timestamp,
        dbxrefs,
        description,
        geneid,
        geneid_with_version,
        locations,
        name,
        notes,
        release_timestamp,
        status,
        submitted_by_id,
        submitted_by_title,
        submitter_comment,
        summary,
        symbol,
        synonyms,
        taxa,
        title,
        transcriptome_annotation,
        uuid,
        version_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
            '@id': 'multi',
            'aliases': 'multi',
            'creation_timestamp': 'multi',
            'dbxrefs': 'multi',
            'description': 'multi',
            'geneid': 'multi',
            'geneid_with_version': 'multi',
            'locations': 'multi',
            'name': 'multi',
            'notes': 'multi',
            'release_timestamp': 'multi',
            'status': 'multi',
            'submitted_by.@id': 'multi',
            'submitted_by.title': 'multi',
            'submitter_comment': 'multi',
            'summary': 'multi',
            'symbol': 'multi',
            'synonyms': 'multi',
            'taxa': 'multi',
            'title': 'multi',
            'transcriptome_annotation': 'multi',
            'uuid': 'multi',
            'version_number': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if id is not None:
            
            _query_params.append(('@id', id))
            
        if aliases is not None:
            
            _query_params.append(('aliases', aliases))
            
        if creation_timestamp is not None:
            
            _query_params.append(('creation_timestamp', creation_timestamp))
            
        if dbxrefs is not None:
            
            _query_params.append(('dbxrefs', dbxrefs))
            
        if description is not None:
            
            _query_params.append(('description', description))
            
        if geneid is not None:
            
            _query_params.append(('geneid', geneid))
            
        if geneid_with_version is not None:
            
            _query_params.append(('geneid_with_version', geneid_with_version))
            
        if locations is not None:
            
            _query_params.append(('locations', locations))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if notes is not None:
            
            _query_params.append(('notes', notes))
            
        if release_timestamp is not None:
            
            _query_params.append(('release_timestamp', release_timestamp))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if submitted_by_id is not None:
            
            _query_params.append(('submitted_by.@id', submitted_by_id))
            
        if submitted_by_title is not None:
            
            _query_params.append(('submitted_by.title', submitted_by_title))
            
        if submitter_comment is not None:
            
            _query_params.append(('submitter_comment', submitter_comment))
            
        if summary is not None:
            
            _query_params.append(('summary', summary))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if synonyms is not None:
            
            _query_params.append(('synonyms', synonyms))
            
        if taxa is not None:
            
            _query_params.append(('taxa', taxa))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if transcriptome_annotation is not None:
            
            _query_params.append(('transcriptome_annotation', transcriptome_annotation))
            
        if uuid is not None:
            
            _query_params.append(('uuid', uuid))
            
        if version_number is not None:
            
            _query_params.append(('version_number', version_number))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # Set client side default value of Query Param "frame".
        _query_params.append(('frame', 'object'))

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genes/@@listing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_browser_annotation_files(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        cell_type_annotation_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by cell_type_annotation.@id")] = None,
        cell_type_annotation_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by cell_type_annotation.term_name")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_format_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_type")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GenomeBrowserAnnotationFileResults:
        """List items in the GenomeBrowserAnnotationFile collection.

        Collection endpoint that accepts various query parameters to filter and sort GenomeBrowserAnnotationFile items. Supports filtering on fields within GenomeBrowserAnnotationFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param assembly: Filter by assembly
        :type assembly: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param cell_type_annotation_id: Filter by cell_type_annotation.@id
        :type cell_type_annotation_id: List[str]
        :param cell_type_annotation_term_name: Filter by cell_type_annotation.term_name
        :type cell_type_annotation_term_name: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_format_type: Filter by file_format_type
        :type file_format_type: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_browser_annotation_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            assay_titles=assay_titles,
            assembly=assembly,
            award_id=award_id,
            award_component=award_component,
            cell_type_annotation_id=cell_type_annotation_id,
            cell_type_annotation_term_name=cell_type_annotation_term_name,
            collections=collections,
            content_md5sum=content_md5sum,
            content_type=content_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_format_type=file_format_type,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            transcriptome_annotation=transcriptome_annotation,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenomeBrowserAnnotationFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_browser_annotation_files_with_http_info(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        cell_type_annotation_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by cell_type_annotation.@id")] = None,
        cell_type_annotation_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by cell_type_annotation.term_name")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_format_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_type")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by submitter_comment")] = None,
        summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by summary")] = None,
        transcriptome_annotation: Annotated[Optional[List[StrictStr]], Field(description="Filter by transcriptome_annotation")] = None,
        upload_status: Annotated[Optional[List[StrictStr]], Field(description="Filter by upload_status")] = None,
        uuid: Annotated[Optional[List[StrictStr]], Field(description="Filter by uuid")] = None,
        validation_error_detail: Annotated[Optional[List[StrictStr]], Field(description="Filter by validation_error_detail")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GenomeBrowserAnnotationFileResults]:
        """List items in the GenomeBrowserAnnotationFile collection.

        Collection endpoint that accepts various query parameters to filter and sort GenomeBrowserAnnotationFile items. Supports filtering on fields within GenomeBrowserAnnotationFile items.

        :param query: Query string for searching.
        :type query: str
        :param limit: Maximum number of results to return. Default is 25. Use 'all' for all results.
        :type limit: Limit
        :param sort: Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.
        :type sort: List[str]
        :param id: Filter by @id
        :type id: List[str]
        :param accession: Filter by accession
        :type accession: List[str]
        :param aliases: Filter by aliases
        :type aliases: List[str]
        :param alternate_accessions: Filter by alternate_accessions
        :type alternate_accessions: List[str]
        :param analysis_step_version: Filter by analysis_step_version
        :type analysis_step_version: List[str]
        :param assay_titles: Filter by assay_titles
        :type assay_titles: List[str]
        :param assembly: Filter by assembly
        :type assembly: List[str]
        :param award_id: Filter by award.@id
        :type award_id: List[str]
        :param award_component: Filter by award.component
        :type award_component: List[str]
        :param cell_type_annotation_id: Filter by cell_type_annotation.@id
        :type cell_type_annotation_id: List[str]
        :param cell_type_annotation_term_name: Filter by cell_type_annotation.term_name
        :type cell_type_annotation_term_name: List[str]
        :param collections: Filter by collections
        :type collections: List[str]
        :param content_md5sum: Filter by content_md5sum
        :type content_md5sum: List[str]
        :param content_type: Filter by content_type
        :type content_type: List[str]
        :param creation_timestamp: Filter by creation_timestamp
        :type creation_timestamp: List[str]
        :param dbxrefs: Filter by dbxrefs
        :type dbxrefs: List[str]
        :param derived_from: Filter by derived_from
        :type derived_from: List[str]
        :param description: Filter by description
        :type description: List[str]
        :param documents: Filter by documents
        :type documents: List[str]
        :param file_format: Filter by file_format
        :type file_format: List[str]
        :param file_format_specifications: Filter by file_format_specifications
        :type file_format_specifications: List[str]
        :param file_format_type: Filter by file_format_type
        :type file_format_type: List[str]
        :param file_set_id: Filter by file_set.@id
        :type file_set_id: List[str]
        :param file_set_accession: Filter by file_set.accession
        :type file_set_accession: List[str]
        :param file_set_file_set_type: Filter by file_set.file_set_type
        :type file_set_file_set_type: List[str]
        :param file_set_samples_id: Filter by file_set.samples.@id
        :type file_set_samples_id: List[str]
        :param file_set_samples_accession: Filter by file_set.samples.accession
        :type file_set_samples_accession: List[str]
        :param file_set_samples_classifications: Filter by file_set.samples.classifications
        :type file_set_samples_classifications: List[str]
        :param file_set_samples_disease_terms_id: Filter by file_set.samples.disease_terms.@id
        :type file_set_samples_disease_terms_id: List[str]
        :param file_set_samples_disease_terms_summary: Filter by file_set.samples.disease_terms.summary
        :type file_set_samples_disease_terms_summary: List[str]
        :param file_set_samples_disease_terms_term_name: Filter by file_set.samples.disease_terms.term_name
        :type file_set_samples_disease_terms_term_name: List[str]
        :param file_set_samples_sample_terms_id: Filter by file_set.samples.sample_terms.@id
        :type file_set_samples_sample_terms_id: List[str]
        :param file_set_samples_sample_terms_term_name: Filter by file_set.samples.sample_terms.term_name
        :type file_set_samples_sample_terms_term_name: List[str]
        :param file_set_samples_summary: Filter by file_set.samples.summary
        :type file_set_samples_summary: List[str]
        :param file_set_samples_taxa: Filter by file_set.samples.taxa
        :type file_set_samples_taxa: List[str]
        :param file_set_summary: Filter by file_set.summary
        :type file_set_summary: List[str]
        :param file_set_taxa: Filter by file_set.taxa
        :type file_set_taxa: List[str]
        :param file_size: Filter by file_size
        :type file_size: List[int]
        :param gene_list_for: Filter by gene_list_for
        :type gene_list_for: List[str]
        :param href: Filter by href
        :type href: List[str]
        :param input_file_for: Filter by input_file_for
        :type input_file_for: List[str]
        :param integrated_in_id: Filter by integrated_in.@id
        :type integrated_in_id: List[str]
        :param integrated_in_associated_phenotypes_id: Filter by integrated_in.associated_phenotypes.@id
        :type integrated_in_associated_phenotypes_id: List[str]
        :param integrated_in_associated_phenotypes_summary: Filter by integrated_in.associated_phenotypes.summary
        :type integrated_in_associated_phenotypes_summary: List[str]
        :param integrated_in_associated_phenotypes_term_name: Filter by integrated_in.associated_phenotypes.term_name
        :type integrated_in_associated_phenotypes_term_name: List[str]
        :param integrated_in_file_set_type: Filter by integrated_in.file_set_type
        :type integrated_in_file_set_type: List[str]
        :param integrated_in_small_scale_gene_list_id: Filter by integrated_in.small_scale_gene_list.@id
        :type integrated_in_small_scale_gene_list_id: List[str]
        :param integrated_in_small_scale_gene_list_symbol: Filter by integrated_in.small_scale_gene_list.symbol
        :type integrated_in_small_scale_gene_list_symbol: List[str]
        :param integrated_in_summary: Filter by integrated_in.summary
        :type integrated_in_summary: List[str]
        :param lab_id: Filter by lab.@id
        :type lab_id: List[str]
        :param lab_title: Filter by lab.title
        :type lab_title: List[str]
        :param loci_list_for: Filter by loci_list_for
        :type loci_list_for: List[str]
        :param md5sum: Filter by md5sum
        :type md5sum: List[str]
        :param notes: Filter by notes
        :type notes: List[str]
        :param release_timestamp: Filter by release_timestamp
        :type release_timestamp: List[str]
        :param revoke_detail: Filter by revoke_detail
        :type revoke_detail: List[str]
        :param s3_uri: Filter by s3_uri
        :type s3_uri: List[str]
        :param status: Filter by status
        :type status: List[str]
        :param submitted_by_id: Filter by submitted_by.@id
        :type submitted_by_id: List[str]
        :param submitted_by_title: Filter by submitted_by.title
        :type submitted_by_title: List[str]
        :param submitted_file_name: Filter by submitted_file_name
        :type submitted_file_name: List[str]
        :param submitter_comment: Filter by submitter_comment
        :type submitter_comment: List[str]
        :param summary: Filter by summary
        :type summary: List[str]
        :param transcriptome_annotation: Filter by transcriptome_annotation
        :type transcriptome_annotation: List[str]
        :param upload_status: Filter by upload_status
        :type upload_status: List[str]
        :param uuid: Filter by uuid
        :type uuid: List[str]
        :param validation_error_detail: Filter by validation_error_detail
        :type validation_error_detail: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_browser_annotation_files_serialize(
            query=query,
            limit=limit,
            sort=sort,
            id=id,
            accession=accession,
            aliases=aliases,
            alternate_accessions=alternate_accessions,
            analysis_step_version=analysis_step_version,
            assay_titles=assay_titles,
            assembly=assembly,
            award_id=award_id,
            award_component=award_component,
            cell_type_annotation_id=cell_type_annotation_id,
            cell_type_annotation_term_name=cell_type_annotation_term_name,
            collections=collections,
            content_md5sum=content_md5sum,
            content_type=content_type,
            creation_timestamp=creation_timestamp,
            dbxrefs=dbxrefs,
            derived_from=derived_from,
            description=description,
            documents=documents,
            file_format=file_format,
            file_format_specifications=file_format_specifications,
            file_format_type=file_format_type,
            file_set_id=file_set_id,
            file_set_accession=file_set_accession,
            file_set_file_set_type=file_set_file_set_type,
            file_set_samples_id=file_set_samples_id,
            file_set_samples_accession=file_set_samples_accession,
            file_set_samples_classifications=file_set_samples_classifications,
            file_set_samples_disease_terms_id=file_set_samples_disease_terms_id,
            file_set_samples_disease_terms_summary=file_set_samples_disease_terms_summary,
            file_set_samples_disease_terms_term_name=file_set_samples_disease_terms_term_name,
            file_set_samples_sample_terms_id=file_set_samples_sample_terms_id,
            file_set_samples_sample_terms_term_name=file_set_samples_sample_terms_term_name,
            file_set_samples_summary=file_set_samples_summary,
            file_set_samples_taxa=file_set_samples_taxa,
            file_set_summary=file_set_summary,
            file_set_taxa=file_set_taxa,
            file_size=file_size,
            gene_list_for=gene_list_for,
            href=href,
            input_file_for=input_file_for,
            integrated_in_id=integrated_in_id,
            integrated_in_associated_phenotypes_id=integrated_in_associated_phenotypes_id,
            integrated_in_associated_phenotypes_summary=integrated_in_associated_phenotypes_summary,
            integrated_in_associated_phenotypes_term_name=integrated_in_associated_phenotypes_term_name,
            integrated_in_file_set_type=integrated_in_file_set_type,
            integrated_in_small_scale_gene_list_id=integrated_in_small_scale_gene_list_id,
            integrated_in_small_scale_gene_list_symbol=integrated_in_small_scale_gene_list_symbol,
            integrated_in_summary=integrated_in_summary,
            lab_id=lab_id,
            lab_title=lab_title,
            loci_list_for=loci_list_for,
            md5sum=md5sum,
            notes=notes,
            release_timestamp=release_timestamp,
            revoke_detail=revoke_detail,
            s3_uri=s3_uri,
            status=status,
            submitted_by_id=submitted_by_id,
            submitted_by_title=submitted_by_title,
            submitted_file_name=submitted_file_name,
            submitter_comment=submitter_comment,
            summary=summary,
            transcriptome_annotation=transcriptome_annotation,
            upload_status=upload_status,
            uuid=uuid,
            validation_error_detail=validation_error_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenomeBrowserAnnotationFileResults",
            '400': "object",
            '404': "NoResultsResponse",
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_browser_annotation_files_without_preload_content(
        self,
        query: Annotated[Optional[StrictStr], Field(description="Query string for searching.")] = None,
        limit: Annotated[Optional[Any], Field(description="Maximum number of results to return. Default is 25. Use 'all' for all results.")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Fields to sort results by. Prefix with '-' for descending order. Can be repeated for multiple sort fields. Does not work with limit=all.")] = None,
        id: Annotated[Optional[List[StrictStr]], Field(description="Filter by @id")] = None,
        accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by accession")] = None,
        aliases: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by aliases")] = None,
        alternate_accessions: Annotated[Optional[List[StrictStr]], Field(description="Filter by alternate_accessions")] = None,
        analysis_step_version: Annotated[Optional[List[StrictStr]], Field(description="Filter by analysis_step_version")] = None,
        assay_titles: Annotated[Optional[List[StrictStr]], Field(description="Filter by assay_titles")] = None,
        assembly: Annotated[Optional[List[StrictStr]], Field(description="Filter by assembly")] = None,
        award_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.@id")] = None,
        award_component: Annotated[Optional[List[StrictStr]], Field(description="Filter by award.component")] = None,
        cell_type_annotation_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by cell_type_annotation.@id")] = None,
        cell_type_annotation_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by cell_type_annotation.term_name")] = None,
        collections: Annotated[Optional[List[StrictStr]], Field(description="Filter by collections")] = None,
        content_md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by content_md5sum")] = None,
        content_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by content_type")] = None,
        creation_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by creation_timestamp")] = None,
        dbxrefs: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by dbxrefs")] = None,
        derived_from: Annotated[Optional[List[StrictStr]], Field(description="Filter by derived_from")] = None,
        description: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by description")] = None,
        documents: Annotated[Optional[List[StrictStr]], Field(description="Filter by documents")] = None,
        file_format: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format")] = None,
        file_format_specifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_specifications")] = None,
        file_format_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_format_type")] = None,
        file_set_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.@id")] = None,
        file_set_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.accession")] = None,
        file_set_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.file_set_type")] = None,
        file_set_samples_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.@id")] = None,
        file_set_samples_accession: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.accession")] = None,
        file_set_samples_classifications: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.classifications")] = None,
        file_set_samples_disease_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.@id")] = None,
        file_set_samples_disease_terms_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.disease_terms.summary")] = None,
        file_set_samples_disease_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.disease_terms.term_name")] = None,
        file_set_samples_sample_terms_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.sample_terms.@id")] = None,
        file_set_samples_sample_terms_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by file_set.samples.sample_terms.term_name")] = None,
        file_set_samples_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.summary")] = None,
        file_set_samples_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.samples.taxa")] = None,
        file_set_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.summary")] = None,
        file_set_taxa: Annotated[Optional[List[StrictStr]], Field(description="Filter by file_set.taxa")] = None,
        file_size: Annotated[Optional[List[Annotated[int, Field(strict=True, ge=0)]]], Field(description="Filter by file_size")] = None,
        gene_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by gene_list_for")] = None,
        href: Annotated[Optional[List[StrictStr]], Field(description="Filter by href")] = None,
        input_file_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by input_file_for")] = None,
        integrated_in_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.@id")] = None,
        integrated_in_associated_phenotypes_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.@id")] = None,
        integrated_in_associated_phenotypes_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.associated_phenotypes.summary")] = None,
        integrated_in_associated_phenotypes_term_name: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by integrated_in.associated_phenotypes.term_name")] = None,
        integrated_in_file_set_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.file_set_type")] = None,
        integrated_in_small_scale_gene_list_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.@id")] = None,
        integrated_in_small_scale_gene_list_symbol: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.small_scale_gene_list.symbol")] = None,
        integrated_in_summary: Annotated[Optional[List[StrictStr]], Field(description="Filter by integrated_in.summary")] = None,
        lab_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.@id")] = None,
        lab_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by lab.title")] = None,
        loci_list_for: Annotated[Optional[List[StrictStr]], Field(description="Filter by loci_list_for")] = None,
        md5sum: Annotated[Optional[List[Annotated[str, Field(strict=True, max_length=32)]]], Field(description="Filter by md5sum")] = None,
        notes: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by notes")] = None,
        release_timestamp: Annotated[Optional[List[StrictStr]], Field(description="Filter by release_timestamp")] = None,
        revoke_detail: Annotated[Optional[List[Annotated[str, Field(strict=True)]]], Field(description="Filter by revoke_detail")] = None,
        s3_uri: Annotated[Optional[List[StrictStr]], Field(description="Filter by s3_uri")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter by status")] = None,
        submitted_by_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.@id")] = None,
        submitted_by_title: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_by.title")] = None,
        submitted_file_name: Annotated[Optional[List[StrictStr]], Field(description="Filter by submitted_file_name")] = None,
        submitter_comment: Annotated[Optional[List[Annotated[