from enum import Enum

class WebhookSource(Enum):
    MS_TEAMS = "MS_TEAMS"
    NOT_DEFINED = "NOT_DEFINED"

class SQAuthUserType(Enum):
    USER = "USER"
    API = "API"
    INTERNAL = "INTERNAL"

class StepType(Enum):
    WORKER = "WORKER"
    HTTP = "HTTP"
    WAIT = "WAIT"
    FAIL = "FAIL"
    PYTHON = "PYTHON"
    JAVASCRIPT = "JAVASCRIPT"
    JQ = "JQ"
    MANAGED = "MANAGED"
    BUILTIN = "BUILTIN"
    NOOP = "NOOP"
    PERSISTED_STATE = "PERSISTED_STATE"
    DEPENDSON = "DEPENDSON"
    INTEGRATION = "INTEGRATION"
    EXIT = "EXIT"
    SUB_PROCESS = "SUB_PROCESS"
    LIST = "LIST"
    PARALLEL = "PARALLEL"
    FOREACH = "FOREACH"
    SWITCH = "SWITCH"
    SCHEDULER = "SCHEDULER"
    PROCESS_TRACKER = "PROCESS_TRACKER"

class StepStatus(Enum):
    PENDING = "PENDING"
    SCHEDULED = "SCHEDULED"
    RUNNING = "RUNNING"
    PAUSED = "PAUSED"
    COMPLETED = "COMPLETED"
    FAILED = "FAILED"
    TIMED_OUT = "TIMED_OUT"
    SKIPPED = "SKIPPED"
    CANCELLED = "CANCELLED"

class ProcessStatus(Enum):
    RUNNING = "RUNNING"
    COMPLETED = "COMPLETED"
    FAILED = "FAILED"
    TIMED_OUT = "TIMED_OUT"
    CANCELLED = "CANCELLED"
    TERMINATED = "TERMINATED"
    REVIEWED = "REVIEWED"

class ProcessTriggerType(Enum):
    MANUAL = "MANUAL"
    SCHEDULED = "SCHEDULED"
    API_MAPPING = "API_MAPPING"
    WEBHOOK = "WEBHOOK"
    API = "API"
    SUB_PROCESS = "SUB_PROCESS"

class ProcessType(Enum):
    STANDARD = "STANDARD"
    DYNAMIC = "DYNAMIC"
    API_ORCHESTRATION = "API_ORCHESTRATION"
    INTERNAL = "INTERNAL"
