<img src="./docs/Geochemistry π.png" width="50%"/>

Geochemistry π is **a Python framework** for data-driven geochemistry discovery. It provides an extendable tool and
one-stop shop for **geochemical data analysis** on tabular data. The goal of the Geochemistry π is to create
a series of user-friendly and extensible products of high automation for the full cycle of geochemistry research.  

## First Phase
It works as a **software application** with a command-line interface (CLI) to automate **data mining** process with
frequently-used **machine learning algorithms**, which would further lower the threshold for the geochemists.

The highlight is that through choosing **simple number options**, the users are able to implement a completed cycle of data
mining **without knowledge of** SciPy, NumPy, Pandas, Scikit-learn, FLAML, Ray packages.

Its models section, shown as below, provides both **supervised learning** and **unsupervised learning** methods to process the
users' data, including four types of algorithms, regression, classification, clustering, and dimensional reduction.

The activity diagram of the Geochemistry π Version 1.0.0:

<img src="./docs/Geochemistryπ-Activity%20Diagram_v1.png" />

The whole package is under construction and the documentation is progressively evolving. 



## Team Info
**Leader:**
+ Can He (Sany, National University of Singapore, Singapore)    
  Email: sanyhew1097618435@163.com

**Core Developers:**
+ Yang Lyu (Daisy, Zhejiang University, China)
+ Jianming Zhao (Jamie, Jilin University, Changchun, China)
+ Jianhao Sun (Jin, China University of Geosciences，Wuhan, China)
+ Shengxin Wang (Samson, Lanzhou University, China)

**Members**:
+ Wenyu Zhao (Molly, Zhejiang University, China)
+ Fang Li (liv, Shenzhen University, China)
+ Ting Liu (Kira, Sun Yat-sen University, China)
+ Kaixin Zheng (Hayne, Sun Yat-sen University, China)
+ Aixiwake·Janganuer (Ayshuak, Sun Yat-sen University, China)
+ Parnanjan Dutta (Presidency University, Kolkata, India)
+ Bailun Jiang (EPSI / Lille University, France)
+ Yongkang Chang (Kill-virus, Langzhou University, China)
+ Xirui Zhu (Rae, University of York, United Kingdom)

## Join Us :)
**The recruitment of research interns is ongoing !!!**

**Key Point: All things are done online, remote work (\*^▽^\*)**

**What can you learn?**
+ Learning the full cycle of data mining on geochemistry data, including the algorithms in regression,
classification, clustering, and decomposition.
+ Learning to be a qualified Python developer, including any Python programing contents towards data mining,
basic software engineering techniques like OOP developing, and cooperation tools like Git.

**What can you get?**  

+ Research internship proof and reference letter after working for > 100 hours.
+ Chance to pay a visit to Hangzhou, China, sponsored by ZJU Earth Data.
+ Chance to be guided by the experts from IT companies in Silicon Valley and Hangzhou.
+ Bonus depending on your performance. 

**Current Working Pattern:**
+ Online working and cooperation
+ Three weeks per working cycle -> One online meeting per working cycle

Even if you are not familiar with topics above, but if you are interested in and have plenty of time to do it.
That's enough. We have a full-developed training system to help you, as a newbie of data mining or Python developer,
learn steps by steps with seniors until you can make a significant contribution to our project.

**More details about the project?**  
Please refer to:   
English Page: https://person.zju.edu.cn/en/zhangzhou  
Chinese Page: https://person.zju.edu.cn/zhangzhou#0  

**Do you want to contribute to this open-source program?**   
Contact with your CV: sanyhew1097618435@163.com  



## In-house Videos
Technical record videos are on Bilibili and Youtube synchronously while other meeting videos are internal materials.
1. [ZJU_Earth_Data Introduction (Geochemical Data, Python, Geochemistry π) - Prof. Zhang](https://www.bilibili.com/video/BV1Lf4y1w7EK?spm_id_from=333.999.0.0)
2. [How to Collaborate and Provide Bug Report on Geochemistry π Through GitHub - Can He (Sany)](https://www.youtube.com/watch?v=1DWoEsqsfvQ&list=PLy8hNsI55lvh1UHjhVhqNUj3xPdV9sEiM&index=3)
3. [How to Run Geochemistry π v1.0.0-alpha - Can He (Sany)](https://www.bilibili.com/video/BV1i541117dd?spm_id_from=333.999.0.0)
4. [How to Create and Use Virtual Environment on Geochemistry π - Can He (Sany)](https://www.youtube.com/watch?v=4KFi7OXxD-c&list=PLy8hNsI55lvh1UHjhVhqNUj3xPdV9sEiM&index=4)
5. [How to use Github-Desktop in conflict resolution - Qiuhao Zhao (Brad)](https://www.youtube.com/watch?v=KT1g5JpuUVI&list=PLy8hNsI55lvh1UHjhVhqNUj3xPdV9sEiM)
6. [Virtual Environment & Packages On Windows - Jianming Zhao (Jamie)](https://www.youtube.com/watch?v=e4VqSBuNp_o&list=PLy8hNsI55lvh1UHjhVhqNUj3xPdV9sEiM&index=2)
7. [Git Workflow & Coordinating Synchronization - Jianming Zhao (Jamie)](https://www.bilibili.com/video/BV1Sa4y1f74k?spm_id_from=333.999.0.0&vd_source=9adcf2c5fdeffe1d11c89d441ef598ba)


## Contributors
+ Qiuhao Zhao (Brad, Zhejiang University, China)
+ Anzhou Li (Andrian, Zhejiang University, China) 
+ Xunxin Liu (Tante, China University of Geosciences, Wuhan, China)
+ Xin Li (The University of Manchester, United Kingdom)