# Structures

App for managing Eve Online structures with Alliance Auth.

[![release](https://img.shields.io/pypi/v/aa-structures?label=release)](https://pypi.org/project/aa-structures/)
[![python](https://img.shields.io/pypi/pyversions/aa-structures)](https://pypi.org/project/aa-structures/)
[![django](https://img.shields.io/pypi/djversions/aa-structures?label=django)](https://pypi.org/project/aa-structures/)
[![pipeline](https://gitlab.com/ErikKalkoken/aa-structures/badges/master/pipeline.svg)](https://gitlab.com/ErikKalkoken/aa-structures/-/pipelines)
[![codecov](https://codecov.io/gl/ErikKalkoken/aa-structures/branch/master/graph/badge.svg?token=wq6yixsYRE)](https://codecov.io/gl/ErikKalkoken/aa-structures)
[![Documentation Status](https://readthedocs.org/projects/aa-structures/badge/?version=latest)](https://aa-structures.readthedocs.io/en/latest/?badge=latest)
[![license](https://img.shields.io/badge/license-MIT-green)](https://gitlab.com/ErikKalkoken/aa-structures/-/blob/master/LICENSE)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![chat](https://img.shields.io/discord/790364535294132234)](https://discord.gg/zmh52wnfvM)

## Contents

- [Overview](#overview)
- [Features](#features)
- [Screenshots](#screenshots)
- [Documentation](https://aa-structures.readthedocs.io/en/latest/)
- [Change Log](CHANGELOG.md)

## Overview

This app is for managing Eve Online structures with [Alliance Auth](https://gitlab.com/allianceauth/allianceauth). It allows all member corporations to see a current list of all their structures in Auth. In addition it allows forwarding Eve Online notifications to Discord.

For details on how to install and use *Structures* please see the [documentation](https://aa-structures.readthedocs.io/en/latest/).

## Features

Structures adds the following main features to Alliance Auth:

- Structure browser with a detailed list of all structures owned by member corporations, automatically synced with the game server
- Structures include all Upwell structures, Custom Offices and Starbases / POSes
- Automatically forwards Eve Online notifications to Discord channels as alerts for these categories:
  - Upwell structures
  - Customs offices
  - Starbases
  - Moon mining
  - Sovereignty
  - Wars
  - Corporation membership changes
- Automatically adds timers from relevant notifications to [Alliance Auth Structure Timers](https://allianceauth.readthedocs.io/en/v2.8.1/features/apps/timerboard.html) or [Structure Timers II](https://gitlab.com/ErikKalkoken/aa-structuretimers) app (if installed)
- Fittings, contents of Upwell structures (e.g. fuel blocks and ammo) and current fuel usage
- Additional structure notifications generated by the app:
  - Configurable alerts to warn about fuel running at in structures and POSes, and which can replace the ESI notifications
  - Notifications to inform when structures have been refueled (BETA)
  - Configurable alerts to warn about jump fuel (liquid ozone) running low in jump gates
  - POS reinforced (BETA)
- Tax rates and access settings of Customs Offices
- Permissions define which structures are visible to a user based on organization membership
- Self-defined tags help to better organize structures
- Ability to increase notification response time and sync resilence with multiple sync characters per structure owner
- Automatically sends alerts to users and admin when token become invalid or sync from ESI fails
- Interface for 3rd party monitoring of the services status
- Chinese :cn:, English :us: and German :de: localization

Please also check out [Discord Notify](https://gitlab.com/ErikKalkoken/aa-discordnotify) that will automatically forward auth notifications to the respective users on Discord.

## Screenshots

Here is an example for the main list of structures:

![StructureList](https://i.imgur.com/m676Y0T.png)

You can also see the fittings and contents of upwell structures:
![Poco details](https://i.imgur.com/qSC5uql.png)

The tax rate and access configuration of customs offices is visible too:
![Poco details](https://i.imgur.com/5XXDCsQ.png)

This is an example for a notification posted on Discord:

![Notification example](https://i.imgur.com/oqBqeFy.png)
