import { ComparisonOperator, FilteringOption, FilteringProperty, GroupText, I18nStrings, JoinOperation, ParsedText, Query, Token } from './interfaces';
import { NonCancelableEventHandler } from '../internal/events';
import { AutosuggestInputRef } from '../internal/components/autosuggest-input';
export declare const getQueryActions: (query: Query, onChange: NonCancelableEventHandler<Query>, inputRef: React.RefObject<AutosuggestInputRef>) => {
    setToken: (index: number, newToken: Token) => void;
    removeToken: (index: number) => void;
    removeAllTokens: () => void;
    addToken: (newToken: Token) => void;
    setOperation: (newOperation: JoinOperation) => void;
};
export declare const getAllowedOperators: (property: FilteringProperty) => ComparisonOperator[];
export declare const parseText: (filteringText: string, filteringProperties: readonly import("./interfaces").PropertyFilterProps.FilteringProperty[] | undefined, disableFreeTextFiltering: boolean) => ParsedText;
export declare const getPropertyOptions: (filteringProperty: FilteringProperty, filteringOptions: readonly FilteringOption[]) => import("@cloudscape-design/collection-hooks").PropertyFilterOption[];
interface OptionGroup<T> {
    label: string;
    options: T[];
}
export declare const getAllValueSuggestions: (filteringOptions: readonly FilteringOption[], filteringProperties: readonly FilteringProperty[], operator: ComparisonOperator | undefined, i18nStrings: I18nStrings, customGroupsText: readonly GroupText[]) => OptionGroup<import("../internal/components/option/interfaces").OptionDefinition>[];
export declare const getPropertyByKey: (filteringProperties: readonly FilteringProperty[], key: string) => import("./interfaces").PropertyFilterProps.FilteringProperty | undefined;
export declare function getExtendedOperator(filteringProperties: readonly FilteringProperty[], property: string, operator: ComparisonOperator): import("@cloudscape-design/collection-hooks").PropertyFilterOperatorExtended<any> | null;
export declare function createPropertiesCompatibilityMap(filteringProperties: readonly FilteringProperty[]): (propertyA: string, propertyB: string) => boolean;
export declare function getPropertySuggestions<T>(filteringProperties: readonly FilteringProperty[], customGroupsText: readonly GroupText[], i18nStrings: I18nStrings, filteringPropertyToOption: (filteringProperty: FilteringProperty) => T): OptionGroup<T>[];
export declare const getAutosuggestOptions: (parsedText: ParsedText, filteringOptions: readonly FilteringOption[], filteringProperties: readonly FilteringProperty[], customGroupsText: readonly GroupText[], i18nStrings: I18nStrings) => {
    filterText: string;
    options: {
        options: {
            value: string;
            label: string;
            __labelPrefix: string;
        }[];
        label: string;
    }[];
} | {
    filterText: string;
    options: (OptionGroup<{
        value: string;
        label: string;
        keepOpenOnSelect: boolean;
    }> | {
        options: {
            value: string;
            label: string;
            description: string | undefined;
            keepOpenOnSelect: boolean;
        }[];
        label: string | undefined;
    })[];
} | {
    filterText: string;
    options: (OptionGroup<import("../internal/components/option/interfaces").OptionDefinition> | OptionGroup<{
        value: string;
        label: string;
        keepOpenOnSelect: boolean;
    }>)[];
};
export declare const operatorToDescription: (operator: ComparisonOperator, i18nStrings: I18nStrings) => string | undefined;
export {};
//# sourceMappingURL=controller.d.ts.map