# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from onfido.models.workflow_run_error import WorkflowRunError
from onfido.models.workflow_run_link import WorkflowRunLink
from typing import Optional, Set
from typing_extensions import Self

class WebhookEventPayloadResource(BaseModel):
    """
    The resource affected by this event.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The identifier of the resource.")
    applicant_id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the Applicant.")
    created_at: Optional[datetime] = Field(default=None, description="The date and time when the resource was created.")
    updated_at: Optional[datetime] = Field(default=None, description="The date and time when the resource was last updated.")
    dashboard_url: Optional[StrictStr] = Field(default=None, description="The URL for viewing the resource on Onfido Dashboard.")
    workflow_id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the Workflow.")
    workflow_run_id: Optional[StrictStr] = None
    workflow_version_id: Optional[StrictInt] = Field(default=None, description="The identifier for the Workflow version.")
    task_def_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The identifier for the Task Definition.")
    task_def_version: Optional[StrictStr] = Field(default=None, description="The task definition version.")
    input: Optional[Dict[str, Any]] = Field(default=None, description="Input object with the fields used by the Task execution.")
    output: Any = Field(default=None, description="Value field (it can be an Object, List, etc.) with the fields produced by the Task execution.")
    reasons: Optional[List[StrictStr]] = Field(default=None, description="The reasons the Workflow Run outcome was reached. Configurable when creating the Workflow Version.")
    link: Optional[WorkflowRunLink] = Field(default=None, description="Object for the configuration of the Workflow Run link.")
    error: Optional[WorkflowRunError] = Field(default=None, description="Error object that details why a Workflow Run is in Error status.")
    customer_user_id: Optional[Annotated[str, Field(strict=True, max_length=256)]] = Field(default=None, description="Customer-provided user identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "applicant_id", "created_at", "updated_at", "dashboard_url", "workflow_id", "workflow_run_id", "workflow_version_id", "task_def_id", "task_def_version", "input", "output", "reasons", "link", "error", "customer_user_id"]

    @field_validator('task_def_id')
    def task_def_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9a-z_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-z_-]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookEventPayloadResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of link
        if self.link:
            _dict['link'] = self.link.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if task_def_version (nullable) is None
        # and model_fields_set contains the field
        if self.task_def_version is None and "task_def_version" in self.model_fields_set:
            _dict['task_def_version'] = None

        # set to None if output (nullable) is None
        # and model_fields_set contains the field
        if self.output is None and "output" in self.model_fields_set:
            _dict['output'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookEventPayloadResource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "applicant_id": obj.get("applicant_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "dashboard_url": obj.get("dashboard_url"),
            "workflow_id": obj.get("workflow_id"),
            "workflow_run_id": obj.get("workflow_run_id"),
            "workflow_version_id": obj.get("workflow_version_id"),
            "task_def_id": obj.get("task_def_id"),
            "task_def_version": obj.get("task_def_version"),
            "input": obj.get("input"),
            "output": obj.get("output"),
            "reasons": obj.get("reasons"),
            "link": WorkflowRunLink.from_dict(obj["link"]) if obj.get("link") is not None else None,
            "error": WorkflowRunError.from_dict(obj["error"]) if obj.get("error") is not None else None,
            "customer_user_id": obj.get("customer_user_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


