# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.watchlist_enhanced_properties_records_inner_address_inner import WatchlistEnhancedPropertiesRecordsInnerAddressInner
from onfido.models.watchlist_enhanced_properties_records_inner_alias_inner import WatchlistEnhancedPropertiesRecordsInnerAliasInner
from onfido.models.watchlist_enhanced_properties_records_inner_associate_inner import WatchlistEnhancedPropertiesRecordsInnerAssociateInner
from onfido.models.watchlist_enhanced_properties_records_inner_attribute_inner import WatchlistEnhancedPropertiesRecordsInnerAttributeInner
from onfido.models.watchlist_enhanced_properties_records_inner_event_inner import WatchlistEnhancedPropertiesRecordsInnerEventInner
from onfido.models.watchlist_enhanced_properties_records_inner_source_inner import WatchlistEnhancedPropertiesRecordsInnerSourceInner
from typing import Optional, Set
from typing_extensions import Self

class WatchlistEnhancedPropertiesRecordsInner(BaseModel):
    """
    WatchlistEnhancedPropertiesRecordsInner
    """ # noqa: E501
    address: Optional[List[WatchlistEnhancedPropertiesRecordsInnerAddressInner]] = Field(default=None, description="All addresses on file.")
    alias: Optional[List[WatchlistEnhancedPropertiesRecordsInnerAliasInner]] = Field(default=None, description="Any names that the person is also known as.")
    associate: Optional[List[WatchlistEnhancedPropertiesRecordsInnerAssociateInner]] = Field(default=None, description="Any linked persons, for example family relatives or business partners.")
    attribute: Optional[List[WatchlistEnhancedPropertiesRecordsInnerAttributeInner]] = Field(default=None, description="Information about the person, for example hair color or nationality.")
    date_of_birth: Optional[List[StrictStr]] = Field(default=None, description="All the date of births on file.")
    event: Optional[List[WatchlistEnhancedPropertiesRecordsInnerEventInner]] = Field(default=None, description="Information about events that have occurred to the person, for example deportation or arrest.")
    full_name: Optional[StrictStr] = Field(default=None, description="The name on file")
    position: Optional[List[StrictStr]] = Field(default=None, description="The role, country and date of each position.")
    source: Optional[List[WatchlistEnhancedPropertiesRecordsInnerSourceInner]] = Field(default=None, description="Details about where the information was obtained.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["address", "alias", "associate", "attribute", "date_of_birth", "event", "full_name", "position", "source"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WatchlistEnhancedPropertiesRecordsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in address (list)
        _items = []
        if self.address:
            for _item_address in self.address:
                if _item_address:
                    _items.append(_item_address.to_dict())
            _dict['address'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in alias (list)
        _items = []
        if self.alias:
            for _item_alias in self.alias:
                if _item_alias:
                    _items.append(_item_alias.to_dict())
            _dict['alias'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in associate (list)
        _items = []
        if self.associate:
            for _item_associate in self.associate:
                if _item_associate:
                    _items.append(_item_associate.to_dict())
            _dict['associate'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attribute (list)
        _items = []
        if self.attribute:
            for _item_attribute in self.attribute:
                if _item_attribute:
                    _items.append(_item_attribute.to_dict())
            _dict['attribute'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in event (list)
        _items = []
        if self.event:
            for _item_event in self.event:
                if _item_event:
                    _items.append(_item_event.to_dict())
            _dict['event'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in source (list)
        _items = []
        if self.source:
            for _item_source in self.source:
                if _item_source:
                    _items.append(_item_source.to_dict())
            _dict['source'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WatchlistEnhancedPropertiesRecordsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": [WatchlistEnhancedPropertiesRecordsInnerAddressInner.from_dict(_item) for _item in obj["address"]] if obj.get("address") is not None else None,
            "alias": [WatchlistEnhancedPropertiesRecordsInnerAliasInner.from_dict(_item) for _item in obj["alias"]] if obj.get("alias") is not None else None,
            "associate": [WatchlistEnhancedPropertiesRecordsInnerAssociateInner.from_dict(_item) for _item in obj["associate"]] if obj.get("associate") is not None else None,
            "attribute": [WatchlistEnhancedPropertiesRecordsInnerAttributeInner.from_dict(_item) for _item in obj["attribute"]] if obj.get("attribute") is not None else None,
            "date_of_birth": obj.get("date_of_birth"),
            "event": [WatchlistEnhancedPropertiesRecordsInnerEventInner.from_dict(_item) for _item in obj["event"]] if obj.get("event") is not None else None,
            "full_name": obj.get("full_name"),
            "position": obj.get("position"),
            "source": [WatchlistEnhancedPropertiesRecordsInnerSourceInner.from_dict(_item) for _item in obj["source"]] if obj.get("source") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


