# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from onfido.models.device_intelligence_report import DeviceIntelligenceReport
from onfido.models.document_report import DocumentReport
from onfido.models.document_video_report import DocumentVideoReport
from onfido.models.document_video_with_address_information_report import DocumentVideoWithAddressInformationReport
from onfido.models.document_with_address_information_report import DocumentWithAddressInformationReport
from onfido.models.document_with_driver_verification_report import DocumentWithDriverVerificationReport
from onfido.models.document_with_driving_licence_information_report import DocumentWithDrivingLicenceInformationReport
from onfido.models.facial_similarity_motion_report import FacialSimilarityMotionReport
from onfido.models.facial_similarity_photo_fully_auto_report import FacialSimilarityPhotoFullyAutoReport
from onfido.models.facial_similarity_photo_report import FacialSimilarityPhotoReport
from onfido.models.facial_similarity_video_report import FacialSimilarityVideoReport
from onfido.models.identity_enhanced_report import IdentityEnhancedReport
from onfido.models.india_pan_report import IndiaPanReport
from onfido.models.known_faces_report import KnownFacesReport
from onfido.models.proof_of_address_report import ProofOfAddressReport
from onfido.models.us_driving_licence_report import UsDrivingLicenceReport
from onfido.models.watchlist_aml_report import WatchlistAmlReport
from onfido.models.watchlist_enhanced_report import WatchlistEnhancedReport
from onfido.models.watchlist_peps_only_report import WatchlistPepsOnlyReport
from onfido.models.watchlist_sanctions_only_report import WatchlistSanctionsOnlyReport
from onfido.models.watchlist_standard_report import WatchlistStandardReport
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

REPORT_ONE_OF_SCHEMAS = ["DeviceIntelligenceReport", "DocumentReport", "DocumentVideoReport", "DocumentVideoWithAddressInformationReport", "DocumentWithAddressInformationReport", "DocumentWithDriverVerificationReport", "DocumentWithDrivingLicenceInformationReport", "FacialSimilarityMotionReport", "FacialSimilarityPhotoFullyAutoReport", "FacialSimilarityPhotoReport", "FacialSimilarityVideoReport", "IdentityEnhancedReport", "IndiaPanReport", "KnownFacesReport", "ProofOfAddressReport", "UsDrivingLicenceReport", "WatchlistAmlReport", "WatchlistEnhancedReport", "WatchlistPepsOnlyReport", "WatchlistSanctionsOnlyReport", "WatchlistStandardReport"]

class Report(BaseModel):
    """
    Report
    """
    # data type: DocumentReport
    oneof_schema_1_validator: Optional[DocumentReport] = None
    # data type: DocumentVideoReport
    oneof_schema_2_validator: Optional[DocumentVideoReport] = None
    # data type: DocumentVideoWithAddressInformationReport
    oneof_schema_3_validator: Optional[DocumentVideoWithAddressInformationReport] = None
    # data type: DocumentWithAddressInformationReport
    oneof_schema_4_validator: Optional[DocumentWithAddressInformationReport] = None
    # data type: DocumentWithDrivingLicenceInformationReport
    oneof_schema_5_validator: Optional[DocumentWithDrivingLicenceInformationReport] = None
    # data type: DocumentWithDriverVerificationReport
    oneof_schema_6_validator: Optional[DocumentWithDriverVerificationReport] = None
    # data type: FacialSimilarityPhotoReport
    oneof_schema_7_validator: Optional[FacialSimilarityPhotoReport] = None
    # data type: FacialSimilarityPhotoFullyAutoReport
    oneof_schema_8_validator: Optional[FacialSimilarityPhotoFullyAutoReport] = None
    # data type: FacialSimilarityVideoReport
    oneof_schema_9_validator: Optional[FacialSimilarityVideoReport] = None
    # data type: FacialSimilarityMotionReport
    oneof_schema_10_validator: Optional[FacialSimilarityMotionReport] = None
    # data type: KnownFacesReport
    oneof_schema_11_validator: Optional[KnownFacesReport] = None
    # data type: IdentityEnhancedReport
    oneof_schema_12_validator: Optional[IdentityEnhancedReport] = None
    # data type: WatchlistAmlReport
    oneof_schema_13_validator: Optional[WatchlistAmlReport] = None
    # data type: WatchlistEnhancedReport
    oneof_schema_14_validator: Optional[WatchlistEnhancedReport] = None
    # data type: WatchlistStandardReport
    oneof_schema_15_validator: Optional[WatchlistStandardReport] = None
    # data type: WatchlistPepsOnlyReport
    oneof_schema_16_validator: Optional[WatchlistPepsOnlyReport] = None
    # data type: WatchlistSanctionsOnlyReport
    oneof_schema_17_validator: Optional[WatchlistSanctionsOnlyReport] = None
    # data type: ProofOfAddressReport
    oneof_schema_18_validator: Optional[ProofOfAddressReport] = None
    # data type: UsDrivingLicenceReport
    oneof_schema_19_validator: Optional[UsDrivingLicenceReport] = None
    # data type: DeviceIntelligenceReport
    oneof_schema_20_validator: Optional[DeviceIntelligenceReport] = None
    # data type: IndiaPanReport
    oneof_schema_21_validator: Optional[IndiaPanReport] = None
    actual_instance: Optional[Union[DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport]] = None
    one_of_schemas: Set[str] = { "DeviceIntelligenceReport", "DocumentReport", "DocumentVideoReport", "DocumentVideoWithAddressInformationReport", "DocumentWithAddressInformationReport", "DocumentWithDriverVerificationReport", "DocumentWithDrivingLicenceInformationReport", "FacialSimilarityMotionReport", "FacialSimilarityPhotoFullyAutoReport", "FacialSimilarityPhotoReport", "FacialSimilarityVideoReport", "IdentityEnhancedReport", "IndiaPanReport", "KnownFacesReport", "ProofOfAddressReport", "UsDrivingLicenceReport", "WatchlistAmlReport", "WatchlistEnhancedReport", "WatchlistPepsOnlyReport", "WatchlistSanctionsOnlyReport", "WatchlistStandardReport" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Report.model_construct()
        error_messages = []
        match = 0
        # validate data type: DocumentReport
        if not isinstance(v, DocumentReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentReport`")
        else:
            match += 1
        # validate data type: DocumentVideoReport
        if not isinstance(v, DocumentVideoReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentVideoReport`")
        else:
            match += 1
        # validate data type: DocumentVideoWithAddressInformationReport
        if not isinstance(v, DocumentVideoWithAddressInformationReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentVideoWithAddressInformationReport`")
        else:
            match += 1
        # validate data type: DocumentWithAddressInformationReport
        if not isinstance(v, DocumentWithAddressInformationReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentWithAddressInformationReport`")
        else:
            match += 1
        # validate data type: DocumentWithDrivingLicenceInformationReport
        if not isinstance(v, DocumentWithDrivingLicenceInformationReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentWithDrivingLicenceInformationReport`")
        else:
            match += 1
        # validate data type: DocumentWithDriverVerificationReport
        if not isinstance(v, DocumentWithDriverVerificationReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DocumentWithDriverVerificationReport`")
        else:
            match += 1
        # validate data type: FacialSimilarityPhotoReport
        if not isinstance(v, FacialSimilarityPhotoReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FacialSimilarityPhotoReport`")
        else:
            match += 1
        # validate data type: FacialSimilarityPhotoFullyAutoReport
        if not isinstance(v, FacialSimilarityPhotoFullyAutoReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FacialSimilarityPhotoFullyAutoReport`")
        else:
            match += 1
        # validate data type: FacialSimilarityVideoReport
        if not isinstance(v, FacialSimilarityVideoReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FacialSimilarityVideoReport`")
        else:
            match += 1
        # validate data type: FacialSimilarityMotionReport
        if not isinstance(v, FacialSimilarityMotionReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FacialSimilarityMotionReport`")
        else:
            match += 1
        # validate data type: KnownFacesReport
        if not isinstance(v, KnownFacesReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `KnownFacesReport`")
        else:
            match += 1
        # validate data type: IdentityEnhancedReport
        if not isinstance(v, IdentityEnhancedReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IdentityEnhancedReport`")
        else:
            match += 1
        # validate data type: WatchlistAmlReport
        if not isinstance(v, WatchlistAmlReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WatchlistAmlReport`")
        else:
            match += 1
        # validate data type: WatchlistEnhancedReport
        if not isinstance(v, WatchlistEnhancedReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WatchlistEnhancedReport`")
        else:
            match += 1
        # validate data type: WatchlistStandardReport
        if not isinstance(v, WatchlistStandardReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WatchlistStandardReport`")
        else:
            match += 1
        # validate data type: WatchlistPepsOnlyReport
        if not isinstance(v, WatchlistPepsOnlyReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WatchlistPepsOnlyReport`")
        else:
            match += 1
        # validate data type: WatchlistSanctionsOnlyReport
        if not isinstance(v, WatchlistSanctionsOnlyReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WatchlistSanctionsOnlyReport`")
        else:
            match += 1
        # validate data type: ProofOfAddressReport
        if not isinstance(v, ProofOfAddressReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProofOfAddressReport`")
        else:
            match += 1
        # validate data type: UsDrivingLicenceReport
        if not isinstance(v, UsDrivingLicenceReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UsDrivingLicenceReport`")
        else:
            match += 1
        # validate data type: DeviceIntelligenceReport
        if not isinstance(v, DeviceIntelligenceReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DeviceIntelligenceReport`")
        else:
            match += 1
        # validate data type: IndiaPanReport
        if not isinstance(v, IndiaPanReport):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IndiaPanReport`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Report with oneOf schemas: DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Report with oneOf schemas: DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("name")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `name` in the input.")

        # check if data type is `DeviceIntelligenceReport`
        if _data_type == "device_intelligence":
            instance.actual_instance = DeviceIntelligenceReport.from_json(json_str)
            return instance

        # check if data type is `DocumentReport`
        if _data_type == "document":
            instance.actual_instance = DocumentReport.from_json(json_str)
            return instance

        # check if data type is `DocumentVideoReport`
        if _data_type == "document_video":
            instance.actual_instance = DocumentVideoReport.from_json(json_str)
            return instance

        # check if data type is `DocumentVideoWithAddressInformationReport`
        if _data_type == "document_video_with_address_information":
            instance.actual_instance = DocumentVideoWithAddressInformationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithAddressInformationReport`
        if _data_type == "document_with_address_information":
            instance.actual_instance = DocumentWithAddressInformationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithDriverVerificationReport`
        if _data_type == "document_with_driver_verification":
            instance.actual_instance = DocumentWithDriverVerificationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithDrivingLicenceInformationReport`
        if _data_type == "document_with_driving_licence_information":
            instance.actual_instance = DocumentWithDrivingLicenceInformationReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityMotionReport`
        if _data_type == "facial_similarity_motion":
            instance.actual_instance = FacialSimilarityMotionReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityPhotoReport`
        if _data_type == "facial_similarity_photo":
            instance.actual_instance = FacialSimilarityPhotoReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityPhotoFullyAutoReport`
        if _data_type == "facial_similarity_photo_fully_auto":
            instance.actual_instance = FacialSimilarityPhotoFullyAutoReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityVideoReport`
        if _data_type == "facial_similarity_video":
            instance.actual_instance = FacialSimilarityVideoReport.from_json(json_str)
            return instance

        # check if data type is `IdentityEnhancedReport`
        if _data_type == "identity_enhanced":
            instance.actual_instance = IdentityEnhancedReport.from_json(json_str)
            return instance

        # check if data type is `IndiaPanReport`
        if _data_type == "india_pan":
            instance.actual_instance = IndiaPanReport.from_json(json_str)
            return instance

        # check if data type is `KnownFacesReport`
        if _data_type == "known_faces":
            instance.actual_instance = KnownFacesReport.from_json(json_str)
            return instance

        # check if data type is `ProofOfAddressReport`
        if _data_type == "proof_of_address":
            instance.actual_instance = ProofOfAddressReport.from_json(json_str)
            return instance

        # check if data type is `UsDrivingLicenceReport`
        if _data_type == "us_driving_licence":
            instance.actual_instance = UsDrivingLicenceReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistAmlReport`
        if _data_type == "watchlist_aml":
            instance.actual_instance = WatchlistAmlReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistEnhancedReport`
        if _data_type == "watchlist_enhanced":
            instance.actual_instance = WatchlistEnhancedReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistPepsOnlyReport`
        if _data_type == "watchlist_peps_only":
            instance.actual_instance = WatchlistPepsOnlyReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistSanctionsOnlyReport`
        if _data_type == "watchlist_sanctions_only":
            instance.actual_instance = WatchlistSanctionsOnlyReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistStandardReport`
        if _data_type == "watchlist_standard":
            instance.actual_instance = WatchlistStandardReport.from_json(json_str)
            return instance

        # check if data type is `DeviceIntelligenceReport`
        if _data_type == "device_intelligence_report":
            instance.actual_instance = DeviceIntelligenceReport.from_json(json_str)
            return instance

        # check if data type is `DocumentReport`
        if _data_type == "document_report":
            instance.actual_instance = DocumentReport.from_json(json_str)
            return instance

        # check if data type is `DocumentVideoReport`
        if _data_type == "document_video_report":
            instance.actual_instance = DocumentVideoReport.from_json(json_str)
            return instance

        # check if data type is `DocumentVideoWithAddressInformationReport`
        if _data_type == "document_video_with_address_information_report":
            instance.actual_instance = DocumentVideoWithAddressInformationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithAddressInformationReport`
        if _data_type == "document_with_address_information_report":
            instance.actual_instance = DocumentWithAddressInformationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithDriverVerificationReport`
        if _data_type == "document_with_driver_verification_report":
            instance.actual_instance = DocumentWithDriverVerificationReport.from_json(json_str)
            return instance

        # check if data type is `DocumentWithDrivingLicenceInformationReport`
        if _data_type == "document_with_driving_licence_information_report":
            instance.actual_instance = DocumentWithDrivingLicenceInformationReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityMotionReport`
        if _data_type == "facial_similarity_motion_report":
            instance.actual_instance = FacialSimilarityMotionReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityPhotoFullyAutoReport`
        if _data_type == "facial_similarity_photo_fully_auto_report":
            instance.actual_instance = FacialSimilarityPhotoFullyAutoReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityPhotoReport`
        if _data_type == "facial_similarity_photo_report":
            instance.actual_instance = FacialSimilarityPhotoReport.from_json(json_str)
            return instance

        # check if data type is `FacialSimilarityVideoReport`
        if _data_type == "facial_similarity_video_report":
            instance.actual_instance = FacialSimilarityVideoReport.from_json(json_str)
            return instance

        # check if data type is `IdentityEnhancedReport`
        if _data_type == "identity_enhanced_report":
            instance.actual_instance = IdentityEnhancedReport.from_json(json_str)
            return instance

        # check if data type is `IndiaPanReport`
        if _data_type == "india_pan_report":
            instance.actual_instance = IndiaPanReport.from_json(json_str)
            return instance

        # check if data type is `KnownFacesReport`
        if _data_type == "known_faces_report":
            instance.actual_instance = KnownFacesReport.from_json(json_str)
            return instance

        # check if data type is `ProofOfAddressReport`
        if _data_type == "proof_of_address_report":
            instance.actual_instance = ProofOfAddressReport.from_json(json_str)
            return instance

        # check if data type is `UsDrivingLicenceReport`
        if _data_type == "us_driving_licence_report":
            instance.actual_instance = UsDrivingLicenceReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistAmlReport`
        if _data_type == "watchlist_aml_report":
            instance.actual_instance = WatchlistAmlReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistEnhancedReport`
        if _data_type == "watchlist_enhanced_report":
            instance.actual_instance = WatchlistEnhancedReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistPepsOnlyReport`
        if _data_type == "watchlist_peps_only_report":
            instance.actual_instance = WatchlistPepsOnlyReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistSanctionsOnlyReport`
        if _data_type == "watchlist_sanctions_only_report":
            instance.actual_instance = WatchlistSanctionsOnlyReport.from_json(json_str)
            return instance

        # check if data type is `WatchlistStandardReport`
        if _data_type == "watchlist_standard_report":
            instance.actual_instance = WatchlistStandardReport.from_json(json_str)
            return instance

        # deserialize data into DocumentReport
        try:
            instance.actual_instance = DocumentReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocumentVideoReport
        try:
            instance.actual_instance = DocumentVideoReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocumentVideoWithAddressInformationReport
        try:
            instance.actual_instance = DocumentVideoWithAddressInformationReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocumentWithAddressInformationReport
        try:
            instance.actual_instance = DocumentWithAddressInformationReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocumentWithDrivingLicenceInformationReport
        try:
            instance.actual_instance = DocumentWithDrivingLicenceInformationReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DocumentWithDriverVerificationReport
        try:
            instance.actual_instance = DocumentWithDriverVerificationReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FacialSimilarityPhotoReport
        try:
            instance.actual_instance = FacialSimilarityPhotoReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FacialSimilarityPhotoFullyAutoReport
        try:
            instance.actual_instance = FacialSimilarityPhotoFullyAutoReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FacialSimilarityVideoReport
        try:
            instance.actual_instance = FacialSimilarityVideoReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FacialSimilarityMotionReport
        try:
            instance.actual_instance = FacialSimilarityMotionReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into KnownFacesReport
        try:
            instance.actual_instance = KnownFacesReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IdentityEnhancedReport
        try:
            instance.actual_instance = IdentityEnhancedReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WatchlistAmlReport
        try:
            instance.actual_instance = WatchlistAmlReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WatchlistEnhancedReport
        try:
            instance.actual_instance = WatchlistEnhancedReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WatchlistStandardReport
        try:
            instance.actual_instance = WatchlistStandardReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WatchlistPepsOnlyReport
        try:
            instance.actual_instance = WatchlistPepsOnlyReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WatchlistSanctionsOnlyReport
        try:
            instance.actual_instance = WatchlistSanctionsOnlyReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProofOfAddressReport
        try:
            instance.actual_instance = ProofOfAddressReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into UsDrivingLicenceReport
        try:
            instance.actual_instance = UsDrivingLicenceReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DeviceIntelligenceReport
        try:
            instance.actual_instance = DeviceIntelligenceReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IndiaPanReport
        try:
            instance.actual_instance = IndiaPanReport.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Report with oneOf schemas: DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Report with oneOf schemas: DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DeviceIntelligenceReport, DocumentReport, DocumentVideoReport, DocumentVideoWithAddressInformationReport, DocumentWithAddressInformationReport, DocumentWithDriverVerificationReport, DocumentWithDrivingLicenceInformationReport, FacialSimilarityMotionReport, FacialSimilarityPhotoFullyAutoReport, FacialSimilarityPhotoReport, FacialSimilarityVideoReport, IdentityEnhancedReport, IndiaPanReport, KnownFacesReport, ProofOfAddressReport, UsDrivingLicenceReport, WatchlistAmlReport, WatchlistEnhancedReport, WatchlistPepsOnlyReport, WatchlistSanctionsOnlyReport, WatchlistStandardReport]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


