# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DocumentPropertiesExtractedData(BaseModel):
    """
    DocumentPropertiesExtractedData
    """ # noqa: E501
    document_number: Optional[StrictStr] = None
    date_of_birth: Optional[date] = None
    date_of_expiry: Optional[date] = None
    first_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    middle_name: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = None
    spouse_name: Optional[StrictStr] = None
    widow_name: Optional[StrictStr] = None
    alias_name: Optional[StrictStr] = None
    gender: Optional[StrictStr] = None
    mrz_line1: Optional[StrictStr] = None
    mrz_line2: Optional[StrictStr] = None
    mrz_line3: Optional[StrictStr] = None
    nationality: Optional[StrictStr] = None
    address_line_1: Optional[StrictStr] = None
    address_line_2: Optional[StrictStr] = None
    address_line_3: Optional[StrictStr] = None
    address_line_4: Optional[StrictStr] = None
    address_line_5: Optional[StrictStr] = None
    issuing_authority: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["document_number", "date_of_birth", "date_of_expiry", "first_name", "last_name", "middle_name", "full_name", "spouse_name", "widow_name", "alias_name", "gender", "mrz_line1", "mrz_line2", "mrz_line3", "nationality", "address_line_1", "address_line_2", "address_line_3", "address_line_4", "address_line_5", "issuing_authority"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentPropertiesExtractedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentPropertiesExtractedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_number": obj.get("document_number"),
            "date_of_birth": obj.get("date_of_birth"),
            "date_of_expiry": obj.get("date_of_expiry"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "middle_name": obj.get("middle_name"),
            "full_name": obj.get("full_name"),
            "spouse_name": obj.get("spouse_name"),
            "widow_name": obj.get("widow_name"),
            "alias_name": obj.get("alias_name"),
            "gender": obj.get("gender"),
            "mrz_line1": obj.get("mrz_line1"),
            "mrz_line2": obj.get("mrz_line2"),
            "mrz_line3": obj.get("mrz_line3"),
            "nationality": obj.get("nationality"),
            "address_line_1": obj.get("address_line_1"),
            "address_line_2": obj.get("address_line_2"),
            "address_line_3": obj.get("address_line_3"),
            "address_line_4": obj.get("address_line_4"),
            "address_line_5": obj.get("address_line_5"),
            "issuing_authority": obj.get("issuing_authority")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


