/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.script.MoonLightParseError;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.MoonLightType;
import eu.quanticol.moonlight.script.TypeEnvironment;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class TypeChecker
extends MoonLightScriptBaseVisitor<MoonLightType> {
    private final boolean isSpatial;
    private final List<MoonLightParseError> errors;
    private final TypeEnvironment typeEnvironment;
    private final EvaluationContext evaluationContext;

    public static MoonLightType inferType(List<MoonLightParseError> errors, TypeEnvironment typeEnvironment, MoonLightScriptParser.ExpressionContext value) {
        TypeChecker tc = new TypeChecker(errors, typeEnvironment, EvaluationContext.NONE, false);
        return (MoonLightType)value.accept(tc);
    }

    public static boolean checkType(List<MoonLightParseError> errors, TypeEnvironment typeEnvironment, MoonLightType expected, MoonLightScriptParser.ExpressionContext value) {
        TypeChecker tc = new TypeChecker(errors, typeEnvironment, EvaluationContext.NONE, false);
        return tc.checkType(expected, value);
    }

    public TypeChecker(List<MoonLightParseError> errors, TypeEnvironment typeEnvironment, EvaluationContext evaluationContext, boolean isSpatial) {
        this.errors = errors;
        this.evaluationContext = evaluationContext;
        this.typeEnvironment = typeEnvironment;
        this.isSpatial = isSpatial;
    }

    @Override
    public MoonLightType visitBinaryMathCallExpression(MoonLightScriptParser.BinaryMathCallExpressionContext ctx) {
        this.checkReal(ctx);
        this.checkReal(ctx);
        return MoonLightType.REAL;
    }

    public void checkReal(ParserRuleContext ctx) {
        this.checkType(MoonLightType.REAL, ctx);
    }

    public void checkBoolean(ParserRuleContext ctx) {
        this.checkType(MoonLightType.BOOLEAN, ctx);
    }

    public boolean checkType(MoonLightType expected, ParserRuleContext ctx) {
        MoonLightType type = (MoonLightType)ctx.accept((ParseTreeVisitor)this);
        if (!expected.isCompatible(type)) {
            this.errors.add(MoonLightParseError.getTypeError(expected, type, ctx));
            return false;
        }
        return true;
    }

    public MoonLightType infer(MoonLightScriptParser.ExpressionContext value) {
        return (MoonLightType)value.accept(this);
    }

    @Override
    public MoonLightType visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        this.checkBoolean(ctx.left);
        this.checkBoolean(ctx.right);
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        this.checkBoolean(ctx.arg);
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        MoonLightType leftType = (MoonLightType)ctx.left.accept(this);
        MoonLightType rightType = (MoonLightType)ctx.right.accept(this);
        if (!leftType.canBeComparedWith(ctx.op.getText(), rightType)) {
            this.errors.add(MoonLightParseError.illegalComparison(leftType, rightType, ctx));
        }
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitOnceExpression(MoonLightScriptParser.OnceExpressionContext ctx) {
        return this.checkUnaryTemporalFormula(ctx, ctx.interval(), ctx.argument);
    }

    private MoonLightType checkUnaryTemporalFormula(ParserRuleContext parent, MoonLightScriptParser.IntervalContext interval, MoonLightScriptParser.ExpressionContext argument) {
        if (this.evaluationContext != EvaluationContext.STATE) {
            this.errors.add(MoonLightParseError.illegalUseOfTemporalOperators(parent));
        } else {
            this.checkBoolean(argument);
            this.checkTimeInterval(interval);
        }
        return MoonLightType.BOOLEAN;
    }

    private MoonLightType checkUnarySpatialFormula(ParserRuleContext parent, MoonLightScriptParser.IntervalContext interval, MoonLightScriptParser.ExpressionContext distance, MoonLightScriptParser.ExpressionContext argument) {
        if (!this.isSpatial) {
            this.errors.add(MoonLightParseError.spaceFormulasInTemporalMonitors(parent));
        } else if (this.evaluationContext != EvaluationContext.STATE) {
            this.errors.add(MoonLightParseError.illegalUseOfTemporalOperators(parent));
        } else {
            this.checkBoolean(argument);
            this.checkSpaceInterval(interval);
            this.checkDistance(distance);
        }
        return MoonLightType.BOOLEAN;
    }

    private void checkDistance(MoonLightScriptParser.ExpressionContext distance) {
        if (distance != null) {
            TypeChecker tc = new TypeChecker(this.errors, this.typeEnvironment, EvaluationContext.EDGE, this.isSpatial);
            tc.checkReal(distance);
        }
    }

    private MoonLightType checkBinaryTemporalFormula(ParserRuleContext parent, MoonLightScriptParser.IntervalContext interval, MoonLightScriptParser.ExpressionContext left, MoonLightScriptParser.ExpressionContext right) {
        if (this.evaluationContext != EvaluationContext.STATE) {
            this.errors.add(MoonLightParseError.illegalUseOfTemporalOperators(parent));
        } else {
            this.checkBoolean(left);
            this.checkBoolean(right);
            this.checkTimeInterval(interval);
        }
        return MoonLightType.BOOLEAN;
    }

    private MoonLightType checkBinarySpatialFormula(ParserRuleContext parent, MoonLightScriptParser.IntervalContext interval, MoonLightScriptParser.ExpressionContext distance, MoonLightScriptParser.ExpressionContext left, MoonLightScriptParser.ExpressionContext right) {
        if (!this.isSpatial) {
            this.errors.add(MoonLightParseError.spaceFormulasInTemporalMonitors(parent));
        } else if (this.evaluationContext != EvaluationContext.STATE) {
            this.errors.add(MoonLightParseError.illegalUseOfTemporalOperators(parent));
        } else {
            this.checkBoolean(left);
            this.checkBoolean(right);
            this.checkSpaceInterval(interval);
            this.checkDistance(distance);
        }
        return MoonLightType.BOOLEAN;
    }

    private void checkTimeInterval(MoonLightScriptParser.IntervalContext interval) {
        this.checkInterval(interval, false);
    }

    private void checkSpaceInterval(MoonLightScriptParser.IntervalContext interval) {
        this.checkInterval(interval, true);
    }

    private void checkInterval(MoonLightScriptParser.IntervalContext interval, boolean isSpatial) {
        if (interval != null) {
            TypeChecker tc = new TypeChecker(this.errors, this.typeEnvironment, EvaluationContext.INTERVAL, isSpatial);
            tc.checkReal(interval.from);
            tc.checkReal(interval.to);
        }
    }

    @Override
    public MoonLightType visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (MoonLightType)ctx.expression().accept(this);
    }

    @Override
    public MoonLightType visitUntilExpression(MoonLightScriptParser.UntilExpressionContext ctx) {
        return this.checkBinaryTemporalFormula(ctx, ctx.interval(), ctx.left, ctx.right);
    }

    @Override
    public MoonLightType visitEverywhereExpression(MoonLightScriptParser.EverywhereExpressionContext ctx) {
        return this.checkUnarySpatialFormula(ctx, ctx.interval(), ctx.distanceExpression, ctx.argument);
    }

    @Override
    public MoonLightType visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        this.checkBoolean(ctx.left);
        this.checkBoolean(ctx.right);
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitUnaryMathCallExpression(MoonLightScriptParser.UnaryMathCallExpressionContext ctx) {
        this.checkReal(ctx.argument);
        return MoonLightType.REAL;
    }

    @Override
    public MoonLightType visitNextExpression(MoonLightScriptParser.NextExpressionContext ctx) {
        return this.checkUnarySpatialFormula(ctx, null, ctx.distanceExpression, ctx.argument);
    }

    @Override
    public MoonLightType visitRealExpression(MoonLightScriptParser.RealExpressionContext ctx) {
        return MoonLightType.REAL;
    }

    @Override
    public MoonLightType visitUnaryExpression(MoonLightScriptParser.UnaryExpressionContext ctx) {
        return this.checkNumberType(ctx.arg);
    }

    private MoonLightType checkNumberType(MoonLightScriptParser.ExpressionContext arg) {
        MoonLightType argumentType = (MoonLightType)arg.accept(this);
        if (!argumentType.isANumber()) {
            this.errors.add(MoonLightParseError.numericalValueExpected(arg, argumentType));
            return MoonLightType.INT;
        }
        return argumentType;
    }

    @Override
    public MoonLightType visitSinceExpression(MoonLightScriptParser.SinceExpressionContext ctx) {
        return this.checkBinaryTemporalFormula(ctx, ctx.interval(), ctx.left, ctx.right);
    }

    @Override
    public MoonLightType visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        String name = ctx.name.getText();
        if (!this.typeEnvironment.exists(name)) {
            this.errors.add(MoonLightParseError.useOfAnUnknownName(name, ctx));
            return MoonLightType.NONE;
        }
        if (!this.typeEnvironment.isValidIn(name, this.evaluationContext)) {
            this.errors.add(MoonLightParseError.illegalUseOfSymbol(name, ctx));
        }
        this.checkArguments(ctx, this.typeEnvironment.getArguments(name), ctx.args);
        return this.typeEnvironment.getTypeOf(name);
    }

    private void checkArguments(MoonLightScriptParser.ExpressionContext parent, MoonLightType[] expected, List<MoonLightScriptParser.ExpressionContext> args) {
        MoonLightScriptParser.ExpressionContext[] actual = new MoonLightScriptParser.ExpressionContext[]{};
        if (args != null) {
            actual = args.toArray(actual);
        }
        if (expected.length != actual.length) {
            this.errors.add(MoonLightParseError.wrongNumberOfParameters(expected.length, actual.length, parent));
        } else {
            for (int i = 0; i < expected.length; ++i) {
                this.checkType(expected[i], actual[i]);
            }
        }
    }

    @Override
    public MoonLightType visitIntExpression(MoonLightScriptParser.IntExpressionContext ctx) {
        return MoonLightType.INT;
    }

    @Override
    public MoonLightType visitGloballyExpression(MoonLightScriptParser.GloballyExpressionContext ctx) {
        return this.checkUnaryTemporalFormula(ctx, ctx.interval(), ctx.argument);
    }

    @Override
    public MoonLightType visitReachExpression(MoonLightScriptParser.ReachExpressionContext ctx) {
        return this.checkBinarySpatialFormula(ctx, ctx.interval(), ctx.distanceExpression, ctx.left, ctx.right);
    }

    @Override
    public MoonLightType visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        this.checkBoolean(ctx.guard);
        MoonLightType thenType = (MoonLightType)ctx.thenExpression.accept(this);
        MoonLightType elseType = (MoonLightType)ctx.elseExpression.accept(this);
        if (thenType.isCompatible(elseType)) {
            return MoonLightType.mix(thenType, elseType);
        }
        this.errors.add(MoonLightParseError.getTypeError(thenType, elseType, ctx.elseExpression));
        return thenType;
    }

    @Override
    public MoonLightType visitOrExpression(MoonLightScriptParser.OrExpressionContext ctx) {
        this.checkBoolean(ctx.left);
        this.checkBoolean(ctx.right);
        return MoonLightType.BOOLEAN;
    }

    @Override
    public MoonLightType visitEscapeExpression(MoonLightScriptParser.EscapeExpressionContext ctx) {
        return this.checkUnarySpatialFormula(ctx, ctx.interval(), ctx.distanceExpression, ctx.argument);
    }

    @Override
    public MoonLightType visitSomewhereExpression(MoonLightScriptParser.SomewhereExpressionContext ctx) {
        return this.checkUnarySpatialFormula(ctx, ctx.interval(), ctx.distanceExpression, ctx.argument);
    }

    @Override
    public MoonLightType visitMulDivExpression(MoonLightScriptParser.MulDivExpressionContext ctx) {
        return this.checkBinaryArithmeticExpression(ctx.left, ctx.right);
    }

    private MoonLightType checkBinaryArithmeticExpression(MoonLightScriptParser.ExpressionContext left, MoonLightScriptParser.ExpressionContext right) {
        MoonLightType leftType = this.checkNumberType(left);
        MoonLightType rightType = this.checkNumberType(right);
        return MoonLightType.mix(leftType, rightType);
    }

    @Override
    public MoonLightType visitSumDifExpression(MoonLightScriptParser.SumDifExpressionContext ctx) {
        return this.checkBinaryArithmeticExpression(ctx.left, ctx.right);
    }

    @Override
    public MoonLightType visitHistoricallyExpression(MoonLightScriptParser.HistoricallyExpressionContext ctx) {
        return this.checkUnaryTemporalFormula(ctx, ctx.interval(), ctx.argument);
    }

    @Override
    public MoonLightType visitEventuallyExpression(MoonLightScriptParser.EventuallyExpressionContext ctx) {
        return this.checkUnaryTemporalFormula(ctx, ctx.interval(), ctx.argument);
    }

    @Override
    public MoonLightType visitInfinityExpression(MoonLightScriptParser.InfinityExpressionContext ctx) {
        return MoonLightType.REAL;
    }

    public static enum EvaluationContext {
        NONE,
        INTERVAL,
        EDGE,
        STATE;

    }
}

