/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import java.util.Objects;

public class MoonLightType {
    public static final int NONE_CODE = -1;
    public static final int BOOLEAN_CODE = 0;
    public static final int INT_CODE = 1;
    public static final int REAL_CODE = 2;
    public static final int CUSTOM_CODE = 3;
    public static final String NONE_VALUE = "none";
    public static final String BOOLEAN_VALUE = "boolean";
    public static final String INT_VALUE = "int";
    public static final String REAL_VALUE = "real";
    private final int code;
    private final String value;
    public static final MoonLightType NONE = new MoonLightType(-1, "none");
    public static final MoonLightType BOOLEAN = new MoonLightType(0, "boolean");
    public static final MoonLightType REAL = new MoonLightType(2, "real");
    public static final MoonLightType INT = new MoonLightType(1, "int");

    private MoonLightType(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public static MoonLightType typeOf(String value) {
        if (INT_VALUE.equals(value)) {
            return INT;
        }
        if (REAL_VALUE.equals(value)) {
            return REAL;
        }
        if ("bool".equals(value)) {
            return BOOLEAN;
        }
        return MoonLightType.customType(value);
    }

    public int getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoonLightType that = (MoonLightType)o;
        if (this.getCode() <= 3) {
            return this.getCode() == that.getCode();
        }
        return this.getCode() == that.getCode() && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getCode(), this.getValue());
    }

    public String toString() {
        return this.value;
    }

    public static MoonLightType customType(String name) {
        return new MoonLightType(3, name);
    }

    public boolean isNone() {
        return this.getCode() == -1;
    }

    public boolean isANumber() {
        return this.isInteger() || this.isReal();
    }

    public boolean isInteger() {
        return this.getCode() == 1;
    }

    public boolean isReal() {
        return this.getCode() == 2;
    }

    public boolean isBoolean() {
        return this.getCode() == 0;
    }

    public static MoonLightType mix(MoonLightType mType1, MoonLightType mType2) {
        if (mType1.equals(mType2)) {
            return mType1;
        }
        if (mType1.isANumber() && mType2.isANumber()) {
            return REAL;
        }
        return NONE;
    }

    public boolean isCompatible(MoonLightType type) {
        return this.equals(type) || this.isReal() && type.isANumber();
    }

    public boolean canBeComparedWith(String text, MoonLightType other) {
        if (!this.isANumber()) {
            if (text.equals("==")) {
                return this.equals(other);
            }
            return false;
        }
        return other.isANumber();
    }
}

