/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.script.ExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class BooleanExpressionEvaluator
extends MoonLightScriptBaseVisitor<Boolean> {
    private final ExpressionEvaluator expressionEvaluator;
    private static final Map<String, BiFunction<Double, Double, Boolean>> relationsMap = new HashMap<String, BiFunction<Double, Double, Boolean>>();

    public BooleanExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public boolean eval(MoonLightScriptParser.ExpressionContext expressionContext) {
        return (Boolean)expressionContext.accept(this);
    }

    @Override
    public Boolean visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        return (Boolean)ctx.left.accept(this) == false || (Boolean)ctx.right.accept(this) != false;
    }

    @Override
    public Boolean visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        return (Boolean)ctx.arg.accept(this) == false;
    }

    @Override
    public Boolean visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return false;
    }

    @Override
    public Boolean visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (Boolean)ctx.expression().accept(this);
    }

    @Override
    public Boolean visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        return (Boolean)ctx.left.accept(this) != false && (Boolean)ctx.right.accept(this) != false;
    }

    @Override
    public Boolean visitOrExpression(MoonLightScriptParser.OrExpressionContext ctx) {
        return (Boolean)ctx.left.accept(this) != false || (Boolean)ctx.right.accept(this) != false;
    }

    @Override
    public Boolean visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return true;
    }

    @Override
    public Boolean visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        if (((Boolean)ctx.guard.accept(this)).booleanValue()) {
            return (Boolean)ctx.thenExpression.accept(this);
        }
        return (Boolean)ctx.elseExpression.accept(this);
    }

    protected Boolean defaultResult() {
        return false;
    }

    @Override
    public Boolean visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        return relationsMap.get(ctx.op.getText()).apply((Double)ctx.left.accept(this.expressionEvaluator), (Double)ctx.right.accept(this.expressionEvaluator));
    }

    @Override
    public Boolean visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        return ctx.accept(this.expressionEvaluator) > 0.0;
    }

    static {
        relationsMap.put("<", (x, y) -> x < y);
        relationsMap.put("<=", (x, y) -> x <= y);
        relationsMap.put("=<", (x, y) -> x <= y);
        relationsMap.put("==", Double::equals);
        relationsMap.put(">", (x, y) -> x > y);
        relationsMap.put(">=", (x, y) -> x >= y);
        relationsMap.put("=>", (x, y) -> x >= y);
    }
}

