/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.script.BiParametricExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class BiParametricBooleanExpressionEvaluator
extends MoonLightScriptBaseVisitor<BiFunction<MoonLightRecord, MoonLightRecord, Boolean>> {
    private final BiParametricExpressionEvaluator biParametricExpressionEvaluator;
    private static final Map<String, BiFunction<Double, Double, Boolean>> relationsMap = new HashMap<String, BiFunction<Double, Double, Boolean>>();

    public BiParametricBooleanExpressionEvaluator(BiParametricExpressionEvaluator biParametricExpressionEvaluator) {
        this.biParametricExpressionEvaluator = biParametricExpressionEvaluator;
    }

    public boolean eval(MoonLightScriptParser.ExpressionContext guard) {
        return false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        BiFunction left = (BiFunction)ctx.left.accept(this);
        BiFunction right = (BiFunction)ctx.right.accept(this);
        return (r, s) -> (Boolean)left.apply(r, s) == false || (Boolean)right.apply(r, s) != false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        BiFunction arg = (BiFunction)ctx.arg.accept(this);
        return (r, s) -> (Boolean)arg.apply(r, s) == false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return (r, s) -> false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (BiFunction)ctx.expression().accept(this);
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        BiFunction left = (BiFunction)ctx.left.accept(this);
        BiFunction right = (BiFunction)ctx.right.accept(this);
        return (r, s) -> (Boolean)left.apply(r, s) != false && (Boolean)right.apply(r, s) != false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitOrExpression(MoonLightScriptParser.OrExpressionContext ctx) {
        BiFunction left = (BiFunction)ctx.left.accept(this);
        BiFunction right = (BiFunction)ctx.right.accept(this);
        return (r, s) -> (Boolean)left.apply(r, s) != false || (Boolean)right.apply(r, s) != false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return (r, s) -> true;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        BiFunction guard = (BiFunction)ctx.guard.accept(this);
        BiFunction thenBranch = (BiFunction)ctx.thenExpression.accept(this);
        BiFunction elseBranch = (BiFunction)ctx.elseExpression.accept(this);
        return (r, s) -> (Boolean)guard.apply(r, s) != false ? (Boolean)thenBranch.apply(r, s) : (Boolean)elseBranch.apply(r, s);
    }

    protected BiFunction<MoonLightRecord, MoonLightRecord, Boolean> defaultResult() {
        return (r, s) -> false;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        BiFunction left = (BiFunction)ctx.left.accept(this.biParametricExpressionEvaluator);
        BiFunction right = (BiFunction)ctx.right.accept(this.biParametricExpressionEvaluator);
        BiFunction<Double, Double, Boolean> op = relationsMap.get(ctx.op.getText());
        return (r, s) -> (Boolean)op.apply((Double)left.apply(r, s), (Double)right.apply(r, s));
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Boolean> visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        BiFunction<MoonLightRecord, MoonLightRecord, Double> arg = ctx.accept(this.biParametricExpressionEvaluator);
        return (r, s) -> (Double)arg.apply((MoonLightRecord)r, (MoonLightRecord)s) > 0.0;
    }

    static {
        relationsMap.put("<", (x, y) -> x < y);
        relationsMap.put("<=", (x, y) -> x <= y);
        relationsMap.put("=<", (x, y) -> x <= y);
        relationsMap.put("==", Double::equals);
        relationsMap.put(">", (x, y) -> x > y);
        relationsMap.put(">=", (x, y) -> x >= y);
        relationsMap.put("=>", (x, y) -> x >= y);
    }
}

