/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.formula.temporal.HistoricallyFormula;
import eu.quanticol.moonlight.formula.temporal.OnceFormula;
import eu.quanticol.moonlight.formula.temporal.SinceFormula;
import eu.quanticol.moonlight.formula.temporal.UntilFormula;
import eu.quanticol.moonlight.io.FormulaType;
import java.util.Random;

public abstract class FormulaGenerator {
    private static final int DEFAULT_MAXSIZE = 10;
    private static final double EPS = 1.0E-6;
    private static final double DEFAULT_MAXTIME = 100.0;
    private final Random random;
    private String[] atomidId;
    private double maxTime;

    FormulaGenerator(Random random, double maxTime, String ... ids) {
        this.random = random;
        this.atomidId = ids;
        this.maxTime = maxTime;
    }

    FormulaGenerator(String ... ids) {
        this(new Random(), 100.0, ids);
    }

    public Formula getFormula() {
        return this.getFormula(this.random.nextInt(10), 100.0);
    }

    public Formula getFormula(int size) {
        return this.getFormula(size, this.maxTime);
    }

    private Formula getFormula(int size, double time) {
        if (size == 0 || time <= 0.0) {
            return this.getAtomicFormula();
        }
        return this.generateFormula(size, time);
    }

    private Formula getAtomicFormula() {
        return new AtomicFormula(this.atomidId[this.random.nextInt(this.atomidId.length)]);
    }

    private Formula generateFormula(int size, double time) {
        FormulaType[] types = this.getFormulaType();
        Interval interval = this.getInterval(false, time);
        double newTime = Math.max(0.0, time - (Double)interval.getEnd());
        switch (types[this.getRandom().nextInt(types.length)]) {
            case AND: {
                return new AndFormula(this.getFormula(size - 1, time), this.getFormula(size - 1, time));
            }
            case ATOMIC: {
                return this.getAtomicFormula();
            }
            case EVENTUALLY: {
                return new EventuallyFormula(this.getFormula(size - 1, newTime), interval);
            }
            case GLOBALLY: {
                return new GloballyFormula(this.getFormula(size - 1, newTime), interval);
            }
            case HISTORICALLY: {
                return new HistoricallyFormula(this.getFormula(size - 1, newTime), interval);
            }
            case NOT: {
                return new NegationFormula(this.getFormula(size - 1, time));
            }
            case ONCE: {
                return new OnceFormula(this.getFormula(size - 1, newTime), interval);
            }
            case OR: {
                return new OrFormula(this.getFormula(size - 1, time), this.getFormula(size - 1, time));
            }
            case SINCE: {
                return new SinceFormula(this.getFormula(size - 1, newTime), this.getFormula(size - 1, newTime), interval);
            }
            case UNTIL: {
                return new UntilFormula(this.getFormula(size - 1, newTime), this.getFormula(size - 1, newTime), interval);
            }
        }
        return null;
    }

    public abstract FormulaType[] getFormulaType();

    protected Interval getInterval(boolean isNullable, double time) {
        if (isNullable && this.random.nextBoolean()) {
            return null;
        }
        double start = this.random.nextDouble() * time;
        double end = start + this.random.nextDouble() * (time - start) + 1.0E-6;
        return new Interval(start, end);
    }

    private Random getRandom() {
        return this.random;
    }
}

