/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.Iterator;
import java.util.LinkedList;

public class LocationServiceList<V>
implements LocationService<Double, V> {
    private final LinkedList<Pair<Double, SpatialModel<V>>> steps = new LinkedList();
    private Pair<Double, SpatialModel<V>> last;

    public void add(double t, SpatialModel<V> m) {
        if (this.last != null && !(this.last.getFirst() < t)) {
            throw new IllegalArgumentException("Wrong time! Is " + t + " expexted >" + this.last.getFirst() + "!");
        }
        this.last = new Pair<Double, SpatialModel<V>>(t, m);
        this.steps.add(this.last);
    }

    @Override
    public SpatialModel<V> get(Double t) {
        Pair temp = null;
        for (Pair pair : this.steps) {
            if (temp != null && t < (Double)pair.getFirst()) {
                return (SpatialModel)temp.getSecond();
            }
            temp = pair;
        }
        return temp != null ? (SpatialModel)temp.getSecond() : null;
    }

    @Override
    public Iterator<Pair<Double, SpatialModel<V>>> times() {
        return this.steps.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.steps.isEmpty();
    }
}

