/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.SpatialOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSpaceTimeSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;

public class UnarySpaceOpMonitor<S, V, R extends Comparable<R>>
implements OnlineMonitor<Double, List<V>, List<Box<R>>> {
    private final OnlineMonitor<Double, List<V>, List<Box<R>>> argument;
    private final TimeSignal<Double, List<Box<R>>> rho;
    private final SpatialOp<Double, S, Box<R>> spatialOp;

    public UnarySpaceOpMonitor(OnlineMonitor<Double, List<V>, List<Box<R>>> argument, SpatialOp<Double, S, Box<R>> op, SignalDomain<R> domain, int size) {
        this.argument = argument;
        this.rho = new OnlineSpaceTimeSignal<R>(size, domain);
        this.spatialOp = op;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(Update<Double, List<V>> signalUpdate) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argument.monitor(signalUpdate);
        ArrayList<TimeChain<Double, List<Box<R>>>> updates = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> argU : argUpdates) {
            updates.add(this.spatialOp.computeUnaryChain(argU));
        }
        updates.forEach(this.rho::refine);
        return updates;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(TimeChain<Double, List<V>> updates) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argument.monitor(updates);
        ArrayList<TimeChain<Double, List<Box<R>>>> output = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> timeChain : argUpdates) {
            output.add(this.spatialOp.computeUnaryChain(timeChain));
        }
        for (TimeChain<Double, List<Box<Object>>> timeChain : output) {
            this.rho.refine(timeChain);
        }
        return output;
    }

    @Override
    public TimeSignal<Double, List<Box<R>>> getResult() {
        return this.rho;
    }
}

