/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.offline.signal.Segment;
import eu.quanticol.moonlight.offline.signal.SignalCursor;

public class OfflineSignalCursor<T>
implements SignalCursor<Double, T> {
    private final boolean forward;
    private final Segment<T> first;
    private final Segment<T> last;
    private Segment<T> current;
    private double time;
    private Segment<T> previous = null;

    public OfflineSignalCursor(boolean forward, Segment<T> first, Segment<T> last) {
        this.forward = forward;
        this.first = first;
        this.last = last;
        this.current = this.setCurrent();
        this.time = this.setTime();
    }

    private double setTime() {
        if (this.current != null) {
            if (this.forward) {
                return this.current.getStart();
            }
            return this.current.getSegmentEnd();
        }
        return Double.NaN;
    }

    private Segment<T> setCurrent() {
        return this.forward ? this.first : this.last;
    }

    @Override
    public Double getCurrentTime() {
        return this.time;
    }

    @Override
    public T getCurrentValue() {
        return this.current != null ? (T)this.current.getValue() : null;
    }

    @Override
    public void forward() {
        if (this.current != null) {
            this.previous = this.current;
            if (!this.current.isRightClosed() || this.current.doEndAt(this.time)) {
                this.current = this.current.getNext();
                this.time = this.current != null ? this.current.getStart() : Double.NaN;
            } else {
                this.time = this.current.getSegmentEnd();
            }
        }
    }

    @Override
    public void backward() {
        if (this.current != null) {
            this.previous = this.current;
            if (this.time > this.current.getStart()) {
                this.time = this.current.getStart();
            } else {
                this.current = this.current.getPrevious();
                this.time = this.current != null ? this.current.getStart() : Double.NaN;
            }
        }
    }

    @Override
    public void revert() {
        if (this.previous == null) {
            throw new UnsupportedOperationException("Nothing to revert");
        }
        this.current = this.previous;
    }

    @Override
    public void move(Double t) {
        if (this.current != null) {
            this.current = this.current.jump(t);
            this.time = t;
        }
    }

    @Override
    public Double nextTime() {
        if (this.current != null) {
            return this.current.nextTimeAfter(this.time);
        }
        return Double.NaN;
    }

    @Override
    public Double previousTime() {
        if (this.current != null) {
            if (this.current.getStart() < this.time) {
                return this.current.getStart();
            }
            return this.current.getPreviousTime();
        }
        return Double.NaN;
    }

    @Override
    public boolean hasNext() {
        return this.current != null && this.current.getNext() != null;
    }

    @Override
    public boolean hasPrevious() {
        return this.current != null && this.current.getPrevious() != null;
    }

    @Override
    public boolean isCompleted() {
        return this.current == null;
    }
}

