/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.algorithms.SpatialAlgorithms;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.algorithms.SpatialOp;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.Function;
import java.util.function.IntFunction;

public class SpatialTemporalMonitorSomewhere<S, T, R>
implements SpatialTemporalMonitor<S, T, R> {
    private final SpatialTemporalMonitor<S, T, R> m;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> distance;
    private final SignalDomain<R> domain;
    private final boolean parallel;

    public SpatialTemporalMonitorSomewhere(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain, boolean parallel) {
        this.m = m;
        this.distance = distance;
        this.domain = domain;
        this.parallel = parallel;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(LocationService<Double, S> locationService, SpatialTemporalSignal<T> signal) {
        SpatialOp<S, R> sp = new SpatialOp<S, R>(locationService, this.distance, this::somewhereOp);
        return sp.computeUnary(this.m.monitor(locationService, signal));
    }

    private IntFunction<R> somewhereOp(IntFunction<R> spatialSignal, DistanceStructure<S, ?> ds) {
        return new SpatialAlgorithms(ds, this.domain, this.parallel).somewhere(spatialSignal);
    }
}

