/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.algorithms.EscapeAlgorithm;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.algorithms.SpatialOp;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.Function;
import java.util.function.IntFunction;

public class SpatialTemporalMonitorEscape<S, T, R>
implements SpatialTemporalMonitor<S, T, R> {
    private final SpatialTemporalMonitor<S, T, R> m;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> distance;
    private final SignalDomain<R> domain;

    public SpatialTemporalMonitorEscape(SpatialTemporalMonitor<S, T, R> m, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain) {
        this.m = m;
        this.distance = distance;
        this.domain = domain;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(LocationService<Double, S> locationService, SpatialTemporalSignal<T> signal) {
        SpatialOp<S, R> sc = new SpatialOp<S, R>(locationService, this.distance, this::escapeOp);
        return sc.computeUnary(this.m.monitor(locationService, signal));
    }

    private IntFunction<R> escapeOp(IntFunction<R> spatialSignal, DistanceStructure<S, ?> ds) {
        return new EscapeAlgorithm(ds, this.domain, spatialSignal).compute();
    }
}

