/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.mfr;

import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitor;
import eu.quanticol.moonlight.offline.signal.STSignal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import eu.quanticol.moonlight.offline.signal.mfr.MfrSignal;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;

public class MfrMonitorBinary<S, T, R>
implements MfrMonitor<S, T, R> {
    private final BinaryOperator<R> operator;
    private final MfrMonitor<S, T, R> leftArg;
    private final MfrMonitor<S, T, R> rightArg;

    public MfrMonitorBinary(BinaryOperator<R> operator, MfrMonitor<S, T, R> leftArg, MfrMonitor<S, T, R> rightArg) {
        this.operator = operator;
        this.leftArg = leftArg;
        this.rightArg = rightArg;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(SpatialTemporalSignal<T> signal) {
        SpatialTemporalSignal<R> left = this.leftArg.monitor(signal);
        SpatialTemporalSignal<R> right = this.rightArg.monitor(signal);
        return left.apply(this.operator, right);
    }

    @Override
    public IntFunction<MfrSignal<R>> monitor(SpatialTemporalSignal<T> signal, IntFunction<int[]> locations) {
        IntFunction left = this.leftArg.monitor(signal, locations);
        IntFunction right = this.rightArg.monitor(signal, locations);
        return i -> ((MfrSignal)left.apply(i)).combine(this.operator, (STSignal)right.apply(i), (int[])locations.apply(i));
    }
}

