/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpaceIterator;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor1;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.mfr.MfrSignal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class ReduceOp<S, R, V> {
    private final Function<List<V>, R> aggregator;
    private final LocationService<Double, S> locSvc;
    private final Function<SpatialModel<S>, DistanceStructure<S, ?>> distance;
    private final int size;

    public ReduceOp(int size, LocationService<Double, S> locSvc, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, Function<List<V>, R> aggregator) {
        this.size = size;
        this.locSvc = locSvc;
        this.distance = distance;
        this.aggregator = aggregator;
    }

    public MfrSignal<R> computeUnary(int[] definitionSet, IntFunction<MfrSignal<V>> s) {
        if (!this.locSvc.isEmpty()) {
            return this.doCompute(s, definitionSet);
        }
        throw new UnsupportedOperationException("Invalid location service passed");
    }

    private MfrSignal<R> doCompute(IntFunction<MfrSignal<V>> setSignal, int[] definitionSet) {
        return new MfrSignal(this.size, i -> this.reduce((MfrSignal)setSignal.apply(i)), definitionSet);
    }

    private Signal<R> reduce(MfrSignal<V> arg) {
        ParallelSignalCursor1<V> cursor = arg.getSignalCursor(true);
        double t = cursor.getCurrentTime();
        Signal result = new Signal();
        SpaceIterator<Double, S> spaceItr = new SpaceIterator<Double, S>(this.locSvc, this.distance);
        spaceItr.init(t);
        while (!Double.isNaN(t) && ReduceOp.isNotCompleted(cursor)) {
            t = this.aggregateArg(arg, cursor, t, result, spaceItr);
        }
        return result;
    }

    private double aggregateArg(MfrSignal<V> arg, ParallelSignalCursor1<V> cursor, double t, Signal<R> result, SpaceIterator<Double, S> spaceItr) {
        IntFunction<V> spatialSignal = cursor.getCurrentValue();
        this.aggregate(t, arg, result, spatialSignal);
        double tNext = cursor.forwardTime();
        spaceItr.forEach(tNext, (itT, itDs) -> this.aggregate((Double)itT, arg, result, spatialSignal));
        t = this.moveSpatialModel(tNext, spaceItr);
        return t;
    }

    private void aggregate(Double t, MfrSignal<V> arg, Signal<R> result, IntFunction<V> spatialSignal) {
        List<V> values = this.locationStream(arg).mapToObj(spatialSignal).toList();
        R aggregated = this.aggregator.apply(values);
        result.add(t, aggregated);
    }

    private IntStream locationStream(MfrSignal<V> signal) {
        return Arrays.stream(signal.getLocationsSet());
    }

    private Double moveSpatialModel(@NotNull Double t, SpaceIterator<Double, S> spaceItr) {
        if (spaceItr.isNextSpaceModelAtSameTime(t)) {
            spaceItr.shiftSpatialModel();
        }
        return t;
    }

    @SafeVarargs
    private static <C> boolean isNotCompleted(ParallelSignalCursor1<C> ... cursors) {
        return Arrays.stream(cursors).map(c -> !c.isCompleted()).reduce(true, (c1, c2) -> c1 != false && c2 != false);
    }
}

