/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.io.AbstractFileByRowReader;
import eu.quanticol.moonlight.io.IllegalFileFormatException;
import eu.quanticol.moonlight.io.SpatialTemporalSignalReader;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CsvSpatialTemporalSignalReader
extends AbstractFileByRowReader
implements SpatialTemporalSignalReader {
    @Override
    public SpatialTemporalSignal<MoonLightRecord> load(RecordHandler handler, File input) throws IOException, IllegalFileFormatException {
        return this.load(handler, this.getRows(input));
    }

    @Override
    public SpatialTemporalSignal<MoonLightRecord> load(RecordHandler handler, String input) throws IllegalFileFormatException {
        return this.load(handler, this.getRows(input));
    }

    private SpatialTemporalSignal<MoonLightRecord> load(RecordHandler handler, List<AbstractFileByRowReader.Row> data) throws IllegalFileFormatException {
        int size = this.checkData(handler, data);
        Iterator<AbstractFileByRowReader.Row> dataIterator = data.iterator();
        dataIterator.next();
        SpatialTemporalSignal<MoonLightRecord> toReturn = new SpatialTemporalSignal<MoonLightRecord>(size);
        while (dataIterator.hasNext()) {
            AbstractFileByRowReader.Row row = dataIterator.next();
            row.addValueToSpatioTemporalSignal(size, handler, toReturn);
        }
        return toReturn;
    }

    private int checkData(RecordHandler handler, List<AbstractFileByRowReader.Row> data) throws IllegalFileFormatException {
        int size = 0;
        Iterator<AbstractFileByRowReader.Row> dataIterator = data.iterator();
        if (dataIterator.hasNext()) {
            size = this.parseSize(dataIterator.next());
        }
        int expected = 1 + size * handler.size();
        while (dataIterator.hasNext()) {
            AbstractFileByRowReader.Row row = dataIterator.next();
            row.split(";");
            if (row.elements.length != expected) {
                throw new IllegalFileFormatException(row.index, "Expected " + expected + " columns at row " + row.index + " are " + row.elements.length + "!");
            }
            if (!row.isDouble(0)) {
                throw new IllegalFileFormatException(row.index, "First element of each row must be a double!");
            }
            for (int i = 0; i < size; ++i) {
                int index = 1 + handler.size() * i;
                if (row.checkRecord(handler, index, index + handler.size())) continue;
                System.err.println("Line: " + row.getLine() + " " + i);
                throw new IllegalFileFormatException(row.index, "Input data error! (Line " + row.getLine() + "@" + i);
            }
        }
        return size;
    }

    private int parseSize(AbstractFileByRowReader.Row row) throws IllegalFileFormatException {
        if (row.getRow().startsWith("LOCATIONS")) {
            row.split(" ");
            if (row.elements.length != 2 || !row.isInteger(1)) {
                throw new IllegalFileFormatException(row.index, "LOCATIONS <num> is expected in the first line!");
            }
            return Integer.parseInt(row.get(1));
        }
        throw new IllegalFileFormatException(row.index, "Number of locations is expected in the first line!");
    }
}

