/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class DefaultDistanceStructure<E, M>
implements DistanceStructure<E, M> {
    private final Function<E, M> distanceFunction;
    private final DistanceDomain<M> distanceDomain;
    private final Map<Integer, Map<Integer, M>> distanceMatrix;
    private final M lowerBound;
    private final M upperBound;
    private final SpatialModel<E> model;

    public DefaultDistanceStructure(@NotNull Function<E, M> distanceFunction, @NotNull DistanceDomain<M> distanceDomain, @NotNull M lowerBound, @NotNull M upperBound, @NotNull SpatialModel<E> model) {
        this.distanceFunction = distanceFunction;
        this.distanceDomain = distanceDomain;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.model = model;
        this.distanceMatrix = this.computeDistanceMatrix();
    }

    @Override
    public SpatialModel<E> getModel() {
        return this.model;
    }

    @Override
    public Function<E, M> getDistanceFunction() {
        return this.distanceFunction;
    }

    @Override
    public DistanceDomain<M> getDistanceDomain() {
        return this.distanceDomain;
    }

    @Override
    public M getDistance(int i, int j) {
        Map<Integer, M> m = this.distanceMatrix.get(i);
        if (m != null) {
            return m.getOrDefault(j, this.distanceDomain.infinity());
        }
        return this.distanceDomain.infinity();
    }

    @Override
    public boolean areWithinBounds(int from, int to) {
        return this.isWithinBounds(this.getDistance(from, to));
    }

    @Override
    public boolean isWithinBounds(M d) {
        return this.distanceDomain.lessOrEqual(this.lowerBound, d) && this.distanceDomain.lessOrEqual(d, this.upperBound);
    }

    private Map<Integer, Map<Integer, M>> computeDistanceMatrix() {
        Map<Integer, Map<Integer, M>> distanceMap = this.distanceMapInit();
        LinkedList<Pair<Integer, Pair<Integer, M>>> queue = this.distanceQueueInit();
        while (!queue.isEmpty()) {
            Pair p = (Pair)queue.poll();
            int l1 = (Integer)p.getFirst();
            int l2 = (Integer)((Pair)p.getSecond()).getFirst();
            Object d1 = ((Pair)p.getSecond()).getSecond();
            this.computeDistances(distanceMap, queue, l1, l2, d1);
        }
        return distanceMap;
    }

    private void computeDistances(Map<Integer, Map<Integer, M>> distanceMap, Deque<Pair<Integer, Pair<Integer, M>>> queue, int l1, int l2, M d1) {
        for (Pair<Integer, E> edge : this.model.previous(l1)) {
            Map<Integer, M> distances;
            M oldD;
            M newD = this.increaseDistance(d1, edge);
            if (!this.distanceDomain.less(newD, oldD = (distances = distanceMap.get(edge.getFirst())).getOrDefault(l2, this.distanceDomain.infinity()))) continue;
            distances.put(l2, newD);
            queue.add(new Pair<Integer, Pair<Integer, M>>(edge.getFirst(), new Pair<Integer, M>(l2, newD)));
        }
    }

    private M increaseDistance(M d, Pair<Integer, E> edge) {
        return this.distanceDomain.sum(this.distanceFunction.apply(edge.getSecond()), d);
    }

    private LinkedList<Pair<Integer, Pair<Integer, M>>> distanceQueueInit() {
        return IntStream.range(0, this.model.size()).boxed().map(i -> new Pair<Integer, Pair<Integer, M>>((Integer)i, new Pair<Integer, M>((Integer)i, this.distanceDomain.zero()))).collect(Collectors.toCollection(LinkedList::new));
    }

    private Map<Integer, Map<Integer, M>> distanceMapInit() {
        HashMap<Integer, Map<Integer, M>> distanceMap = new HashMap<Integer, Map<Integer, M>>();
        IntStream.range(0, this.model.size()).forEach(location -> {
            HashMap<Integer, M> locationDistances = new HashMap<Integer, M>();
            locationDistances.put(location, this.distanceDomain.zero());
            distanceMap.put(location, locationDistances);
        });
        return distanceMap;
    }
}

