"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = __importDefault(require("axios"));
const d3 = __importStar(require("d3"));
const react_1 = __importStar(require("react"));
const Canvas_1 = __importDefault(require("./components/Canvas"));
const GlobalStyle_1 = require("./styles/GlobalStyle");
// const defdata = [
//   {
//     id: '.venv/share/jupyter',
//     value: 7964,
//   },
//   {
//     id: '.venv/asdf',
//     value: 1111,
//   },
//   {
//     id: '.venv/share',
//   },
//   {
//     id: '.venv',
//   },
// ]
// https://github.com/diego3g/electron-typescript-react/issues
const DATA_FILE = 'du.txt';
exports.App = () => {
    const [data, setData] = react_1.default.useState(null);
    const [err, setErr] = react_1.default.useState(null);
    react_1.useEffect(() => {
        const load = async () => {
            const resp = await axios_1.default.get(DATA_FILE);
            if (resp.status !== 200) {
                setErr(`Failed to get ${DATA_FILE} with status ${resp.status}`);
                return;
            }
            const text = resp.data;
            const d = d3.tsvParse(`value\tid\n${text}`);
            if (!d?.length || d.length < 2) {
                setErr(`failed to find tsv formatted data in ${DATA_FILE}`);
            }
            setData(d);
        };
        load();
    }, []);
    if (err) {
        return react_1.default.createElement(react_1.default.Fragment, null, err);
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(GlobalStyle_1.GlobalStyle, null),
        data && react_1.default.createElement(Canvas_1.default, { data: data })));
};
//# sourceMappingURL=App.js.map