from typing import Any, Dict, List, Mapping, Optional, Tuple

from botocore import utils as utils
from botocore.utils import IMDSRegionProvider

BOTOCORE_DEFAUT_SESSION_VARIABLES: Dict[str, Tuple[Any, ...]]
DEFAULT_S3_CONFIG_VARS: Dict[str, Tuple[Any, ...]]
DEFAULT_PROXIES_CONFIG_VARS: Dict[str, Tuple[Any, ...]]

def create_botocore_default_config_mapping(session: Any) -> Any: ...

class DefaultConfigResolver:
    def __init__(self, default_config_data: Mapping[str, Any]) -> None: ...
    def get_default_modes(self) -> List[str]: ...
    def get_default_config_values(self, mode: str) -> Any: ...

class ConfigChainFactory:
    def __init__(self, session: Any, environ: Optional[Any] = ...) -> None: ...
    def create_config_chain(
        self,
        instance_name: Optional[Any] = ...,
        env_var_names: Optional[Any] = ...,
        config_property_names: Optional[Any] = ...,
        default: Optional[Any] = ...,
        conversion_func: Optional[Any] = ...,
    ) -> Any: ...

class ConfigValueStore:
    def __init__(self, mapping: Optional[Any] = ...) -> None: ...
    def get_config_variable(self, logical_name: str) -> Any: ...
    def get_config_provider(self, logical_name: str) -> "BaseProvider": ...
    def set_config_variable(self, logical_name: str, value: Any) -> None: ...
    def clear_config_variable(self, logical_name: str) -> None: ...
    def set_config_provider(self, logical_name: str, provider: Any) -> None: ...

class SmartDefaultsConfigStoreFactory:
    def __init__(
        self,
        default_config_resolver: DefaultConfigResolver,
        imds_region_provider: IMDSRegionProvider,
    ) -> None: ...
    def merge_smart_defaults(
        self, config_store: ConfigValueStore, mode: str, region_name: str
    ) -> None: ...
    def resolve_auto_mode(self, region_name: str) -> str: ...

class BaseProvider:
    def provide(self) -> None: ...

class ChainProvider(BaseProvider):
    def __init__(
        self, providers: Optional[Any] = ..., conversion_func: Optional[Any] = ...
    ) -> None: ...
    def provide(self) -> Any: ...
    def set_default_provider(self, default_provider: BaseProvider) -> None: ...

class InstanceVarProvider(BaseProvider):
    def __init__(self, instance_var: Any, session: Any) -> None: ...
    def provide(self) -> Any: ...

class ScopedConfigProvider(BaseProvider):
    def __init__(self, config_var_name: Any, session: Any) -> None: ...
    def provide(self) -> Any: ...

class EnvironmentProvider(BaseProvider):
    def __init__(self, name: Any, env: Any) -> None: ...
    def provide(self) -> Any: ...

class SectionConfigProvider(BaseProvider):
    def __init__(
        self, section_name: Any, session: Any, override_providers: Optional[Any] = ...
    ) -> None: ...
    def provide(self) -> Any: ...
    def set_default_provider(self, key: str, default_provider: BaseProvider) -> None: ...

class ConstantProvider(BaseProvider):
    def __init__(self, value: Any) -> None: ...
    def provide(self) -> Any: ...
