# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import


class ApiException(Exception):

    def __init__(self, status=None, reason=None, http_resp=None):
        if http_resp:
            self.status = http_resp.status
            self.reason = http_resp.reason
            self.body = http_resp.data
            self.headers = http_resp.getheaders()
            self.trace_token = http_resp.getheader('X-DocuSign-TraceToken')
            self.timestamp = http_resp.getheader('date')
            self.response = http_resp
        else:
            self.status = status
            self.reason = reason
            self.body = None
            self.headers = None

    def __str__(self):
        """
        Custom error messages for exception
        """
        error_message = "({0})\n" \
                        "Reason: {1}\n" \
                        "Trace-Token: {2}\n" \
                        "Timestamp: {3}\n".format(self.status, self.reason, self.trace_token, self.timestamp)
        if self.headers:
            error_message += "HTTP response headers: {0}\n".format(self.headers)

        if self.body:
            error_message += "HTTP response body: {0}\n".format(self.body)

        return error_message


class ArgumentException(Exception):

    def __init__(self, *args, **kwargs):
        if not args:
            super(Exception).__init__("argument cannot be empty")
        else:
            super(Exception).__init__(*args, **kwargs)


class InvalidBasePath(Exception):
    pass
