# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class BulkEnvelopesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_bulk_send_list(self, account_id, **kwargs):
        """
        Creates a new bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_list(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param BulkSendingList bulk_sending_list:
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_send_list_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_bulk_send_list_with_http_info(account_id, **kwargs)
            return data

    def create_bulk_send_list_with_http_info(self, account_id, **kwargs):
        """
        Creates a new bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_list_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param BulkSendingList bulk_sending_list:
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_sending_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_send_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_send_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_sending_list' in params:
            body_params = params['bulk_sending_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendingList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_bulk_send_request(self, account_id, bulk_send_list_id, **kwargs):
        """
        Uses the specified bulk send list to send the envelope specified in the payload
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_request(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendRequest bulk_send_request:
        :return: BulkSendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_send_request_with_http_info(account_id, bulk_send_list_id, **kwargs)
        else:
            (data) = self.create_bulk_send_request_with_http_info(account_id, bulk_send_list_id, **kwargs)
            return data

    def create_bulk_send_request_with_http_info(self, account_id, bulk_send_list_id, **kwargs):
        """
        Uses the specified bulk send list to send the envelope specified in the payload
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_request_with_http_info(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendRequest bulk_send_request:
        :return: BulkSendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_list_id', 'bulk_send_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_send_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_send_request`")
        # verify the required parameter 'bulk_send_list_id' is set
        if ('bulk_send_list_id' not in params) or (params['bulk_send_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_list_id` when calling `create_bulk_send_request`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_list_id' in params:
            path_params['bulkSendListId'] = params['bulk_send_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_send_request' in params:
            body_params = params['bulk_send_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_bulk_send_test_request(self, account_id, bulk_send_list_id, **kwargs):
        """
        Tests whether the specified bulk sending list can be used to send an envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_test_request(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendRequest bulk_send_request:
        :return: BulkSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_send_test_request_with_http_info(account_id, bulk_send_list_id, **kwargs)
        else:
            (data) = self.create_bulk_send_test_request_with_http_info(account_id, bulk_send_list_id, **kwargs)
            return data

    def create_bulk_send_test_request_with_http_info(self, account_id, bulk_send_list_id, **kwargs):
        """
        Tests whether the specified bulk sending list can be used to send an envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_send_test_request_with_http_info(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendRequest bulk_send_request:
        :return: BulkSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_list_id', 'bulk_send_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_send_test_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_send_test_request`")
        # verify the required parameter 'bulk_send_list_id' is set
        if ('bulk_send_list_id' not in params) or (params['bulk_send_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_list_id` when calling `create_bulk_send_test_request`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_list_id' in params:
            path_params['bulkSendListId'] = params['bulk_send_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_send_request' in params:
            body_params = params['bulk_send_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendTestResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_bulk_send_list(self, account_id, bulk_send_list_id, **kwargs):
        """
        Deletes an existing bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_send_list(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :return: BulkSendingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
        else:
            (data) = self.delete_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
            return data

    def delete_bulk_send_list_with_http_info(self, account_id, bulk_send_list_id, **kwargs):
        """
        Deletes an existing bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bulk_send_list_with_http_info(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :return: BulkSendingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_list_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bulk_send_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_bulk_send_list`")
        # verify the required parameter 'bulk_send_list_id' is set
        if ('bulk_send_list_id' not in params) or (params['bulk_send_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_list_id` when calling `delete_bulk_send_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_list_id' in params:
            path_params['bulkSendListId'] = params['bulk_send_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendingListSummaries',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_send_batch_envelopes(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Gets envelopes from a specific bulk send batch
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batch_envelopes(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :param str count:
        :param str include:
        :param str order:
        :param str order_by:
        :param str search_text:
        :param str start_position:
        :param str status:
        :param str user_id:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_send_batch_envelopes_with_http_info(account_id, bulk_send_batch_id, **kwargs)
        else:
            (data) = self.get_bulk_send_batch_envelopes_with_http_info(account_id, bulk_send_batch_id, **kwargs)
            return data

    def get_bulk_send_batch_envelopes_with_http_info(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Gets envelopes from a specific bulk send batch
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batch_envelopes_with_http_info(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :param str count:
        :param str include:
        :param str order:
        :param str order_by:
        :param str search_text:
        :param str start_position:
        :param str status:
        :param str user_id:
        :return: EnvelopesInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_batch_id', 'count', 'include', 'order', 'order_by', 'search_text', 'start_position', 'status', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_send_batch_envelopes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_send_batch_envelopes`")
        # verify the required parameter 'bulk_send_batch_id' is set
        if ('bulk_send_batch_id' not in params) or (params['bulk_send_batch_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_batch_id` when calling `get_bulk_send_batch_envelopes`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/envelopes'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_batch_id' in params:
            path_params['bulkSendBatchId'] = params['bulk_send_batch_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'order' in params:
            query_params['order'] = params['order']
        if 'order_by' in params:
            query_params['order_by'] = params['order_by']
        if 'search_text' in params:
            query_params['search_text'] = params['search_text']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EnvelopesInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_send_batch_status(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Gets a specific bulk send batch status
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batch_status(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :return: BulkSendBatchStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, **kwargs)
        else:
            (data) = self.get_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, **kwargs)
            return data

    def get_bulk_send_batch_status_with_http_info(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Gets a specific bulk send batch status
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :return: BulkSendBatchStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_batch_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_send_batch_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_send_batch_status`")
        # verify the required parameter 'bulk_send_batch_id' is set
        if ('bulk_send_batch_id' not in params) or (params['bulk_send_batch_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_batch_id` when calling `get_bulk_send_batch_status`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_batch_id' in params:
            path_params['bulkSendBatchId'] = params['bulk_send_batch_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendBatchStatus',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_send_batches(self, account_id, **kwargs):
        """
        Returns a list of bulk send batch satuses initiated by account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batches(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str batch_ids:
        :param str count:
        :param str search_text:
        :param str start_position:
        :param str status:
        :return: BulkSendBatchSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_send_batches_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_bulk_send_batches_with_http_info(account_id, **kwargs)
            return data

    def get_bulk_send_batches_with_http_info(self, account_id, **kwargs):
        """
        Returns a list of bulk send batch satuses initiated by account.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_batches_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str batch_ids:
        :param str count:
        :param str search_text:
        :param str start_position:
        :param str status:
        :return: BulkSendBatchSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'batch_ids', 'count', 'search_text', 'start_position', 'status']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_send_batches" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_send_batches`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_batch'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'batch_ids' in params:
            query_params['batch_ids'] = params['batch_ids']
        if 'count' in params:
            query_params['count'] = params['count']
        if 'search_text' in params:
            query_params['search_text'] = params['search_text']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'status' in params:
            query_params['status'] = params['status']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendBatchSummaries',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_send_list(self, account_id, bulk_send_list_id, **kwargs):
        """
        Gets a specific bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_list(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
        else:
            (data) = self.get_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
            return data

    def get_bulk_send_list_with_http_info(self, account_id, bulk_send_list_id, **kwargs):
        """
        Gets a specific bulk send list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_list_with_http_info(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_list_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_send_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_send_list`")
        # verify the required parameter 'bulk_send_list_id' is set
        if ('bulk_send_list_id' not in params) or (params['bulk_send_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_list_id` when calling `get_bulk_send_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_list_id' in params:
            path_params['bulkSendListId'] = params['bulk_send_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendingList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bulk_send_lists(self, account_id, **kwargs):
        """
        Lists top-level details for all bulk send lists visible to the current user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_lists(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: BulkSendingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bulk_send_lists_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_bulk_send_lists_with_http_info(account_id, **kwargs)
            return data

    def get_bulk_send_lists_with_http_info(self, account_id, **kwargs):
        """
        Lists top-level details for all bulk send lists visible to the current user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bulk_send_lists_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: BulkSendingListSummaries
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_send_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_bulk_send_lists`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendingListSummaries',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_bulk_send_batch_status(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Put/Update a specific bulk send batch status
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_send_batch_status(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :param BulkSendBatchRequest bulk_send_batch_request:
        :return: BulkSendBatchStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, **kwargs)
        else:
            (data) = self.update_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, **kwargs)
            return data

    def update_bulk_send_batch_status_with_http_info(self, account_id, bulk_send_batch_id, **kwargs):
        """
        Put/Update a specific bulk send batch status
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_send_batch_status_with_http_info(account_id, bulk_send_batch_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_batch_id: (required)
        :param BulkSendBatchRequest bulk_send_batch_request:
        :return: BulkSendBatchStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_batch_id', 'bulk_send_batch_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bulk_send_batch_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_bulk_send_batch_status`")
        # verify the required parameter 'bulk_send_batch_id' is set
        if ('bulk_send_batch_id' not in params) or (params['bulk_send_batch_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_batch_id` when calling `update_bulk_send_batch_status`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_batch_id' in params:
            path_params['bulkSendBatchId'] = params['bulk_send_batch_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_send_batch_request' in params:
            body_params = params['bulk_send_batch_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendBatchStatus',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_bulk_send_list(self, account_id, bulk_send_list_id, **kwargs):
        """
        Updates an existing bulk send list.  If send_envelope query string value is provided, will accept an empty payload and try to send the specified envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_send_list(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendingList bulk_sending_list:
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
        else:
            (data) = self.update_bulk_send_list_with_http_info(account_id, bulk_send_list_id, **kwargs)
            return data

    def update_bulk_send_list_with_http_info(self, account_id, bulk_send_list_id, **kwargs):
        """
        Updates an existing bulk send list.  If send_envelope query string value is provided, will accept an empty payload and try to send the specified envelope
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_bulk_send_list_with_http_info(account_id, bulk_send_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str bulk_send_list_id: (required)
        :param BulkSendingList bulk_sending_list:
        :return: BulkSendingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bulk_send_list_id', 'bulk_sending_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bulk_send_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_bulk_send_list`")
        # verify the required parameter 'bulk_send_list_id' is set
        if ('bulk_send_list_id' not in params) or (params['bulk_send_list_id'] is None):
            raise ValueError("Missing the required parameter `bulk_send_list_id` when calling `update_bulk_send_list`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'bulk_send_list_id' in params:
            path_params['bulkSendListId'] = params['bulk_send_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_sending_list' in params:
            body_params = params['bulk_sending_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BulkSendingList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
