# openapiipify
OpenAPI client for ipify, a simple public IP address API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.0.1-pre.0
- Package version: 3.0.1-pre.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [http://blog.cliffano.com](http://blog.cliffano.com)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/cliffano/openapi-ipify.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/cliffano/openapi-ipify.git`)

Then import the package:
```python
import openapiipify
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapiipify
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapiipify
from pprint import pprint
from openapiipify.api import default_api
from openapiipify.model.ip import Ip
# Defining the host is optional and defaults to https://api.ipify.org
# See configuration.py for a list of all supported configuration parameters.
configuration = openapiipify.Configuration(
    host = "https://api.ipify.org"
)



# Enter a context with an instance of the API client
with openapiipify.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    format = "json" # str | Response format (optional)
    param_callback = "callback_example" # str | JSONP callback function name (optional)

    try:
        # Get your public IP address
        api_response = api_instance.get_ip(format=format, param_callback=param_callback)
        pprint(api_response)
    except openapiipify.ApiException as e:
        print("Exception when calling DefaultApi->get_ip: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.ipify.org*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_ip**](docs/DefaultApi.md#get_ip) | **GET** / | Get your public IP address


## Documentation For Models

 - [Ip](docs/Ip.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

blah@cliffano.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapiipify.apis and openapiipify.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapiipify.api.default_api import DefaultApi`
- `from openapiipify.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapiipify
from openapiipify.apis import *
from openapiipify.models import *
```

