// util/simple-io-funcs.h

// Copyright 2009-2011  Microsoft Corporation;  Jan Silovsky

// See ../../COPYING for clarification regarding multiple authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at

//  http://www.apache.org/licenses/LICENSE-2.0

// THIS CODE IS PROVIDED *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
// WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
// MERCHANTABLITY OR NON-INFRINGEMENT.
// See the Apache 2 License for the specific language governing permissions and
// limitations under the License.
#ifndef KALDI_UTIL_SIMPLE_IO_FUNCS_H_
#define KALDI_UTIL_SIMPLE_IO_FUNCS_H_

#include <string>
#include <vector>
#include "util/kaldi-io.h"

// This header contains some utilities for reading some common, simple text
// formats:integers in files, one per line, and integers in files, possibly
// multiple per line. these are not really fully native Kaldi formats; they are
// mostly for small files that might be generated by scripts, and can be read
// all at one time. for longer files of this type, we would probably use the
// Table code.

namespace kaldi {

/// WriteToList attempts to write this list of integers, one per line,
/// to the given file, in text format.
/// returns true if succeeded.
bool WriteIntegerVectorSimple(const std::string &wxfilename,
                              const std::vector<int32> &v);

/// ReadFromList attempts to read this list of integers, one per line,
/// from the given file, in text format.
/// returns true if succeeded.
bool ReadIntegerVectorSimple(const std::string &rxfilename,
                             std::vector<int32> *v);

// This is a file format like:
// 1 2
// 3
//
// 4 5 6
// etc.
bool WriteIntegerVectorVectorSimple(const std::string &wxfilename,
                                    const std::vector<std::vector<int32> > &v);

bool ReadIntegerVectorVectorSimple(const std::string &rxfilename,
                                   std::vector<std::vector<int32> > *v);


}  // end namespace kaldi.


#endif  // KALDI_UTIL_SIMPLE_IO_FUNCS_H_
