import { ReactTypeScriptProject, ReactTypeScriptProjectOptions } from "projen/lib/web";
/**
 * Configuration options for the CloudscapeReactTsWebsiteProject.
 */
export interface CloudscapeReactTsWebsiteProjectOptions extends ReactTypeScriptProjectOptions {
    /**
     * Name of the application name.
     *
     * @default "Sample App"
     */
    readonly applicationName?: string;
    /**
     * Public directory.
     *
     * @default "public"
     */
    readonly publicDir?: string;
}
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
export declare class CloudscapeReactTsWebsiteProject extends ReactTypeScriptProject {
    readonly applicationName: string;
    readonly publicDir: string;
    constructor(options: CloudscapeReactTsWebsiteProjectOptions);
    private buildSampleDirEntries;
}
