# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/core.ipynb (unless otherwise specified).

__all__ = ['TSFeatures']

# Cell
import requests
import json

import pandas as pd

# Cell
class TSFeatures:

    def __init__(self, credentials: str = None) -> 'TSFeatures':
        self.credentials = credentials

    def calculate_features_from_url(self, url: str, freq: int,
                                    kind: str = 'static',
                                    unique_id_column: str = 'unique_id',
                                    ds_column: str = 'ds',
                                    y_column: str = 'y') -> str:
        """Calculates features from S3 URL.

        Parameters
        ----------
        kind: str
            Kind of features. Static returns features for each time series.
            temporal returns for each ds and each time series.
        unique_id_column: str
            Column name identifying each time series.
        ds_column: str
            Column name identifying each time stamp.
        y_column: str
            Column name identifying the target variable.
        """
        query = dict(url=url, freq=freq, kind=kind,
                     unique_id_column=unique_id_column,
                     ds_column=ds_column,
                     y_column=y_column)
        resp = requests.get('http://3.220.207.54/tsfeatures', data=json.dumps(query))

        return resp.text