# pnap-network-storage-api
Create, list, edit, and delete storage networks with the Network Storage API. Use storage networks to expand storage capacity on a private network.
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/bare-metal-cloud-storage' target='_blank'>here</a>
</span>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/network-storage/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
$ pip install pnap_network_storage_api
```

Then import the package:
```python
import pnap_network_storage_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_network_storage_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pnap_network_storage_api
from pprint import pprint
from pnap_network_storage_api.api import storage_networks_api
from pnap_network_storage_api.model.error import Error
from pnap_network_storage_api.model.storage_network import StorageNetwork
from pnap_network_storage_api.model.storage_network_create import StorageNetworkCreate
from pnap_network_storage_api.model.storage_network_update import StorageNetworkUpdate
from pnap_network_storage_api.model.volume import Volume
from pnap_network_storage_api.model.volume_update import VolumeUpdate
# Defining the host is optional and defaults to https://api.phoenixnap.com/network-storage/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_network_storage_api.Configuration(
    host = "https://api.phoenixnap.com/network-storage/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2
configuration = pnap_network_storage_api.Configuration(
    host = "https://api.phoenixnap.com/network-storage/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pnap_network_storage_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = storage_networks_api.StorageNetworksApi(api_client)
    location = "PHX" # str | If present will filter the result by the given location. (optional)

    try:
        # List all storage networks.
        api_response = api_instance.storage_networks_get(location=location)
        pprint(api_response)
    except pnap_network_storage_api.ApiException as e:
        print("Exception when calling StorageNetworksApi->storage_networks_get: %s\n" % e)
```

To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:
```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']
```

## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/network-storage/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StorageNetworksApi* | [**storage_networks_get**](docs/StorageNetworksApi.md#storage_networks_get) | **GET** /storage-networks | List all storage networks.
*StorageNetworksApi* | [**storage_networks_id_delete**](docs/StorageNetworksApi.md#storage_networks_id_delete) | **DELETE** /storage-networks/{storageNetworkId} | Delete a storage network and its volume.
*StorageNetworksApi* | [**storage_networks_id_get**](docs/StorageNetworksApi.md#storage_networks_id_get) | **GET** /storage-networks/{storageNetworkId} | Get storage network details.
*StorageNetworksApi* | [**storage_networks_id_patch**](docs/StorageNetworksApi.md#storage_networks_id_patch) | **PATCH** /storage-networks/{storageNetworkId} | Update storage network details.
*StorageNetworksApi* | [**storage_networks_post**](docs/StorageNetworksApi.md#storage_networks_post) | **POST** /storage-networks | Create a storage network and volume.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_get**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_get) | **GET** /storage-networks/{storageNetworkId}/volumes | Display one or more volumes belonging to a storage network.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_delete**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_delete) | **DELETE** /storage-networks/{storageNetworkId}/volumes/{volumeId} | Delete a Storage Network&#39;s Volume
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_get**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_get) | **GET** /storage-networks/{storageNetworkId}/volumes/{volumeId} | Get a storage network&#39;s volume details.
*StorageNetworksApi* | [**storage_networks_storage_network_id_volumes_volume_id_patch**](docs/StorageNetworksApi.md#storage_networks_storage_network_id_volumes_volume_id_patch) | **PATCH** /storage-networks/{storageNetworkId}/volumes/{volumeId} | Update a storage network&#39;s volume details.


## Documentation For Models

 - [Error](docs/Error.md)
 - [NfsPermissions](docs/NfsPermissions.md)
 - [Permissions](docs/Permissions.md)
 - [Status](docs/Status.md)
 - [StorageNetwork](docs/StorageNetwork.md)
 - [StorageNetworkCreate](docs/StorageNetworkCreate.md)
 - [StorageNetworkUpdate](docs/StorageNetworkUpdate.md)
 - [Volume](docs/Volume.md)
 - [VolumeCreate](docs/VolumeCreate.md)
 - [VolumeUpdate](docs/VolumeUpdate.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **networkstorage**: Grants full access to Network Storage API.
 - **networkstorage.read**: Grants read only access to Network Storage API.


## Author

support@phoenixnap.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pnap_network_storage_api.apis and pnap_network_storage_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pnap_network_storage_api.api.default_api import DefaultApi`
- `from pnap_network_storage_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pnap_network_storage_api
from pnap_network_storage_api.apis import *
from pnap_network_storage_api.models import *
```

