# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/08_key.ipynb (unless otherwise specified).

__all__ = ['Key', 'load_key_from_json']

# Cell
import json
from rich import print as rich_print
from dataclasses import dataclass, FrozenInstanceError

# Cell
@dataclass(frozen=True)
class Key:
    """Immutable Numerai credentials."""
    pub_id: str
    secret_key: str

    def __post_init__(self):
        rich_print(
            f":key: Numerai Auth key initialized with pub_id = '{self.pub_id}' :key:"
        )

    def __repr__(self):
        return f"Numerai Auth Key. pub_id = '{self.pub_id}'"

    def __str__(self):
        return self.__repr__()


def load_key_from_json(file_path: str, *args, **kwargs):
    """
    Initialize Key object from JSON file. \n
    Credentials file must have the following format: \n
    `{"pub_id": "PUBLIC_ID", "secret_key": "SECRET_KEY"}`
    """
    with open(file_path) as json_file:
        json_data = json.load(json_file, *args, **kwargs)
    pub_id = json_data["pub_id"]
    secret_key = json_data["secret_key"]
    return Key(pub_id=pub_id, secret_key=secret_key)