from ase.data.colors import jmol_colors, cpk_colors
from ase.data import covalent_radii
covalent_radii[0] = 1.0
jmol_colors[0] = [0.8, 0.8, 0.0]
cpk_colors[0] = [0.8, 0.8, 0.0]



vesta_color = {
'X': [0.8, 0.0, 0.8],
'H': [1.0, 0.8, 0.8], 
'D': [0.8, 0.8, 1.0], 
'He': [0.98907, 0.91312, 0.81091], 
'Li': [0.52731, 0.87953, 0.4567], 
'Be': [0.37147, 0.8459, 0.48292], 
'B': [0.1249, 0.63612, 0.05948], 
'C': [0.5043, 0.28659, 0.16236], 
'N': [0.69139, 0.72934, 0.9028], 
'O': [0.99997, 0.01328, 0.0], 
'F': [0.69139, 0.72934, 0.9028], 
'Ne': [0.99954, 0.21788, 0.71035], 
'Na': [0.97955, 0.86618, 0.23787], 
'Mg': [0.98773, 0.48452, 0.0847], 
'Al': [0.50718, 0.70056, 0.84062], 
'Si': [0.10596, 0.23226, 0.98096], 
'P': [0.75557, 0.61256, 0.76425], 
'S': [1.0, 0.98071, 0.0], 
'Cl': [0.19583, 0.98828, 0.01167], 
'Ar': [0.81349, 0.99731, 0.77075], 
'K': [0.63255, 0.13281, 0.96858], 
'Ca': [0.35642, 0.58863, 0.74498], 
'Sc': [0.71209, 0.3893, 0.67279], 
'Ti': [0.47237, 0.79393, 1.0], 
'V': [0.9, 0.1, 0.0], 
'Cr': [0.0, 0.0, 0.62], 
'Mn': [0.66148, 0.03412, 0.62036], 
'Fe': [0.71051, 0.44662, 0.00136], 
'Co': [0.0, 0.0, 0.68666], 
'Ni': [0.72032, 0.73631, 0.74339], 
'Cu': [0.1339, 0.28022, 0.86606], 
'Zn': [0.56123, 0.56445, 0.50799], 
'Ga': [0.62292, 0.89293, 0.45486], 
'Ge': [0.49557, 0.43499, 0.65193], 
'As': [0.45814, 0.81694, 0.34249], 
'Se': [0.6042, 0.93874, 0.06122], 
'Br': [0.49645, 0.19333, 0.01076], 
'Kr': [0.98102, 0.75805, 0.95413], 
'Rb': [1.0, 0.0, 0.6], 
'Sr': [0.0, 1.0, 0.15259], 
'Y': [0.40259, 0.59739, 0.55813], 
'Zr': [0.0, 1.0, 0.0], 
'Nb': [0.29992, 0.70007, 0.46459], 
'Mo': [0.70584, 0.52602, 0.68925], 
'Tc': [0.80574, 0.68699, 0.79478], 
'Ru': [0.81184, 0.72113, 0.68089], 
'Rh': [0.80748, 0.82205, 0.67068], 
'Pd': [0.75978, 0.76818, 0.72454], 
'Ag': [0.72032, 0.73631, 0.74339], 
'Cd': [0.95145, 0.12102, 0.86354], 
'In': [0.84378, 0.50401, 0.73483], 
'Sn': [0.60764, 0.56052, 0.72926], 
'Sb': [0.84627, 0.51498, 0.31315], 
'Te': [0.67958, 0.63586, 0.32038], 
'I': [0.55914, 0.122, 0.54453], 
'Xe': [0.60662, 0.63218, 0.97305], 
'Cs': [0.05872, 0.99922, 0.72578], 
'Ba': [0.11835, 0.93959, 0.17565], 
'La': [0.3534, 0.77057, 0.28737], 
'Ce': [0.82055, 0.99071, 0.02374], 
'Pr': [0.9913, 0.88559, 0.02315], 
'Nd': [0.98701, 0.5556, 0.02744], 
'Pm': [0.0, 0.0, 0.96], 
'Sm': [0.99042, 0.02403, 0.49195], 
'Eu': [0.98367, 0.03078, 0.83615], 
'Gd': [0.75325, 0.01445, 1.0], 
'Tb': [0.44315, 0.01663, 0.99782], 
'Dy': [0.1939, 0.02374, 0.99071], 
'Ho': [0.02837, 0.25876, 0.98608], 
'Er': [0.28688, 0.45071, 0.23043], 
'Tm': [0.0, 0.0, 0.88], 
'Yb': [0.15323, 0.99165, 0.95836], 
'Lu': [0.15097, 0.99391, 0.71032], 
'Hf': [0.70704, 0.70552, 0.3509], 
'Ta': [0.71952, 0.60694, 0.33841], 
'W': [0.55616, 0.54257, 0.50178], 
'Re': [0.70294, 0.69401, 0.55789], 
'Os': [0.78703, 0.69512, 0.47379], 
'Ir': [0.78975, 0.81033, 0.45049], 
'Pt': [0.79997, 0.77511, 0.75068], 
'Au': [0.99628, 0.70149, 0.22106], 
'Hg': [0.8294, 0.72125, 0.79823], 
'Tl': [0.58798, 0.53854, 0.42649], 
'Pb': [0.32386, 0.32592, 0.35729], 
'Bi': [0.82428, 0.18732, 0.97211], 
'Po': [0.0, 0.0, 1.0], 
'At': [0.0, 0.0, 1.0], 
'Rn': [1.0, 1.0, 0.0], 
'Fr': [0.0, 0.0, 0.0], 
'Ra': [0.42959, 0.66659, 0.34786], 
'Ac': [0.39344, 0.62101, 0.45034], 
'Th': [0.14893, 0.99596, 0.47106], 
'Pa': [0.16101, 0.98387, 0.20855], 
'U': [0.47774, 0.63362, 0.66714], 
'Np': [0.3, 0.3, 0.3], 
'Pu': [0.3, 0.3, 0.3], 
'Am': [0.3, 0.3, 0.3], 
'XX': [0.3, 0.3, 0.3],
}

# Default bondsetting suggestion from VESTA
# bond pair    search mode   polyhedra
default_bonds = {
('Ac', 'O' ):  [1,  1],
('Ac', 'F' ):  [1,  1],
('Ac', 'Cl'):  [1,  1],
('Ac', 'Br'):  [1,  1],
('Ag', 'O' ):  [1,  1],
('Ag', 'S' ):  [1,  1],
('Ag', 'F' ):  [1,  1],
('Ag', 'Cl'):  [1,  1],
('Ag', 'Br'):  [1,  1],
('Ag', 'I' ):  [1,  1],
('Ag', 'Se'):  [1,  1],
('Ag', 'Te'):  [1,  1],
('Ag', 'N' ):  [1,  1],
('Ag', 'P' ):  [1,  1],
('Ag', 'As'):  [1,  1],
('Ag', 'H' ):  [1,  1],
('Al', 'O' ):  [1,  1],
('Al', 'S' ):  [1,  1],
('Al', 'Se'):  [1,  1],
('Al', 'Te'):  [1,  1],
('Al', 'F' ):  [1,  1],
('Al', 'Cl'):  [1,  1],
('Al', 'Br'):  [1,  1],
('Al', 'I' ):  [1,  1],
('Al', 'N' ):  [1,  1],
('Al', 'P' ):  [1,  1],
('Al', 'As'):  [1,  1],
('Al', 'H' ):  [1,  1],
('Am', 'O' ):  [1,  1],
('Am', 'F' ):  [1,  1],
('Am', 'Cl'):  [1,  1],
('Am', 'Br'):  [1,  1],
('As', 'S' ):  [1,  1],
('As', 'Se'):  [1,  1],
('As', 'O' ):  [1,  1],
('As', 'Te'):  [1,  1],
('As', 'F' ):  [1,  1],
('As', 'Cl'):  [1,  1],
('As', 'Br'):  [1,  1],
('As', 'I' ):  [1,  1],
('As', 'C' ):  [1,  1],
('Au', 'Cl'):  [1,  1],
('Au', 'I' ):  [1,  1],
('Au', 'O' ):  [1,  1],
('Au', 'S' ):  [1,  1],
('Au', 'F' ):  [1,  1],
('Au', 'Br'):  [1,  1],
('Au', 'N' ):  [1,  1],
('Au', 'Se'):  [1,  1],
('Au', 'Te'):  [1,  1],
('Au', 'P' ):  [1,  1],
('Au', 'As'):  [1,  1],
('Au', 'H' ):  [1,  1],
('B' , 'O' ):  [1,  1],
('B' , 'S' ):  [1,  1],
('B' , 'Se'):  [1,  1],
('B' , 'Te'):  [1,  1],
('B' , 'F' ):  [1,  1],
('B' , 'Cl'):  [1,  1],
('B' , 'Br'):  [1,  1],
('B' , 'I' ):  [1,  1],
('B' , 'N' ):  [1,  1],
('B' , 'P' ):  [1,  1],
('B' , 'As'):  [1,  1],
('B' , 'H' ):  [1,  1],
('B' , 'B' ):  [1,  1],
('Ba', 'O' ):  [1,  1],
('Ba', 'S' ):  [1,  1],
('Ba', 'Se'):  [1,  1],
('Ba', 'Te'):  [1,  1],
('Ba', 'F' ):  [1,  1],
('Ba', 'Cl'):  [1,  1],
('Ba', 'Br'):  [1,  1],
('Ba', 'I' ):  [1,  1],
('Ba', 'N' ):  [1,  1],
('Ba', 'P' ):  [1,  1],
('Ba', 'As'):  [1,  1],
('Ba', 'H' ):  [1,  1],
('Be', 'O' ):  [1,  1],
('Be', 'S' ):  [1,  1],
('Be', 'Se'):  [1,  1],
('Be', 'Te'):  [1,  1],
('Be', 'F' ):  [1,  1],
('Be', 'Cl'):  [1,  1],
('Be', 'Br'):  [1,  1],
('Be', 'I' ):  [1,  1],
('Be', 'N' ):  [1,  1],
('Be', 'P' ):  [1,  1],
('Be', 'As'):  [1,  1],
('Be', 'H' ):  [1,  1],
('Bi', 'O' ):  [1,  1],
('Bi', 'S' ):  [1,  1],
('Bi', 'Se'):  [1,  1],
('Bi', 'F' ):  [1,  1],
('Bi', 'Cl'):  [1,  1],
('Bi', 'Br'):  [1,  1],
('Bi', 'I' ):  [1,  1],
('Bi', 'N' ):  [1,  1],
('Bi', 'Te'):  [1,  1],
('Bi', 'P' ):  [1,  1],
('Bi', 'As'):  [1,  1],
('Bi', 'H' ):  [1,  1],
('Bk', 'O' ):  [1,  1],
('Bk', 'F' ):  [1,  1],
('Bk', 'Cl'):  [1,  1],
('Bk', 'Br'):  [1,  1],
('Br', 'O' ):  [1,  1],
('Br', 'F' ):  [1,  1],
('Br', 'Cl'):  [1,  1],
('C' , 'Au' ):  [1,  1],
('C' , 'O' ):  [2,  1],
('C' , 'Cl'):  [2,  1],
('C' , 'C' ):  [2,  0],
('C' , 'S' ):  [2,  0],
('C' , 'F' ):  [2,  1],
('C' , 'Br'):  [2,  1],
('C' , 'N' ):  [2,  1],
('C' , 'Se'):  [2,  1],
('C' , 'I' ):  [2,  1],
('C' , 'Te'):  [1,  1],
('C' , 'P' ):  [2,  1],
('C' , 'Pt' ):  [1,  1],
('C' , 'H' ):  [1,  0],
('Ca', 'O' ):  [1,  1],
('Ca', 'S' ):  [1,  1],
('Ca', 'Se'):  [1,  1],
('Ca', 'Te'):  [1,  1],
('Ca', 'F' ):  [1,  1],
('Ca', 'Cl'):  [1,  1],
('Ca', 'Br'):  [1,  1],
('Ca', 'I' ):  [1,  1],
('Ca', 'N' ):  [1,  1],
('Ca', 'P' ):  [1,  1],
('Ca', 'As'):  [1,  1],
('Ca', 'H' ):  [1,  1],
('Cd', 'O' ):  [1,  1],
('Cd', 'S' ):  [1,  1],
('Cd', 'Se'):  [1,  1],
('Cd', 'Te'):  [1,  1],
('Cd', 'F' ):  [1,  1],
('Cd', 'Cl'):  [1,  1],
('Cd', 'Br'):  [1,  1],
('Cd', 'I' ):  [1,  1],
('Cd', 'N' ):  [1,  1],
('Cd', 'P' ):  [1,  1],
('Cd', 'As'):  [1,  1],
('Cd', 'H' ):  [1,  1],
('Ce', 'O' ):  [1,  1],
('Ce', 'S' ):  [1,  1],
('Ce', 'F' ):  [1,  1],
('Ce', 'Cl'):  [1,  1],
('Ce', 'Br'):  [1,  1],
('Ce', 'I' ):  [1,  1],
('Ce', 'N' ):  [1,  1],
('Ce', 'Se'):  [1,  1],
('Ce', 'Te'):  [1,  1],
('Ce', 'P' ):  [1,  1],
('Ce', 'As'):  [1,  1],
('Ce', 'H' ):  [1,  1],
('Cf', 'O' ):  [1,  1],
('Cf', 'F' ):  [1,  1],
('Cf', 'Cl'):  [1,  1],
('Cf', 'Br'):  [1,  1],
('Cl' , 'H'):  [1,  0],
('Cl', 'O' ):  [1,  1],
('Cl', 'F' ):  [1,  1],
('Cl', 'Cl'):  [1,  1],
('Cm', 'O' ):  [1,  1],
('Cm', 'F' ):  [1,  1],
('Cm', 'Cl'):  [1,  1],
('Co', 'H' ):  [1,  1],
('Co', 'O' ):  [1,  1],
('Co', 'S' ):  [1,  1],
('Co', 'F' ):  [1,  1],
('Co', 'Cl'):  [1,  1],
('Co', 'N' ):  [1,  1],
('Co', 'C' ):  [1,  1],
('Co', 'Br'):  [1,  1],
('Co', 'I' ):  [1,  1],
('Co', 'Se'):  [1,  1],
('Co', 'Te'):  [1,  1],
('Co', 'P' ):  [1,  1],
('Co', 'As'):  [1,  1],
('Cr', 'O' ):  [1,  1],
('Cr', 'F' ):  [1,  1],
('Cr', 'Cl'):  [1,  1],
('Cr', 'Br'):  [1,  1],
('Cr', 'I' ):  [1,  1],
('Cr', 'N' ):  [1,  1],
('Cr', 'S' ):  [1,  1],
('Cr', 'Se'):  [1,  1],
('Cr', 'Te'):  [1,  1],
('Cr', 'P' ):  [1,  1],
('Cr', 'As'):  [1,  1],
('Cr', 'H' ):  [1,  1],
('Cs', 'O' ):  [1,  1],
('Cs', 'S' ):  [1,  1],
('Cs', 'Se'):  [1,  1],
('Cs', 'Te'):  [1,  1],
('Cs', 'F' ):  [1,  1],
('Cs', 'Cl'):  [1,  1],
('Cs', 'Br'):  [1,  1],
('Cs', 'I' ):  [1,  1],
('Cs', 'N' ):  [1,  1],
('Cs', 'P' ):  [1,  1],
('Cs', 'As'):  [1,  1],
('Cs', 'H' ):  [1,  1],
('Cu', 'O' ):  [1,  1],
('Cu', 'S' ):  [1,  1],
('Cu', 'Se'):  [1,  1],
('Cu', 'F' ):  [1,  1],
('Cu', 'Cl'):  [1,  1],
('Cu', 'Br'):  [1,  1],
('Cu', 'I' ):  [1,  1],
('Cu', 'N' ):  [1,  1],
('Cu', 'P' ):  [1,  1],
('Cu', 'As'):  [1,  1],
('Cu', 'C' ):  [1,  1],
('Cu', 'Te'):  [1,  1],
('Cu', 'H' ):  [1,  1],
('Dy', 'O' ):  [1,  1],
('Dy', 'F' ):  [1,  1],
('Dy', 'Cl'):  [1,  1],
('Dy', 'Br'):  [1,  1],
('Dy', 'I' ):  [1,  1],
('Dy', 'S' ):  [1,  1],
('Dy', 'Se'):  [1,  1],
('Dy', 'Te'):  [1,  1],
('Dy', 'N' ):  [1,  1],
('Dy', 'P' ):  [1,  1],
('Dy', 'As'):  [1,  1],
('Dy', 'H' ):  [1,  1],
('Er', 'O' ):  [1,  1],
('Er', 'S' ):  [1,  1],
('Er', 'Se'):  [1,  1],
('Er', 'F' ):  [1,  1],
('Er', 'Cl'):  [1,  1],
('Er', 'Br'):  [1,  1],
('Er', 'I' ):  [1,  1],
('Er', 'Te'):  [1,  1],
('Er', 'N' ):  [1,  1],
('Er', 'P' ):  [1,  1],
('Er', 'As'):  [1,  1],
('Er', 'H' ):  [1,  1],
('Es', 'O' ):  [1,  1],
('Eu', 'O' ):  [1,  1],
('Eu', 'S' ):  [1,  1],
('Eu', 'F' ):  [1,  1],
('Eu', 'Cl'):  [1,  1],
('Eu', 'Br'):  [1,  1],
('Eu', 'I' ):  [1,  1],
('Eu', 'N' ):  [1,  1],
('Eu', 'Se'):  [1,  1],
('Eu', 'Te'):  [1,  1],
('Eu', 'P' ):  [1,  1],
('Eu', 'As'):  [1,  1],
('Eu', 'H' ):  [1,  1],
('F' , 'H' ):  [1,  0],
('Fe', 'O' ):  [1,  1],
('Fe', 'S' ):  [1,  1],
('Fe', 'F' ):  [1,  1],
('Fe', 'Cl'):  [1,  1],
('Fe', 'Br'):  [1,  1],
('Fe', 'I' ):  [1,  1],
('Fe', 'N' ):  [1,  1],
('Fe', 'C' ):  [1,  1],
('Fe', 'Se'):  [1,  1],
('Fe', 'Te'):  [1,  1],
('Fe', 'P' ):  [1,  1],
('Fe', 'As'):  [1,  1],
('Fe', 'H' ):  [1,  1],
('Ga', 'Se'):  [1,  1],
('Ga', 'O' ):  [1,  1],
('Ga', 'S' ):  [1,  1],
('Ga', 'F' ):  [1,  1],
('Ga', 'Cl'):  [1,  1],
('Ga', 'Br'):  [1,  1],
('Ga', 'I' ):  [1,  1],
('Ga', 'Te'):  [1,  1],
('Ga', 'N' ):  [1,  1],
('Ga', 'P' ):  [1,  1],
('Ga', 'As'):  [1,  1],
('Ga', 'H' ):  [1,  1],
('Gd', 'O' ):  [1,  1],
('Gd', 'F' ):  [1,  1],
('Gd', 'S' ):  [1,  1],
('Gd', 'Cl'):  [1,  1],
('Gd', 'Br'):  [1,  1],
('Gd', 'I' ):  [1,  1],
('Gd', 'Se'):  [1,  1],
('Gd', 'Te'):  [1,  1],
('Gd', 'N' ):  [1,  1],
('Gd', 'P' ):  [1,  1],
('Gd', 'As'):  [1,  1],
('Gd', 'H' ):  [1,  1],
('Ge', 'O' ):  [1,  1],
('Ge', 'S' ):  [1,  1],
('Ge', 'Se'):  [1,  1],
('Ge', 'F' ):  [1,  1],
('Ge', 'Cl'):  [1,  1],
('Ge', 'Br'):  [1,  1],
('Ge', 'I' ):  [1,  1],
('Ge', 'Te'):  [1,  1],
('Ge', 'N' ):  [1,  1],
('Ge', 'P' ):  [1,  1],
('Ge', 'As'):  [1,  1],
('Ge', 'H' ):  [1,  1],
('Ge', 'Ge'):  [1,  1],
('O' , 'H' ):  [1,  0],
('H' , 'O' ):  [0,  0],
('H' , 'N' ):  [0,  0],
('O' , 'D' ):  [1,  0],
('D' , 'O' ):  [0,  0],
('D' , 'F' ):  [1,  0],
('D' , 'Cl'):  [1,  0],
('D' , 'N' ):  [1,  0],
('Hf', 'F' ):  [1,  1],
('Hf', 'O' ):  [1,  1],
('Hf', 'Cl'):  [1,  1],
('Hf', 'Br'):  [1,  1],
('Hf', 'S' ):  [1,  1],
('Hf', 'Se'):  [1,  1],
('Hf', 'Te'):  [1,  1],
('Hf', 'I' ):  [1,  1],
('Hf', 'N' ):  [1,  1],
('Hf', 'P' ):  [1,  1],
('Hf', 'As'):  [1,  1],
('Hf', 'H' ):  [1,  1],
('Hg', 'O' ):  [1,  1],
('Hg', 'F' ):  [1,  1],
('Hg', 'Cl'):  [1,  1],
('Hg', 'S' ):  [1,  1],
('Hg', 'Br'):  [1,  1],
('Hg', 'I' ):  [1,  1],
('Hg', 'Se'):  [1,  1],
('Hg', 'Te'):  [1,  1],
('Hg', 'N' ):  [1,  1],
('Hg', 'P' ):  [1,  1],
('Hg', 'As'):  [1,  1],
('Hg', 'H' ):  [1,  1],
('Hg', 'Hg'):  [1,  1],
('Ho', 'O' ):  [1,  1],
('Ho', 'S' ):  [1,  1],
('Ho', 'F' ):  [1,  1],
('Ho', 'Cl'):  [1,  1],
('Ho', 'Br'):  [1,  1],
('Ho', 'I' ):  [1,  1],
('Ho', 'Se'):  [1,  1],
('Ho', 'Te'):  [1,  1],
('Ho', 'N' ):  [1,  1],
('Ho', 'P' ):  [1,  1],
('Ho', 'As'):  [1,  1],
('Ho', 'H' ):  [1,  1],
('I' , 'I' ):  [1,  1],
('I' , 'F' ):  [1,  1],
('I' , 'Cl'):  [1,  1],
('I' , 'O' ):  [1,  1],
('In', 'Cl'):  [1,  1],
('In', 'O' ):  [1,  1],
('In', 'S' ):  [1,  1],
('In', 'F' ):  [1,  1],
('In', 'Br'):  [1,  1],
('In', 'I' ):  [1,  1],
('In', 'Co'):  [1,  1],
('In', 'Mn'):  [1,  1],
('In', 'Se'):  [1,  1],
('In', 'Te'):  [1,  1],
('In', 'N' ):  [1,  1],
('In', 'P' ):  [1,  1],
('In', 'As'):  [1,  1],
('In', 'H' ):  [1,  1],
('Ir', 'O' ):  [1,  1],
('Ir', 'F' ):  [1,  1],
('Ir', 'Cl'):  [1,  1],
('Ir', 'S' ):  [1,  1],
('Ir', 'Se'):  [1,  1],
('Ir', 'Te'):  [1,  1],
('Ir', 'Br'):  [1,  1],
('Ir', 'I' ):  [1,  1],
('Ir', 'N' ):  [1,  1],
('Ir', 'P' ):  [1,  1],
('Ir', 'As'):  [1,  1],
('Ir', 'H' ):  [1,  1],
('K' , 'O' ):  [1,  1],
('K' , 'S' ):  [1,  1],
('K' , 'Se'):  [1,  1],
('K' , 'Te'):  [1,  1],
('K' , 'F' ):  [1,  1],
('K' , 'Cl'):  [1,  1],
('K' , 'Br'):  [1,  1],
('K' , 'I' ):  [1,  1],
('K' , 'N' ):  [1,  1],
('K' , 'P' ):  [1,  1],
('K' , 'As'):  [1,  1],
('K' , 'H' ):  [1,  1],
('Kr', 'F' ):  [1,  1],
('La', 'O' ):  [1,  1],
('La', 'S' ):  [1,  1],
('La', 'Se'):  [1,  1],
('La', 'Te'):  [1,  1],
('La', 'F' ):  [1,  1],
('La', 'Cl'):  [1,  1],
('La', 'Br'):  [1,  1],
('La', 'I' ):  [1,  1],
('La', 'N' ):  [1,  1],
('La', 'P' ):  [1,  1],
('La', 'As'):  [1,  1],
('La', 'H' ):  [1,  1],
('Li', 'O' ):  [1,  1],
('Li', 'S' ):  [1,  1],
('Li', 'Se'):  [1,  1],
('Li', 'Te'):  [1,  1],
('Li', 'F' ):  [1,  1],
('Li', 'Cl'):  [1,  1],
('Li', 'Br'):  [1,  1],
('Li', 'I' ):  [1,  1],
('Li', 'N' ):  [1,  1],
('Lu', 'O' ):  [1,  1],
('Lu', 'S' ):  [1,  1],
('Lu', 'Se'):  [1,  1],
('Lu', 'Te'):  [1,  1],
('Lu', 'F' ):  [1,  1],
('Lu', 'Cl'):  [1,  1],
('Lu', 'Br'):  [1,  1],
('Lu', 'I' ):  [1,  1],
('Lu', 'N' ):  [1,  1],
('Lu', 'P' ):  [1,  1],
('Lu', 'As'):  [1,  1],
('Lu', 'H' ):  [1,  1],
('Mg', 'O' ):  [1,  1],
('Mg', 'S' ):  [1,  1],
('Mg', 'Se'):  [1,  1],
('Mg', 'Te'):  [1,  1],
('Mg', 'F' ):  [1,  1],
('Mg', 'Cl'):  [1,  1],
('Mg', 'Br'):  [1,  1],
('Mg', 'I' ):  [1,  1],
('Mg', 'N' ):  [1,  1],
('Mg', 'P' ):  [1,  1],
('Mg', 'As'):  [1,  1],
('Mg', 'H' ):  [1,  1],
('Mn', 'O' ):  [1,  1],
('Mn', 'S' ):  [1,  1],
('Mn', 'F' ):  [1,  1],
('Mn', 'Cl'):  [1,  1],
('Mn', 'Br'):  [1,  1],
('Mn', 'I' ):  [1,  1],
('Mn', 'N' ):  [1,  1],
('Mn', 'Se'):  [1,  1],
('Mn', 'Te'):  [1,  1],
('Mn', 'P' ):  [1,  1],
('Mn', 'As'):  [1,  1],
('Mn', 'H' ):  [1,  1],
('Mo', 'S' ):  [1,  1],
('Mo', 'Cl'):  [1,  1],
('Mo', 'O' ):  [1,  1],
('Mo', 'F' ):  [1,  1],
('Mo', 'Br'):  [1,  1],
('Mo', 'N' ):  [1,  1],
('Mo', 'I' ):  [1,  1],
('Mo', 'Se'):  [1,  1],
('Mo', 'Te'):  [1,  1],
('Mo', 'P' ):  [1,  1],
('Mo', 'As'):  [1,  1],
('Mo', 'H' ):  [1,  1],
('N' , 'H' ):  [1,  0],
('N' , 'O' ):  [1,  1],
('N' , 'F' ):  [1,  1],
('N' , 'Cl'):  [1,  1],
('N' , 'N' ):  [1,  1],
('Na', 'O' ):  [1,  1],
('Na', 'S' ):  [1,  1],
('Na', 'Se'):  [1,  1],
('Na', 'Te'):  [1,  1],
('Na', 'F' ):  [1,  1],
('Na', 'Cl'):  [1,  1],
('Na', 'Br'):  [1,  1],
('Na', 'I' ):  [1,  1],
('Na', 'N' ):  [1,  1],
('Na', 'P' ):  [1,  1],
('Na', 'As'):  [1,  1],
('Na', 'H' ):  [1,  1],
('Nb', 'O' ):  [1,  1],
('Nb', 'F' ):  [1,  1],
('Nb', 'Cl'):  [1,  1],
('Nb', 'Br'):  [1,  1],
('Nb', 'N' ):  [1,  1],
('Nb', 'I' ):  [1,  1],
('Nb', 'S' ):  [1,  1],
('Nb', 'Se'):  [1,  1],
('Nb', 'Te'):  [1,  1],
('Nb', 'P' ):  [1,  1],
('Nb', 'As'):  [1,  1],
('Nb', 'H' ):  [1,  1],
('Nd', 'O' ):  [1,  1],
('Nd', 'S' ):  [1,  1],
('Nd', 'Se'):  [1,  1],
('Nd', 'Te'):  [1,  1],
('Nd', 'F' ):  [1,  1],
('Nd', 'Cl'):  [1,  1],
('Nd', 'Br'):  [1,  1],
('Nd', 'I' ):  [1,  1],
('Nd', 'N' ):  [1,  1],
('NH', 'O' ):  [1,  1],
('NH', 'F' ):  [1,  1],
('NH', 'Cl'):  [1,  1],
('Ni', 'O' ):  [1,  1],
('Ni', 'S' ):  [1,  1],
('Ni', 'F' ):  [1,  1],
('Ni', 'Cl'):  [1,  1],
('Ni', 'Br'):  [1,  1],
('Ni', 'I' ):  [1,  1],
('Ni', 'N' ):  [1,  1],
('Ni', 'Se'):  [1,  1],
('Ni', 'Te'):  [1,  1],
('Ni', 'P' ):  [1,  1],
('Ni', 'As'):  [1,  1],
('Ni', 'H' ):  [1,  1],
('Np', 'F' ):  [1,  1],
('Np', 'Cl'):  [1,  1],
('Np', 'S' ):  [1,  1],
('Np', 'Br'):  [1,  1],
('Np', 'I' ):  [1,  1],
('Np', 'O' ):  [1,  1],
('O' , 'O' ):  [1,  0],
('Os', 'O' ):  [1,  1],
('Os', 'S' ):  [1,  1],
('Os', 'F' ):  [1,  1],
('Os', 'Cl'):  [1,  1],
('Os', 'Br'):  [1,  1],
('P' , 'O' ):  [1,  1],
('P' , 'S' ):  [1,  1],
('P' , 'Se'):  [1,  1],
('P' , 'F' ):  [1,  1],
('P' , 'Cl'):  [1,  1],
('P' , 'Br'):  [1,  1],
('P' , 'N' ):  [1,  1],
('P' , 'I' ):  [1,  1],
('P' , 'P' ):  [1,  1],
('P' , 'As'):  [1,  1],
('P' , 'H' ):  [1,  1],
('Pa', 'O' ):  [1,  1],
('Pa', 'F' ):  [1,  1],
('Pa', 'Cl'):  [1,  1],
('Pa', 'Br'):  [1,  1],
('Pb', 'O' ):  [1,  1],
('Pb', 'S' ):  [1,  1],
('Pb', 'Se'):  [1,  1],
('Pb', 'F' ):  [1,  1],
('Pb', 'Cl'):  [1,  1],
('Pb', 'Br'):  [1,  1],
('Pb', 'I' ):  [1,  1],
('Pb', 'N' ):  [1,  1],
('Pb', 'Te'):  [1,  1],
('Pb', 'P' ):  [1,  1],
('Pb', 'As'):  [1,  1],
('Pb', 'H' ):  [1,  1],
('Pd', 'O' ):  [1,  1],
('Pd', 'S' ):  [1,  1],
('Pd', 'F' ):  [1,  1],
('Pd', 'Cl'):  [1,  1],
('Pd', 'Br'):  [1,  1],
('Pd', 'I' ):  [1,  1],
('Pd', 'N' ):  [1,  1],
('Pd', 'C' ):  [1,  1],
('Pd', 'Se'):  [1,  1],
('Pd', 'Te'):  [1,  1],
('Pd', 'P' ):  [1,  1],
('Pd', 'As'):  [1,  1],
('Pd', 'H' ):  [1,  1],
('Pm', 'F' ):  [1,  1],
('Pm', 'Cl'):  [1,  1],
('Pm', 'Br'):  [1,  1],
('Po', 'O' ):  [1,  1],
('Po', 'F' ):  [1,  1],
('Pr', 'O' ):  [1,  1],
('Pr', 'S' ):  [1,  1],
('Pr', 'Se'):  [1,  1],
('Pr', 'Te'):  [1,  1],
('Pr', 'F' ):  [1,  1],
('Pr', 'Cl'):  [1,  1],
('Pr', 'Br'):  [1,  1],
('Pr', 'I' ):  [1,  1],
('Pr', 'N' ):  [1,  1],
('Pr', 'P' ):  [1,  1],
('Pr', 'As'):  [1,  1],
('Pr', 'H' ):  [1,  1],
('Pt', 'O' ):  [1,  1],
('Pt', 'S' ):  [1,  1],
('Pt', 'F' ):  [1,  1],
('Pt', 'Cl'):  [1,  1],
('Pt', 'Br'):  [1,  1],
('Pt', 'C' ):  [1,  1],
('Pt', 'N' ):  [1,  1],
('Pt', 'I' ):  [1,  1],
('Pt', 'Se'):  [1,  1],
('Pt', 'Te'):  [1,  1],
('Pt', 'P' ):  [1,  1],
('Pt', 'As'):  [1,  1],
('Pt', 'H' ):  [1,  1],
('Pu', 'O' ):  [1,  1],
('Pu', 'F' ):  [1,  1],
('Pu', 'Cl'):  [1,  1],
('Pu', 'S' ):  [1,  1],
('Pu', 'Br'):  [1,  1],
('Pu', 'I' ):  [1,  1],
('Rb', 'O' ):  [1,  1],
('Rb', 'S' ):  [1,  1],
('Rb', 'Se'):  [1,  1],
('Rb', 'Te'):  [1,  1],
('Rb', 'F' ):  [1,  1],
('Rb', 'Cl'):  [1,  1],
('Rb', 'Br'):  [1,  1],
('Rb', 'I' ):  [1,  1],
('Rb', 'N' ):  [1,  1],
('Rb', 'P' ):  [1,  1],
('Rb', 'As'):  [1,  1],
('Rb', 'H' ):  [1,  1],
('Re', 'Cl'):  [1,  1],
('Re', 'O' ):  [1,  1],
('Re', 'F' ):  [1,  1],
('Re', 'Br'):  [1,  1],
('Re', 'I' ):  [1,  1],
('Re', 'S' ):  [1,  1],
('Re', 'Se'):  [1,  1],
('Re', 'Te'):  [1,  1],
('Re', 'N' ):  [1,  1],
('Re', 'P' ):  [1,  1],
('Re', 'As'):  [1,  1],
('Re', 'H' ):  [1,  1],
('Rh', 'O' ):  [1,  1],
('Rh', 'F' ):  [1,  1],
('Rh', 'Cl'):  [1,  1],
('Rh', 'Br'):  [1,  1],
('Rh', 'N' ):  [1,  1],
('Rh', 'I' ):  [1,  1],
('Rh', 'S' ):  [1,  1],
('Rh', 'Se'):  [1,  1],
('Rh', 'Te'):  [1,  1],
('Rh', 'P' ):  [1,  1],
('Rh', 'As'):  [1,  1],
('Rh', 'H' ):  [1,  1],
('Ru', 'Se'):  [1,  1],
('Ru', 'F' ):  [1,  1],
('Ru', 'O' ):  [1,  1],
('Ru', 'S' ):  [1,  1],
('Ru', 'Cl'):  [1,  1],
('Ru', 'N' ):  [1,  1],
('Ru', 'Br'):  [1,  1],
('Ru', 'I' ):  [1,  1],
('Ru', 'Te'):  [1,  1],
('Ru', 'P' ):  [1,  1],
('Ru', 'As'):  [1,  1],
('Ru', 'H' ):  [1,  1],
('S' , 'O' ):  [1,  1],
('S' , 'S' ):  [1,  1],
('S' , 'N' ):  [1,  1],
('S' , 'F' ):  [1,  1],
('S' , 'Cl'):  [1,  1],
('S' , 'Br'):  [1,  1],
('S' , 'I' ):  [1,  1],
('S' , 'H' ):  [1,  1],
('Sb', 'O' ):  [1,  1],
('Sb', 'S' ):  [1,  1],
('Sb', 'Se'):  [1,  1],
('Sb', 'F' ):  [1,  1],
('Sb', 'Cl'):  [1,  1],
('Sb', 'Br'):  [1,  1],
('Sb', 'I' ):  [1,  1],
('Sb', 'N' ):  [1,  1],
('Sb', 'Te'):  [1,  1],
('Sb', 'P' ):  [1,  1],
('Sb', 'As'):  [1,  1],
('Sb', 'H' ):  [1,  1],
('Sc', 'O' ):  [1,  1],
('Sc', 'S' ):  [1,  1],
('Sc', 'Se'):  [1,  1],
('Sc', 'Te'):  [1,  1],
('Sc', 'F' ):  [1,  1],
('Sc', 'Cl'):  [1,  1],
('Sc', 'Br'):  [1,  1],
('Sc', 'I' ):  [1,  1],
('Sc', 'N' ):  [1,  1],
('Sc', 'P' ):  [1,  1],
('Sc', 'As'):  [1,  1],
('Sc', 'H' ):  [1,  1],
('Se', 'S' ):  [1,  1],
('Se', 'Se'):  [1,  1],
('Se', 'O' ):  [1,  1],
('Se', 'F' ):  [1,  1],
('Se', 'Cl'):  [1,  1],
('Se', 'Br'):  [1,  1],
('Se', 'N' ):  [1,  1],
('Se', 'I' ):  [1,  1],
('Se', 'H' ):  [1,  1],
('Si', 'O' ):  [1,  1],
('Si', 'S' ):  [1,  1],
('Si', 'Se'):  [1,  1],
('Si', 'Te'):  [1,  1],
('Si', 'F' ):  [1,  1],
('Si', 'Cl'):  [1,  1],
('Si', 'Br'):  [1,  1],
('Si', 'I' ):  [1,  1],
('Si', 'C' ):  [1,  1],
('Si', 'N' ):  [1,  1],
('Si', 'P' ):  [1,  1],
('Si', 'As'):  [1,  1],
('Si', 'H' ):  [1,  1],
('Si', 'Si'):  [1,  1],
('Sm', 'O' ):  [1,  1],
('Sm', 'N' ):  [1,  1],
('Sm', 'S' ):  [1,  1],
('Sm', 'Se'):  [1,  1],
('Sm', 'Te'):  [1,  1],
('Sm', 'F' ):  [1,  1],
('Sm', 'Cl'):  [1,  1],
('Sm', 'Br'):  [1,  1],
('Sm', 'I' ):  [1,  1],
('Sm', 'P' ):  [1,  1],
('Sm', 'As'):  [1,  1],
('Sm', 'H' ):  [1,  1],
('Sn', 'O' ):  [1,  1],
('Sn', 'S' ):  [1,  1],
('Sn', 'F' ):  [1,  1],
('Sn', 'Cl'):  [1,  1],
('Sn', 'Br'):  [1,  1],
('Sn', 'I' ):  [1,  1],
('Sn', 'N' ):  [1,  1],
('Sn', 'Se'):  [1,  1],
('Sn', 'Te'):  [1,  1],
('Sn', 'P' ):  [1,  1],
('Sn', 'As'):  [1,  1],
('Sn', 'H' ):  [1,  1],
('Sr', 'O' ):  [1,  1],
('Sr', 'S' ):  [1,  1],
('Sr', 'Se'):  [1,  1],
('Sr', 'Te'):  [1,  1],
('Sr', 'F' ):  [1,  1],
('Sr', 'Cl'):  [1,  1],
('Sr', 'Br'):  [1,  1],
('Sr', 'I' ):  [1,  1],
('Sr', 'N' ):  [1,  1],
('Sr', 'P' ):  [1,  1],
('Sr', 'As'):  [1,  1],
('Sr', 'H' ):  [1,  1],
('Ta', 'O' ):  [1,  1],
('Ta', 'S' ):  [1,  1],
('Ta', 'F' ):  [1,  1],
('Ta', 'Cl'):  [1,  1],
('Ta', 'Br'):  [1,  1],
('Ta', 'I' ):  [1,  1],
('Ta', 'Se'):  [1,  1],
('Ta', 'Te'):  [1,  1],
('Ta', 'N' ):  [1,  1],
('Ta', 'P' ):  [1,  1],
('Ta', 'As'):  [1,  1],
('Ta', 'H' ):  [1,  1],
('Tb', 'O' ):  [1,  1],
('Tb', 'S' ):  [1,  1],
('Tb', 'Se'):  [1,  1],
('Tb', 'Te'):  [1,  1],
('Tb', 'F' ):  [1,  1],
('Tb', 'Cl'):  [1,  1],
('Tb', 'Br'):  [1,  1],
('Tb', 'I' ):  [1,  1],
('Tb', 'N' ):  [1,  1],
('Tb', 'P' ):  [1,  1],
('Tb', 'As'):  [1,  1],
('Tb', 'H' ):  [1,  1],
('Tc', 'O' ):  [1,  1],
('Tc', 'F' ):  [1,  1],
('Tc', 'Cl'):  [1,  1],
('Te', 'O' ):  [1,  1],
('Te', 'S' ):  [1,  1],
('Te', 'F' ):  [1,  1],
('Te', 'Cl'):  [1,  1],
('Te', 'Br'):  [1,  1],
('Te', 'I' ):  [1,  1],
('Te', 'Se'):  [1,  1],
('Te', 'Te'):  [1,  1],
('Te', 'N' ):  [1,  1],
('Te', 'P' ):  [1,  1],
('Te', 'H' ):  [1,  1],
('Th', 'O' ):  [1,  1],
('Th', 'S' ):  [1,  1],
('Th', 'Se'):  [1,  1],
('Th', 'Te'):  [1,  1],
('Th', 'F' ):  [1,  1],
('Th', 'Cl'):  [1,  1],
('Th', 'Br'):  [1,  1],
('Th', 'I' ):  [1,  1],
('Th', 'N' ):  [1,  1],
('Th', 'P' ):  [1,  1],
('Th', 'As'):  [1,  1],
('Th', 'H' ):  [1,  1],
('Ti', 'F' ):  [1,  1],
('Ti', 'Cl'):  [1,  1],
('Ti', 'Br'):  [1,  1],
('Ti', 'O' ):  [1,  1],
('Ti', 'S' ):  [1,  1],
('Ti', 'I' ):  [1,  1],
('Ti', 'Se'):  [1,  1],
('Ti', 'Te'):  [1,  1],
('Ti', 'N' ):  [1,  1],
('Ti', 'P' ):  [1,  1],
('Ti', 'As'):  [1,  1],
('Ti', 'H' ):  [1,  1],
('Tl', 'O' ):  [1,  1],
('Tl', 'S' ):  [1,  1],
('Tl', 'F' ):  [1,  1],
('Tl', 'Cl'):  [1,  1],
('Tl', 'Br'):  [1,  1],
('Tl', 'I' ):  [1,  1],
('Tl', 'Se'):  [1,  1],
('Tl', 'Te'):  [1,  1],
('Tl', 'N' ):  [1,  1],
('Tl', 'P' ):  [1,  1],
('Tl', 'As'):  [1,  1],
('Tl', 'H' ):  [1,  1],
('Tm', 'O' ):  [1,  1],
('Tm', 'S' ):  [1,  1],
('Tm', 'Se'):  [1,  1],
('Tm', 'Te'):  [1,  1],
('Tm', 'F' ):  [1,  1],
('Tm', 'Cl'):  [1,  1],
('Tm', 'Br'):  [1,  1],
('Tm', 'I' ):  [1,  1],
('Tm', 'N' ):  [1,  1],
('Tm', 'P' ):  [1,  1],
('Tm', 'As'):  [1,  1],
('Tm', 'H' ):  [1,  1],
('U' , 'O' ):  [1,  1],
('U' , 'S' ):  [1,  1],
('U' , 'F' ):  [1,  1],
('U' , 'Cl'):  [1,  1],
('U' , 'Br'):  [1,  1],
('U' , 'I' ):  [1,  1],
('U' , 'N' ):  [1,  1],
('U' , 'Se'):  [1,  1],
('U' , 'Te'):  [1,  1],
('U' , 'P' ):  [1,  1],
('U' , 'As'):  [1,  1],
('U' , 'H' ):  [1,  1],
('V' , 'O' ):  [1,  1],
('V' , 'Cl'):  [1,  1],
('V' , 'S' ):  [1,  1],
('V' , 'F' ):  [1,  1],
('V' , 'Br'):  [1,  1],
('V' , 'N' ):  [1,  1],
('V' , 'I' ):  [1,  1],
('V' , 'Se'):  [1,  1],
('V' , 'Te'):  [1,  1],
('V' , 'P' ):  [1,  1],
('V' , 'As'):  [1,  1],
('V' , 'H' ):  [1,  1],
('W' , 'O' ):  [1,  1],
('W' , 'F' ):  [1,  1],
('W' , 'Cl'):  [1,  1],
('W' , 'Br'):  [1,  1],
('W' , 'I' ):  [1,  1],
('W' , 'S' ):  [1,  1],
('W' , 'Se'):  [1,  1],
('W' , 'Te'):  [1,  1],
('W' , 'N' ):  [1,  1],
('W' , 'P' ):  [1,  1],
('W' , 'As'):  [1,  1],
('W' , 'H' ):  [1,  1],
('Xe', 'O' ):  [1,  1],
('Xe', 'F' ):  [1,  1],
('Y' , 'O' ):  [1,  1],
('Y' , 'S' ):  [1,  1],
('Y' , 'Se'):  [1,  1],
('Y' , 'Te'):  [1,  1],
('Y' , 'F' ):  [1,  1],
('Y' , 'Cl'):  [1,  1],
('Y' , 'Br'):  [1,  1],
('Y' , 'I' ):  [1,  1],
('Y' , 'N' ):  [1,  1],
('Y' , 'P' ):  [1,  1],
('Y' , 'As'):  [1,  1],
('Y' , 'H' ):  [1,  1],
('Yb', 'O' ):  [1,  1],
('Yb', 'N' ):  [1,  1],
('Yb', 'S' ):  [1,  1],
('Yb', 'Se'):  [1,  1],
('Yb', 'Te'):  [1,  1],
('Yb', 'F' ):  [1,  1],
('Yb', 'Cl'):  [1,  1],
('Yb', 'Br'):  [1,  1],
('Yb', 'I' ):  [1,  1],
('Yb', 'P' ):  [1,  1],
('Yb', 'As'):  [1,  1],
('Yb', 'H' ):  [1,  1],
('Zn', 'O' ):  [1,  1],
('Zn', 'S' ):  [1,  1],
('Zn', 'Se'):  [1,  1],
('Zn', 'Te'):  [1,  1],
('Zn', 'F' ):  [1,  1],
('Zn', 'Cl'):  [1,  1],
('Zn', 'Br'):  [1,  1],
('Zn', 'I' ):  [1,  1],
('Zn', 'N' ):  [1,  1],
('Zn', 'P' ):  [1,  1],
('Zn', 'As'):  [1,  1],
('Zn', 'H' ):  [1,  1],
('Zr', 'O' ):  [1,  1],
('Zr', 'F' ):  [1,  1],
('Zr', 'Cl'):  [1,  1],
('Zr', 'S' ):  [1,  1],
('Zr', 'Se'):  [1,  1],
('Zr', 'Te'):  [1,  1],
('Zr', 'Br'):  [1,  1],
('Zr', 'I' ):  [1,  1],
('Zr', 'N' ):  [1,  1],
('Zr', 'P' ):  [1,  1],
('Zr', 'As'):  [1,  1],
('Zr', 'H' ):  [1,  1],
}

material_styles_dict = {
            'default'   : {'Metallic': 0.1, 'Specular': 0.2, 'Roughness': 0.2, },
            'ceramic' : {'Subsurface': 0.1, 'Metallic': 0.02, 'Specular': 0.5, 'Roughness': 0.0},
            'plastic' : {'Metallic': 0.0, 'Specular': 0.5, 'Roughness': 1.0, },
            'glass'   : {'Metallic': 0.0, 'Specular': 0.5, 'Roughness': 0.0, 'Transmission': 0.98},
            'mirror'  : {'Metallic': 0.99, 'Specular': 2.0, 'Roughness': 0.001},
            }

default_batoms = {
        'show_unit_cell': 'default',
        'celllinewidth': 0.025,  # radius of the cylinders representing the cell
        'balltypes': None,
        'radii': None, 
        'colors': None,
        'make_real': False,
        'kind_props': None,
        'bond_cutoff': None,  # 
        'bond_list': {},  # [[atom1, atom2], ... ] pairs of bonding atoms
        'polyhedra_dict': {},
        'search_pbc': False, #{'bonds_dict': {}, 'molecule_list': {}},
        'search_bond': False, #{'bonds_dict': {}, 'molecule_list': {}},
        'search_molecule': False, #{'search_list': None},
        'boundary_list': [],
        'isosurface':None,
        'cube': None,
        'highlight': None, # highlight atoms
}
