package dyliss.biopax.pattern.miner;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;
import dyliss.biopax.pattern.SpaimSIFEnum;

import org.biopax.paxtools.pattern.util.Blacklist;

import java.util.HashSet;
import java.util.Set;

/**
 * Miner for the controls-state-change pattern.
 * @author Ozgun Babur
 */
public class TestCSCOThroughControllingSmallMoleculeMiner2 extends AbstractSIFMiner
{
	
	
	protected TestCSCOThroughControllingSmallMoleculeMiner2(String name, String description)
	{
		super(SpaimSIFEnum.TEST_CONTROLS_STATE_CHANGE_OF2, name, description);
	}

	/**
	 * Empty constructor.
	 */
	public TestCSCOThroughControllingSmallMoleculeMiner2()
	{
		super(SpaimSIFEnum.TEST_CONTROLS_STATE_CHANGE_OF2, "-through-controlling-small-mol", "The first protein produces a non-ubique small " +
				"molecule, and this small molecule controls state of the second protein.");
	}
	 

	//

 

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.controlsStateChangeThroughControllerSmallMolecule(blacklist);
	}

	@Override
	public String[] getMediatorLabels()
	{
		return new String[]{"upper Control", "upper Conversion", "Control", "Conversion",
			"controller PE"};
	}

	@Override
	public String getSourceLabel()
	{
		return "upper controller ER";
	}

	@Override
	public String getTargetLabel()
	{
		return "changed ER";
	}

	@Override
	public String[] getSourcePELabels()
	{
		return new String[]{"upper controller simple PE", "upper controller PE"};
	}

	@Override
	public String[] getTargetPELabels()
	{
		return new String[]{"input PE", "input simple PE", "output PE", "output simple PE"};
	}
}
