package dyliss.biopax.pattern.miner;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;

import dyliss.biopax.pattern.SpaimSIFEnum;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;

/**
 * Miner for the controls-transport pattern.
 * @author Ozgun Babur
 */
public class ControlsTransportMiner extends ControlsStateChangeOfMiner
{
	/**
	 * Constructor that sets name and description.
	 */
	public ControlsTransportMiner()
	{
		super(SpaimSIFEnum.CONTROLS_TRANSPORT_OF);
	}

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.controlsTransport();
	}
}
