package dyliss.biopax.pattern.miner;
import org.biopax.paxtools.pattern.miner.AbstractSIFMiner;

import dyliss.biopax.pattern.SpaimSIFEnum;

import org.biopax.paxtools.pattern.Pattern;
import dyliss.biopax.pattern.SpaimPatternBox;

/**
 * Miner for the controls-phosphorylation pattern.
 * @author Ozgun Babur
 */
public class ControlsPhosphorylationMiner extends ControlsStateChangeOfMiner
{
	/**
	 * Constructor that sets the type.
	 */
	public ControlsPhosphorylationMiner()
	{
		super("phosphorylation",
				SpaimSIFEnum.CONTROLS_PHOSPHORYLATION_OF.getDescription());
		setType(SpaimSIFEnum.CONTROLS_PHOSPHORYLATION_OF);
	}

	/**
	 * Constructs the pattern.
	 * @return pattern
	 */
	@Override
	public Pattern constructPattern()
	{
		return SpaimPatternBox.controlsPhosphorylation();
	}
}
